/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.container;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ContainerUtil {
    public static <T> Set<T> disjunctSet(Set<T> a, Set<T> b) {
        HashSet<T> aCopy = new HashSet<T>(a);
        HashSet<T> bCopy = new HashSet<T>(b);
        aCopy.removeAll(b);
        bCopy.removeAll(a);
        HashSet<T> result = new HashSet<T>(aCopy);
        result.addAll(bCopy);
        return result;
    }

    public static <T> List<T> disjunctList(List<T> a, List<T> b) {
        ArrayList<T> aCopy = new ArrayList<T>(a);
        ArrayList<T> bCopy = new ArrayList<T>(b);
        aCopy.removeAll(b);
        bCopy.removeAll(a);
        ArrayList<T> result = new ArrayList<T>(aCopy);
        result.addAll(bCopy);
        return result;
    }

    public static <T> Set<T> disjunctSet(List<T> a, List<T> b) {
        return ContainerUtil.disjunctSet(new HashSet<T>(a), new HashSet<T>(b));
    }

    public static <T> ArrayList<T> asArrayList(T ... elements) {
        ArrayList<T> list = new ArrayList<T>(elements.length);
        for (T t : elements) {
            list.add(t);
        }
        return list;
    }

    public static String asSeparatedString(Iterable<?> iterable, String separator) {
        if (separator == null) {
            separator = ",";
        }
        Iterator<?> iterator = iterable.iterator();
        boolean hasNext = iterator.hasNext();
        StringBuilder sb = new StringBuilder();
        while (hasNext) {
            sb.append(String.valueOf(iterator.next()));
            hasNext = iterator.hasNext();
            if (!hasNext) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String arrayAsSeparatedString(Object array, String separator) {
        if (array == null) {
            return "";
        }
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Passed object must be an array.");
        }
        if (separator == null) {
            separator = ",";
        }
        int length = Array.getLength(array);
        int lastElementIdx = length - 1;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i != length; ++i) {
            Object obj = Array.get(array, i);
            sb.append(String.valueOf(obj));
            if (i == lastElementIdx) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static int arrayHashCode(Object array) {
        if (array == null) {
            return 0;
        }
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Passed object must be an array.");
        }
        int hashCode = 1;
        int length = Array.getLength(array);
        for (int i = 0; i != length; ++i) {
            Object obj = Array.get(array, i);
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    public static ArrayList asArrayList(Object array) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Passed object must be an array.");
        }
        int size = Array.getLength(array);
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i != size; ++i) {
            list.add(Array.get(array, i));
        }
        return list;
    }

    public static long[] convertToLongArray(List<Long> list) {
        long[] array = new long[list.size()];
        for (int i = 0; i != list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    public static int[] convertToIntegerArray(List<Integer> list) {
        int[] array = new int[list.size()];
        for (int i = 0; i != list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }
}

