/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.connection;

import de.proveo.util.connection.ServletConnectionException;
import de.proveo.util.connection.ssl.EasySSLProtocolSocketFactory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.util.Map;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.auth.NTLMScheme;
import org.apache.commons.httpclient.auth.RFC2617Scheme;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServletConnection {
    private static final Log log = LogFactory.getLog(ServletConnection.class);
    public static final String PROTOCOL_HTTP = "http";
    public static final String PROTOCOL_HTTPS = "https";
    private final int SOCKET_TIMEOUT = 60000;
    private final long CONNECTION_MANAGER_TIMEOUT = 30000L;
    private final String PARA_PASSWORD = "password";
    private HttpClient client;
    private HttpConnection httpConnection;
    private PostMethod httpMethod;
    private String host;
    private String lastStatusText = "";
    private String protocol;
    private String proxyDomain;
    private String proxyName;
    private String proxyPass;
    private String proxyUser;
    private boolean useProxy = false;
    private boolean useProxyAuthentication = false;
    private int lastState = 0;
    private int port;
    private int proxyPort;
    private boolean authNeeded = false;

    public ServletConnection(String host, int port) {
        this(host, port, PROTOCOL_HTTP);
    }

    public ServletConnection(String host, int port, String prot) {
        this.host = host;
        this.port = port;
        this.protocol = prot;
        if (!prot.equals(PROTOCOL_HTTP) && !prot.equals(PROTOCOL_HTTPS)) {
            log.warn((Object)("Unknown protocol '" + prot + "'"));
        }
    }

    public void close() {
        try {
            if (this.httpMethod != null) {
                log.debug((Object)"try to abort http method...");
                this.httpMethod.abort();
                this.releaseMethod((HttpMethod)this.httpMethod);
                this.httpMethod = null;
                log.debug((Object)"http method aborted.");
            } else {
                log.debug((Object)"http method already null");
            }
            if (this.httpConnection != null) {
                log.debug((Object)"try to close connection...");
                this.httpConnection.close();
                this.httpConnection.releaseConnection();
                this.httpConnection = null;
                log.debug((Object)"Servlet connection closed.");
            } else {
                log.debug((Object)"httpConnection already null");
            }
        }
        catch (Throwable ex) {
            log.debug((Object)"Could not close servlet connection regulary", ex);
        }
        this.client = null;
    }

    private void releaseMethod(HttpMethod method) {
        try {
            if (method != null) {
                log.debug((Object)"try to release http method...");
                method.releaseConnection();
                log.debug((Object)"http method released.");
            }
        }
        catch (Throwable ex) {
            log.debug((Object)"Could not release servlet connection regulary.", ex);
        }
    }

    public void connect() {
        String method = "connect(): ";
        this.client = new HttpClient();
        HttpClientParams params = this.client.getParams();
        params.setSoTimeout(60000);
        params.setConnectionManagerTimeout(30000L);
        params.setContentCharset("UTF-8");
        params.setCredentialCharset("UTF-8");
        params.setHttpElementCharset("UTF-8");
        if (this.protocol.equals(PROTOCOL_HTTPS)) {
            EasySSLProtocolSocketFactory psf = new EasySSLProtocolSocketFactory();
            Protocol easyhttps = new Protocol(PROTOCOL_HTTPS, (ProtocolSocketFactory)psf, this.port);
            Protocol.registerProtocol((String)PROTOCOL_HTTPS, (Protocol)easyhttps);
            log.debug((Object)(method + "https protocol registered."));
        }
        HostConfiguration hostConfiguration = this.client.getHostConfiguration();
        hostConfiguration.setHost(this.host, this.port, this.protocol);
        if (this.useProxy) {
            log.debug((Object)(method + "setup proxy..."));
            if (this.useProxyAuthentication) {
                params.setParameter("http.authentication.credential-provider", (Object)new AuthenticationProvider(this.proxyUser, this.proxyPass, this.proxyDomain));
                params.setAuthenticationPreemptive(true);
                log.debug((Object)(method + "proxy authentication configured."));
            } else {
                log.debug((Object)(method + "proxy without authentication."));
            }
            hostConfiguration.setProxy(this.proxyName, this.proxyPort);
            log.debug((Object)(method + "proxy configuration set."));
        }
        this.client.setParams(params);
        this.httpConnection = this.client.getHttpConnectionManager().getConnection(hostConfiguration);
    }

    public int executeMethod(String url) throws HttpException, IOException, ServletConnectionException {
        String passwd = this.getParaFromUrl(url, "password");
        url = this.removePwFromtUrl(url);
        return this.executeMethod(url, passwd);
    }

    public int executeMethod(String url, String passwd) throws HttpException, IOException, ServletConnectionException {
        String method = "executeMethod(): ";
        PostMethod postMethod = new PostMethod(url);
        postMethod.addRequestHeader("ContentType", "application/x-www-form-urlencoded;charset=UTF-8");
        if (passwd != null && passwd.length() > 0) {
            postMethod.addParameter("password", passwd);
        }
        postMethod.setDoAuthentication(this.authNeeded);
        this.lastState = this.client.executeMethod((HttpMethod)postMethod);
        this.lastStatusText = postMethod.getStatusText();
        this.releaseMethod((HttpMethod)postMethod);
        if (this.lastState >= 400) {
            log.error((Object)(method + "status not ok (" + this.lastState + ", " + this.lastStatusText + "), break"));
            throw new ServletConnectionException("BadStatusCode", "" + this.lastState, this.lastStatusText);
        }
        return this.lastState;
    }

    public int getLastState() {
        return this.lastState;
    }

    public String getLastStatusText() {
        return this.lastStatusText;
    }

    public ObjectInputStream getObjectInputStream(String servletAlias, Map<String, String> servletParams) throws ServletConnectionException {
        String val;
        String method = "getObjectInputStream(servletPath, params): ";
        ObjectInputStream ois = null;
        StringBuilder urlParameters = new StringBuilder();
        for (String key : servletParams.keySet()) {
            if (key.equals("password")) continue;
            val = servletParams.get(key);
            urlParameters.append(key);
            urlParameters.append('=');
            try {
                urlParameters.append(URLEncoder.encode(val, "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                urlParameters.append(val);
            }
            urlParameters.append('&');
        }
        String parameters = urlParameters.toString();
        if (parameters.endsWith("&")) {
            parameters = parameters.substring(0, parameters.lastIndexOf("&"));
        }
        String url = this.getUrl(servletAlias, parameters);
        try {
            this.httpMethod = new PostMethod(url);
        }
        catch (Throwable ex) {
            log.error((Object)(method + "runs into exception '" + ex.getClass().getName() + "' : " + ex.toString()), ex);
            throw new ServletConnectionException("UnknownException", ex.getClass().getName(), ex.toString());
        }
        this.httpMethod.addRequestHeader("ContentType", "application/x-www-form-urlencoded;charset=UTF-8");
        this.httpMethod.setDoAuthentication(this.authNeeded);
        for (String key : servletParams.keySet()) {
            val = servletParams.get(key);
            this.httpMethod.addParameter(key, val);
        }
        try {
            HttpClientParams httpClientParams = this.client.getParams();
            httpClientParams.setSoTimeout(60000);
            httpClientParams.setConnectionManagerTimeout(30000L);
            httpClientParams.setContentCharset("UTF-8");
            httpClientParams.setCredentialCharset("UTF-8");
            httpClientParams.setHttpElementCharset("UTF-8");
            this.lastState = this.client.executeMethod((HttpMethod)this.httpMethod);
            this.lastStatusText = this.httpMethod.getStatusText();
            if (this.lastState >= 400) {
                log.error((Object)(method + "status not ok (" + this.lastState + ", " + this.lastStatusText + "), break"));
                if (this.lastState == 505) {
                    log.error((Object)(method + "(check URL for spaces and special characters)"));
                }
                throw new ServletConnectionException("BadStatusCode", "" + this.lastState, this.lastStatusText);
            }
            InputStream is = this.httpMethod.getResponseBodyAsStream();
            ois = new ObjectInputStream(new BufferedInputStream(is));
        }
        catch (SocketTimeoutException ste) {
            log.error((Object)(method + ste.toString() + ", Servlet time out"));
            throw new ServletConnectionException("TimeOut", ste);
        }
        catch (ConnectException ce) {
            log.error((Object)(method + ce.toString() + ", Servlet can not connect"));
            throw new ServletConnectionException("ConnectError", ce);
        }
        catch (HttpException e) {
            log.error((Object)(method + e.toString()));
            throw new ServletConnectionException("HttpError", e);
        }
        catch (SSLHandshakeException ssle) {
            log.error((Object)(method + ssle.toString()));
            throw new ServletConnectionException("SslHandshakeError", ssle);
        }
        catch (IOException ioe) {
            log.error((Object)(method + ioe.toString() + ", Network not available ? Servlet not accessible ? Server not running ?"));
            throw new ServletConnectionException("NoServerFound");
        }
        catch (ServletConnectionException sce) {
            log.error((Object)(method + sce.toString() + ", Bad status code? Check stacktrace..."));
            throw new ServletConnectionException("BadStatusCode");
        }
        catch (Exception ex) {
            log.error((Object)(method + "uncatched exception '" + ex.getClass().getName() + "' : " + ex.toString()));
            throw new ServletConnectionException("UnknownException", ex.getClass().getName(), ex.toString());
        }
        return ois;
    }

    public String getSafeUrl(String servletAlias, String parameters) {
        return this.removePwFromtUrl(this.getUrl(servletAlias, parameters));
    }

    public String getUrl(String servletAlias, String parameters) {
        String url = this.protocol + "://" + this.host + ":" + this.port + "/" + servletAlias;
        if (parameters != null && parameters.length() > 1) {
            parameters = parameters.replaceAll(" ", "%20");
            parameters = parameters.replaceAll("\\\\", "/");
            url = url + "?" + parameters;
        }
        return url;
    }

    private String removePwFromtUrl(String url) {
        int ind = url.indexOf("password=");
        if (ind < 0) {
            return url;
        }
        String part1 = url.substring(0, ind);
        String rest = url.substring(ind, url.length());
        ind = rest.indexOf("&");
        String part2 = "";
        if (ind >= 0) {
            part2 = rest.substring(ind + 1, rest.length());
        }
        String ret = part1 + part2;
        return ret;
    }

    private String getParaFromUrl(String url, String para) {
        String method = "getParaFromtUrl(): ";
        String ret = "";
        int ind = url.indexOf(para + "=");
        if (ind < 0) {
            log.debug((Object)(method + "parameter '" + para + "' not found in URL '" + url + "'"));
            return ret;
        }
        String rest = url.substring(ind + para.length() + 1, url.length());
        ret = (ind = rest.indexOf("&")) >= 0 ? rest.substring(0, ind) : rest;
        return ret;
    }

    public Object readObject(String url, String passwd) throws ServletConnectionException {
        ObjectInputStream ois;
        String method = "readObject(): ";
        PostMethod postMethod = new PostMethod(url);
        postMethod.addRequestHeader("ContentType", "application/x-www-form-urlencoded;charset=UTF-8");
        if (passwd != null && passwd.length() > 0) {
            postMethod.addParameter("password", passwd);
        }
        postMethod.setDoAuthentication(this.authNeeded);
        try {
            this.lastState = this.client.executeMethod((HttpMethod)postMethod);
            this.lastStatusText = postMethod.getStatusText();
            if (this.lastState >= 400) {
                log.error((Object)(method + "status not ok (" + this.lastState + ", " + this.lastStatusText + "), break"));
                throw new ServletConnectionException("BadStatusCode", "" + this.lastState, this.lastStatusText);
            }
            InputStream is = postMethod.getResponseBodyAsStream();
            ois = new ObjectInputStream(new BufferedInputStream(is));
        }
        catch (SocketTimeoutException ste) {
            log.error((Object)(method + ste.toString() + ", Servlet time out"));
            throw new ServletConnectionException("TimeOut", ste);
        }
        catch (ConnectException ce) {
            log.error((Object)(method + ce.toString() + ", Servlet can not connect"));
            throw new ServletConnectionException("ConnectError", ce);
        }
        catch (HttpException e) {
            log.error((Object)(method + e.toString()));
            throw new ServletConnectionException("HttpError", e);
        }
        catch (SSLHandshakeException ssle) {
            log.error((Object)(method + ssle.toString()));
            throw new ServletConnectionException("SslHandshakeError", ssle);
        }
        catch (IOException ioe) {
            log.error((Object)(method + ioe.toString() + ", Network not available ? Servlet not accessible ? Server not running ?"));
            throw new ServletConnectionException("NoServerFound");
        }
        catch (Exception ex) {
            log.error((Object)(method + "uncatched exception '" + ex.getClass().getName() + "' : " + ex.toString()));
            throw new ServletConnectionException("UnknownException", ex.getClass().getName(), ex.toString());
        }
        Object obj = null;
        try {
            obj = ois.readObject();
            ois.close();
        }
        catch (IOException ioe) {
            log.error((Object)(method + "Error : " + ioe.toString()));
            throw new ServletConnectionException("ObjectResponseError");
        }
        catch (ClassNotFoundException ce) {
            log.error((Object)(method + "Error : " + ce.toString()));
            throw new ServletConnectionException("ObjectClassError");
        }
        this.releaseMethod((HttpMethod)postMethod);
        return obj;
    }

    public String readString(String url) throws ServletConnectionException {
        String passwd = this.getParaFromUrl(url, "password");
        url = this.removePwFromtUrl(url);
        return this.readString(url, passwd);
    }

    public String readString(String url, String passwd) throws ServletConnectionException {
        String response;
        String method = "readString(): ";
        PostMethod postMethod = new PostMethod(url);
        postMethod.addRequestHeader("ContentType", "application/x-www-form-urlencoded;charset=UTF-8");
        if (passwd != null && passwd.length() > 0) {
            postMethod.addParameter("password", passwd);
        }
        postMethod.setDoAuthentication(this.authNeeded);
        try {
            this.lastState = this.client.executeMethod((HttpMethod)postMethod);
            this.lastStatusText = postMethod.getStatusText();
            if (this.lastState >= 400) {
                log.error((Object)(method + "status not ok (" + this.lastState + ", " + this.lastStatusText + "), break"));
                throw new ServletConnectionException("BadStatusCode", "" + this.lastState, this.lastStatusText);
            }
            response = postMethod.getResponseBodyAsString();
        }
        catch (SocketTimeoutException ste) {
            log.error((Object)(method + ste.toString() + ", Servlet time out"));
            throw new ServletConnectionException("TimeOut", ste);
        }
        catch (HttpException e) {
            log.error((Object)(method + e.toString()));
            throw new ServletConnectionException("HttpError", e);
        }
        catch (SSLHandshakeException ssle) {
            log.error((Object)(method + ssle.toString()));
            throw new ServletConnectionException("SslHandshakeError", ssle);
        }
        catch (IOException ioe) {
            log.error((Object)(method + ioe.toString() + ", Network not available ? Servlet not accessible ? Server not running ?"));
            throw new ServletConnectionException("NoServerFound");
        }
        catch (Exception ex) {
            log.error((Object)(method + "uncatched exception '" + ex.getClass().getName() + "' : " + ex.toString()));
            throw new ServletConnectionException("UnknownException", ex.getClass().getName(), ex.toString());
        }
        this.releaseMethod((HttpMethod)postMethod);
        return response;
    }

    public void setAuthenticate(String username, String password) {
        if (this.client == null) {
            this.connect();
        }
        this.client.getState().setCredentials(new AuthScope(this.host, this.port, AuthScope.ANY_REALM), (Credentials)new UsernamePasswordCredentials(username, password));
        this.authNeeded = true;
    }

    public void setupProxy(String name, int port, String user, String pass, String dom) {
        this.useProxy = true;
        this.proxyName = name;
        this.proxyPort = port;
        this.proxyUser = user;
        this.proxyPass = pass;
        this.proxyDomain = dom;
        if (this.proxyUser.length() > 0) {
            this.useProxyAuthentication = true;
        }
    }

    public class AuthenticationProvider
    implements CredentialsProvider {
        String domain;
        String password;
        String user;

        public AuthenticationProvider(String user, String password, String domain) {
            this.user = user;
            this.password = password;
            this.domain = domain;
        }

        public Credentials getCredentials(AuthScheme authscheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
            String method = "getCredentials(): ";
            if (authscheme == null) {
                return null;
            }
            try {
                if (authscheme instanceof NTLMScheme) {
                    log.debug((Object)(host + ":" + port + " requires Windows authentication, return NTLM credentials"));
                    return new NTCredentials(this.user, this.password, host, this.domain);
                }
                if (authscheme instanceof RFC2617Scheme) {
                    log.debug((Object)(host + ":" + port + " requires authentication with the realm '" + authscheme.getRealm() + "', return USER/PASS credentials"));
                    return new UsernamePasswordCredentials(this.user, this.password);
                }
                log.error((Object)(method + "Unsupported authentication scheme: " + authscheme.getSchemeName()));
                throw new CredentialsNotAvailableException("Unsupported authentication scheme: " + authscheme.getSchemeName());
            }
            catch (IOException e) {
                throw new CredentialsNotAvailableException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

