/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.custom.hints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.html.custom.conf.Attribute;
import org.netbeans.modules.html.custom.conf.Configuration;
import org.netbeans.modules.html.custom.conf.Tag;
import org.netbeans.modules.html.custom.hints.MissingRequiredAttributes;
import org.netbeans.modules.html.custom.hints.UnknownAttributes;
import org.netbeans.modules.html.editor.api.HtmlEditorUtils;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementVisitor;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.Snapshot;

public class CheckerElementVisitor {
    public static ElementVisitor getChecker(RuleContext context, Configuration conf, Snapshot snapshot, List<Hint> hints) {
        ArrayList<ElementVisitor> visitors = new ArrayList<ElementVisitor>();
        visitors.add(new UnknownAttributesChecker(context, conf, snapshot, hints));
        visitors.add(new MissingRequiredAttributeChecker(context, conf, snapshot, hints));
        return new AggregatedVisitor(visitors);
    }

    public static class AggregatedVisitor
    implements ElementVisitor {
        private final Collection<ElementVisitor> visitors;

        public AggregatedVisitor(Collection<ElementVisitor> visitors) {
            this.visitors = visitors;
        }

        public void visit(Element node) {
            for (ElementVisitor visitor : this.visitors) {
                visitor.visit(node);
            }
        }
    }

    protected static abstract class Checker
    implements ElementVisitor {
        protected RuleContext context;
        protected Configuration conf;
        protected Snapshot snapshot;
        protected List<Hint> hints;

        public Checker(RuleContext context, Configuration conf, Snapshot snapshot, List<Hint> hints) {
            this.context = context;
            this.conf = conf;
            this.snapshot = snapshot;
            this.hints = hints;
        }
    }

    private static class MissingRequiredAttributeChecker
    extends Checker {
        public MissingRequiredAttributeChecker(RuleContext context, Configuration conf, Snapshot snapshot, List<Hint> hints) {
            super(context, conf, snapshot, hints);
        }

        public void visit(Element node) {
            switch (node.type()) {
                case OPEN_TAG: {
                    OpenTag ot = (OpenTag)node;
                    String name = ot.name().toString();
                    Tag tagModel = this.conf.getTag(name);
                    if (tagModel == null) break;
                    ArrayList<Attribute> toAdd = new ArrayList<Attribute>();
                    for (Attribute modelAttribute : tagModel.getAttributes()) {
                        if (!modelAttribute.isRequired() || ot.getAttribute(modelAttribute.getName()) != null) continue;
                        toAdd.add(modelAttribute);
                    }
                    if (toAdd.isEmpty()) break;
                    this.hints.add(new MissingRequiredAttributes(toAdd, ot, this.context, HtmlEditorUtils.getDocumentOffsetRange((Element)node, (Snapshot)this.snapshot), false));
                }
            }
        }
    }

    private static class UnknownAttributesChecker
    extends Checker {
        public UnknownAttributesChecker(RuleContext context, Configuration conf, Snapshot snapshot, List<Hint> hints) {
            super(context, conf, snapshot, hints);
        }

        public void visit(Element node) {
            switch (node.type()) {
                case OPEN_TAG: {
                    OpenTag ot = (OpenTag)node;
                    String name = ot.name().toString();
                    Tag tagModel = this.conf.getTag(name);
                    if (tagModel == null) break;
                    Collection tagAttrs = ot.attributes();
                    ArrayList<String> unknownAttributeNames = new ArrayList<String>();
                    for (org.netbeans.modules.html.editor.lib.api.elements.Attribute a : tagAttrs) {
                        String attrName = a.name().toString();
                        if (tagModel.getAttribute(attrName) != null || this.conf.getAttribute(attrName) != null) continue;
                        unknownAttributeNames.add(attrName);
                    }
                    if (unknownAttributeNames.isEmpty()) break;
                    boolean lineHint = false;
                    OffsetRange range = new OffsetRange(this.snapshot.getEmbeddedOffset(ot.from()), this.snapshot.getEmbeddedOffset(ot.to()));
                    this.hints.add(new UnknownAttributes(unknownAttributeNames, tagModel.getName(), this.context, range, lineHint));
                }
            }
        }
    }
}

