/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.netbeans.modules.schema2beans.BaseAttribute;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.BeanProp;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.DDFactory;
import org.netbeans.modules.schema2beans.DDLogFlags;
import org.netbeans.modules.schema2beans.JavaBeansUtil;
import org.netbeans.modules.schema2beans.NodeFactory;
import org.netbeans.modules.schema2beans.QName;
import org.netbeans.modules.schema2beans.Schema2BeansRuntimeException;
import org.netbeans.modules.schema2beans.TraceLogger;
import org.netbeans.modules.schema2beans.Wrapper;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMBinding {
    int id = DDFactory.getUniqueId();
    Node node;
    int pos;
    int posDOM;
    private static final Class charArrayClass = Array.newInstance(Character.TYPE, 0).getClass();
    private BeanProperty prop;

    public DOMBinding() {
    }

    public DOMBinding(Node node) {
        this();
        this.node = node;
    }

    void setNode(Node node) {
        this.node = node;
    }

    void moveBefore(BeanProp prop, Node node) {
        Node parent = prop.getParentNode();
        parent.removeChild(this.node);
        parent.insertBefore(this.node, node);
    }

    public int getId() {
        return this.id;
    }

    String idToString() {
        return Integer.toHexString(this.id);
    }

    Node getNode() {
        return this.node;
    }

    void register(BeanProp prop, Object value) {
        BeanProperty bp = new BeanProperty(prop);
        if (Common.isBean(prop.type)) {
            ((BaseBean)value).setDomBinding(this);
        }
        this.prop = bp;
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 13, "property " + prop.getDtdName() + " bound to B(" + this.hashCode() + ")");
        }
        if (this.node != null) {
            NamedNodeMap l = this.node.getAttributes();
            for (int i = 0; i < l.getLength(); ++i) {
                Node n = l.item(i);
                prop.createTransientAttribute(n.getNodeName());
            }
        }
    }

    private BeanProperty getBeanProperty(BeanProp prop) {
        if (this.prop != null && this.prop.beanProp == prop) {
            return this.prop;
        }
        return null;
    }

    BeanProp getBeanProp(BaseBean bean) {
        if (this.prop != null && this.prop.value == bean) {
            return this.prop.beanProp;
        }
        return null;
    }

    void setLastKnownIndex(BeanProp prop, int index) {
        BeanProperty bp = this.getBeanProperty(prop);
        if (bp != null) {
            bp.lastIndex = index;
        }
    }

    int getLastKnownIndex(BeanProp prop) {
        BeanProperty bp = this.getBeanProperty(prop);
        if (bp != null) {
            return bp.lastIndex;
        }
        return -1;
    }

    Object getBean(BeanProp prop) {
        BeanProperty bp = this.getBeanProperty(prop);
        if (bp != null) {
            return bp.value;
        }
        return null;
    }

    String getAttributeValue(BeanProp prop, String name) {
        CacheAttr ca;
        if (this.node != null) {
            Attr a = ((Element)this.node).getAttributeNode(name);
            if (a != null) {
                return a.getValue();
            }
            return null;
        }
        BeanProperty bp = this.getBeanProperty(prop);
        if (bp != null && bp.attributes != null && (ca = this.findCacheAttr(bp, name)) != null) {
            return ca.value;
        }
        return null;
    }

    private CacheAttr findCacheAttr(BeanProperty bp, String name) {
        for (int i = 0; i < bp.attributes.size(); ++i) {
            CacheAttr ca = (CacheAttr)bp.attributes.get(i);
            if (!ca.name.equals(name)) continue;
            return ca;
        }
        return null;
    }

    void setAttributeValue(BeanProp prop, String name, String value) {
        if (this.node != null) {
            if (value != null) {
                ((Element)this.node).setAttribute(name, value);
            } else {
                String v = ((Element)this.node).getAttribute(name);
                if (v != null) {
                    try {
                        ((Element)this.node).removeAttribute(name);
                    }
                    catch (DOMException e) {}
                }
            }
        } else {
            CacheAttr ca;
            BeanProperty bp = this.getBeanProperty(prop);
            if (bp.attributes == null) {
                bp.attributes = new ArrayList();
            }
            if ((ca = this.findCacheAttr(bp, name)) == null) {
                ca = new CacheAttr(name, value);
                bp.attributes.add(ca);
            } else {
                ca.value = value;
            }
        }
    }

    void setDefaultAttributeValues(BeanProp prop) {
        BeanProperty bp = this.getBeanProperty(prop);
        if (bp != null) {
            BaseAttribute[] ap = prop.getAttributes();
            for (int i = 0; i < ap.length; ++i) {
                String value = ap[i].getDefaultValue();
                if (value == null) continue;
                this.setAttributeValue(prop, ap[i].getDtdName(), value);
            }
        }
    }

    public String getDomValue(Node n) {
        StringBuffer str = new StringBuffer();
        this.nodeToString(str, n, true);
        return str.toString();
    }

    private void nodeToString(StringBuffer str, Node n, boolean root) {
        if (root) {
            this.nodeChildrenToString(str, n);
        } else {
            while (n != null) {
                this.nodeChildrenToString(str, n);
                n = n.getNextSibling();
            }
        }
    }

    private void nodeChildrenToString(StringBuffer str, Node n) {
        String value = n.getNodeValue();
        short type = n.getNodeType();
        if ((type == 3 || type == 4) && value != null) {
            str.append(value);
        }
        if (n.getFirstChild() != null) {
            this.nodeToString(str, n.getFirstChild(), false);
        }
    }

    Object getValue(BeanProp prop) {
        String ret = null;
        switch (prop.getType() & 0xFF00) {
            case 256: {
                Class cls = prop.getPropClass();
                ret = this.node != null ? this.getDomValue(this.node) : (String)this.getBean(prop);
                if (!String.class.isAssignableFrom(cls) && ret != null) {
                    String clsName = cls.getName().intern();
                    try {
                        if (Wrapper.class.isAssignableFrom(cls)) {
                            Wrapper w = (Wrapper)cls.newInstance();
                            w.setWrapperValue(ret);
                            return w;
                        }
                        if (Character.class.isAssignableFrom(cls)) {
                            String s = ret.trim();
                            char c = '\u0000';
                            if (s.length() == 0) {
                                if (ret.length() != 0) {
                                    c = ret.charAt(0);
                                }
                            } else {
                                c = s.charAt(0);
                            }
                            return new Character(c);
                        }
                        if (charArrayClass.isAssignableFrom(cls)) {
                            return ret.toCharArray();
                        }
                        if (clsName == "org.netbeans.modules.schema2beans.QName" || clsName == "javax.xml.namespace.QName") {
                            String ns = "";
                            String localPart = null;
                            String prefix = "";
                            int colonPos = ret.indexOf(58);
                            if (colonPos < 0) {
                                localPart = ret;
                            } else {
                                prefix = ret.substring(0, colonPos);
                                localPart = ret.substring(colonPos + 1, ret.length());
                                ns = this.findNamespace(prefix);
                            }
                            if (clsName == "org.netbeans.modules.schema2beans.QName") {
                                return new QName(ns, localPart, prefix);
                            }
                            Constructor c = cls.getDeclaredConstructor(String.class, String.class, String.class);
                            return c.newInstance(ns, localPart, prefix);
                        }
                        return JavaBeansUtil.convertValue(cls, ret.trim());
                    }
                    catch (Exception e) {
                        throw new Schema2BeansRuntimeException(MessageFormat.format(Common.getMessage("CantInstantiatePropertyClass_msg"), cls.getName(), prop.getName(), ret, e.getLocalizedMessage()), e);
                    }
                }
                return ret;
            }
            case 512: {
                return this.getBean(prop);
            }
            case 768: {
                return this.nodeToBoolean(prop);
            }
        }
        throw new Schema2BeansRuntimeException(Common.getMessage("TypeNotSupported_msg", prop.getPropClass(), new Integer(prop.getType())));
    }

    protected Boolean nodeToBoolean(BeanProp prop) {
        if (this.node == null) {
            Object result = this.getBean(prop);
            if (result == null) {
                return Boolean.FALSE;
            }
            return (Boolean)result;
        }
        String ret = this.getDomValue(this.node);
        if (ret == null) {
            return Boolean.TRUE;
        }
        if ((ret = ret.toLowerCase().intern()) == "false" || ret == "0") {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected String findNamespace(String prefix) {
        String targetName = "xmlns:" + prefix;
        for (Node n = this.node; n != null; n = n.getParentNode()) {
            Attr a;
            NamedNodeMap nodeMap = n.getAttributes();
            if (nodeMap == null || (a = (Attr)nodeMap.getNamedItem(targetName)) == null) continue;
            return a.getValue();
        }
        return "";
    }

    private String getWrapperValue(Object value) {
        if (value.getClass().isInstance(Wrapper.class)) {
            return ((Wrapper)value).getWrapperValue();
        }
        if (value.getClass().isAssignableFrom(charArrayClass)) {
            return new String((char[])value);
        }
        if (value instanceof Calendar) {
            return DOMBinding.calendarToString((Calendar)value);
        }
        if (value instanceof QName) {
            QName q = (QName)value;
            if ("".equals(q.getPrefix())) {
                return q.getLocalPart();
            }
            return q.getPrefix() + ":" + q.getLocalPart();
        }
        Class<?> cls = value.getClass();
        String clsName = cls.getName();
        if (clsName.equals("javax.xml.namespace.QName")) {
            try {
                Method prefixMethod = cls.getDeclaredMethod("getPrefix", new Class[0]);
                String prefix = (String)prefixMethod.invoke(value, new Object[0]);
                Method localPartMethod = cls.getDeclaredMethod("getLocalPart", new Class[0]);
                String localPart = (String)localPartMethod.invoke(value, new Object[0]);
                if ("".equals(prefix)) {
                    return localPart;
                }
                return prefix + ":" + localPart;
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return value.toString();
    }

    public static String calendarToString(Calendar cal) {
        Date date = cal.getTime();
        SimpleDateFormat formatter = cal.get(10) == 0 && cal.get(12) == 0 && cal.get(13) == 0 ? new SimpleDateFormat("yyyy-MM-dd") : (cal.get(14) == 0 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S"));
        String result = formatter.format(date);
        if (TimeZone.getDefault().hasSameRules(cal.getTimeZone())) {
            return result;
        }
        TimeZone tz = cal.getTimeZone();
        int offset = DOMBinding.timeZoneOffset(tz, 0L);
        if (offset == 0) {
            return result + "Z";
        }
        int seconds = offset / 1000;
        if (seconds > 0) {
            result = result + "+";
        } else {
            seconds = -1 * seconds;
            result = result + "-";
        }
        int hours = seconds / 3600;
        if (hours < 10) {
            result = result + "0";
        }
        result = result + hours + ":";
        int minutes = seconds / 60 % 60;
        if (minutes < 10) {
            result = result + "0";
        }
        result = result + minutes;
        return result;
    }

    Object setValue(BeanProp prop, Object value) {
        Object oldValue = null;
        BeanProperty bp = this.getBeanProperty(prop);
        if (bp != null) {
            oldValue = bp.value;
            if (oldValue == null && this.node != null) {
                oldValue = this.getValue(prop);
            }
            if (Common.isBean(prop.type)) {
                bp.value = value;
            } else if (Common.isString(prop.type) && value != null) {
                if (value instanceof QName) {
                    QName q = (QName)value;
                    String prefix = q.getPrefix();
                    String declaredNS = "";
                    if ("".equals(prefix)) {
                        prefix = prop.getDtdName() + "_ns__";
                        q = new QName(q.getNamespaceURI(), q.getLocalPart(), prefix);
                    } else {
                        declaredNS = this.findNamespace(prefix);
                    }
                    if ("".equals(declaredNS)) {
                        ((Element)this.node).setAttribute("xmlns:" + prefix, q.getNamespaceURI());
                        prop.createTransientAttribute("xmlns:" + prefix);
                    }
                } else {
                    Class<?> cls = value.getClass();
                    String clsName = cls.getName();
                    if (clsName.equals("javax.xml.namespace.QName")) {
                        try {
                            Method prefixMethod = cls.getDeclaredMethod("getPrefix", new Class[0]);
                            String prefix = (String)prefixMethod.invoke(value, new Object[0]);
                            Method nsMethod = cls.getDeclaredMethod("getNamespaceURI", new Class[0]);
                            String ns = (String)nsMethod.invoke(value, new Object[0]);
                            String declaredNS = "";
                            if ("".equals(prefix)) {
                                Method localPartMethod = cls.getDeclaredMethod("getLocalPart", new Class[0]);
                                String localPart = (String)localPartMethod.invoke(value, new Object[0]);
                                Constructor<?> c = cls.getDeclaredConstructor(String.class, String.class, String.class);
                                prefix = prop.getDtdName() + "_ns__";
                                value = c.newInstance(ns, localPart, prefix);
                            } else {
                                declaredNS = this.findNamespace(prefix);
                            }
                            if ("".equals(declaredNS)) {
                                ((Element)this.node).setAttribute("xmlns:" + prefix, ns);
                                prop.createTransientAttribute("xmlns:" + prefix);
                            }
                        }
                        catch (NoSuchMethodException e) {
                            throw new RuntimeException(e);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                        catch (InstantiationException e) {
                            throw new RuntimeException(e);
                        }
                        catch (InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                bp.value = this.getWrapperValue(value);
            } else {
                bp.value = value;
            }
        }
        return oldValue;
    }

    private static int timeZoneOffset(TimeZone tz, long date) {
        if (tz.inDaylightTime(new Date(date))) {
            return tz.getRawOffset() + (tz.useDaylightTime() ? 3600000 : 0);
        }
        return tz.getRawOffset();
    }

    void remove(BeanProp prop) {
    }

    void removeProp(BeanProp prop) {
        if (this.prop != null && this.prop.beanProp == prop) {
            this.prop = null;
        }
    }

    void removeNode(BeanProp prop) {
        if (this.node != null) {
            Node parent = prop.getParentNode();
            if (DDLogFlags.debug) {
                TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 20, this.node.getNodeName() + " from " + parent.getNodeName());
            }
            DOMBinding.removeSurroundingSpace(parent, this.node);
            parent.removeChild(this.node);
            this.node = null;
        }
    }

    private static void removeSurroundingSpace(Node parent, Node node) {
        String s;
        Node nextNode = node.getNextSibling();
        if (nextNode != null && nextNode.getNodeType() == 3 && (s = nextNode.getNodeValue()).trim().length() == 0) {
            int i = s.indexOf(10);
            if (i == -1) {
                parent.removeChild(nextNode);
            } else {
                s = s.substring(i);
                Node previousNode = node.getPreviousSibling();
                if (previousNode != null && previousNode.getNodeType() == 3) {
                    String s1 = previousNode.getNodeValue();
                    if (previousNode.getPreviousSibling() != null) {
                        if (s1.trim().length() == 0) {
                            i = s1.lastIndexOf(10);
                            if (i > 0) {
                                s = s1.substring(0, i) + s;
                            } else {
                                parent.removeChild(previousNode);
                            }
                        }
                    } else {
                        parent.removeChild(previousNode);
                    }
                }
                nextNode.setNodeValue(s);
            }
        }
    }

    void notifyBeansForChange(Object oldValue, Object newValue, String attrName) {
        if (this.prop != null) {
            PropertyChangeEvent e = this.prop.beanProp.prepareForChangeEvent(this, oldValue, newValue, attrName);
            this.prop.beanProp.notifyInternal(e, true);
        }
    }

    void syncNodes(BeanProp prop, BeanProp.Action a) {
        BeanProperty bp = this.getBeanProperty(prop);
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 17, a.toString() + " " + prop.getDtdName() + (bp == null ? " - unknown prop!" : ""));
        }
        if (bp == null) {
            return;
        }
        if (a.action == 2) {
            int i = prop.idToIndex(this.id);
            if (i != -1) {
                bp.lastIndex = i;
            }
            PropertyChangeEvent e = prop.prepareForChangeEvent(this, bp.value, null, null);
            if (Common.isBean(prop.type)) {
                BaseBean bean = (BaseBean)bp.value;
                bean.syncNodes(a);
            }
            if (this.prop != null && this.prop.beanProp == prop && this.node != null && (prop.getType() & 0xFF00) == 256) {
                bp.value = this.getDomValue(this.node);
            }
            this.removeNode(prop);
            prop.notifyInternal(e, false);
        } else if (a.action == 1) {
            Node sibling;
            Node parent;
            if (Common.isBean(prop.type)) {
                NodeFactory f = prop.getNodeFactory();
                if (this.node != null) {
                    System.out.println("Removing from old graph.");
                    BeanProp.Action a2 = new BeanProp.Action(2);
                    this.syncNodes(this.prop.beanProp, a2);
                }
                parent = prop.getParentNode();
                this.node = f.createElement(prop);
                if (DDLogFlags.debug) {
                    TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 19, "adding new child " + this.node.getNodeName() + " to node " + parent.getNodeName());
                }
                sibling = prop.getFollowingSibling(this);
                parent.insertBefore(this.node, sibling);
                BaseBean bean = (BaseBean)bp.value;
                bean.setGraphManager(prop.bean.graphManager());
                bean.syncNodes(a);
            } else if (Common.isBoolean(prop.type)) {
                boolean v = false;
                if (bp.value != null) {
                    v = (Boolean)bp.value;
                }
                if (Common.shouldNotBeEmpty(prop.type) || this.node == null || this.nodeToBoolean(prop) != v) {
                    if (DDLogFlags.debug) {
                        TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 19, (v ? "adding new" : "removing") + " tag " + prop.getDtdName());
                    }
                    parent = prop.getParentNode();
                    if (v || Common.shouldNotBeEmpty(prop.type)) {
                        NodeFactory f = prop.getNodeFactory();
                        if (this.node == null) {
                            this.node = f.createElement(prop);
                            Node sibling2 = prop.getFollowingSibling(this);
                            parent.insertBefore(this.node, sibling2);
                        }
                        if (Common.shouldNotBeEmpty(prop.type)) {
                            CharacterData text = (CharacterData)this.node.getFirstChild();
                            if (text == null) {
                                text = (CharacterData)f.createText();
                                this.node.appendChild(text);
                                if (DDLogFlags.debug) {
                                    TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 19, "adding new text node " + text.getNodeName() + " to node " + this.node.getNodeName());
                                }
                            }
                            text.setData("" + v);
                        }
                    } else if (this.node != null) {
                        parent.removeChild(this.node);
                        this.node = null;
                    }
                } else if (DDLogFlags.debug) {
                    TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 19, "keeping same boolean value");
                }
            } else {
                CharacterData text;
                NodeFactory f = prop.getNodeFactory();
                if (this.node == null) {
                    parent = prop.getParentNode();
                    this.node = f.createElement(prop);
                    if (DDLogFlags.debug) {
                        TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 19, "adding new child " + this.node.getNodeName() + " to node " + parent.getNodeName());
                    }
                    sibling = prop.getFollowingSibling(this);
                    parent.insertBefore(this.node, sibling);
                }
                if ((text = (CharacterData)this.node.getFirstChild()) == null) {
                    text = (CharacterData)f.createText();
                    this.node.appendChild(text);
                    if (DDLogFlags.debug) {
                        TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 19, "adding new text node " + text.getNodeName() + " to node " + this.node.getNodeName());
                    }
                }
                text.setData(bp.value.toString());
            }
            if (this.node != null && bp.attributes != null) {
                for (int i = 0; i < bp.attributes.size(); ++i) {
                    CacheAttr ca = (CacheAttr)bp.attributes.get(i);
                    if (ca.value == null) continue;
                    ((Element)this.node).setAttribute(ca.name, ca.value);
                }
                bp.attributes = null;
            }
        } else {
            throw new IllegalArgumentException(Common.getMessage("UnknownAction_msg", new Integer(a.action)));
        }
    }

    boolean hasDomNode() {
        return this.node != null;
    }

    class BeanProperty {
        BeanProp beanProp;
        Object value;
        int lastIndex;
        ArrayList attributes;

        BeanProperty(BeanProp b) {
            this.beanProp = b;
            this.value = null;
            this.lastIndex = -1;
            this.attributes = null;
        }
    }

    class CacheAttr {
        String name;
        String value;

        CacheAttr(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

