/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.event.infomanLite.model;

import de.proveo.event.util.raw.ByteArrayBigEndianParser;
import java.io.IOException;
import org.apache.commons.lang.builder.ToStringBuilder;

public class InfomanLiteSession {
    private final String imei;
    boolean[] reservedBits = new boolean[4];

    public InfomanLiteSession(byte[] data) throws IOException {
        ByteArrayBigEndianParser parse = new ByteArrayBigEndianParser(data);
        this.imei = parse.getBCD(0, 0, 15);
        this.reservedBits[0] = parse.isSet(7, 4);
        this.reservedBits[1] = parse.isSet(7, 5);
        this.reservedBits[2] = parse.isSet(7, 6);
        this.reservedBits[3] = parse.isSet(7, 7);
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("imei", (Object)this.getIMEI());
        builder.append("reservedBits", this.reservedBits);
        return builder.toString();
    }

    public String getIMEI() {
        return this.imei;
    }
}

