/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.event.infomanLite.model;

import de.proveo.event.util.raw.ByteArrayLittleEndianParser;
import de.proveo.event.util.raw.ByteUtil;
import java.io.IOException;
import org.apache.commons.lang.builder.ToStringBuilder;

public class InfomanLiteEvent {
    public static final int FRAME_HEADER_START_BYTE = 224;
    final byte[] data;
    final int checksum;
    final int length;
    private String serialNumber;

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public InfomanLiteEvent(byte[] data, int length, int checksum) {
        this.data = data;
        this.checksum = checksum;
        this.length = length;
    }

    protected static int checkDataLength(int dataLength) throws IOException {
        if (dataLength > 255) {
            throw new IOException("packets with a length more then 255 are not supported");
        }
        if (dataLength < 0) {
            throw new IllegalArgumentException("length cannot be less then zero");
        }
        return dataLength;
    }

    public static int parseHeader(ByteArrayLittleEndianParser headerParser) throws IOException {
        if (headerParser.size() != 2) {
            throw new IllegalArgumentException("unexpected header length: " + headerParser.size());
        }
        if (headerParser.getUnsignedByte(0) != 224) {
            throw new IOException("wrong start byte:" + headerParser.getUnsignedByte(0));
        }
        return InfomanLiteEvent.checkDataLength(headerParser.getUnsignedByte(1));
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("imei", (Object)this.serialNumber);
        builder.append("length", this.length);
        builder.append("checksum", this.checksum);
        StringBuffer dataStr = new StringBuffer("\n");
        for (int index = 0; index < this.data.length; index += 16) {
            int bytesInLine = 16;
            if (index + bytesInLine > this.data.length) {
                bytesInLine = this.data.length - index;
            }
            dataStr.append(ByteUtil.toHexString((byte[])this.data, (int)index, (int)bytesInLine));
            dataStr.append("\n");
        }
        builder.append("data", (Object)dataStr);
        return builder.toString();
    }

    public int getChecksum() {
        return this.checksum;
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] toByteArray() {
        byte[] arr = new byte[2 + this.data.length];
        arr[0] = -32;
        arr[1] = (byte)this.length;
        System.arraycopy(this.data, 0, arr, 2, this.data.length - 1);
        arr[arr.length - 1] = (byte)this.checksum;
        return arr;
    }
}

