/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.software.archive.util;

import java.io.IOException;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.SaveAsCapable;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class PropertiesDataObject
extends MultiDataObject {
    private Lookup lookup = null;

    public PropertiesDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException, IOException {
        super(pf, loader);
        CookieSet cookies = this.getCookieSet();
        CloneableEditorSupport ces = DataEditorSupport.create((DataObject)this, (MultiDataObject.Entry)this.getPrimaryEntry(), (CookieSet)cookies);
        this.lookup = new ProxyLookup(new Lookup[]{cookies.getLookup(), Lookups.singleton((Object)ces)});
        cookies.add((Node.Cookie)ces);
        cookies.assign(SaveAsCapable.class, (Object[])new SaveAsCapable[]{new SaveAsCapableImpl()});
    }

    protected Node createNodeDelegate() {
        return new DataNode((DataObject)this, Children.LEAF, this.getLookup());
    }

    public Lookup getLookup() {
        if (this.lookup == null) {
            return this.getCookieSet().getLookup();
        }
        return this.lookup;
    }

    private class SaveAsCapableImpl
    implements SaveAsCapable {
        private SaveAsCapableImpl() {
        }

        public void saveAs(FileObject folder, String name) throws IOException {
            CloneableEditorSupport support = (CloneableEditorSupport)PropertiesDataObject.this.getLookup().lookup(CloneableEditorSupport.class);
            if (support != null && support instanceof DataEditorSupport) {
                ((DataEditorSupport)support).saveAs(folder, name);
            }
        }
    }
}

