/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.software.archive.util;

import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.gui.util.DialogUtil;
import de.proveo.idm.software.archive.api.Resource;
import de.proveo.idm.software.archive.impl.filefilter.ExpectedSizeFileFilter;
import de.proveo.idm.software.archive.impl.filefilter.ExtendedFileNameExtensionFilter;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class FileUtil {
    protected static final FileNameExtensionFilter ubootEnvFileFilter = new FileNameExtensionFilter(NbBundle.getMessage(FileUtil.class, (String)"FileUtil.ubootEnv.description"), NbBundle.getMessage(FileUtil.class, (String)"FileUtil.ubootEnv.extension"));
    protected static final FileNameExtensionFilter pmFirmwareFileFilter = new FileNameExtensionFilter(NbBundle.getMessage(FileUtil.class, (String)"FileUtil.pmFirmware.description"), NbBundle.getMessage(FileUtil.class, (String)"FileUtil.pmFirmware.extension"));
    protected static final FileFilter ubootImageFileFilter;
    protected static final FileFilter kernelImageFileFilter;
    protected static final FileFilter userspaceImageFileFilter;
    protected static final FileFilter userspaceArchiveFileFilter;
    protected static final FileFilter infomanSoftwareFileFilter;
    protected static final FileFilter elitoKernelFileFilter;
    protected static final FileFilter elitoUserspaceFileFilter;
    protected static final FileFilter configurationFileFilter;
    protected static final FileFilter infomanEFMConfigurationFileFilter;
    protected static final FileFilter modemFirmwareFileFilter;
    protected static final FileFilter nomoFirmwareFileFilter;
    protected static final FileFilter infomanEFMBinaryFileFilter;
    protected static final FileFilter infomanEFMDebugFileFilter;
    protected static final FileFilter infomanEFMBootloaderFileFilter;

    public static String getAbsolutePath(Resource resource) {
        File file;
        if (resource != null && (file = resource.getAsFile()) != null) {
            return file.getAbsolutePath();
        }
        return "";
    }

    public static File getFile(String path) {
        if (path != null && path.trim().length() != 0) {
            return new File(path);
        }
        return null;
    }

    public static List<FileFilter> getFileFilters(Device.DeviceType deviceType, Resource.ResourceType type) {
        ArrayList<FileFilter> fileFilters = new ArrayList<FileFilter>();
        block0 : switch (type) {
            case INFOMAN_INSTALL_ARCHIVE: 
            case INFOMAN_UPDATE_ARCHIVE: {
                fileFilters.add(infomanSoftwareFileFilter);
                break;
            }
            case KERNEL_IMAGE: {
                fileFilters.add(kernelImageFileFilter);
                fileFilters.add(elitoKernelFileFilter);
                break;
            }
            case USERSPACE_IMAGE: {
                fileFilters.add(userspaceImageFileFilter);
                fileFilters.add(elitoUserspaceFileFilter);
                break;
            }
            case USERSPACE_ARCHIVE: {
                fileFilters.add(userspaceArchiveFileFilter);
                break;
            }
            case BOOTLOADER_ENV_SETTINGS: {
                fileFilters.add(ubootEnvFileFilter);
                break;
            }
            case BOOTLOADER_IMAGE: {
                fileFilters.add(ubootImageFileFilter);
                break;
            }
            case POWERMANAGEMENT_FIRMWARE: {
                fileFilters.add(pmFirmwareFileFilter);
                break;
            }
            case MODEM_FIRMWARE: {
                fileFilters.add(modemFirmwareFileFilter);
                break;
            }
            case CONFIG_TEMPLATE: 
            case EXAMPLES_CONFIG: {
                switch (deviceType) {
                    case INFOMAN_EFM: {
                        fileFilters.add(infomanEFMConfigurationFileFilter);
                        break block0;
                    }
                }
                fileFilters.add(configurationFileFilter);
                break;
            }
            case APPLICATION: 
            case APPLICATION_JTAG: 
            case APPLICATION_BOOT: 
            case INSTALL_BINARY: 
            case BOOTLOADER_BINARY: {
                fileFilters.add(infomanEFMBinaryFileFilter);
                break;
            }
            case APPLICATION_JTAG_DEBUG: 
            case APPLICATION_BOOT_DEBUG: 
            case DEBUG_INSTALL_BINARY: 
            case DEBUG_BOOTLOADER_BINARY: {
                fileFilters.add(infomanEFMDebugFileFilter);
                break;
            }
            case BOOTLOADER: {
                fileFilters.add(infomanEFMBootloaderFileFilter);
                break;
            }
            case NOMO_FIRMWARE: {
                fileFilters.add(nomoFirmwareFileFilter);
            }
        }
        return fileFilters;
    }

    public static String getResourcesDirectoryPath() {
        FileObject root = org.openide.filesystems.FileUtil.getConfigRoot();
        FileObject resources = root.getFileObject("resources");
        if (resources == null) {
            try {
                resources = root.createFolder("resources");
            }
            catch (IOException ex) {
                return System.getProperty("java.io.tmpdir");
            }
        }
        return org.openide.filesystems.FileUtil.toFile((FileObject)resources).getAbsolutePath();
    }

    public static File showFileOpenDialog(Component parent, Device.DeviceType deviceType, Resource.ResourceType ... type) {
        ArrayList<FileFilter> filters = new ArrayList<FileFilter>();
        for (Resource.ResourceType t : type) {
            for (FileFilter fileFilter : FileUtil.getFileFilters(deviceType, t)) {
                filters.add(fileFilter);
            }
        }
        return DialogUtil.showSingleOpenFileChooserDialog((String)"FileUtil.currentPath", (boolean)filters.isEmpty(), (boolean)true, (int)0, (FileFilter[])filters.toArray(new FileFilter[filters.size()]));
    }

    static {
        userspaceArchiveFileFilter = new ExtendedFileNameExtensionFilter(NbBundle.getMessage(FileUtil.class, (String)"FileUtil.userspaceArchive.description"), NbBundle.getMessage(FileUtil.class, (String)"FileUtil.userspaceArchive.extension"));
        infomanSoftwareFileFilter = new ExtendedFileNameExtensionFilter(NbBundle.getMessage(FileUtil.class, (String)"FileUtil.infomanSoftwareFile.description"), NbBundle.getMessage(FileUtil.class, (String)"FileUtil.infomanSoftwareFile.extension"));
        modemFirmwareFileFilter = new ExtendedFileNameExtensionFilter(NbBundle.getMessage(FileUtil.class, (String)"FileUtil.modemFirmware.description"), NbBundle.getMessage(FileUtil.class, (String)"FileUtil.modemFirmware.extension"));
        nomoFirmwareFileFilter = new ExtendedFileNameExtensionFilter(NbBundle.getMessage(FileUtil.class, (String)"FileUtil.nomoFirmware.description"), NbBundle.getMessage(FileUtil.class, (String)"FileUtil.nomoFirmware.extension"));
        infomanEFMBinaryFileFilter = new ExtendedFileNameExtensionFilter(NbBundle.getMessage(FileUtil.class, (String)"FileUtil.infomanEFMBinaryFile.description"), NbBundle.getMessage(FileUtil.class, (String)"FileUtil.infomanEFMBinaryFile.extension"));
        infomanEFMDebugFileFilter = new ExtendedFileNameExtensionFilter(NbBundle.getMessage(FileUtil.class, (String)"FileUtil.infomanEFMDebugFile.description"), NbBundle.getMessage(FileUtil.class, (String)"FileUtil.infomanEFMDebugFile.extension.elf"), NbBundle.getMessage(FileUtil.class, (String)"FileUtil.infomanEFMDebugFile.extension.map"));
        infomanEFMBootloaderFileFilter = new ExtendedFileNameExtensionFilter(NbBundle.getMessage(FileUtil.class, (String)"FileUtil.infomanEFMBootloaderFile.description"), NbBundle.getMessage(FileUtil.class, (String)"FileUtil.infomanEFMBootloaderFile.extension.bup"));
        String[] extensions = new String[]{NbBundle.getMessage(FileUtil.class, (String)"FileUtil.ubootImage.extension"), NbBundle.getMessage(FileUtil.class, (String)"FileUtil.image.extension.compressed")};
        FileNameExtensionFilter ubootImgExtFilter = new FileNameExtensionFilter(NbBundle.getMessage(FileUtil.class, (String)"FileUtil.ubootImage.description"), extensions);
        ubootImageFileFilter = new ExpectedSizeFileFilter(ubootImgExtFilter, 102400L, 204800L);
        extensions[0] = NbBundle.getMessage(FileUtil.class, (String)"FileUtil.image.extension");
        ExtendedFileNameExtensionFilter imgExtFilter = new ExtendedFileNameExtensionFilter(NbBundle.getMessage(FileUtil.class, (String)"FileUtil.image.description"), extensions);
        kernelImageFileFilter = new ExpectedSizeFileFilter(imgExtFilter, 0x100000L, 0x200000L);
        userspaceImageFileFilter = new ExpectedSizeFileFilter(imgExtFilter, 0xF00000L, 0x2100000L);
        imgExtFilter = new ExtendedFileNameExtensionFilter(NbBundle.getMessage(FileUtil.class, (String)"FileUtil.elito.kernel.description"), NbBundle.getMessage(FileUtil.class, (String)"FileUtil.elito.kernel.extension"));
        elitoKernelFileFilter = new ExpectedSizeFileFilter(imgExtFilter, 0x100000L, 0x200000L);
        imgExtFilter = new ExtendedFileNameExtensionFilter(NbBundle.getMessage(FileUtil.class, (String)"FileUtil.elito.userspace.description"), NbBundle.getMessage(FileUtil.class, (String)"FileUtil.elito.userspace.extension"));
        elitoUserspaceFileFilter = new ExpectedSizeFileFilter(imgExtFilter, 0xF00000L, 0x2100000L);
        configurationFileFilter = new ExtendedFileNameExtensionFilter(NbBundle.getMessage(FileUtil.class, (String)"FileUtil.configuration.description"), NbBundle.getMessage(FileUtil.class, (String)"FileUtil.configuration.extension"));
        infomanEFMConfigurationFileFilter = new ExtendedFileNameExtensionFilter(NbBundle.getMessage(FileUtil.class, (String)"FileUtil.infomanEFM.configuration.description"), NbBundle.getMessage(FileUtil.class, (String)"FileUtil.infomanEFM.configuration.extension"));
    }
}

