/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.software.archive.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.security.MessageDigest;
import org.apache.commons.io.IOUtils;
import org.openide.util.Exceptions;

public class ChecksumUtil {
    public static String generateSHA1Checksum(byte[] data) {
        StringBuilder buffer = new StringBuilder();
        try {
            byte[] mdBytes;
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(data);
            for (byte b : mdBytes = md.digest()) {
                buffer.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
            }
            return buffer.toString();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return buffer.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String generateSHA1Checksum(File file) {
        String string;
        FileInputStream fStream = null;
        ByteArrayOutputStream bOut = null;
        try {
            int input;
            fStream = new FileInputStream(file);
            bOut = new ByteArrayOutputStream();
            while ((input = fStream.read()) != -1) {
                bOut.write(input);
            }
            string = ChecksumUtil.generateSHA1Checksum(bOut.toByteArray());
        }
        catch (IOException ex) {
            try {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fStream);
                IOUtils.closeQuietly(bOut);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fStream);
            IOUtils.closeQuietly((OutputStream)bOut);
            return null;
        }
        IOUtils.closeQuietly((InputStream)fStream);
        IOUtils.closeQuietly((OutputStream)bOut);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String parseSHA1Checksum(File file) {
        FileReader reader = null;
        BufferedReader bf = null;
        StringBuilder builder = new StringBuilder();
        try {
            reader = new FileReader(file);
            bf = new BufferedReader(reader);
            String checksumStr = bf.readLine();
            builder.append(checksumStr.substring(0, checksumStr.indexOf(" ")));
        }
        catch (Exception ex) {
            try {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)reader);
        }
        IOUtils.closeQuietly((Reader)reader);
        return builder.toString();
    }
}

