/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.software.archive.util;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.gui.navigation.api.SoftwareBundle;
import de.proveo.idm.software.archive.api.AbstractInfomanEFMSoftwareBundle;
import de.proveo.idm.software.archive.api.AbstractInfomanSoftwareBundle;
import de.proveo.idm.software.archive.api.AbstractNoMoSoftwareBundle;
import de.proveo.idm.software.archive.api.InfomanSoftwareArchiveManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class BundleHandlerChooser
extends PanelBuilder {
    private static final InfomanSoftwareArchiveManager INFOMAN_SOFTWARE_ARCHIVE = (InfomanSoftwareArchiveManager)Lookup.getDefault().lookup(InfomanSoftwareArchiveManager.class);
    private final Collection<AbstractInfomanSoftwareBundle> infomanBundles = INFOMAN_SOFTWARE_ARCHIVE.getAllInfomanBundles();
    private final Collection<AbstractInfomanEFMSoftwareBundle> infomanLiteBundles = INFOMAN_SOFTWARE_ARCHIVE.getAllInfomanEFMBundles();
    private final Collection<AbstractNoMoSoftwareBundle> nomoBundles = INFOMAN_SOFTWARE_ARCHIVE.getAllNoMoBundles();
    private final List<SoftwareBundle> allBundles = new ArrayList<SoftwareBundle>();
    private final CellConstraints cc = new CellConstraints();
    private final ButtonGroup btnGroup = new ButtonGroup();

    public BundleHandlerChooser() throws UnsupportedOperationException {
        this(null, Device.DeviceType.ANY);
    }

    public BundleHandlerChooser(String message) throws UnsupportedOperationException {
        this(message, Device.DeviceType.ANY);
    }

    public BundleHandlerChooser(Device.DeviceType deviceType) throws UnsupportedOperationException {
        this(null, deviceType);
    }

    public BundleHandlerChooser(String message, Device.DeviceType deviceType) throws UnsupportedOperationException {
        super(new FormLayout("3dlu, fill:default:grow, 3dlu", "3dlu, p, 3dlu, p, 3dlu"));
        if (Device.DeviceType.INFOMAN.equals((Object)deviceType) || Device.DeviceType.ANY.equals((Object)deviceType) || Device.DeviceType.UNKNOWN.equals((Object)deviceType)) {
            this.allBundles.addAll(this.infomanBundles);
        }
        if (Device.DeviceType.INFOMAN_EFM.equals((Object)deviceType) || Device.DeviceType.ANY.equals((Object)deviceType) || Device.DeviceType.UNKNOWN.equals((Object)deviceType)) {
            this.allBundles.addAll(this.infomanLiteBundles);
        }
        if (Device.DeviceType.NOMO.equals((Object)deviceType) || Device.DeviceType.ANY.equals((Object)deviceType) || Device.DeviceType.UNKNOWN.equals((Object)deviceType)) {
            this.allBundles.addAll(this.nomoBundles);
        }
        this.init(message);
    }

    private void init(String message) throws UnsupportedOperationException {
        if (this.allBundles.isEmpty()) {
            throw new UnsupportedOperationException("No bundle installed!");
        }
        String labelTxt = message != null ? message : NbBundle.getMessage(BundleHandlerChooser.class, (String)"BundleHandlerChooser.default");
        this.addLabel(labelTxt, this.cc.xy(2, 2));
        int rowOffset = 6;
        for (SoftwareBundle isb : this.allBundles) {
            this.getLayout().appendRow(RowSpec.decode((String)"p"));
            this.getLayout().appendRow(RowSpec.decode((String)"3dlu"));
            JRadioButton rdBtn = new JRadioButton(isb.getVersion());
            this.btnGroup.add(rdBtn);
            if (rowOffset == 6) {
                rdBtn.setSelected(true);
            }
            this.add(rdBtn, this.cc.xy(2, rowOffset));
            rowOffset += 2;
        }
    }

    public SoftwareBundle getSelectedBundle() {
        Enumeration<AbstractButton> rdButtons = this.btnGroup.getElements();
        while (rdButtons.hasMoreElements()) {
            AbstractButton btn = rdButtons.nextElement();
            if (!btn.isSelected()) continue;
            String chosenBundle = btn.getText();
            for (SoftwareBundle isb : this.allBundles) {
                if (!isb.getVersion().equals(chosenBundle)) continue;
                return isb;
            }
        }
        return null;
    }
}

