/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.software.archive.impl.nav.actions;

import de.proveo.idm.software.archive.api.InfomanResourceNavigationItem;
import de.proveo.idm.software.archive.api.Resource;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class OpenPropertiesAction
extends AbstractAction
implements ContextAwareAction {
    private Lookup lookup;

    public OpenPropertiesAction() {
        super(NbBundle.getMessage(OpenPropertiesAction.class, (String)"OpenPropertiesAction.name"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        InfomanResourceNavigationItem item = (InfomanResourceNavigationItem)((Object)this.lookup.lookup(InfomanResourceNavigationItem.class));
        Resource resource = item.getInfomanResource();
        File file = resource.getAsFile();
        try {
            OpenCookie cookie;
            FileObject gpsFileObj = FileUtil.toFileObject((File)file);
            DataObject dataObj = DataObject.find((FileObject)gpsFileObj);
            if (dataObj != null && (cookie = (OpenCookie)dataObj.getCookie(OpenCookie.class)) != null) {
                cookie.open();
            }
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        OpenPropertiesAction ret = new OpenPropertiesAction();
        ret.lookup = actionContext;
        return ret;
    }
}

