/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.software.archive.impl.nav.actions;

import de.proveo.idm.core.gui.navigation.api.SoftwareBundle;
import de.proveo.idm.core.gui.util.DialogUtil;
import de.proveo.idm.core.util.ThreadPool;
import de.proveo.idm.software.archive.api.AbstractInfomanEFMSoftwareBundle;
import de.proveo.idm.software.archive.api.AbstractInfomanSoftwareBundle;
import de.proveo.idm.software.archive.impl.BundleDownloader;
import de.proveo.idm.software.archive.impl.BundleExtractor;
import de.proveo.idm.software.archive.impl.filefilter.ExtendedFileNameExtensionFilter;
import de.proveo.idm.software.archive.impl.nav.BundleNavigationItem;
import de.proveo.idm.software.archive.util.FileUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class InstallResourcesLocalAction
extends AbstractAction
implements ContextAwareAction {
    private static final Logger log = Logger.getLogger(InstallResourcesLocalAction.class.getName());
    private Lookup lookup;

    public InstallResourcesLocalAction() {
        super(NbBundle.getMessage(InstallResourcesLocalAction.class, (String)"InstallResourcesLocalAction.name"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ExtendedFileNameExtensionFilter fileFilter;
        SoftwareBundle bundle = (SoftwareBundle)this.lookup.lookup(SoftwareBundle.class);
        if (bundle instanceof BundleNavigationItem) {
            bundle = ((BundleNavigationItem)bundle).getBundle();
        }
        if (bundle instanceof AbstractInfomanSoftwareBundle) {
            fileFilter = new ExtendedFileNameExtensionFilter(NbBundle.getMessage(InstallResourcesLocalAction.class, (String)"InstallResourcesLocalAction.infoman.archive.desc"), NbBundle.getMessage(InstallResourcesLocalAction.class, (String)"InstallResourcesLocalAction.infoman.archive.ext"));
        } else if (bundle instanceof AbstractInfomanEFMSoftwareBundle) {
            fileFilter = new ExtendedFileNameExtensionFilter(NbBundle.getMessage(InstallResourcesLocalAction.class, (String)"InstallResourcesLocalAction.infomanEFM.archive.desc"), NbBundle.getMessage(InstallResourcesLocalAction.class, (String)"InstallResourcesLocalAction.infomanEFM.archive.ext"));
        } else {
            log.log(Level.INFO, "Software bundle in lookup is neither a AbstractInfomanSoftwareBundle nor a AbstractInfomanEFMSoftwareBundle: {0}", bundle);
            return;
        }
        File resource = DialogUtil.showSingleOpenFileChooserDialog((String)"InstallResourcesLocalAction.resourcePath", (boolean)false, (boolean)false, (int)0, (FileFilter[])new FileFilter[]{fileFilter});
        if (resource != null) {
            File extractTo;
            final String bundleName = bundle.getFilename();
            final File destination = new File(FileUtil.getResourcesDirectoryPath(), "SoftwareArchive" + File.separator + bundleName);
            if (!destination.equals(resource)) {
                if (destination.exists()) {
                    try {
                        FileUtils.forceDelete((File)destination);
                    }
                    catch (Exception ex) {
                        log.log(Level.WARNING, "Could not delete previous resource folder", ex);
                    }
                }
                try {
                    FileUtils.copyFile((File)resource, (File)destination);
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "Could not copy selected archive to resource storage (temporary user directory)", ex);
                    return;
                }
            }
            String tmpArchiveFilenamePrefix = "infomanBundle-";
            String[] bundleNameSplitted = StringUtils.split((String)bundleName, (String)"-");
            if (bundleNameSplitted.length != 0) {
                tmpArchiveFilenamePrefix = bundleNameSplitted[0] + "-";
            }
            if ((extractTo = new File(FileUtil.getResourcesDirectoryPath(), "SoftwareArchive" + File.separator + tmpArchiveFilenamePrefix + bundle.getVersion())).exists()) {
                try {
                    FileUtils.forceDelete((File)extractTo);
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "Could not delete previous extracted resource folder", ex);
                }
            }
            final SoftwareBundle softwareBundle = bundle;
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    ProgressHandle handle = ProgressHandleFactory.createHandle((String)(NbBundle.getMessage(BundleDownloader.class, (String)"BundleDownloader.progress.fetching") + " " + bundleName + " ..."));
                    handle.start();
                    handle.switchToIndeterminate();
                    BundleExtractor extractor = new BundleExtractor(handle, softwareBundle, destination, extractTo);
                    extractor.execute();
                }
            };
            ThreadPool.getInstance().execute(run);
        }
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        InstallResourcesLocalAction ret = new InstallResourcesLocalAction();
        ret.lookup = actionContext;
        return ret;
    }
}

