/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.software.archive.impl.nav;

import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.navigation.api.impl.NavigationItemNode;
import de.proveo.idm.core.gui.navigation.sheet.ReadOnlyProperty;
import de.proveo.idm.software.archive.api.InfomanResourceNavigationItem;
import de.proveo.idm.software.archive.api.Resource;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class InfomanResourceNode
extends NavigationItemNode {
    public InfomanResourceNode(InfomanResourceNavigationItem infomanResourceNavigationItem) {
        super((NavigationItem)infomanResourceNavigationItem);
        String actionPath = this.getActionPathForResource(infomanResourceNavigationItem.getInfomanResource());
        if (actionPath != null) {
            this.setActionPath(actionPath);
        }
    }

    public String getIconBaseWithExtension() {
        return "de/proveo/idm/software/archive/impl/nav/icons/file.png";
    }

    public HelpCtx getHelpCtx() {
        return ((InfomanResourceNavigationItem)this.navigationItem).getInfomanResource().getHelp();
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.setName("file");
        set.setDisplayName(NbBundle.getMessage(InfomanResourceNode.class, (String)"InfomanResourceNode.set.file"));
        sheet.put(set);
        Resource resource = ((InfomanResourceNavigationItem)this.navigationItem).getInfomanResource();
        if (resource != null) {
            Object value = resource.getName();
            if (value == null) {
                value = "";
            }
            ReadOnlyProperty property = new ReadOnlyProperty("name", NbBundle.getMessage(InfomanResourceNode.class, (String)"InfomanResourceNode.attribute.name"), value);
            set.put((Node.Property)property);
            value = resource.getVersion();
            if (value == null) {
                value = "";
            }
            property = new ReadOnlyProperty("version", NbBundle.getMessage(InfomanResourceNode.class, (String)"InfomanResourceNode.attribute.version"), value);
            set.put((Node.Property)property);
            value = resource.getShortDescription();
            if (value == null) {
                value = "";
            }
            property = new ReadOnlyProperty("description", NbBundle.getMessage(InfomanResourceNode.class, (String)"InfomanResourceNode.attribute.description"), value);
            property.setShortDescription(resource.getLongDescription());
            set.put((Node.Property)property);
            value = "0";
            File file = resource.getAsFile();
            if (file != null) {
                value = (double)FileUtils.sizeOf((File)file) / 1024.0;
            }
            ReadOnlyProperty property2 = new ReadOnlyProperty("fileSize", NbBundle.getMessage(InfomanResourceNode.class, (String)"InfomanResourceNode.attribute.fileSize"), value);
            set.put((Node.Property)property2);
        }
        return sheet;
    }

    private String getActionPathForResource(Resource resource) {
        if (resource != null) {
            Resource.ResourceType type = resource.getResourceType();
            switch (type) {
                case BOOTLOADER_ENV_SETTINGS: {
                    return "Actions/InfomanResource/Types/UBootSettings";
                }
                case EXAMPLES_CONFIG: {
                    String rName = resource.getName();
                    if (rName == null) break;
                    if (rName.endsWith("gps.properties")) {
                        return "Actions/InfomanResource/Types/ExampleConfigurations/GPS";
                    }
                    return "Actions/InfomanResource/Types/ExampleConfigurations/Infoman";
                }
            }
        }
        return null;
    }
}

