/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.software.archive.impl.filefilter;

import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;

public class ExtendedFileNameExtensionFilter
extends FileFilter {
    private final String description;
    private final String[] extensions;
    private final String[] lowerCaseExtensions;

    public ExtendedFileNameExtensionFilter(String description, String ... extensions) {
        if (extensions == null || extensions.length == 0) {
            throw new IllegalArgumentException("Extensions must be non-null and not empty");
        }
        this.description = description;
        this.extensions = new String[extensions.length];
        this.lowerCaseExtensions = new String[extensions.length];
        for (int i = 0; i < extensions.length; ++i) {
            if (extensions[i] == null || extensions[i].length() == 0) {
                throw new IllegalArgumentException("Each extension must be non-null and not empty");
            }
            this.extensions[i] = extensions[i];
            this.lowerCaseExtensions[i] = extensions[i].toLowerCase(Locale.ENGLISH);
        }
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String fileName = f.getName().toLowerCase(Locale.ENGLISH);
            int i = fileName.lastIndexOf(46);
            if (i > 0 && i < fileName.length() - 1) {
                for (String extension : this.lowerCaseExtensions) {
                    if (!fileName.endsWith(extension)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String[] getExtensions() {
        String[] result = new String[this.extensions.length];
        System.arraycopy(this.extensions, 0, result, 0, this.extensions.length);
        return result;
    }

    public String toString() {
        return super.toString() + "[description=" + this.getDescription() + " extensions=" + Arrays.asList(this.getExtensions()) + "]";
    }
}

