/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.software.archive.impl.filefilter;

import de.proveo.idm.software.archive.impl.filefilter.AbstractFileFilterDecorator;
import de.proveo.idm.software.archive.impl.filefilter.DummyFileFilter;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class ExpectedSizeFileFilter
extends AbstractFileFilterDecorator {
    public static final int SIZE_NOT_SPECIFIED = -1;
    final long minSize;
    final long maxSize;

    public ExpectedSizeFileFilter(String description, long minSize, long maxSize) {
        this(new DummyFileFilter(description), minSize, maxSize);
    }

    public ExpectedSizeFileFilter(FileFilter fileFilter, long minSize, long maxSize) {
        super(fileFilter);
        this.checkSize(minSize);
        this.checkSize(maxSize);
        this.minSize = minSize;
        this.maxSize = maxSize;
    }

    @Override
    public boolean accept(File f) {
        if (this.fileFilter.accept(f)) {
            if (f.isDirectory()) {
                return true;
            }
            long size = f.length();
            if (this.minSize != -1L && size < this.minSize) {
                return false;
            }
            return this.maxSize == -1L || size <= this.maxSize;
        }
        return false;
    }

    private void checkSize(long size) {
        if (size < 0L && size != -1L) {
            throw new IllegalArgumentException("size mus be >=0 or SIZE_NOT_SPECIFIED");
        }
    }
}

