/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.software.archive.impl;

import de.proveo.idm.core.gui.navigation.api.SoftwareBundle;
import de.proveo.idm.software.archive.api.Resource;
import de.proveo.idm.software.archive.util.ChecksumUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.MissingResourceException;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ResourceImpl
implements Resource {
    private final File file;
    private Resource.ResourceType type;
    private final String version;
    private final SoftwareBundle bundle;

    public ResourceImpl(File file, SoftwareBundle bundle, Resource.ResourceType type, String version) {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException(new FileNotFoundException(file == null ? "null" : file.getAbsolutePath()));
        }
        this.file = file;
        this.type = type;
        this.version = version;
        this.bundle = bundle;
        if (this.type == null) {
            this.type = Resource.ResourceType.MISC;
        }
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getShortDescription() {
        String ret;
        String rKey = this.getClass().getSimpleName() + "." + (Object)((Object)this.type) + ".description.short";
        try {
            ret = NbBundle.getMessage(ResourceImpl.class, (String)rKey);
        }
        catch (MissingResourceException ex) {
            ret = this.type.name();
        }
        return ret;
    }

    @Override
    public String getLongDescription() {
        String ret;
        String rKey = this.getClass().getSimpleName() + "." + (Object)((Object)this.type) + ".description.long";
        try {
            ret = NbBundle.getMessage(ResourceImpl.class, (String)rKey);
        }
        catch (MissingResourceException ex) {
            ret = this.type.name();
        }
        return ret;
    }

    @Override
    public Resource.ResourceType getResourceType() {
        return this.type;
    }

    @Override
    public InputStream getAsStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public File getAsFile() {
        return this.file;
    }

    @Override
    public String getChecksum() {
        String csFileName = this.file.getPath() + File.separator + ".SHA";
        File csFile = new File(csFileName);
        String checksum = csFile.exists() ? ChecksumUtil.parseSHA1Checksum(this.file) : ChecksumUtil.generateSHA1Checksum(this.file);
        return checksum;
    }

    @Override
    public HelpCtx getHelp() {
        String ctx = String.format("%s.%s.helpCtx", new Object[]{this.getVersion(), this.type});
        return new HelpCtx(ctx);
    }

    @Override
    public SoftwareBundle getAssociatedSoftwareBundle() {
        return this.bundle;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Resource) {
            Resource res = (Resource)obj;
            String path = null;
            File thisFile = this.getAsFile();
            if (thisFile != null) {
                path = thisFile.getAbsolutePath();
            }
            String otherPath = null;
            File otherFile = res.getAsFile();
            if (otherFile != null) {
                otherPath = otherFile.getAbsolutePath();
            }
            return path != null && otherPath != null && path.equals(otherPath);
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append((Object)this.bundle);
        hcb.append((Object)this.file);
        hcb.append((Object)this.type);
        hcb.append((Object)this.version);
        return hcb.toHashCode();
    }
}

