/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.software.archive.impl;

import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.gui.navigation.api.SoftwareBundle;
import de.proveo.idm.core.gui.util.DialogUtil;
import de.proveo.idm.core.util.ThreadPool;
import de.proveo.idm.software.archive.api.AbstractInfomanEFMSoftwareBundle;
import de.proveo.idm.software.archive.api.AbstractInfomanSoftwareBundle;
import de.proveo.idm.software.archive.api.AbstractNoMoSoftwareBundle;
import de.proveo.idm.software.archive.api.AbstractSoftwareBundle;
import de.proveo.idm.software.archive.api.InfomanSoftwareArchiveManager;
import de.proveo.idm.software.archive.impl.BundleDownloader;
import de.proveo.idm.software.archive.impl.BundleVersionComparator;
import de.proveo.idm.software.archive.util.BundleHandlerChooser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class InfomanSoftwareArchiveManagerImpl
implements InfomanSoftwareArchiveManager {
    protected final Map<SoftwareBundle.Type, Collection<AbstractInfomanSoftwareBundle>> infomanBundlesByType = new EnumMap<SoftwareBundle.Type, Collection<AbstractInfomanSoftwareBundle>>(SoftwareBundle.Type.class);
    protected final Map<String, AbstractInfomanSoftwareBundle> infomanBundlesByVersion = new HashMap<String, AbstractInfomanSoftwareBundle>();
    protected final Map<SoftwareBundle.Type, Collection<AbstractInfomanEFMSoftwareBundle>> infomanEFMBundlesByType = new EnumMap<SoftwareBundle.Type, Collection<AbstractInfomanEFMSoftwareBundle>>(SoftwareBundle.Type.class);
    protected final Map<String, AbstractInfomanEFMSoftwareBundle> infomanEFMBundlesByVersion = new HashMap<String, AbstractInfomanEFMSoftwareBundle>();
    protected final Map<SoftwareBundle.Type, Collection<AbstractNoMoSoftwareBundle>> nomoBundlesByType = new EnumMap<SoftwareBundle.Type, Collection<AbstractNoMoSoftwareBundle>>(SoftwareBundle.Type.class);
    protected final Map<String, AbstractNoMoSoftwareBundle> nomoBundlesByVersion = new HashMap<String, AbstractNoMoSoftwareBundle>();

    @Override
    public synchronized void update() {
        this.infomanBundlesByType.clear();
        this.infomanBundlesByVersion.clear();
        this.infomanEFMBundlesByType.clear();
        this.infomanEFMBundlesByVersion.clear();
        this.nomoBundlesByType.clear();
        this.nomoBundlesByVersion.clear();
        Collection infomanLookupAll = Lookup.getDefault().lookupAll(AbstractInfomanSoftwareBundle.class);
        for (Object bundle : infomanLookupAll) {
            Collection<AbstractInfomanSoftwareBundle> bundles = this.infomanBundlesByType.get(((AbstractSoftwareBundle)bundle).getType());
            if (bundles == null) {
                bundles = new ArrayList<AbstractInfomanSoftwareBundle>();
                this.infomanBundlesByType.put(((AbstractSoftwareBundle)bundle).getType(), bundles);
            }
            bundles.add((AbstractInfomanSoftwareBundle)bundle);
            this.infomanBundlesByVersion.put(((AbstractSoftwareBundle)bundle).getVersion(), (AbstractInfomanSoftwareBundle)bundle);
            Runnable run = new Runnable((AbstractInfomanSoftwareBundle)bundle){
                final /* synthetic */ AbstractInfomanSoftwareBundle val$bundle;
                {
                    this.val$bundle = abstractInfomanSoftwareBundle;
                }

                @Override
                public void run() {
                    BundleDownloader downloader = new BundleDownloader(this.val$bundle);
                    downloader.execute();
                }
            };
            ThreadPool.getInstance().execute(run);
        }
        Collection infomanEFMLookupAll = Lookup.getDefault().lookupAll(AbstractInfomanEFMSoftwareBundle.class);
        for (final AbstractInfomanEFMSoftwareBundle bundle : infomanEFMLookupAll) {
            Collection<AbstractInfomanEFMSoftwareBundle> bundles = this.infomanEFMBundlesByType.get(bundle.getType());
            if (bundles == null) {
                bundles = new ArrayList<AbstractInfomanEFMSoftwareBundle>();
                this.infomanEFMBundlesByType.put(bundle.getType(), bundles);
            }
            bundles.add(bundle);
            this.infomanEFMBundlesByVersion.put(bundle.getVersion(), bundle);
            new Thread("ResourceDownload::InfomanEFMBundle_" + bundle.getVersion()){

                @Override
                public void run() {
                    BundleDownloader downloader = new BundleDownloader(bundle);
                    downloader.execute();
                }
            }.start();
        }
        Collection nomoLookupAll = Lookup.getDefault().lookupAll(AbstractNoMoSoftwareBundle.class);
        for (final AbstractNoMoSoftwareBundle bundle : nomoLookupAll) {
            Collection<AbstractNoMoSoftwareBundle> bundles = this.nomoBundlesByType.get(bundle.getType());
            if (bundles == null) {
                bundles = new ArrayList<AbstractNoMoSoftwareBundle>();
                this.nomoBundlesByType.put(bundle.getType(), bundles);
            }
            bundles.add(bundle);
            this.nomoBundlesByVersion.put(bundle.getVersion(), bundle);
            new Thread("ResourceDownload::NoMoBundle_" + bundle.getVersion()){

                @Override
                public void run() {
                    BundleDownloader downloader = new BundleDownloader(bundle);
                    downloader.execute();
                }
            }.start();
        }
    }

    @Override
    public synchronized boolean hasBundles() {
        return this.hasInfomanBundles() && this.hasInfomanEFMBundles();
    }

    @Override
    public synchronized boolean hasInfomanBundles() {
        return !this.infomanBundlesByVersion.isEmpty();
    }

    @Override
    public synchronized boolean hasInfomanEFMBundles() {
        return !this.infomanEFMBundlesByVersion.isEmpty();
    }

    @Override
    public boolean hasNoMoBundles() {
        return !this.nomoBundlesByVersion.isEmpty();
    }

    @Override
    public synchronized AbstractInfomanSoftwareBundle getInfomanBundle(String version) {
        AbstractInfomanSoftwareBundle bundle = this.infomanBundlesByVersion.get(version);
        if (bundle == null) {
            String title = NbBundle.getMessage(InfomanSoftwareArchiveManagerImpl.class, (String)"InfomanSoftwareArchiveManagerImpl.title", (Object)version);
            String message = NbBundle.getMessage(InfomanSoftwareArchiveManagerImpl.class, (String)"InfomanSoftwareArchiveManagerImpl.noBundle", (Object)version);
            try {
                SoftwareBundle tmpBundle;
                BundleHandlerChooser chooser = new BundleHandlerChooser(message, Device.DeviceType.INFOMAN);
                Object option = DialogUtil.showOkCancelQuestionDialog((Object)chooser.getPanel(), (String)title);
                if (DialogUtil.OK_OPTION.equals(option) && (tmpBundle = chooser.getSelectedBundle()) != null && tmpBundle instanceof AbstractInfomanSoftwareBundle) {
                    bundle = (AbstractInfomanSoftwareBundle)tmpBundle;
                }
            }
            catch (UnsupportedOperationException ex) {
                DialogUtil.showErrorDialog((Object)NbBundle.getMessage(InfomanSoftwareArchiveManagerImpl.class, (String)"InfomanSoftwareArchiveManagerImpl.noBundleInstalled.msg"), (String)NbBundle.getMessage(InfomanSoftwareArchiveManagerImpl.class, (String)"InfomanSoftwareArchiveManagerImpl.noBundleInstalled.title"));
                return null;
            }
        }
        return bundle;
    }

    @Override
    public synchronized Collection<AbstractInfomanSoftwareBundle> getAllInfomanBundles() {
        ArrayList<AbstractInfomanSoftwareBundle> bundles = new ArrayList<AbstractInfomanSoftwareBundle>(this.infomanBundlesByVersion.values());
        Collections.sort(bundles, new BundleVersionComparator());
        return bundles;
    }

    @Override
    public synchronized Collection<AbstractInfomanSoftwareBundle> findInfomanBundle(String versionPattern) {
        ArrayList<AbstractInfomanSoftwareBundle> bundles = new ArrayList<AbstractInfomanSoftwareBundle>();
        for (String version : this.infomanBundlesByVersion.keySet()) {
            if (!version.startsWith(versionPattern)) continue;
            bundles.add(this.infomanBundlesByVersion.get(version));
        }
        Collections.sort(bundles, new BundleVersionComparator());
        return bundles;
    }

    @Override
    public synchronized Collection<AbstractInfomanSoftwareBundle> getInfomanBundles(SoftwareBundle.Type type) {
        Collection<AbstractInfomanSoftwareBundle> bundles = this.infomanBundlesByType.get(type);
        if (bundles == null) {
            return Collections.emptyList();
        }
        ArrayList<AbstractInfomanSoftwareBundle> ret = new ArrayList<AbstractInfomanSoftwareBundle>(bundles);
        Collections.sort(ret, new BundleVersionComparator());
        return ret;
    }

    @Override
    public synchronized AbstractInfomanEFMSoftwareBundle getInfomanEFMBundle(String version) {
        AbstractInfomanEFMSoftwareBundle bundle = this.infomanEFMBundlesByVersion.get(version);
        if (bundle == null) {
            String title = NbBundle.getMessage(InfomanSoftwareArchiveManagerImpl.class, (String)"InfomanSoftwareArchiveManagerImpl.title", (Object)version);
            String message = NbBundle.getMessage(InfomanSoftwareArchiveManagerImpl.class, (String)"InfomanSoftwareArchiveManagerImpl.noBundle", (Object)version);
            try {
                SoftwareBundle tmpBundle;
                BundleHandlerChooser chooser = new BundleHandlerChooser(message, Device.DeviceType.INFOMAN_EFM);
                Object option = DialogUtil.showOkCancelQuestionDialog((Object)chooser.getPanel(), (String)title);
                if (DialogUtil.OK_OPTION.equals(option) && (tmpBundle = chooser.getSelectedBundle()) != null && tmpBundle instanceof AbstractInfomanEFMSoftwareBundle) {
                    bundle = (AbstractInfomanEFMSoftwareBundle)tmpBundle;
                }
            }
            catch (UnsupportedOperationException ex) {
                DialogUtil.showErrorDialog((Object)NbBundle.getMessage(InfomanSoftwareArchiveManagerImpl.class, (String)"InfomanSoftwareArchiveManagerImpl.noBundleInstalled.msg"), (String)NbBundle.getMessage(InfomanSoftwareArchiveManagerImpl.class, (String)"InfomanSoftwareArchiveManagerImpl.noBundleInstalled.title"));
                return null;
            }
        }
        return bundle;
    }

    @Override
    public AbstractNoMoSoftwareBundle getNoMoBundle(String version) {
        AbstractNoMoSoftwareBundle bundle = this.nomoBundlesByVersion.get(version);
        if (bundle == null) {
            String title = NbBundle.getMessage(InfomanSoftwareArchiveManagerImpl.class, (String)"InfomanSoftwareArchiveManagerImpl.title", (Object)version);
            String message = NbBundle.getMessage(InfomanSoftwareArchiveManagerImpl.class, (String)"InfomanSoftwareArchiveManagerImpl.noBundle", (Object)version);
            try {
                SoftwareBundle tmpBundle;
                BundleHandlerChooser chooser = new BundleHandlerChooser(message, Device.DeviceType.NOMO);
                Object option = DialogUtil.showOkCancelQuestionDialog((Object)chooser.getPanel(), (String)title);
                if (DialogUtil.OK_OPTION.equals(option) && (tmpBundle = chooser.getSelectedBundle()) != null && tmpBundle instanceof AbstractNoMoSoftwareBundle) {
                    bundle = (AbstractNoMoSoftwareBundle)tmpBundle;
                }
            }
            catch (UnsupportedOperationException ex) {
                DialogUtil.showErrorDialog((Object)NbBundle.getMessage(InfomanSoftwareArchiveManagerImpl.class, (String)"InfomanSoftwareArchiveManagerImpl.noBundleInstalled.msg"), (String)NbBundle.getMessage(InfomanSoftwareArchiveManagerImpl.class, (String)"InfomanSoftwareArchiveManagerImpl.noBundleInstalled.title"));
                return null;
            }
        }
        return bundle;
    }

    @Override
    public synchronized Collection<AbstractInfomanEFMSoftwareBundle> getAllInfomanEFMBundles() {
        ArrayList<AbstractInfomanEFMSoftwareBundle> bundles = new ArrayList<AbstractInfomanEFMSoftwareBundle>(this.infomanEFMBundlesByVersion.values());
        Collections.sort(bundles, new BundleVersionComparator());
        return bundles;
    }

    @Override
    public synchronized Collection<AbstractNoMoSoftwareBundle> getAllNoMoBundles() {
        ArrayList<AbstractNoMoSoftwareBundle> bundles = new ArrayList<AbstractNoMoSoftwareBundle>(this.nomoBundlesByVersion.values());
        Collections.sort(bundles, new BundleVersionComparator());
        return bundles;
    }

    @Override
    public synchronized Collection<AbstractInfomanEFMSoftwareBundle> findInfomanEFMBundle(String versionPattern) {
        ArrayList<AbstractInfomanEFMSoftwareBundle> bundles = new ArrayList<AbstractInfomanEFMSoftwareBundle>();
        for (String version : this.infomanEFMBundlesByVersion.keySet()) {
            if (!version.startsWith(versionPattern)) continue;
            bundles.add(this.infomanEFMBundlesByVersion.get(version));
        }
        Collections.sort(bundles, new BundleVersionComparator());
        return bundles;
    }

    @Override
    public Collection<AbstractNoMoSoftwareBundle> findNoMoBundle(String versionPattern) {
        ArrayList<AbstractNoMoSoftwareBundle> bundles = new ArrayList<AbstractNoMoSoftwareBundle>();
        for (String version : this.nomoBundlesByVersion.keySet()) {
            if (!version.startsWith(versionPattern)) continue;
            bundles.add(this.nomoBundlesByVersion.get(version));
        }
        Collections.sort(bundles, new BundleVersionComparator());
        return bundles;
    }

    @Override
    public synchronized Collection<AbstractInfomanEFMSoftwareBundle> getInfomanEFMBundles(SoftwareBundle.Type type) {
        Collection<AbstractInfomanEFMSoftwareBundle> bundles = this.infomanEFMBundlesByType.get(type);
        if (bundles == null) {
            return Collections.emptyList();
        }
        ArrayList<AbstractInfomanEFMSoftwareBundle> ret = new ArrayList<AbstractInfomanEFMSoftwareBundle>(bundles);
        Collections.sort(ret, new BundleVersionComparator());
        return ret;
    }

    @Override
    public Collection<AbstractNoMoSoftwareBundle> getNoMoBundles(SoftwareBundle.Type type) {
        Collection<AbstractNoMoSoftwareBundle> bundles = this.nomoBundlesByType.get(type);
        if (bundles == null) {
            return Collections.emptyList();
        }
        ArrayList<AbstractNoMoSoftwareBundle> ret = new ArrayList<AbstractNoMoSoftwareBundle>(bundles);
        Collections.sort(ret, new BundleVersionComparator());
        return ret;
    }
}

