/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.software.archive.impl;

import de.proveo.idm.core.gui.navigation.api.SoftwareBundle;
import de.proveo.idm.core.gui.util.NotificationUtil;
import de.proveo.idm.software.archive.impl.nav.SoftwareBundleNavigationManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.SwingWorker;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2Utils;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class BundleExtractor
extends SwingWorker<Boolean, Void>
implements Cancellable {
    private static final Logger log = Logger.getLogger(BundleExtractor.class.getName());
    private final String handleProgressName = NbBundle.getMessage(BundleExtractor.class, (String)"BundleExtractor.progress.extracting");
    private final ProgressHandle handle;
    private final SoftwareBundle bundle;
    private final File extractTo;
    private Exception pendingException = null;
    private boolean cancel = false;
    private boolean finished = false;
    private File bundleArchive;

    public BundleExtractor(ProgressHandle handle, SoftwareBundle bundle, File bundleArchive, File extractTo) {
        if (bundle == null || bundleArchive == null || extractTo == null) {
            throw new IllegalArgumentException("Parameters cannot be null. bundle:" + bundle + " bundleArchive:" + bundleArchive + " extractTo:" + extractTo);
        }
        this.handle = handle;
        this.bundle = bundle;
        this.bundleArchive = bundleArchive;
        this.extractTo = extractTo;
    }

    protected boolean isFinished() {
        return this.finished;
    }

    public boolean cancel() {
        this.cancel = true;
        return super.cancel(false);
    }

    @Override
    protected Boolean doInBackground() throws Exception {
        if (this.handle != null) {
            this.handle.switchToIndeterminate();
            this.handle.progress(this.handleProgressName + " ...");
        }
        boolean ret = false;
        if (this.bundleArchive == null) {
            log.severe("Bundle archive cannot be null!");
            return ret;
        }
        if (this.cancel) {
            return ret;
        }
        try {
            if (!this.extractTo.exists()) {
                FileUtils.forceMkdir((File)this.extractTo);
            }
            ret = this.bundleArchive.getName().endsWith(".zip") ? this.extract(new ZipFile(this.bundleArchive), this.extractTo) : this.extract(this.bundleArchive, this.extractTo);
        }
        catch (Exception ex) {
            try {
                FileUtils.forceDelete((File)this.extractTo);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not delete bundle extraction folder: {0}", this.extractTo.getAbsolutePath());
            }
            this.pendingException = ex;
            ret = false;
        }
        if (this.cancel) {
            ret = true;
        }
        return ret;
    }

    @Override
    protected void done() {
        this.finished = true;
        String bundleName = this.extractTo.getName();
        if (this.pendingException != null) {
            if (this.handle != null) {
                this.handle.finish();
            }
            NotificationUtil.notifyError((String)NbBundle.getMessage(BundleExtractor.class, (String)"BundleExtractor.failed.title", (Object)bundleName), (String)NbBundle.getMessage(BundleExtractor.class, (String)"BundleExtractor.failed.message", (Object)bundleName));
            Exceptions.printStackTrace((Throwable)this.pendingException);
        } else {
            try {
                this.bundle.setExtractedDirectory(this.extractTo);
                if (Boolean.TRUE == this.get()) {
                    NotificationUtil.notifyInfo((String)NbBundle.getMessage(BundleExtractor.class, (String)"BundleExtractor.finished.title", (Object)bundleName), (String)NbBundle.getMessage(BundleExtractor.class, (String)"BundleExtractor.finished.message", (Object)bundleName));
                }
            }
            catch (CancellationException ex) {
            }
            catch (Exception ex) {
                NotificationUtil.notifyError((String)NbBundle.getMessage(BundleExtractor.class, (String)"BundleExtractor.failed.title", (Object)bundleName), (String)NbBundle.getMessage(BundleExtractor.class, (String)"BundleExtractor.failed.message", (Object)bundleName));
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (this.handle != null) {
                    this.handle.finish();
                }
            }
        }
        SoftwareBundleNavigationManager navigationItemManager = (SoftwareBundleNavigationManager)Lookup.getDefault().lookup(SoftwareBundleNavigationManager.class);
        navigationItemManager.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean extract(ZipFile zipFile, File targetDir) throws IOException {
        boolean ret = false;
        FileUtils.forceMkdir((File)targetDir);
        int size = zipFile.size();
        if (this.handle != null) {
            this.handle.switchToDeterminate(size);
        }
        int extracted = 0;
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (!this.cancel && zipEntries.hasMoreElements()) {
            File target;
            ZipEntry zipEntry = zipEntries.nextElement();
            String zipEntryName = zipEntry.getName();
            if (this.handle != null) {
                this.handle.progress(this.handleProgressName + " " + zipEntryName + " ...");
            }
            if (this.needsToBeExtracted(zipEntry, target = new File(targetDir, zipEntry.getName()))) {
                if (zipEntry.isDirectory()) {
                    FileUtils.forceMkdir((File)target);
                } else {
                    FileOutputStream out = null;
                    InputStream is = null;
                    try {
                        FileUtils.touch((File)target);
                        is = zipFile.getInputStream(zipEntry);
                        out = new FileOutputStream(target);
                        IOUtils.copy((InputStream)is, (OutputStream)out);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(out);
                        IOUtils.closeQuietly((InputStream)is);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)out);
                    IOUtils.closeQuietly((InputStream)is);
                }
                ret = true;
            }
            if (this.handle == null) continue;
            this.handle.progress(++extracted);
        }
        if (!this.cancel) return ret;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean extract(File file, File targetDir) throws IOException {
        FileInputStream fis;
        boolean ret = false;
        FileUtils.forceMkdir((File)targetDir);
        File tarFile = file;
        String archiveFileName = file.getName();
        boolean deleteTar = false;
        if (!archiveFileName.endsWith(".tar")) {
            fis = null;
            BufferedInputStream in = null;
            BZip2CompressorInputStream cIn = null;
            FileOutputStream out = null;
            try {
                String tarFileName;
                fis = new FileInputStream(file);
                in = new BufferedInputStream(fis);
                if (archiveFileName.endsWith("bz2")) {
                    cIn = new BZip2CompressorInputStream((InputStream)in);
                    tarFileName = BZip2Utils.getUncompressedFilename((String)archiveFileName);
                } else {
                    if (!archiveFileName.endsWith("gz")) throw new IOException("Unsupported archive: " + archiveFileName);
                    cIn = new GzipCompressorInputStream((InputStream)in);
                    tarFileName = GzipUtils.getUncompressedFilename((String)archiveFileName);
                }
                tarFile = new File(targetDir.getAbsolutePath() + File.separator + tarFileName);
                FileUtils.forceDeleteOnExit((File)tarFile);
                deleteTar = true;
                out = new FileOutputStream(tarFile);
                IOUtils.copy((InputStream)cIn, (OutputStream)out);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)fis);
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(cIn);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fis);
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((InputStream)cIn);
            IOUtils.closeQuietly((OutputStream)out);
        }
        fis = null;
        TarArchiveInputStream tarIn = null;
        try {
            fis = new FileInputStream(tarFile);
            tarIn = new TarArchiveInputStream((InputStream)fis);
            TarArchiveEntry tarEntry = null;
            while (!this.cancel && (tarEntry = tarIn.getNextTarEntry()) != null) {
                File target;
                String zipEntryName = tarEntry.getName();
                if (this.handle != null) {
                    this.handle.progress(this.handleProgressName + " " + zipEntryName + " ...");
                }
                if (!this.needsToBeExtracted(tarEntry, target = new File(targetDir, tarEntry.getName()))) continue;
                if (tarEntry.isDirectory()) {
                    FileUtils.forceMkdir((File)target);
                } else {
                    FileOutputStream out = null;
                    try {
                        int count;
                        FileUtils.touch((File)target);
                        out = new FileOutputStream(target);
                        int bufferSize = 2048;
                        byte[] content = new byte[bufferSize];
                        while ((count = tarIn.read(content, 0, bufferSize)) != -1) {
                            out.write(content, 0, count);
                        }
                        out.flush();
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(out);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)out);
                }
                ret = true;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            IOUtils.closeQuietly(tarIn);
            if (!deleteTar) throw throwable;
            try {
                FileUtils.forceDelete((File)tarFile);
                throw throwable;
            }
            catch (Exception ex) {
                FileUtils.deleteQuietly((File)tarFile);
            }
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fis);
        IOUtils.closeQuietly((InputStream)tarIn);
        if (deleteTar) {
            try {
                FileUtils.forceDelete((File)tarFile);
            }
            catch (Exception ex) {
                FileUtils.deleteQuietly((File)tarFile);
            }
        }
        if (!this.cancel) return ret;
        return false;
    }

    private boolean needsToBeExtracted(ZipEntry zipEntry, File target) {
        if (target.exists()) {
            long zipSize;
            if (target.isDirectory() != zipEntry.isDirectory()) {
                return true;
            }
            if (!target.canRead()) {
                return true;
            }
            return !zipEntry.isDirectory() && (zipSize = zipEntry.getSize()) != -1L && zipSize != FileUtils.sizeOf((File)target);
        }
        return true;
    }

    private boolean needsToBeExtracted(TarArchiveEntry tarEntry, File target) {
        if (target.exists()) {
            long zipSize;
            if (target.isDirectory() != tarEntry.isDirectory()) {
                return true;
            }
            if (!target.canRead()) {
                return true;
            }
            return !tarEntry.isDirectory() && (zipSize = tarEntry.getSize()) != -1L && zipSize != FileUtils.sizeOf((File)target);
        }
        return true;
    }
}

