/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.software.archive.api.gui;

import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.software.archive.api.Resource;
import de.proveo.idm.software.archive.api.gui.ResourceSelectorDialog;
import de.proveo.idm.software.archive.impl.ResourceImpl;
import de.proveo.idm.software.archive.impl.nav.resourceselect.ResourceSelectorPanel;
import de.proveo.idm.software.archive.util.FileUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openide.util.NbBundle;

public class ResourceSelectorField
extends JPanel {
    private static final Logger log = Logger.getLogger(ResourceSelectorField.class.getName());
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private ResourceSelectorPanel.FileChecker fileChecker = null;
    private ResourceSelectorDialog selectDialog = null;
    private Device.DeviceType deviceType;
    private Resource.ResourceType[] acceptedTypes;
    private JButton browseBtn;
    private JTextField textField;

    public ResourceSelectorField(Device.DeviceType deviceType, Resource.ResourceType ... acceptedTypes) {
        this.deviceType = deviceType;
        this.acceptedTypes = acceptedTypes;
        this.selectDialog = new ResourceSelectorDialog(this.deviceType, this.acceptedTypes);
        this.initComponents();
        this.fileChecker = new ResourceSelectorPanel.FileChecker(this, this.textField, this.deviceType, this.acceptedTypes);
        this.textField.getDocument().addDocumentListener(this.fileChecker);
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public JButton getBrowseBtn() {
        return this.browseBtn;
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
        this.fileChecker.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
        this.fileChecker.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
        this.fileChecker.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
        this.fileChecker.removePropertyChangeListener(listener);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textField.setEnabled(enabled);
        this.browseBtn.setEnabled(enabled);
        File file = FileUtil.getFile(FileUtil.getAbsolutePath(this.getSelectedResource()));
        boolean valid = ResourceSelectorPanel.checkFile(this.deviceType, this.acceptedTypes, file);
        this.pcs.firePropertyChange("fileValid", !valid, valid);
        this.pcs.firePropertyChange("fileChanged", null, file);
    }

    public void setMessage(String msg) {
        this.textField.setText(msg);
    }

    public Resource getSelectedResource() {
        File file = FileUtil.getFile(this.textField.getText());
        Resource ret = this.selectDialog.findResourceByFile(file);
        if (ret == null && file != null) {
            Resource.ResourceType type = Resource.ResourceType.MISC;
            if (this.acceptedTypes.length == 1) {
                type = this.acceptedTypes[0];
            }
            try {
                ret = new ResourceImpl(file, null, type, null);
            }
            catch (Exception ex) {
                ret = null;
            }
        }
        return ret;
    }

    public void setSelectedResource(File selectedResource) {
        String selectedResourceString = "";
        if (selectedResource != null) {
            selectedResourceString = selectedResource.getAbsolutePath();
        }
        this.textField.setText(selectedResourceString);
        boolean valid = ResourceSelectorPanel.checkFile(this.deviceType, this.acceptedTypes, selectedResource);
        this.pcs.firePropertyChange("fileChanged", null, selectedResource);
        this.pcs.firePropertyChange("fileValid", !valid, valid);
    }

    private void initComponents() {
        this.textField = new JTextField();
        this.browseBtn = new JButton();
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        this.setMinimumSize(new Dimension(100, 25));
        this.setLayout(new BorderLayout(5, 0));
        this.textField.setText(NbBundle.getMessage(ResourceSelectorField.class, (String)"ResourceSelectorField.textField.text"));
        this.add((Component)this.textField, "Center");
        this.browseBtn.setText(NbBundle.getMessage(ResourceSelectorField.class, (String)"ResourceSelectorField.browseBtn.text"));
        this.browseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResourceSelectorField.this.browseBtnActionPerformed(evt);
            }
        });
        this.add((Component)this.browseBtn, "East");
    }

    private void browseBtnActionPerformed(ActionEvent evt) {
        File file = null;
        Resource resource = this.getSelectedResource();
        if (resource != null) {
            file = resource.getAsFile();
        }
        resource = this.selectDialog.selectResource(file);
        if (!this.selectDialog.isCanceled()) {
            file = null;
            if (resource != null) {
                file = resource.getAsFile();
            }
            this.setSelectedResource(file);
        }
    }
}

