/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.software.archive.api;

import java.io.File;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public abstract class InfomanEFMRead {
    private static final Logger log = Logger.getLogger(InfomanEFMRead.class.getName());

    public abstract Properties parseFile(File var1) throws Exception;

    public abstract List<String> getATReadCommands() throws Exception;

    public abstract List<String> getATIgnoreCommands() throws Exception;

    public String processCommandReadResponse(String cmd, String readResponse) {
        return readResponse;
    }

    protected boolean isBitSetPrimitive(long byteValue, int bitNumber) {
        long mask = 1 << bitNumber;
        return (byteValue & mask) > 0L;
    }

    protected Boolean isBitSet(long byteValue, int bitNumber) {
        return this.isBitSetPrimitive(byteValue, bitNumber) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected String isBitSetStr(long byteValue, int bitNumber) {
        return this.isBitSet(byteValue, bitNumber).toString();
    }

    protected Properties parseUnknownATCommand(String command) {
        Properties props = new Properties();
        if (!command.contains("=")) {
            log.log(Level.WARNING, "Could not parse unknown AT command, command was: {0}", command);
            return props;
        }
        String[] values = StringUtils.split((String)command, (String)"=");
        if (values.length == 2) {
            props.setProperty(values[0], values[1]);
        } else {
            log.log(Level.WARNING, "Unexpected values in unknown AT command, command was: {0}", command);
        }
        return props;
    }

    protected String parseString(String str) {
        return StringUtils.remove((String)str, (char)'\"').trim();
    }

    protected String parseNumber(String str) {
        str = str.trim();
        while (str.startsWith("0")) {
            str = StringUtils.removeStart((String)str, (String)"0");
        }
        if (str.length() == 0) {
            str = "0";
        } else if (str.startsWith(".")) {
            str = "0" + str;
        }
        return str;
    }

    protected String parseBoolean(String str) {
        if ((str = str.trim()).equals("1")) {
            return "true";
        }
        return "false";
    }

    protected String parseHoursMinutesPeriod(String str) {
        String[] values = StringUtils.split((String)str, (char)':');
        if (values.length == 2) {
            int h = this.parseInt(values[0]);
            int m = this.parseInt(values[1]);
            long period = h * 60 * 60 * 1000 + m * 60 * 1000;
            return Long.toString(period);
        }
        return "0";
    }

    protected String parseHoursMinutesSecondsPeriod(String str) {
        String[] values = StringUtils.split((String)str, (char)':');
        if (values.length == 3) {
            int h = this.parseInt(values[0]);
            int m = this.parseInt(values[1]);
            int s = this.parseInt(values[2]);
            long period = h * 60 * 60 * 1000 + m * 60 * 1000 + s * 1000;
            return Long.toString(period);
        }
        return "0";
    }

    protected int parseInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception ex) {
            return 0;
        }
    }
}

