/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.software.archive.api;

import de.proveo.idm.core.gui.navigation.api.InfomanConfigurationSyntax;
import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.navigation.api.SoftwareBundle;
import de.proveo.idm.software.archive.api.ConfigurationUpdate;
import de.proveo.idm.software.archive.api.InfomanResourceNavigationItem;
import de.proveo.idm.software.archive.api.Resource;
import de.proveo.idm.software.archive.impl.FileClassLoader;
import de.proveo.idm.software.archive.impl.ResourceImpl;
import de.proveo.idm.software.archive.impl.nav.BundleGroupItem;
import de.proveo.idm.software.archive.impl.nav.BundleNavigationItem;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public abstract class AbstractSoftwareBundle
implements SoftwareBundle {
    protected static final String VERSION = "version";
    protected static final String TYPE = "type";
    protected static final String FILENAME = "filename";
    protected static final String BUNDLE_URL_SUB_FOLDER = "bundle.url.subFolder";
    protected static final String OVERRIDE = "OVERRIDE";
    protected static final String SHORT_DESCRIPTION = "OpenIDE-Module-Short-Description";
    protected static final String LONG_DESCRIPTION = "OpenIDE-Module-Long-Description";
    protected File bundleDirectory;
    protected FileClassLoader bundleDirectoryClassLoader;
    protected final Class clazz;

    public AbstractSoftwareBundle(Class clazz) {
        this.clazz = clazz;
    }

    protected String getProperty(String key) {
        return NbBundle.getMessage((Class)this.clazz, (String)key);
    }

    public String getVersion() {
        return this.getProperty(VERSION);
    }

    public SoftwareBundle.Type getType() {
        return this.getType(this.getProperty(TYPE));
    }

    public String getFilename() {
        return this.getProperty(FILENAME);
    }

    public List<String> getBundleUrls() {
        ArrayList<String> urls = new ArrayList<String>();
        String urlSuffix = this.getProperty(BUNDLE_URL_SUB_FOLDER);
        urlSuffix = urlSuffix.endsWith("/") ? urlSuffix + this.getFilename() : urlSuffix + "/" + this.getFilename();
        if (urlSuffix.startsWith("/")) {
            urls.add(urlSuffix);
        } else {
            urlSuffix = "/" + urlSuffix;
            List updateProviders = UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(true);
            for (UpdateUnitProvider uup : updateProviders) {
                String updateUrl = uup.getProviderURL().toString();
                String urlPrefix = StringUtils.substringBeforeLast((String)updateUrl, (String)"/");
                String url = urlPrefix + urlSuffix;
                urls.add(url);
            }
        }
        return urls;
    }

    public String getShortDescription() {
        return this.getProperty(SHORT_DESCRIPTION);
    }

    public String getLongDescription() {
        return this.getProperty(LONG_DESCRIPTION);
    }

    public HelpCtx getHelp() {
        return new HelpCtx("de.proveo.infoman." + this.getVersion() + ".about");
    }

    protected String getIconBaseWithExtension(Resource.ResourceType resourceType) {
        String iconBase = null;
        try {
            iconBase = NbBundle.getMessage(AbstractSoftwareBundle.class, (String)("AbstractSoftwareBundle.node." + resourceType.toString() + ".icon"));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return iconBase;
    }

    protected SoftwareBundle.Type getType(String typeStr) {
        return SoftwareBundle.Type.valueOf((String)typeStr.trim().toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getBundleArchiveMD5Sum() {
        String md5sumFileName = this.getFilename() + ".MD5";
        File ret = null;
        InputStream is = null;
        try {
            is = this.getModuleResource(md5sumFileName);
            if (is == null) {
                md5sumFileName = this.getFilename() + ".md5";
                is = this.getModuleResource(md5sumFileName);
            }
            if (is != null) {
                ret = File.createTempFile(this.getFilename(), "MD5");
                ret.deleteOnExit();
                FileUtils.copyInputStreamToFile((InputStream)is, (File)ret);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return ret;
    }

    protected InputStream getModuleResource(String name) {
        return this.clazz.getResourceAsStream(name);
    }

    protected InputStream getArchiveResource(String name) throws IOException {
        if (this.bundleDirectory == null) {
            return null;
        }
        File file = new File(this.bundleDirectory, name);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        return null;
    }

    protected ResourceBundle getResourceBundle(String name, Locale locale) throws IOException {
        return ResourceBundle.getBundle(name, locale, this.bundleDirectoryClassLoader);
    }

    public void setExtractedDirectory(File bundleDirectory) throws IOException {
        this.bundleDirectory = bundleDirectory;
        this.bundleDirectoryClassLoader = new FileClassLoader();
        this.bundleDirectoryClassLoader.addURL(Utilities.toURI((File)this.bundleDirectory).toURL());
    }

    public InputStream getResource(String name) throws IOException {
        InputStream in = this.getModuleResource(name);
        if (in == null) {
            in = this.getArchiveResource(name);
        }
        return in;
    }

    public Collection<Resource> getResources(Resource.ResourceType resourceType) {
        if (this.bundleDirectory == null) {
            return Collections.emptyList();
        }
        return this.findAllResourcesInFolder(this.bundleDirectory, resourceType);
    }

    private Collection<Resource> findAllResourcesInFolder(File folder, Resource.ResourceType resourceType) {
        File[] files;
        ArrayList<Resource> resources = new ArrayList<Resource>();
        FileFilter fileFilter = this.getFileFilter(resourceType);
        for (File file : files = folder.listFiles(fileFilter)) {
            if (!file.isDirectory() && folder.getName().equals(resourceType.toString())) {
                File newFile = this.getOverriddenFile(file, resourceType.toString());
                if (newFile == null) {
                    newFile = file;
                }
                resources.add(new ResourceImpl(newFile, this, resourceType, this.getVersion()));
                continue;
            }
            if (!file.isDirectory()) continue;
            resources.addAll(this.findAllResourcesInFolder(file, resourceType));
        }
        return resources;
    }

    public BundleNavigationItem getBundleNavigation(Resource.ResourceType ... allowedResourceTypes) {
        BundleNavigationItem bundleNavItem = new BundleNavigationItem(this);
        if (this.bundleDirectory == null) {
            return bundleNavItem;
        }
        File[] subDirectories = this.bundleDirectory.listFiles((FileFilter)FileFilterUtils.directoryFileFilter());
        if (subDirectories != null) {
            for (File subDir : subDirectories) {
                BundleGroupItem groupItem = this.buildNavigationForSubfolder(subDir, allowedResourceTypes);
                if (groupItem == null) continue;
                bundleNavItem.addChild((NavigationItem)groupItem);
            }
        }
        return bundleNavItem;
    }

    protected BundleGroupItem buildNavigationForSubfolder(File folder, Resource.ResourceType ... allowedResourceTypes) {
        Resource.ResourceType resType;
        if (allowedResourceTypes == null || allowedResourceTypes.length == 0) {
            allowedResourceTypes = Resource.ResourceType.values();
        }
        String name = folder.getName();
        String description = "";
        try {
            resType = Resource.ResourceType.valueOf(folder.getName());
        }
        catch (Exception ex) {
            resType = null;
        }
        if (resType != null) {
            try {
                name = NbBundle.getMessage(AbstractSoftwareBundle.class, (String)("AbstractSoftwareBundle.node." + resType.toString() + ".name"));
            }
            catch (MissingResourceException ex) {
                name = resType.toString();
            }
            try {
                description = NbBundle.getMessage(AbstractSoftwareBundle.class, (String)("AbstractSoftwareBundle.node." + resType.toString() + ".description"));
            }
            catch (MissingResourceException ex) {
                description = "";
            }
        }
        BundleGroupItem typeItem = new BundleGroupItem(name, description, null);
        File[] files = folder.listFiles(this.getFileFilter(resType));
        if (files != null) {
            for (File file : files) {
                BundleGroupItem childGroupItem;
                if (!file.isDirectory() && resType != null && ArrayUtils.contains((Object[])allowedResourceTypes, (Object)((Object)resType))) {
                    File newFile = this.getOverriddenFile(file, resType.toString());
                    if (newFile == null) {
                        newFile = file;
                    }
                    ResourceImpl resource = new ResourceImpl(newFile, this, resType, this.getVersion());
                    InfomanResourceNavigationItem item = new InfomanResourceNavigationItem(resource, (NavigationItem)typeItem);
                    item.setIconBaseWithExtension(this.getIconBaseWithExtension(resType));
                    continue;
                }
                if (!file.isDirectory() || (childGroupItem = this.buildNavigationForSubfolder(file, allowedResourceTypes)) == null) continue;
                typeItem.addChild((NavigationItem)childGroupItem);
            }
        }
        if (typeItem.getChildren().isEmpty()) {
            typeItem = null;
        }
        return typeItem;
    }

    protected FileFilter getFileFilter(Resource.ResourceType resourceType) {
        try {
            String extension = NbBundle.getMessage(AbstractSoftwareBundle.class, (String)("fileFilter." + resourceType.toString()));
            return new ExtensionFileFilter(extension);
        }
        catch (Exception ex) {
            return new AcceptAllFileFilter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File getOverriddenFile(File file, String typeString) {
        String fileName = file.getName();
        File directory = new File(file.getParent() + File.separator + OVERRIDE + File.separator);
        File overrideFile = new File(directory, file.getName());
        if (overrideFile.exists()) {
            return overrideFile;
        }
        InputStream in = this.getClass().getResourceAsStream("OVERRIDE/" + typeString + "/" + fileName);
        if (in != null) {
            File file2;
            FileOutputStream out = null;
            try {
                FileUtils.forceMkdir((File)directory);
                out = new FileOutputStream(overrideFile);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                file2 = overrideFile;
            }
            catch (IOException ex) {
                try {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((InputStream)in);
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)out);
            }
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
            return file2;
        }
        return null;
    }

    class InfomanConfigurationSyntaxImpl
    implements InfomanConfigurationSyntax {
        private final ResourceBundle configSyntaxBundle;
        private final AbstractSoftwareBundle infomanSoftwareBundle;
        private final String helpIdPrefix;

        public InfomanConfigurationSyntaxImpl(AbstractSoftwareBundle infomanSoftwareBundle, ResourceBundle configSyntaxBundle, String helpIdPrefix) {
            this.configSyntaxBundle = configSyntaxBundle;
            this.infomanSoftwareBundle = infomanSoftwareBundle;
            this.helpIdPrefix = helpIdPrefix;
        }

        public InputStream getSyntax() throws IOException {
            return AbstractSoftwareBundle.this.getResource("syntax.xml");
        }

        public String getLabel(String key) {
            if (this.configSyntaxBundle == null) {
                return key;
            }
            try {
                String label = this.configSyntaxBundle.getString(key);
                if (label == null) {
                    return key;
                }
                return label;
            }
            catch (MissingResourceException ex) {
                return key;
            }
        }

        public String getShortDescription(String key) {
            if (this.configSyntaxBundle == null) {
                return null;
            }
            try {
                return this.configSyntaxBundle.getString(key + ".shortDescription");
            }
            catch (MissingResourceException ex) {
                return null;
            }
        }

        public String getHelpID(String key) {
            return this.helpIdPrefix + StringUtils.replace((String)AbstractSoftwareBundle.this.getVersion(), (String)".", (String)"_") + ".config." + key;
        }

        public void updateConfiguration(Properties configuration) {
            List updaterClassNames = null;
            try {
                InputStream in = AbstractSoftwareBundle.this.getResource("configUpdater.list");
                if (in != null) {
                    updaterClassNames = IOUtils.readLines((InputStream)in);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (updaterClassNames != null) {
                for (String updaterClassName : updaterClassNames) {
                    try {
                        Class<?> clazz = Class.forName(updaterClassName);
                        ConfigurationUpdate updater = (ConfigurationUpdate)clazz.newInstance();
                        updater.updateConfiguration(this.infomanSoftwareBundle, configuration);
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
    }

    class ExtensionFileFilter
    implements FileFilter {
        final String extension;

        public ExtensionFileFilter(String extension) {
            this.extension = extension;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().endsWith(this.extension);
        }
    }

    class AcceptAllFileFilter
    implements FileFilter {
        AcceptAllFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return true;
        }
    }
}

