/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.notifications;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.netbeans.modules.notifications.NotificationImpl;
import org.netbeans.modules.notifications.center.NotificationCenterManager;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class Utils {
    private static final int DATE_MINUTES_AGO = 0;
    private static final int DATE_TODAY = 1;
    private static final int DATE_YESTERDAY = 2;
    private static final int DATE_THIS_WEEK = 3;
    private static final int DATE_FULL = 4;
    private static final DateFormat timeFormat = DateFormat.getTimeInstance(3);
    private static final DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3);
    private static final KeyStroke DELETE_KEY = KeyStroke.getKeyStroke("DELETE");

    public static String getFormatedDate(Calendar calendar) {
        if (calendar == null) {
            return "";
        }
        int evaluation = Utils.evaluateDate(calendar);
        switch (evaluation) {
            case 0: {
                int minutes = Utils.calculateMinutes(calendar, Calendar.getInstance());
                return NbBundle.getMessage(Utils.class, (String)(minutes == 1 ? "LBL_MinuteAgo" : "LBL_MinutesAgo"), (Object)minutes);
            }
            case 1: {
                return NbBundle.getMessage(Utils.class, (String)"LBL_Today", (Object)timeFormat.format(calendar.getTime()));
            }
            case 2: {
                return NbBundle.getMessage(Utils.class, (String)"LBL_Yesterday", (Object)timeFormat.format(calendar.getTime()));
            }
        }
        return dateFormat.format(calendar.getTime());
    }

    public static String getFullFormatedDate(Calendar calendar) {
        if (calendar == null) {
            return "";
        }
        return DateFormat.getDateTimeInstance(2, 3).format(calendar.getTime());
    }

    private static int evaluateDate(Calendar calendar) {
        Calendar rightNow = Calendar.getInstance();
        if (calendar.get(2) == rightNow.get(2) && calendar.get(1) == rightNow.get(1) && calendar.get(4) == rightNow.get(4)) {
            if (calendar.get(5) == rightNow.get(5)) {
                if (Utils.calculateMinutes(calendar, rightNow) <= 60) {
                    return 0;
                }
                return 1;
            }
            if (calendar.get(5) == rightNow.get(5) - 1) {
                return 2;
            }
            return 3;
        }
        return 4;
    }

    private static int calculateMinutes(Calendar c1, Calendar c2) {
        int minutesC1 = c1.get(11) * 60 + c1.get(12);
        int minutesC2 = c2.get(11) * 60 + c2.get(12);
        int result = minutesC2 - minutesC1;
        if (result == 0) {
            return 1;
        }
        if (result < 0) {
            return -result;
        }
        return result;
    }

    public static Color getTextBackground() {
        Color textB = UIManager.getColor("Table.background");
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            textB = UIManager.getColor("NbExplorerView.background");
        }
        return textB != null ? textB : Color.WHITE;
    }

    public static Color getComboBorderColor() {
        Color shadow = UIManager.getColor(Utilities.isWindows() ? "Nb.ScrollPane.Border.color" : "TextField.shadow");
        return shadow != null ? shadow : Utils.getPopupBorderColor();
    }

    public static Color getPopupBorderColor() {
        Color shadow = UIManager.getColor("controlShadow");
        return shadow != null ? shadow : Color.GRAY;
    }

    public static Action[] getNotificationActions(NotificationImpl notification) {
        ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
        actions.add(new MarkUnreadAction(notification));
        actions.add(new DeleteAction(notification));
        actions.add(null);
        actions.add(new MarkAllReadAction());
        actions.add(new DeleteAllAction());
        return actions.toArray(new Action[actions.size()]);
    }

    public static Action[] getGlobalNotificationActions() {
        ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
        actions.add(new MarkAllReadAction());
        actions.add(new DeleteAllAction());
        return actions.toArray(new Action[actions.size()]);
    }

    private static class DeleteAction
    extends AbstractAction {
        private final NotificationImpl notification;

        public DeleteAction(NotificationImpl notification) {
            super(NbBundle.getMessage(Utils.class, (String)"LBL_Delete"));
            this.putValue("AcceleratorKey", DELETE_KEY);
            this.notification = notification;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.notification.clear();
        }
    }

    private static class DeleteAllAction
    extends AbstractAction {
        public DeleteAllAction() {
            super(NbBundle.getMessage(Utils.class, (String)"LBL_DeleteAll"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NotificationCenterManager.getInstance().deleteAll();
        }
    }

    private static class MarkAllReadAction
    extends AbstractAction {
        public MarkAllReadAction() {
            super(NbBundle.getMessage(Utils.class, (String)"LBL_MarkAllRead"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NotificationCenterManager.getInstance().markAllRead();
        }
    }

    private static class MarkUnreadAction
    extends AbstractAction {
        private final NotificationImpl notification;

        public MarkUnreadAction(NotificationImpl notification) {
            super(NbBundle.getMessage(Utils.class, (String)"LBL_MarkUnread"));
            this.notification = notification;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.notification.markAsRead(false);
        }
    }
}

