/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.notifications;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.CharConversionException;
import java.util.Calendar;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.notifications.Utils;
import org.netbeans.modules.notifications.center.NotificationCenterManager;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

public class NotificationImpl
extends Notification
implements Comparable<NotificationImpl> {
    private final String title;
    private final Icon icon;
    private final NotificationDisplayer.Priority priority;
    private JComponent balloonComp;
    private JComponent detailsComp;
    private String detailsText;
    private ActionListener al;
    private final NotificationDisplayer.Category category;
    private final Calendar dateCreated;
    private boolean read;

    public NotificationImpl(String title, Icon icon, NotificationDisplayer.Priority priority, NotificationDisplayer.Category category, Calendar dateCreated) {
        this.title = title;
        this.icon = icon;
        this.priority = priority;
        this.category = category;
        this.dateCreated = dateCreated;
        this.read = false;
    }

    public void clear() {
        NotificationCenterManager.getInstance().delete(this);
    }

    public void markAsRead(boolean read) {
        if (read != this.read) {
            this.read = read;
            NotificationCenterManager manager = NotificationCenterManager.getInstance();
            manager.wasRead(this);
        }
    }

    @Override
    public int compareTo(NotificationImpl n) {
        int res = this.priority.compareTo((Enum)n.priority);
        if (0 == res) {
            res = this.category.getDisplayName().compareTo(n.category.getDisplayName());
        }
        if (0 == res) {
            res = this.title.compareTo(n.title);
        }
        return res;
    }

    public JComponent getBalloonComp() {
        return this.balloonComp;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public JComponent getDetailsComponent() {
        return this.detailsComp;
    }

    public String getTitle() {
        return this.title;
    }

    public NotificationDisplayer.Priority getPriority() {
        return this.priority;
    }

    public NotificationDisplayer.Category getCategory() {
        return this.category;
    }

    public Calendar getDateCreated() {
        return this.dateCreated;
    }

    public boolean isRead() {
        return this.read;
    }

    boolean showBallon() {
        return this.priority != NotificationDisplayer.Priority.SILENT;
    }

    void setDetails(String detailsText, ActionListener al) {
        this.detailsText = detailsText;
        this.al = al;
    }

    void setDetails(JComponent balloonComp, JComponent detailsComp) {
        this.balloonComp = balloonComp;
        this.detailsComp = detailsComp;
    }

    public void initDecorations() {
        if (null != this.detailsText) {
            this.balloonComp = this.createDetails(this.detailsText, this.al);
            this.detailsComp = this.createDetails(this.detailsText, this.al);
        }
        JComponent titleComp = this.createTitle(this.title, this.icon);
        JComponent balloon = this.createContent(titleComp, this.balloonComp);
        balloon.setBorder(BorderFactory.createEmptyBorder(8, 5, 0, 0));
        this.balloonComp = balloon;
        titleComp = this.createTitle(this.title, this.icon);
        this.detailsComp = this.createContent(titleComp, this.detailsComp, this.createPriority(this.priority), this.createCategory(this.category), this.createDate(this.dateCreated));
    }

    private JComponent createContent(JComponent titleComp, JComponent popupDetails) {
        return this.createContent(titleComp, popupDetails, null, null, null);
    }

    private JComponent createContent(JComponent titleComp, JComponent detailsComp, JComponent priorityComp, JComponent categoryComp, JComponent dateComp) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        panel.add((Component)titleComp, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 3, 3), 0, 0));
        if (priorityComp != null) {
            panel.add((Component)priorityComp, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 3, 3), 0, 0));
        }
        if (categoryComp != null) {
            panel.add((Component)categoryComp, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 3, 3), 0, 0));
        }
        panel.add((Component)detailsComp, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 17, 1, new Insets(10, 10, 3, 3), 0, 0));
        panel.add((Component)new JLabel(), new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        if (dateComp != null) {
            panel.add((Component)dateComp, new GridBagConstraints(2, 4, 3, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        }
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotificationImpl.this.markAsRead(true);
            }
        };
        this.addActionListener(detailsComp, actionListener);
        return panel;
    }

    private void addActionListener(Container c, ActionListener al) {
        if (c instanceof AbstractButton) {
            ((AbstractButton)c).addActionListener(al);
        }
        for (Component child : c.getComponents()) {
            if (!(child instanceof Container)) continue;
            this.addActionListener((Container)child, al);
        }
    }

    private JComponent createTitle(String title, Icon icon) {
        JLabel titleComp = new JLabel("<html>" + title);
        if (icon != null) {
            titleComp.setIcon(icon);
        }
        titleComp.setFont(titleComp.getFont().deriveFont(1));
        return titleComp;
    }

    private JComponent createDetails(String text, ActionListener action) {
        try {
            text = (action == null ? "<html>" : "<html><a href=\"_blank\">") + XMLUtil.toElementContent((String)text);
        }
        catch (CharConversionException ex) {
            throw new IllegalArgumentException(ex);
        }
        if (null == action) {
            return new JLabel(text);
        }
        JButton btn = new JButton(text);
        btn.setFocusable(false);
        btn.setBorder(BorderFactory.createEmptyBorder());
        btn.setBorderPainted(false);
        btn.setFocusPainted(false);
        btn.setOpaque(false);
        btn.setContentAreaFilled(false);
        btn.addActionListener(action);
        btn.setCursor(Cursor.getPredefinedCursor(12));
        return btn;
    }

    private JComponent createPriority(NotificationDisplayer.Priority p) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        panel.add((Component)new JLabel(NbBundle.getMessage(NotificationImpl.class, (String)"LBL_Priority")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        panel.add((Component)new JLabel(p.getIcon()), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(p.name()), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
        panel.add((Component)new JLabel(), new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JComponent createCategory(NotificationDisplayer.Category c) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        panel.add((Component)new JLabel(NbBundle.getMessage(NotificationImpl.class, (String)"LBL_Category")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        panel.add((Component)new JLabel(c.getDisplayName()), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JComponent createDate(Calendar dateCreated) {
        return new JLabel(Utils.getFullFormatedDate(dateCreated));
    }
}

