/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.kenai;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.logging.Level;
import org.netbeans.modules.bugtracking.commons.TextUtils;
import org.netbeans.modules.bugtracking.spi.RepositoryInfo;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.kenai.KenaiConfiguration;
import org.netbeans.modules.bugzilla.kenai.KenaiQuery;
import org.netbeans.modules.bugzilla.kenai.KenaiQueryController;
import org.netbeans.modules.bugzilla.query.BugzillaQuery;
import org.netbeans.modules.bugzilla.query.QueryParameter;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.repository.IssueField;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.netbeans.modules.team.spi.OwnerInfo;
import org.netbeans.modules.team.spi.RepositoryUser;
import org.netbeans.modules.team.spi.TeamAccessor;
import org.netbeans.modules.team.spi.TeamAccessorUtils;
import org.netbeans.modules.team.spi.TeamProject;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class KenaiRepository
extends BugzillaRepository
implements PropertyChangeListener {
    private String urlParam;
    private Image icon;
    private final String product;
    private KenaiQuery myIssues;
    private KenaiQuery allIssues;
    private String host;
    private final TeamProject kenaiProject;

    KenaiRepository(TeamProject kenaiProject, String repoName, String url, String host, String userName, char[] password, String urlParam, String product) {
        super(KenaiRepository.createInfo(repoName, url, kenaiProject));
        this.urlParam = urlParam;
        if (url.contains("netbeans.org")) {
            this.icon = ImageUtilities.loadImage((String)"org/netbeans/modules/kenai/resources/netbeans-small.png", (boolean)false);
        } else if (url.contains("kenai.com")) {
            this.icon = ImageUtilities.loadImage((String)"org/netbeans/modules/kenai/resources/kenai-small.png", (boolean)false);
        } else if (url.contains("java.net")) {
            this.icon = ImageUtilities.loadImage((String)"org/netbeans/modules/kenai/resources/javanet.png", (boolean)false);
        }
        if (this.icon == null) {
            this.icon = ImageUtilities.loadImage((String)"org/netbeans/modules/bugtracking/ui/resources/kenai-small.png", (boolean)true);
        }
        this.product = product;
        this.host = host;
        assert (kenaiProject != null);
        this.kenaiProject = kenaiProject;
        TeamAccessor kenaiAccessor = TeamAccessorUtils.getTeamAccessor((String)url);
        if (kenaiAccessor != null) {
            kenaiAccessor.addPropertyChangeListener((PropertyChangeListener)this, kenaiProject.getWebLocation().toString());
        }
    }

    public KenaiRepository(TeamProject kenaiProject, String repoName, String url, String host, String urlParam, String product) {
        this(kenaiProject, repoName, url, host, KenaiRepository.getKenaiUser(kenaiProject), KenaiRepository.getKenaiPassword(kenaiProject), urlParam, product);
    }

    @Override
    public Image getIcon() {
        return this.icon;
    }

    @Override
    public BugzillaQuery createQuery() {
        KenaiQuery q = new KenaiQuery(null, (BugzillaRepository)this, null, this.product, false, false);
        return q;
    }

    @Override
    public BugzillaQuery createPersistentQuery(String queryName, String urlParams, boolean urlDef) {
        return new KenaiQuery(queryName, (BugzillaRepository)this, urlParams, this.product, true, false);
    }

    @Override
    public BugzillaIssue createIssue() {
        return super.createIssue();
    }

    @Override
    public synchronized Collection<BugzillaQuery> getQueries() {
        LinkedList<BugzillaQuery> ret = new LinkedList<BugzillaQuery>();
        ret.addAll(super.getQueries());
        ret.addAll(this.getDefinedQueries());
        return ret;
    }

    @Override
    public Collection<BugzillaIssue> getUnsubmittedIssues() {
        LinkedHashSet<BugzillaIssue> unsubmitted = new LinkedHashSet<BugzillaIssue>(super.getUnsubmittedIssues());
        Iterator it = unsubmitted.iterator();
        while (it.hasNext()) {
            BugzillaIssue issue = (BugzillaIssue)((Object)it.next());
            if (this.product.equals(issue.getRepositoryFieldValue(IssueField.PRODUCT))) continue;
            it.remove();
        }
        return unsubmitted;
    }

    private Collection<BugzillaQuery> getDefinedQueries() {
        BugzillaQuery ai;
        ArrayList<BugzillaQuery> queries = new ArrayList<BugzillaQuery>();
        BugzillaQuery mi = this.getMyIssuesQuery();
        if (mi != null) {
            queries.add(mi);
        }
        if ((ai = this.getAllIssuesQuery()) != null) {
            queries.add(ai);
        }
        return queries;
    }

    public TeamProject getKenaiProject() {
        return this.kenaiProject;
    }

    public synchronized BugzillaQuery getAllIssuesQuery() throws MissingResourceException {
        if (!this.providePredefinedQueries() || BugzillaUtil.isNbRepository(this)) {
            return null;
        }
        if (this.allIssues == null) {
            StringBuffer url = new StringBuffer();
            url = new StringBuffer();
            url.append(this.urlParam);
            url.append(MessageFormat.format("&product={0}&bug_status=UNCONFIRMED&bug_status=NEW&bug_status=ASSIGNED&bug_status=REOPENED", this.product));
            this.allIssues = new KenaiQuery(TeamAccessorUtils.ALL_ISSUES_QUERY_DISPLAY_NAME, (BugzillaRepository)this, url.toString(), this.product, true, true);
        }
        return this.allIssues;
    }

    public synchronized BugzillaQuery getMyIssuesQuery() throws MissingResourceException {
        if (!this.providePredefinedQueries()) {
            return null;
        }
        if (this.myIssues == null) {
            String url = this.getMyIssuesQueryUrl();
            this.myIssues = new KenaiQuery(TeamAccessorUtils.MY_ISSUES_QUERY_DISPLAY_NAME, (BugzillaRepository)this, url.toString(), this.product, true, true);
        }
        return this.myIssues;
    }

    private String getMyIssuesQueryUrl() {
        StringBuilder url = new StringBuilder();
        url.append(this.urlParam);
        String user = KenaiRepository.getKenaiUser(this.kenaiProject);
        if (user == null) {
            user = "";
        }
        String userMail = user + "@" + this.host;
        String urlFormat = BugzillaUtil.isNbRepository(this) ? "&product={0}&bug_status=NEW&bug_status=STARTED&bug_status=REOPENED&emailassigned_to1=1&emailreporter1=1&emailtype1=exact&email1={1}" : "&product={0}&bug_status=UNCONFIRMED&bug_status=NEW&bug_status=ASSIGNED&bug_status=REOPENED&emailassigned_to1=1&emailreporter1=1&emailtype1=exact&email1={1}";
        url.append(MessageFormat.format(urlFormat, this.product, userMail));
        return url.toString();
    }

    @Override
    public synchronized void refreshConfiguration() {
        KenaiConfiguration conf = (KenaiConfiguration)this.getConfiguration();
        conf.reset();
        super.refreshConfiguration();
    }

    @Override
    protected BugzillaConfiguration createConfiguration(boolean forceRefresh) {
        KenaiConfiguration kc = new KenaiConfiguration(this, this.product);
        kc.initialize(this, forceRefresh);
        return kc;
    }

    @Override
    public void ensureCredentials() {
        this.authenticate(null);
    }

    @Override
    public boolean authenticate(String errroMsg) {
        PasswordAuthentication pa = TeamAccessorUtils.getPasswordAuthentication((String)this.kenaiProject.getWebLocation().toString(), (boolean)true);
        if (pa == null) {
            return false;
        }
        String user = pa.getUserName();
        char[] password = pa.getPassword();
        this.setTaskRepository(user, password);
        return true;
    }

    public boolean isLoggedIn() {
        return TeamAccessorUtils.isLoggedIn((URL)this.kenaiProject.getWebLocation());
    }

    public boolean isMyIssues(BugzillaQuery q) {
        return this.myIssues == q;
    }

    public String getProductName() {
        return this.product;
    }

    private static String getKenaiUser(TeamProject kenaiProject) {
        PasswordAuthentication pa = TeamAccessorUtils.getPasswordAuthentication((String)kenaiProject.getWebLocation().toString(), (boolean)false);
        if (pa != null) {
            return pa.getUserName();
        }
        return "";
    }

    private static char[] getKenaiPassword(TeamProject kenaiProject) {
        PasswordAuthentication pa = TeamAccessorUtils.getPasswordAuthentication((String)kenaiProject.getWebLocation().toString(), (boolean)false);
        if (pa != null) {
            return pa.getPassword();
        }
        return new char[0];
    }

    @Override
    protected QueryParameter[] getSimpleSearchParameters() {
        List data;
        ArrayList<QueryParameter.SimpleQueryParameter> ret = new ArrayList<QueryParameter.SimpleQueryParameter>();
        ret.add(new QueryParameter.SimpleQueryParameter("product", new String[]{this.product}, this.getTaskRepository().getCharacterEncoding()));
        Node[] nodes = WindowManager.getDefault().getRegistry().getActivatedNodes();
        OwnerInfo ownerInfo = this.getOwnerInfo(nodes);
        if (ownerInfo != null && ownerInfo.getOwner().equals(this.product) && (data = ownerInfo.getExtraData()) != null && data.size() > 0) {
            ret.add(new QueryParameter.SimpleQueryParameter("component", new String[]{(String)data.get(0)}, this.getTaskRepository().getCharacterEncoding()));
        }
        return ret.toArray(new QueryParameter[ret.size()]);
    }

    @Override
    public Collection<RepositoryUser> getUsers() {
        return TeamAccessorUtils.getProjectMembers((TeamProject)this.kenaiProject);
    }

    public String getHost() {
        return this.host;
    }

    private static String getRepositoryId(String name, String url) {
        return TextUtils.encodeURL((String)url) + ":" + name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("team.login.changed")) {
            char[] psswd;
            String user;
            PasswordAuthentication pa = TeamAccessorUtils.getPasswordAuthentication((String)this.kenaiProject.getWebLocation().toString(), (boolean)false);
            if (pa != null) {
                user = pa.getUserName();
                psswd = pa.getPassword();
            } else {
                user = "";
                psswd = new char[]{};
            }
            this.setTaskRepository(user, psswd);
            KenaiRepository kenaiRepository = this;
            synchronized (kenaiRepository) {
                if (evt.getNewValue() != null && this.myIssues != null) {
                    KenaiQueryController c = (KenaiQueryController)this.myIssues.getController();
                    String url = this.getMyIssuesQueryUrl();
                    c.populate(url);
                    this.myIssues.setUrlParameters(url);
                }
            }
        }
    }

    @Override
    public OwnerInfo getOwnerInfo(Node[] nodes) {
        OwnerInfo ownerInfo = super.getOwnerInfo(nodes);
        if (ownerInfo != null) {
            if (ownerInfo.getOwner().equals(this.product)) {
                return ownerInfo;
            }
            Bugzilla.LOG.log(Level.WARNING, " returned owner [{0}] for {1} is different then product [{2}]", new Object[]{ownerInfo.getOwner(), nodes[0], this.product});
            return null;
        }
        return null;
    }

    private boolean providePredefinedQueries() {
        String provide = System.getProperty("org.netbeans.modules.bugzilla.noPredefinedQueries");
        return !"true".equals(provide);
    }

    private static RepositoryInfo createInfo(String repoName, String url, TeamProject project) {
        String id = KenaiRepository.getRepositoryId(repoName, url);
        String tooltip = NbBundle.getMessage(BugzillaRepository.class, (String)"LBL_RepositoryTooltipNoUser", (Object[])new Object[]{repoName, url});
        RepositoryInfo i = new RepositoryInfo(id, "org.netbeans.modules.bugzilla", url, repoName, tooltip);
        i.putValue("team.project.name", project.getName());
        return i;
    }

    @Override
    protected RepositoryInfo createInfo(String id, String url, String name, String user, String httpUser, char[] password, char[] httpPassword) {
        RepositoryInfo i = super.createInfo(id, url, name, user, httpUser, password, httpPassword);
        i.putValue("team.project.name", this.kenaiProject.getName());
        return i;
    }
}

