/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.issue;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.api.Issue;
import org.netbeans.modules.bugtracking.api.IssueQuickSearch;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.commons.AttachmentsPanel;
import org.netbeans.modules.bugtracking.commons.CollapsibleSectionPanel;
import org.netbeans.modules.bugtracking.commons.LinkButton;
import org.netbeans.modules.bugtracking.commons.NBBugzillaUtils;
import org.netbeans.modules.bugtracking.commons.SectionPanel;
import org.netbeans.modules.bugtracking.commons.UIUtils;
import org.netbeans.modules.bugtracking.spi.SchedulePicker;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.BugzillaConfig;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.issue.Bundle;
import org.netbeans.modules.bugzilla.issue.CommentsPanel;
import org.netbeans.modules.bugzilla.kenai.KenaiRepository;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.repository.CustomIssueField;
import org.netbeans.modules.bugzilla.repository.IssueField;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.netbeans.modules.mylyn.util.NbDateRange;
import org.netbeans.modules.spellchecker.api.Spellchecker;
import org.netbeans.modules.team.ide.spi.IDEServices;
import org.netbeans.modules.team.spi.OwnerInfo;
import org.netbeans.modules.team.spi.RepositoryUser;
import org.netbeans.modules.team.spi.RepositoryUserRenderer;
import org.netbeans.modules.team.spi.TeamAccessorUtils;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class IssuePanel
extends JPanel {
    private static Color incomingChangesColor = null;
    private static final RequestProcessor RP = new RequestProcessor("Bugzilla Issue Panel", 5, false);
    private static final URL ICON_REMOTE_PATH = IssuePanel.class.getClassLoader().getResource("org/netbeans/modules/bugzilla/resources/remote.png");
    private static final ImageIcon ICON_REMOTE = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/remote.png", (boolean)true);
    private static final URL ICON_CONFLICT_PATH = IssuePanel.class.getClassLoader().getResource("org/netbeans/modules/bugzilla/resources/conflict.png");
    private static final ImageIcon ICON_CONFLICT = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/conflict.png", (boolean)true);
    private static final URL ICON_UNSUBMITTED_PATH = IssuePanel.class.getClassLoader().getResource("org/netbeans/modules/bugzilla/resources/unsubmitted.png");
    private static final ImageIcon ICON_UNSUBMITTED = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/unsubmitted.png", (boolean)true);
    private static final String SECTION_ATTRIBUTES = ".attributes";
    private static final String SECTION_ATTACHMENTS = ".attachments";
    private static final String SECTION_COMMENTS = ".comments";
    private static final String SECTION_PRIVATE = ".private";
    private static final String ATTRIBUTE_PRIVATE_NOTES = "nb.private.notes";
    private static final String ATTRIBUTE_ESTIMATE = "nb.estimate";
    private static final String ATTRIBUTE_DUE_DATE = "nb.due.date";
    private static final String ATTRIBUTE_SCHEDULE_DATE = "nb.schedule.date";
    private BugzillaIssue issue;
    private CommentsPanel commentsPanel;
    private AttachmentsPanel attachmentsPanel;
    private int resolvedIndex;
    private List<String> keywords = new LinkedList<String>();
    private boolean reloading;
    private boolean skipReload;
    private boolean usingTargetMilestones;
    private OwnerInfo ownerInfo;
    private final Set<String> unsavedFields = new HashSet<String>();
    private boolean customFieldsLoaded;
    private boolean initializingNewTask;
    private Action[] attributesSectionActions;
    private Action[] attachmentsSectionActions;
    private Action[] commentsSectionActions;
    private Action[] privateSectionActions;
    private final IDEServices.DatePickerComponent dueDatePicker;
    private final IDEServices.DatePickerComponent deadlinePicker;
    private final SchedulePicker scheduleDatePicker;
    private static final NumberFormatter estimateFormatter;
    private boolean opened;
    PropertyChangeListener cacheListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() != IssuePanel.this.issue) {
                return;
            }
            if ("issue.status_changed".equals(evt.getPropertyName())) {
                Mutex.EVENT.readAccess(new Runnable(){

                    @Override
                    public void run() {
                        IssuePanel.this.updateFieldStatuses();
                    }
                });
            }
        }
    };
    private int oldCommentCount;
    private boolean noSummary = false;
    private boolean invalidKeyword = false;
    private boolean cyclicDependency = false;
    private boolean noComponent = false;
    private boolean noVersion = false;
    private boolean noTargetMilestione = false;
    private boolean noDuplicateId = false;
    private final Map<IssueField, String> fieldsConflict = new LinkedHashMap<IssueField, String>();
    private final Map<IssueField, String> fieldsIncoming = new LinkedHashMap<IssueField, String>();
    private final Map<IssueField, String> fieldsLocal = new LinkedHashMap<IssueField, String>();
    private final TooltipsMap tooltipsConflict = new TooltipsMap();
    private final TooltipsMap tooltipsIncoming = new TooltipsMap();
    private final TooltipsMap tooltipsLocal = new TooltipsMap();
    private Map<Component, Boolean> enableMap = new HashMap<Component, Boolean>();
    private List<CustomFieldInfo> customFields = new LinkedList<CustomFieldInfo>();
    private JTextField actualField;
    private JLabel actualLabel;
    private JLabel actualWarning;
    private JTextArea addCommentArea;
    private JCheckBox assignToDefaultCheckBox;
    private JComboBox assignedCombo;
    private JTextField assignedField;
    private JLabel assignedLabel;
    private JLabel assignedToStatusLabel;
    private JLabel assignedToWarning;
    private JCheckBox attachLogCheckBox;
    private CollapsibleSectionPanel attachmentsSection;
    private JPanel attachmentsSectionPanel;
    private JLabel attachmentsWarning;
    private CollapsibleSectionPanel attributesSection;
    private JPanel attributesSectionPanel;
    private JButton blocksButton;
    private JTextField blocksField;
    private JLabel blocksLabel;
    private JLabel blocksWarning;
    private LinkButton btnDeleteTask;
    private JPanel buttonsPanel;
    private LinkButton cancelButton;
    private JTextField ccField;
    private JLabel ccLabel;
    private JLabel ccWarning;
    private JLabel commentWarning;
    private CollapsibleSectionPanel commentsSection;
    private JPanel commentsSectionPanel;
    private JTextField completeField;
    private JLabel completeLabel;
    private JLabel completeWarning;
    private JComboBox componentCombo;
    private JLabel componentLabel;
    private JLabel componentWarning;
    private JPanel customFieldsPanelLeft;
    private JPanel customFieldsPanelRight;
    private JLabel deadlineLabel;
    private JLabel deadlineWarning;
    private JTextField dependsField;
    private JLabel dependsLabel;
    private JButton dependsOnButton;
    private JLabel dependsOnWarning;
    private JLabel dueDateLabel;
    private JPanel dummyAttachmentsPanel;
    private JPanel dummyCommentsPanel;
    private JTextField dummyDeadlineField;
    private JTextField dummyDueDateField;
    private JLabel dummyLabel1;
    private JLabel dummyLabel2;
    private JLabel dummyLabel3;
    private JTextField dummyScheduleDateField;
    private JLabel dummyTimetrackingLabel;
    private JPanel dummyTimetrackingPanel;
    private JButton duplicateButton;
    private JTextField duplicateField;
    private JLabel duplicateLabel;
    private JLabel duplicateWarning;
    private JFormattedTextField estimateField;
    private JLabel estimateLabel;
    private JTextField estimatedField;
    private JLabel estimatedLabel;
    private JLabel estimatedWarning;
    private JTextField gainField;
    private JLabel gainLabel;
    private JLabel gainWarning;
    private JTextField headerField;
    private JPanel headerPanel;
    private JComboBox issueTypeCombo;
    private JLabel issueTypeLabel;
    private JLabel issueTypeWarning;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JButton keywordsButton;
    private JTextField keywordsField;
    private JLabel keywordsLabel;
    private JLabel keywordsWarning;
    private JPanel mainPanel;
    private JScrollPane mainScrollPane;
    private JPanel messagePanel;
    private JLabel milestoneWarning;
    private JTextField modifiedField;
    private JLabel modifiedLabel;
    private SectionPanel newCommentSection;
    private JPanel newCommentSectionPanel;
    private JLabel notesLabel;
    private JComboBox osCombo;
    private JComboBox platformCombo;
    private JLabel platformLabel;
    private JLabel platformWarning;
    private JComboBox priorityCombo;
    private JLabel priorityLabel;
    private JLabel priorityWarning;
    private JTextArea privateNotesField;
    private JScrollPane privateNotesScrollPane;
    private JPanel privatePanel;
    private CollapsibleSectionPanel privateSection;
    private JComboBox productCombo;
    private JTextField productField;
    private JLabel productLabel;
    private JLabel productWarning;
    private JTextField qaContactField;
    private JLabel qaContactLabel;
    private JLabel qaContactWarning;
    private LinkButton refreshButton;
    private JTextField remainingField;
    private JLabel remainingLabel;
    private JLabel remainingWarning;
    private JTextField reportedField;
    private JLabel reportedLabel;
    private JLabel reportedStatusLabel;
    private JComboBox resolutionCombo;
    private JTextField resolutionField;
    private JLabel resolutionLabel;
    private JLabel resolutionWarning;
    private JLabel scheduleDateLabel;
    private JScrollPane scrollPane1;
    private JLabel separatorDismissButton;
    private JLabel separatorLabel3;
    private JLabel separatorLabel4;
    private JLabel separatorLabel6;
    private JComboBox severityCombo;
    private LinkButton showInBrowserButton;
    private JComboBox statusCombo;
    private JLabel statusLabel;
    private JLabel statusWarning;
    private JTextField statusWhiteboardField;
    private JLabel statusWhiteboardLabel;
    private JLabel statusWhiteboardWarning;
    private LinkButton submitButton;
    private JTextField summaryField;
    private JLabel summaryLabel;
    private JLabel summaryWarning;
    private JComboBox targetMilestoneCombo;
    private JLabel targetMilestoneLabel;
    private JLabel timetrackingLabel;
    private JPanel timetrackingPanel;
    private JLabel timetrackingWarning;
    private JTextField urlField;
    private LinkButton urlLabel;
    private JLabel urlWarning;
    private JComboBox versionCombo;
    private JLabel versionLabel;
    private JLabel versionWarning;
    private LinkButton viewLogButton;
    private JTextField workedField;
    private JLabel workedLabel;
    private JLabel workedSumField;
    private JLabel workedWarning;
    private static final String CURRENT_NB_VERSION = "8.0";

    public IssuePanel() {
        this.initComponents();
        this.updateReadOnlyField(this.reportedField);
        this.updateReadOnlyField(this.modifiedField);
        this.updateReadOnlyField(this.resolutionField);
        this.updateReadOnlyField(this.productField);
        this.updateReadOnlyField(this.headerField);
        this.messagePanel.setBackground(this.getBackground());
        this.customFieldsPanelLeft.setBackground(this.getBackground());
        this.customFieldsPanelRight.setBackground(this.getBackground());
        Font font = this.reportedLabel.getFont();
        this.headerField.setFont(font.deriveFont((float)((double)font.getSize() * 1.7)));
        this.duplicateLabel.setVisible(false);
        this.duplicateWarning.setVisible(false);
        this.duplicateField.setVisible(false);
        this.duplicateButton.setVisible(false);
        this.attachDocumentListeners();
        this.attachHideStatusListener();
        this.addCommentArea.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                IssuePanel.this.makeCaretVisible(IssuePanel.this.addCommentArea);
            }
        });
        UIUtils.fixFocusTraversalKeys((JComponent)this.addCommentArea);
        this.commentsPanel = new CommentsPanel();
        this.commentsPanel.setNewCommentHandler(new CommentsPanel.NewCommentHandler(){

            @Override
            public void append(String text) {
                IssuePanel.this.addCommentArea.append(text);
                IssuePanel.this.addCommentArea.requestFocus();
                IssuePanel.this.scrollRectToVisible(IssuePanel.this.scrollPane1.getBounds());
            }
        });
        this.attachmentsPanel = new AttachmentsPanel((JComponent)this);
        ((GroupLayout)this.commentsSectionPanel.getLayout()).replace(this.dummyCommentsPanel, this.commentsPanel);
        ((GroupLayout)this.attributesSectionPanel.getLayout()).replace(this.dummyTimetrackingPanel, this.timetrackingPanel);
        ((GroupLayout)this.attachmentsSectionPanel.getLayout()).replace(this.dummyAttachmentsPanel, (Component)this.attachmentsPanel);
        this.deadlinePicker = UIUtils.createDatePickerComponent();
        ((GroupLayout)this.timetrackingPanel.getLayout()).replace(this.dummyDeadlineField, this.deadlinePicker.getComponent());
        GroupLayout layout = (GroupLayout)this.privatePanel.getLayout();
        this.dueDatePicker = UIUtils.createDatePickerComponent();
        this.scheduleDatePicker = new SchedulePicker();
        layout.replace(this.dummyDueDateField, this.dueDatePicker.getComponent());
        this.dueDateLabel.setLabelFor(this.dueDatePicker.getComponent());
        layout.replace(this.dummyScheduleDateField, this.scheduleDatePicker.getComponent());
        this.scheduleDateLabel.setLabelFor(this.scheduleDatePicker.getComponent());
        this.privateNotesField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                IssuePanel.this.makeCaretVisible(IssuePanel.this.privateNotesField);
            }
        });
        UIUtils.fixFocusTraversalKeys((JComponent)this.privateNotesField);
        this.initSpellChecker();
        this.initDefaultButton();
        UIUtils.issue163946Hack((JScrollPane)this.scrollPane1);
        font = UIManager.getFont("Label.font");
        if (font != null) {
            this.mainScrollPane.getVerticalScrollBar().setUnitIncrement((int)((double)font.getSize() * 1.5));
            this.mainScrollPane.getHorizontalScrollBar().setUnitIncrement((int)((double)font.getSize() * 1.5));
        }
    }

    private void initDefaultButton() {
        if (Boolean.getBoolean("bugtracking.suppressActionKeys")) {
            return;
        }
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "submit");
        ActionMap actionMap = this.getActionMap();
        AbstractAction submitAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (IssuePanel.this.submitButton.isEnabled()) {
                    IssuePanel.this.submitButtonActionPerformed(null);
                }
            }
        };
        actionMap.put("submit", submitAction);
    }

    private void updateReadOnlyField(JTextField field) {
        Color bkColor;
        if ("GTK".equals(UIManager.getLookAndFeel().getID())) {
            field.setUI(new BasicTextFieldUI());
        }
        if (null != (bkColor = this.getBackground())) {
            bkColor = new Color(bkColor.getRGB());
        }
        field.setBackground(bkColor);
        Caret caret = field.getCaret();
        if (caret instanceof DefaultCaret) {
            ((DefaultCaret)caret).setUpdatePolicy(1);
        }
    }

    void reloadFormInAWT(final boolean force) {
        if (EventQueue.isDispatchThread()) {
            this.reloadForm(force);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IssuePanel.this.reloadForm(force);
                }
            });
        }
    }

    BugzillaIssue getIssue() {
        return this.issue;
    }

    void modelStateChanged(final boolean isDirty, final boolean isModified) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                if (!IssuePanel.this.reloading && isDirty) {
                    IssuePanel.this.issue.markUserChange();
                }
                if (!isDirty) {
                    IssuePanel.this.clearUnsavedFields();
                }
                if (IssuePanel.this.enableMap.isEmpty()) {
                    IssuePanel.this.cancelButton.setEnabled(isModified || isDirty);
                } else {
                    IssuePanel.this.enableMap.put(IssuePanel.this.cancelButton, isModified || isDirty);
                }
                if (!IssuePanel.this.initializingNewTask) {
                    IssuePanel.this.issue.fireChangeEvent();
                }
            }
        });
    }

    boolean initializingNewTask() {
        return this.initializingNewTask;
    }

    public void setIssue(BugzillaIssue issue) {
        assert (SwingUtilities.isEventDispatchThread()) : "Accessing Swing components. Do not call outside event-dispatch thread!";
        if (this.issue == null) {
            issue.removePropertyChangeListener(this.cacheListener);
            issue.addPropertyChangeListener(this.cacheListener);
            this.summaryField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    IssuePanel.this.updateNoSummary();
                }
            });
            this.keywordsField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    IssuePanel.this.updateInvalidKeyword();
                }
            });
        }
        this.issue = issue;
        this.initCombos();
        List<String> kws = issue.getRepository().getConfiguration().getKeywords();
        this.keywords.clear();
        for (String keyword : kws) {
            this.keywords.add(keyword.toUpperCase());
        }
        this.attachmentsSection.setActions(this.getAttachmentsSectionActions());
        this.setupListeners();
        boolean showQAContact = BugzillaUtil.showQAContact(issue.getRepository());
        if (this.qaContactLabel.isVisible() != showQAContact) {
            GroupLayout layout = (GroupLayout)this.attributesSectionPanel.getLayout();
            JLabel temp = new JLabel();
            IssuePanel.swap(layout, this.ccLabel, this.qaContactLabel, temp);
            IssuePanel.swap(layout, this.ccField, this.qaContactField, temp);
            this.qaContactLabel.setVisible(showQAContact);
            this.qaContactField.setVisible(showQAContact);
        }
        boolean showStatusWhiteboard = BugzillaUtil.showStatusWhiteboard(issue.getRepository());
        this.statusWhiteboardLabel.setVisible(showStatusWhiteboard);
        this.statusWhiteboardField.setVisible(showStatusWhiteboard);
        this.statusWhiteboardWarning.setVisible(showStatusWhiteboard);
        boolean showIssueType = BugzillaUtil.showIssueType(issue.getRepository());
        this.issueTypeLabel.setVisible(false);
        this.issueTypeCombo.setVisible(showIssueType);
        this.issueTypeWarning.setVisible(false);
        this.severityCombo.setVisible(!showIssueType);
        if (showIssueType) {
            GroupLayout layout = (GroupLayout)this.attributesSectionPanel.getLayout();
            JLabel temp = new JLabel();
            IssuePanel.swap(layout, this.severityCombo, this.issueTypeCombo, temp);
        }
        if (issue.isNew() && NBBugzillaUtils.isNbRepository((String)issue.getRepository().getUrl())) {
            this.ownerInfo = issue.getOwnerInfo();
            if (this.ownerInfo == null) {
                Node[] selection = WindowManager.getDefault().getRegistry().getActivatedNodes();
                this.ownerInfo = issue.getRepository().getOwnerInfo(selection);
            }
        }
        Dimension dim = this.ccField.getPreferredSize();
        int width1 = Math.max(this.osCombo.getPreferredSize().width, this.platformCombo.getPreferredSize().width);
        int width2 = Math.max(this.priorityCombo.getPreferredSize().width, showIssueType ? this.issueTypeCombo.getPreferredSize().width : this.severityCombo.getPreferredSize().width);
        int gap = LayoutStyle.getInstance().getPreferredGap(this.osCombo, this.platformCombo, LayoutStyle.ComponentPlacement.RELATED, 3, this);
        this.ccField.setPreferredSize(new Dimension(2 * Math.max(width1, width2) + gap, dim.height));
    }

    private void selectProduct() {
        if (this.ownerInfo != null) {
            String owner = this.findInModel(this.productCombo, this.ownerInfo.getOwner());
            this.productCombo.setSelectedItem(owner);
            List data = this.ownerInfo.getExtraData();
            if (data != null && data.size() > 0) {
                String component = this.findInModel(this.componentCombo, (String)data.get(0));
                this.selectInCombo(this.componentCombo, component, true);
            }
        } else {
            BugzillaRepository repository = this.issue.getRepository();
            if (repository instanceof KenaiRepository) {
                String productName = ((KenaiRepository)repository).getProductName();
                this.productCombo.setSelectedItem(productName);
            } else if (BugzillaUtil.isNbRepository(repository)) {
                String defaultProduct = "ide";
                String defaultComponent = "Code";
                this.productCombo.setSelectedItem(defaultProduct);
                this.componentCombo.setSelectedItem(defaultComponent);
            } else {
                this.productCombo.setSelectedIndex(0);
            }
        }
        this.storeFieldValueForNewIssue(IssueField.COMPONENT, this.componentCombo);
    }

    private String findInModel(JComboBox combo, String value) {
        ComboBoxModel model = combo.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            String element = model.getElementAt(i).toString();
            if (!value.toLowerCase().equals(element.toString().toLowerCase())) continue;
            return element;
        }
        return null;
    }

    private static void swap(GroupLayout layout, JComponent comp1, JComponent comp2, JComponent temp) {
        layout.replace(comp1, temp);
        layout.replace(comp2, comp1);
        layout.replace(temp, comp2);
    }

    void reloadForm(boolean force) {
        if (this.skipReload || !this.opened) {
            return;
        }
        this.enableComponents(true);
        this.reloading = true;
        this.clearHighlights();
        boolean isNew = this.issue.isNew();
        boolean showProductCombo = isNew || !(this.issue.getRepository() instanceof KenaiRepository) || NBBugzillaUtils.isNbRepository((String)this.issue.getRepository().getUrl());
        boolean hasTimeTracking = !isNew && this.issue.hasTimeTracking();
        GroupLayout layout = (GroupLayout)this.attributesSectionPanel.getLayout();
        if (showProductCombo) {
            if (this.productCombo.getParent() == null) {
                layout.replace(this.productField, this.productCombo);
            }
        } else if (this.productField.getParent() == null) {
            layout.replace(this.productCombo, this.productField);
        }
        this.productLabel.setLabelFor(isNew ? this.productCombo : this.productField);
        boolean isNetbeans = NBBugzillaUtils.isNbRepository((String)this.issue.getRepository().getUrl());
        if (isNew && isNetbeans) {
            this.attachLogCheckBox.setVisible(true);
            String attachLogValue = this.issue.getFieldValue(IssueField.NB_ATTACH_IDE_LOG);
            if (attachLogValue.isEmpty()) {
                this.attachLogCheckBox.setSelected(BugzillaConfig.getInstance().getAttachLogFile());
            } else {
                this.reloadField(this.attachLogCheckBox, IssueField.NB_ATTACH_IDE_LOG);
            }
        } else {
            this.attachLogCheckBox.setVisible(false);
        }
        this.switchViewLog();
        this.headerField.setVisible(!isNew);
        this.statusCombo.setEnabled(!isNew);
        this.newCommentSection.setLabel(NbBundle.getMessage(IssuePanel.class, (String)(isNew ? "IssuePanel.description" : "IssuePanel.newCommentSection.label")));
        this.reportedLabel.setVisible(!isNew);
        this.reportedField.setVisible(!isNew);
        this.modifiedLabel.setVisible(!isNew);
        this.modifiedField.setVisible(!isNew);
        this.assignToDefaultCheckBox.setVisible(!isNew && this.issue.canAssignToDefault());
        this.assignToDefaultCheckBox.setSelected(false);
        this.statusLabel.setVisible(!isNew);
        this.statusCombo.setVisible(!isNew);
        this.resolutionLabel.setVisible(!isNew);
        this.timetrackingLabel.setVisible(hasTimeTracking);
        this.timetrackingPanel.setVisible(hasTimeTracking);
        this.dummyTimetrackingLabel.setVisible(hasTimeTracking);
        this.commentsSection.setVisible(!isNew);
        this.attachmentsSection.setVisible(!isNew);
        this.dummyLabel3.setVisible(!isNew);
        this.refreshButton.setVisible(!isNew);
        this.cancelButton.setVisible(!isNew);
        this.separatorLabel6.setVisible(!isNew);
        this.btnDeleteTask.setVisible(isNew);
        this.separatorDismissButton.setVisible(isNew);
        this.separatorLabel3.setVisible(!isNew);
        this.showInBrowserButton.setVisible(!isNew);
        this.separatorLabel4.setVisible(!isNew);
        this.privateSection.setVisible(!isNew);
        this.assignedField.setEditable(this.issue.isNew() || this.issue.canReassign());
        this.assignedCombo.setEnabled(this.assignedField.isEditable());
        Mnemonics.setLocalizedText((AbstractButton)this.submitButton, (String)NbBundle.getMessage(IssuePanel.class, (String)(isNew ? "IssuePanel.submitButton.text.new" : "IssuePanel.submitButton.text")));
        if (isNew && force && this.issue.isMarkedNewUnread()) {
            this.initializeNewTask();
            this.initStatusCombo("NEW");
        } else {
            String selectedAssignee;
            String format = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.headerLabel.format");
            String headerTxt = MessageFormat.format(format, this.issue.getID(), this.issue.getSummary());
            this.headerField.setText(headerTxt);
            Dimension dim = this.headerField.getPreferredSize();
            this.headerField.setMinimumSize(new Dimension(0, dim.height));
            this.headerField.setPreferredSize(new Dimension(0, dim.height));
            this.reloadField(force, this.summaryField, IssueField.SUMMARY);
            this.reloadField(force, this.productCombo, IssueField.PRODUCT);
            this.reloadField(this.productField, IssueField.PRODUCT);
            this.reloadField(force, this.componentCombo, IssueField.COMPONENT);
            this.reloadField(force, this.versionCombo, IssueField.VERSION);
            this.reloadField(force, this.platformCombo, IssueField.PLATFORM);
            this.reloadField(force, this.osCombo, IssueField.OS);
            this.reloadField(this.resolutionField, IssueField.RESOLUTION);
            this.initStatusCombo(this.issue.getRepositoryFieldValue(IssueField.STATUS));
            this.reloadField(force, this.statusCombo, IssueField.STATUS);
            this.reloadField(force, this.resolutionCombo, IssueField.RESOLUTION);
            this.reloadField(force, this.duplicateField, IssueField.DUPLICATE_ID);
            JTextField field = new JTextField();
            this.duplicateField.setBorder(field.getBorder());
            this.duplicateField.setBackground(field.getBackground());
            this.reloadField(force, this.priorityCombo, IssueField.PRIORITY);
            if (BugzillaUtil.isNbRepository(this.issue.getRepository())) {
                this.reloadField(force, this.issueTypeCombo, IssueField.ISSUE_TYPE);
            }
            this.reloadField(force, this.severityCombo, IssueField.SEVERITY);
            if (this.usingTargetMilestones) {
                this.reloadField(force, this.targetMilestoneCombo, IssueField.MILESTONE);
            }
            this.reloadField(this.assignToDefaultCheckBox, IssueField.REASSIGN_TO_DEFAULT);
            this.reloadField(this.urlField, IssueField.URL);
            this.reloadField(force, this.statusWhiteboardField, IssueField.WHITEBOARD);
            this.reloadField(force, this.keywordsField, IssueField.KEYWORDS);
            if (isNew) {
                if (this.addCommentArea.getText().isEmpty()) {
                    this.reloadField(this.addCommentArea, IssueField.DESCRIPTION);
                }
            } else {
                this.reloadField(this.addCommentArea, IssueField.COMMENT);
            }
            boolean isKenaiRepository = this.issue.getRepository() instanceof KenaiRepository;
            if (!isNew) {
                Date modification;
                format = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.reportedLabel.format");
                Date creation = this.issue.getCreatedDate();
                String creationTxt = creation != null ? DateFormat.getDateInstance(2).format(creation) : "";
                String reporterName = this.issue.getFieldValue(IssueField.REPORTER_NAME);
                String reporter = this.issue.getFieldValue(IssueField.REPORTER);
                String reporterTxt = reporterName == null || reporterName.trim().length() == 0 ? reporter : reporterName;
                String reportedTxt = MessageFormat.format(format, creationTxt, reporterTxt);
                this.reportedField.setText(reportedTxt);
                IssuePanel.fixPrefSize(this.reportedField);
                if (isKenaiRepository && this.reportedStatusLabel.getIcon() == null) {
                    int index = reporter.indexOf(64);
                    String userName = index == -1 ? reporter : reporter.substring(0, index);
                    String host = ((KenaiRepository)this.issue.getRepository()).getHost();
                    JLabel label = TeamAccessorUtils.createUserWidget((String)this.issue.getRepository().getUrl(), (String)userName, (String)host, (String)TeamAccessorUtils.getChatLink((String)this.issue.getID()));
                    if (label != null) {
                        label.setText(null);
                        ((GroupLayout)this.attributesSectionPanel.getLayout()).replace(this.reportedStatusLabel, label);
                        this.reportedStatusLabel = label;
                    }
                }
                String modifiedTxt = (modification = this.issue.getLastModifyDate()) != null ? DateFormat.getDateTimeInstance().format(modification) : "";
                this.modifiedField.setText(modifiedTxt);
                IssuePanel.fixPrefSize(this.modifiedField);
                this.privateNotesField.setText(this.issue.getPrivateNotes());
                this.dueDatePicker.setDate(this.issue.getDueDate());
                NbDateRange scheduleDate = this.issue.getScheduleDate();
                this.scheduleDatePicker.setScheduleDate(scheduleDate == null ? null : scheduleDate.toSchedulingInfo());
                this.estimateField.setValue(this.issue.getEstimate());
                this.dueDatePicker.getComponent().setEnabled(!hasTimeTracking);
                if (hasTimeTracking) {
                    BugzillaIssue.Comment[] comments;
                    this.reloadField(force, this.estimatedField, IssueField.ESTIMATED_TIME);
                    this.reloadField(force, this.workedField, IssueField.WORK_TIME);
                    this.reloadField(force, this.remainingField, IssueField.REMAINING_TIME);
                    this.reloadField(force, this.deadlinePicker, IssueField.DEADLINE);
                    String actualString = this.issue.getFieldValue(IssueField.ACTUAL_TIME);
                    if (actualString.trim().equals("")) {
                        actualString = "0";
                    }
                    this.actualField.setText(String.valueOf(Double.parseDouble(actualString) + this.getDoubleValue(this.remainingField)));
                    double worked = 0.0;
                    for (BugzillaIssue.Comment comment : comments = this.issue.getComments()) {
                        worked += comment.getWorked().doubleValue();
                    }
                    this.workedSumField.setText(String.valueOf(worked));
                    this.gainField.setText(String.valueOf(this.getDoubleValue(this.estimatedField) - this.getDoubleValue(this.remainingField)));
                    this.completeField.setText(String.valueOf((int)Math.floor(this.getDoubleValue(this.workedSumField) / this.getDoubleValue(this.actualField) * 100.0)));
                }
            }
            String assignee = this.issue.getFieldValue(IssueField.ASSIGNED_TO);
            String string = selectedAssignee = this.assignedField.getParent() == null ? this.assignedCombo.getSelectedItem().toString() : this.assignedField.getText();
            if (isKenaiRepository && assignee.trim().length() > 0 && (force || !selectedAssignee.equals(assignee))) {
                int index = assignee.indexOf(64);
                String userName = index == -1 ? assignee : assignee.substring(0, index);
                String host = ((KenaiRepository)this.issue.getRepository()).getHost();
                JLabel label = TeamAccessorUtils.createUserWidget((String)this.issue.getRepository().getUrl(), (String)userName, (String)host, (String)TeamAccessorUtils.getChatLink((String)this.issue.getID()));
                if (label != null) {
                    label.setText(null);
                    ((GroupLayout)this.attributesSectionPanel.getLayout()).replace(this.assignedToStatusLabel, label);
                    label.setVisible(this.assignedToStatusLabel.isVisible());
                    this.assignedToStatusLabel = label;
                }
            }
            if (force) {
                this.assignedToStatusLabel.setVisible(assignee.trim().length() > 0);
            }
            if (this.assignedField.getParent() == null) {
                this.reloadField(force, this.assignedCombo, IssueField.ASSIGNED_TO);
            } else {
                this.reloadField(force, this.assignedField, IssueField.ASSIGNED_TO);
            }
            this.reloadField(force, this.qaContactField, IssueField.QA_CONTACT);
            this.reloadField(force, this.ccField, IssueField.CC);
            this.reloadField(force, this.dependsField, IssueField.DEPENDS_ON);
            this.reloadField(force, this.blocksField, IssueField.BLOCKS);
            if (!this.customFieldsLoaded) {
                this.customFieldsLoaded = true;
                this.initCustomFields();
            }
            this.reloadCustomFields(force);
        }
        int newCommentCount = this.issue.getComments().length;
        if (!force) {
            if (this.oldCommentCount != newCommentCount) {
                String message = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.commentAddedWarning");
                this.fieldsIncoming.put(IssueField.COMMENT_COUNT, message);
            } else {
                this.fieldsIncoming.remove(IssueField.COMMENT_COUNT);
            }
        }
        this.oldCommentCount = newCommentCount;
        List<BugzillaIssue.Attachment> attachments = this.issue.getAttachments();
        List<AttachmentsPanel.AttachmentInfo> unsubmitted = this.issue.getUnsubmittedAttachments();
        if (!isNew) {
            this.commentsPanel.setIssue(this.issue, attachments);
            this.commentsSection.setLabel(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.commentsLabel.text", (Object)(this.issue.getComments().length + 1)));
        }
        if (isNetbeans) {
            AttachmentsPanel.NBBugzillaCallback callback = new AttachmentsPanel.NBBugzillaCallback(){

                public String getLogFilePath() {
                    return "var/log/messages.log";
                }

                public String getLogFileContentType() {
                    return "text/plain";
                }

                public String getLogFileDescription() {
                    return Bundle.MSG_LOG_FILE_DESC();
                }

                public void showLogFile() {
                    IssuePanel.showLogFile(null);
                }
            };
            this.attachmentsPanel.setAttachments(attachments, unsubmitted, callback);
        } else {
            this.attachmentsPanel.setAttachments(attachments, unsubmitted, null);
        }
        this.attachmentsSection.setLabel(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.attachmentsLabel.text", (Object)attachments.size()));
        UIUtils.keepFocusedComponentVisible((Component)this.commentsPanel, (JComponent)this);
        UIUtils.keepFocusedComponentVisible((Component)this.attachmentsPanel, (JComponent)this);
        this.updateFieldStatuses();
        this.updateNoSummary();
        this.updateMessagePanel();
        this.cancelButton.setEnabled(this.issue.hasLocalEdits() || !this.unsavedFields.isEmpty());
        this.reloading = false;
        this.repaint();
    }

    private void reloadCustomFields(boolean force) {
        for (CustomFieldInfo field : this.customFields) {
            this.reloadField(force, field.comp, field.field);
        }
    }

    private static void fixPrefSize(JTextField textField) {
        textField.setPreferredSize(null);
        Dimension dim = textField.getPreferredSize();
        Dimension fixedDim = new Dimension(dim.width + 1, dim.height);
        textField.setPreferredSize(fixedDim);
    }

    private void reloadField(boolean force, Object component, IssueField field) {
        this.reloadField(component, field);
    }

    private void reloadField(Object component, IssueField field) {
        block4: {
            String newValue;
            block8: {
                block7: {
                    block6: {
                        block5: {
                            newValue = component instanceof JList ? this.mergeValues(this.issue.getFieldValues(field)) : this.issue.getFieldValue(field);
                            boolean fieldDirty = this.unsavedFields.contains(field.getKey());
                            if (fieldDirty) break block4;
                            if (!(component instanceof JComboBox)) break block5;
                            JComboBox combo = (JComboBox)component;
                            this.selectInCombo(combo, newValue, true);
                            break block4;
                        }
                        if (!(component instanceof JTextComponent)) break block6;
                        ((JTextComponent)component).setText(newValue);
                        break block4;
                    }
                    if (!(component instanceof JList)) break block7;
                    JList list = (JList)component;
                    list.clearSelection();
                    ListModel model = list.getModel();
                    for (String value : this.issue.getFieldValues(field)) {
                        for (int i = 0; i < model.getSize(); ++i) {
                            if (!value.equals(model.getElementAt(i))) continue;
                            list.addSelectionInterval(i, i);
                        }
                    }
                    break block4;
                }
                if (!(component instanceof JCheckBox)) break block8;
                ((JCheckBox)component).setSelected("1".equals(newValue));
                break block4;
            }
            if (!(component instanceof IDEServices.DatePickerComponent)) break block4;
            IDEServices.DatePickerComponent picker = (IDEServices.DatePickerComponent)component;
            try {
                picker.setDate(BugzillaIssue.DUE_DATE_FORMAT.parse(newValue));
            }
            catch (ParseException ex) {
                picker.setDate(null);
            }
        }
    }

    private void updateFieldDecorations(Object component, IssueField field, JLabel warningLabel, JComponent fieldLabel) {
        this.updateFieldDecorations(warningLabel, fieldLabel, this.fieldName(fieldLabel), Pair.of((Object)field, (Object)component));
    }

    private void updateFieldDecorations(JLabel warningLabel, JComponent fieldLabel, Pair<IssueField, ? extends Object> ... fields) {
        this.updateFieldDecorations(warningLabel, fieldLabel, this.fieldName(fieldLabel), fields);
    }

    private void updateFieldDecorations(JLabel warningLabel, JComponent fieldLabel, String fieldName, Pair<IssueField, ? extends Object> ... fields) {
        boolean isNew = this.issue.isNew();
        String newValue = "";
        String lastSeenValue = "";
        String repositoryValue = "";
        boolean fieldDirty = false;
        boolean valueModifiedByUser = false;
        boolean valueModifiedByServer = false;
        for (Pair<IssueField, ? extends Object> p : fields) {
            Object component = p.second();
            IssueField field = (IssueField)p.first();
            if (component instanceof JList) {
                newValue = newValue + " " + this.mergeValues(this.issue.getFieldValues(field));
                lastSeenValue = lastSeenValue + " " + this.mergeValues(this.issue.getLastSeenFieldValues(field));
                repositoryValue = repositoryValue + " " + this.mergeValues(this.issue.getRepositoryFieldValues(field));
            } else {
                newValue = newValue + " " + this.issue.getFieldValue(field);
                lastSeenValue = lastSeenValue + " " + this.issue.getLastSeenFieldValue(field);
                repositoryValue = repositoryValue + " " + this.issue.getRepositoryFieldValue(field);
            }
            fieldDirty |= this.unsavedFields.contains(field.getKey());
            valueModifiedByUser |= (this.issue.getFieldStatus(field) & 4) != 0;
            valueModifiedByServer |= (this.issue.getFieldStatus(field) & 2) != 0;
        }
        newValue = newValue.substring(1);
        lastSeenValue = lastSeenValue.substring(1);
        repositoryValue = repositoryValue.substring(1);
        if (warningLabel != null) {
            boolean change = false;
            if (!isNew) {
                String message;
                boolean visible = warningLabel.isVisible();
                IssueField field = (IssueField)fields[0].first();
                this.removeTooltips(warningLabel, field);
                if (fieldLabel != null && fieldLabel.getFont().isBold()) {
                    fieldLabel.setFont(fieldLabel.getFont().deriveFont(fieldLabel.getFont().getStyle() & 0xFFFFFFFE));
                }
                if (visible && valueModifiedByServer && (valueModifiedByUser || fieldDirty) && !newValue.equals(repositoryValue)) {
                    message = Bundle.IssuePanel_fieldModifiedConflict(fieldName, lastSeenValue, repositoryValue);
                    change = this.fieldsLocal.remove(field) != null | this.fieldsIncoming.remove(field) != null | !message.equals(this.fieldsConflict.put(field, message));
                    this.tooltipsConflict.addTooltip(warningLabel, field, Bundle.IssuePanel_fieldModifiedConflictTT(fieldName, lastSeenValue, repositoryValue, newValue, IssuePanel.ICON_CONFLICT_PATH));
                } else if (visible && valueModifiedByServer) {
                    message = Bundle.IssuePanel_fieldModifiedRemotely(fieldName, lastSeenValue, repositoryValue);
                    change = this.fieldsLocal.remove(field) != null | this.fieldsConflict.remove(field) != null | !message.equals(this.fieldsIncoming.put(field, message));
                    this.tooltipsIncoming.addTooltip(warningLabel, field, Bundle.IssuePanel_fieldModifiedRemotelyTT(fieldName, lastSeenValue, repositoryValue, IssuePanel.ICON_REMOTE_PATH));
                } else if (visible && (valueModifiedByUser || fieldDirty) && !newValue.equals(lastSeenValue)) {
                    if (field == IssueField.COMMENT) {
                        message = Bundle.IssuePanel_commentAddedLocally();
                        this.tooltipsLocal.addTooltip(warningLabel, field, Bundle.IssuePanel_commentAddedLocallyTT(IssuePanel.ICON_UNSUBMITTED_PATH));
                    } else {
                        message = Bundle.IssuePanel_fieldModifiedLocally(fieldName, lastSeenValue, newValue);
                        this.tooltipsLocal.addTooltip(warningLabel, field, Bundle.IssuePanel_fieldModifiedLocallyTT(fieldName, lastSeenValue, newValue, IssuePanel.ICON_UNSUBMITTED_PATH));
                    }
                    change = this.fieldsConflict.remove(field) != null | this.fieldsIncoming.remove(field) != null | !message.equals(this.fieldsLocal.put(field, message));
                } else {
                    change = this.fieldsLocal.remove(field) != null | this.fieldsConflict.remove(field) != null | this.fieldsIncoming.remove(field) != null;
                }
                this.updateIcon(warningLabel);
                if (fieldDirty && fieldLabel != null) {
                    fieldLabel.setFont(fieldLabel.getFont().deriveFont(fieldLabel.getFont().getStyle() | 1));
                }
            }
            if (change && !this.reloading) {
                this.updateMessagePanel();
            }
        }
    }

    private void updateAttachmentsStatus() {
        boolean change = false;
        if (!this.issue.isNew()) {
            boolean valueModifiedByUser = !this.issue.getUnsubmittedAttachments().isEmpty();
            this.removeTooltips(this.attachmentsWarning, IssueField.NB_NEW_ATTACHMENTS);
            AbstractButton attachmentsLabel = this.attachmentsSection.getLabelComponent();
            if (attachmentsLabel.getFont().isBold()) {
                attachmentsLabel.setFont(attachmentsLabel.getFont().deriveFont(attachmentsLabel.getFont().getStyle() & 0xFFFFFFFE));
            }
            if (valueModifiedByUser) {
                String message = Bundle.IssuePanel_attachmentsAddedLocally();
                this.tooltipsLocal.addTooltip(this.attachmentsWarning, IssueField.NB_NEW_ATTACHMENTS, Bundle.IssuePanel_attachmentsToSubmit(IssuePanel.ICON_UNSUBMITTED_PATH));
                change = !message.equals(this.fieldsLocal.put(IssueField.NB_NEW_ATTACHMENTS, message));
            } else {
                change = this.fieldsLocal.remove(IssueField.NB_NEW_ATTACHMENTS) != null;
            }
            this.updateIcon(this.attachmentsWarning);
            if (this.unsavedFields.contains(IssueField.NB_NEW_ATTACHMENTS.getKey())) {
                attachmentsLabel.setFont(attachmentsLabel.getFont().deriveFont(attachmentsLabel.getFont().getStyle() | 1));
            }
        }
        if (change && !this.reloading) {
            this.updateMessagePanel();
        }
    }

    private void updateFieldDecorations(String key, JComponent fieldLabel) {
        boolean fieldDirty = this.unsavedFields.contains(key);
        if (fieldLabel != null) {
            if (fieldDirty) {
                fieldLabel.setFont(fieldLabel.getFont().deriveFont(fieldLabel.getFont().getStyle() | 1));
            } else {
                fieldLabel.setFont(fieldLabel.getFont().deriveFont(fieldLabel.getFont().getStyle() & 0xFFFFFFFE));
            }
        }
    }

    private boolean selectInCombo(JComboBox combo, Object value, boolean forceInModel) {
        ComboBoxModel model;
        if (value == null) {
            return false;
        }
        if (!value.equals(combo.getSelectedItem())) {
            combo.setSelectedItem(value);
        }
        if (forceInModel && !value.equals("") && !value.equals(combo.getSelectedItem()) && (model = combo.getModel()) instanceof DefaultComboBoxModel) {
            ((DefaultComboBoxModel)model).insertElementAt(value, 0);
            combo.setSelectedIndex(0);
        }
        return value.equals(combo.getSelectedItem());
    }

    private String fieldName(JComponent fieldLabel) {
        String txt;
        assert (fieldLabel instanceof JLabel || fieldLabel instanceof AbstractButton);
        if (fieldLabel instanceof JLabel) {
            txt = ((JLabel)fieldLabel).getText().trim();
        } else if (fieldLabel instanceof AbstractButton) {
            txt = ((AbstractButton)fieldLabel).getText().trim();
        } else {
            return null;
        }
        if (txt.endsWith(":")) {
            txt = txt.substring(0, txt.length() - 1);
        }
        return txt;
    }

    private void initCombos() {
        BugzillaRepository repository = this.issue.getRepository();
        BugzillaConfiguration bc = repository.getConfiguration();
        if (bc == null || !bc.isValid()) {
            return;
        }
        this.productCombo.setModel(this.toComboModel(bc.getProducts()));
        this.platformCombo.setModel(this.toComboModel(bc.getPlatforms()));
        this.osCombo.setModel(this.toComboModel(bc.getOSs()));
        LinkedList<String> resolutions = new LinkedList<String>(bc.getResolutions());
        resolutions.remove("MOVED");
        this.resolutionCombo.setModel(this.toComboModel(resolutions));
        this.priorityCombo.setModel(this.toComboModel(bc.getPriorities()));
        this.priorityCombo.setRenderer(new PriorityRenderer());
        this.severityCombo.setModel(this.toComboModel(bc.getSeverities()));
        this.initAssignedCombo();
        if (BugzillaUtil.isNbRepository(repository)) {
            this.issueTypeCombo.setModel(this.toComboModel(bc.getIssueTypes()));
        }
    }

    private void initAssignedCombo() {
        this.assignedCombo.setRenderer(new RepositoryUserRenderer());
        RP.post(new Runnable(){

            @Override
            public void run() {
                BugzillaRepository repository = IssuePanel.this.issue.getRepository();
                final Collection<RepositoryUser> users = repository.getUsers();
                final DefaultComboBoxModel<RepositoryUser> assignedModel = new DefaultComboBoxModel<RepositoryUser>();
                for (RepositoryUser user : users) {
                    assignedModel.addElement(user);
                }
                EventQueue.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        IssuePanel.this.reloading = true;
                        try {
                            Object assignee;
                            Object object = assignee = IssuePanel.this.assignedField.getParent() == null ? IssuePanel.this.assignedCombo.getSelectedItem() : IssuePanel.this.assignedField.getText();
                            if (assignee == null) {
                                assignee = "";
                            }
                            IssuePanel.this.assignedCombo.setModel(assignedModel);
                            GroupLayout layout = (GroupLayout)IssuePanel.this.attributesSectionPanel.getLayout();
                            if (IssuePanel.this.assignedCombo.getParent() == null != users.isEmpty()) {
                                layout.replace(users.isEmpty() ? IssuePanel.this.assignedCombo : IssuePanel.this.assignedField, users.isEmpty() ? IssuePanel.this.assignedField : IssuePanel.this.assignedCombo);
                                IssuePanel.this.assignedLabel.setLabelFor(users.isEmpty() ? IssuePanel.this.assignedField : IssuePanel.this.assignedCombo);
                            }
                            if (IssuePanel.this.assignedField.getParent() == null) {
                                IssuePanel.this.assignedCombo.setSelectedItem(assignee);
                            } else {
                                IssuePanel.this.assignedField.setText(assignee.toString());
                            }
                        }
                        finally {
                            IssuePanel.this.reloading = false;
                        }
                    }
                });
            }
        });
    }

    private void initStatusCombo(String currentStatus) {
        String status;
        BugzillaRepository repository = this.issue.getRepository();
        BugzillaConfiguration bc = repository.getConfiguration();
        if (bc == null || !bc.isValid()) {
            return;
        }
        List<String> allStatuses = bc.getStatusValues();
        List<String> openStatuses = bc.getOpenStatusValues();
        LinkedList<String> statuses = new LinkedList<String>();
        boolean oldRepository = this.issue.getRepository().getConfiguration().getInstalledVersion().compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_2) < 0;
        String nev = "NEW";
        String unconfirmed = "UNCONFIRMED";
        String reopened = "REOPENED";
        String resolved = "RESOLVED";
        if (currentStatus != null) {
            currentStatus = currentStatus.trim();
        }
        if ((status = this.issue.getLastSeenFieldValue(IssueField.STATUS)).isEmpty()) {
            status = currentStatus;
        }
        if (openStatuses.contains(status)) {
            statuses.addAll(openStatuses);
            if (!unconfirmed.equals(status)) {
                statuses.remove(unconfirmed);
            }
            if (!reopened.equals(status)) {
                statuses.remove(reopened);
            }
            if (oldRepository && !nev.equals(status)) {
                statuses.remove(nev);
            }
            statuses.add(resolved);
        } else {
            if (allStatuses.contains(reopened)) {
                statuses.add(reopened);
            } else {
                statuses.addAll(openStatuses);
                statuses.remove(unconfirmed);
                if (oldRepository) {
                    statuses.remove(nev);
                }
            }
            if (resolved.equals(status)) {
                LinkedList<String> closedStatuses = new LinkedList<String>(allStatuses);
                closedStatuses.removeAll(openStatuses);
                statuses.addAll(closedStatuses);
            } else {
                if (!oldRepository) {
                    statuses.add(resolved);
                }
                if (allStatuses.contains(status)) {
                    if (!"".equals(status)) {
                        for (int i = allStatuses.indexOf(status); i < allStatuses.size(); ++i) {
                            String s = allStatuses.get(i);
                            if (openStatuses.contains(s)) continue;
                            statuses.add(s);
                        }
                    }
                } else {
                    Bugzilla.LOG.log(Level.WARNING, "status value {0} not between all statuses: {1}", new Object[]{status, allStatuses});
                }
            }
        }
        this.resolvedIndex = statuses.indexOf(resolved);
        this.statusCombo.setModel(this.toComboModel(statuses));
        this.statusCombo.setSelectedItem(currentStatus);
    }

    private ComboBoxModel toComboModel(List<String> items) {
        return new DefaultComboBoxModel<Object>(items.toArray());
    }

    private void updateFieldStatuses() {
        this.updateFieldStatus(this.summaryLabel, IssueField.SUMMARY);
        this.updateFieldDecorations(this.summaryField, IssueField.SUMMARY, this.summaryWarning, this.summaryLabel);
        this.updateFieldStatus(this.productLabel, IssueField.PRODUCT);
        this.updateFieldDecorations(this.productCombo.getParent() == null ? this.productField : this.productCombo, IssueField.PRODUCT, this.productWarning, this.productLabel);
        this.updateFieldStatus(this.componentLabel, IssueField.COMPONENT);
        this.updateFieldDecorations(this.componentCombo, IssueField.COMPONENT, this.componentWarning, this.componentLabel);
        this.updateFieldStatus(this.versionLabel, IssueField.VERSION);
        this.updateFieldDecorations(this.versionCombo, IssueField.VERSION, this.versionWarning, this.versionLabel);
        this.updateFieldStatus(this.platformLabel, IssueField.PLATFORM, IssueField.OS);
        this.updateFieldDecorations(this.platformWarning, (JComponent)this.platformLabel, Pair.of((Object)IssueField.PLATFORM, (Object)this.platformCombo), Pair.of((Object)IssueField.OS, (Object)this.osCombo));
        this.updateFieldStatus(this.statusLabel, IssueField.STATUS);
        this.updateFieldDecorations(this.statusCombo, IssueField.STATUS, this.statusWarning, this.statusLabel);
        this.updateFieldStatus(this.resolutionLabel, IssueField.RESOLUTION);
        this.updateFieldDecorations(this.resolutionCombo, IssueField.RESOLUTION, this.resolutionWarning, this.resolutionLabel);
        this.updateFieldStatus(this.duplicateLabel, IssueField.DUPLICATE_ID);
        this.updateFieldDecorations(this.duplicateWarning, (JComponent)this.duplicateLabel, Bundle.LBL_Duplicate_fieldName(), Pair.of((Object)IssueField.DUPLICATE_ID, (Object)this.duplicateField));
        if (BugzillaUtil.showIssueType(this.issue.getRepository())) {
            this.updateFieldStatus(this.priorityLabel, IssueField.PRIORITY, IssueField.ISSUE_TYPE);
            this.updateFieldDecorations(this.priorityWarning, (JComponent)this.priorityLabel, Pair.of((Object)IssueField.PRIORITY, (Object)this.priorityCombo), Pair.of((Object)IssueField.ISSUE_TYPE, (Object)this.issueTypeCombo));
        } else {
            this.updateFieldStatus(this.priorityLabel, IssueField.PRIORITY, IssueField.SEVERITY);
            this.updateFieldDecorations(this.priorityWarning, (JComponent)this.priorityLabel, Pair.of((Object)IssueField.PRIORITY, (Object)this.priorityCombo), Pair.of((Object)IssueField.SEVERITY, (Object)this.severityCombo));
        }
        this.updateFieldStatus(this.targetMilestoneLabel, IssueField.MILESTONE);
        this.updateFieldDecorations(this.targetMilestoneCombo, IssueField.MILESTONE, this.milestoneWarning, this.targetMilestoneLabel);
        this.updateFieldStatus((JComponent)this.urlLabel, IssueField.URL);
        this.updateFieldDecorations(this.urlField, IssueField.URL, this.urlWarning, (JComponent)this.urlLabel);
        this.updateFieldStatus(this.statusWhiteboardLabel, IssueField.WHITEBOARD);
        this.updateFieldDecorations(this.statusWhiteboardField, IssueField.WHITEBOARD, this.statusWhiteboardWarning, this.statusWhiteboardLabel);
        this.updateFieldStatus(this.keywordsLabel, IssueField.KEYWORDS);
        this.updateFieldDecorations(this.keywordsField, IssueField.KEYWORDS, this.keywordsWarning, this.keywordsLabel);
        this.updateFieldStatus(this.assignedLabel, IssueField.ASSIGNED_TO);
        if (this.assignedField.getParent() == null) {
            this.updateFieldDecorations(this.assignedCombo, IssueField.ASSIGNED_TO, this.assignedToWarning, this.assignedLabel);
        } else {
            this.updateFieldDecorations(this.assignedField, IssueField.ASSIGNED_TO, this.assignedToWarning, this.assignedLabel);
        }
        this.updateFieldStatus(this.qaContactLabel, IssueField.QA_CONTACT);
        this.updateFieldDecorations(this.qaContactField, IssueField.QA_CONTACT, this.qaContactWarning, this.qaContactLabel);
        this.updateFieldStatus(this.ccLabel, IssueField.CC);
        this.updateFieldDecorations(this.ccField, IssueField.CC, this.ccWarning, this.ccLabel);
        this.updateFieldStatus(this.dependsLabel, IssueField.DEPENDS_ON);
        this.updateFieldDecorations(this.dependsField, IssueField.DEPENDS_ON, this.dependsOnWarning, this.dependsLabel);
        this.updateFieldStatus(this.blocksLabel, IssueField.BLOCKS);
        this.updateFieldDecorations(this.blocksField, IssueField.BLOCKS, this.blocksWarning, this.blocksLabel);
        this.updateFieldStatus(this.timetrackingWarning, IssueField.ESTIMATED_TIME, IssueField.REMAINING_TIME, IssueField.WORK_TIME, IssueField.DEADLINE, IssueField.COMMENT);
        this.updateFieldDecorations(this.estimatedField, IssueField.ESTIMATED_TIME, this.timetrackingWarning, this.estimatedLabel);
        this.updateFieldDecorations(this.remainingField, IssueField.REMAINING_TIME, this.timetrackingWarning, this.remainingLabel);
        this.updateFieldDecorations(this.workedField, IssueField.WORK_TIME, this.timetrackingWarning, this.workedLabel);
        this.updateFieldDecorations(this.deadlinePicker, IssueField.DEADLINE, this.timetrackingWarning, this.deadlineLabel);
        this.updateFieldStatus(this.newCommentSection.getLabelComponent(), new IssueField[0]);
        this.updateFieldDecorations(this.addCommentArea, IssueField.COMMENT, this.commentWarning, this.newCommentSection.getLabelComponent());
        this.updateCustomFieldStatuses();
        this.updateAttachmentsStatus();
        this.updateFieldDecorations(ATTRIBUTE_PRIVATE_NOTES, this.notesLabel);
        this.updateFieldDecorations(ATTRIBUTE_DUE_DATE, this.dueDateLabel);
        this.updateFieldDecorations(ATTRIBUTE_SCHEDULE_DATE, this.scheduleDateLabel);
        this.updateFieldDecorations(ATTRIBUTE_ESTIMATE, this.estimateLabel);
        this.repaint();
    }

    private void updateCustomFieldStatuses() {
        for (CustomFieldInfo field : this.customFields) {
            this.updateFieldStatus(field.label, field.field);
            this.updateFieldDecorations(field.comp, field.field, field.warning, field.label);
        }
    }

    private void updateFieldStatus(JComponent label, IssueField ... fields) {
        label.setOpaque(false);
        for (IssueField field : fields) {
            boolean highlight;
            boolean bl = highlight = !this.issue.isNew() && (this.issue.getFieldStatus(field) & 2) != 0;
            if (!highlight) continue;
            label.setOpaque(true);
            label.setBackground(incomingChangesColor);
            break;
        }
    }

    private void cancelHighlight(JComponent label) {
        if (!this.reloading) {
            label.setOpaque(false);
            label.getParent().repaint();
        }
    }

    private void storeFieldValue(IssueField field, JComboBox combo) {
        Object value = combo.getSelectedItem();
        if (value != null) {
            this.storeFieldValue(field, value.toString());
        }
    }

    private void storeFieldValue(IssueField field, JTextComponent textComponent) {
        this.storeFieldValue(field, textComponent.getText());
    }

    private void storeFieldValue(IssueField field, JList list) {
        ArrayList<String> values = new ArrayList<String>();
        for (Object value : list.getSelectedValues()) {
            values.add(value.toString());
        }
        if (!this.issue.getFieldValues(field).equals(values)) {
            this.addUnsavedField(field.getKey());
            this.issue.setFieldValues(field, values);
        }
    }

    private void storeFieldValue(IssueField field, String value) {
        boolean changed = false;
        if (field == IssueField.STATUS) {
            changed = true;
            if (value.equals("CLOSED")) {
                this.issue.close();
                this.issue.setFieldValue(IssueField.RESOLUTION, this.resolutionField.getText());
            } else if (value.equals("VERIFIED")) {
                this.issue.verify();
                this.issue.setFieldValue(IssueField.RESOLUTION, this.resolutionField.getText());
            } else if (value.equals("REOPENED")) {
                this.issue.reopen();
                this.issue.setFieldValue(IssueField.RESOLUTION, "");
            } else if (value.equals("RESOLVED")) {
                this.issue.resolve(this.resolutionCombo.getSelectedItem().toString());
                this.addUnsavedField(IssueField.RESOLUTION.getKey());
                this.issue.setFieldValue(IssueField.RESOLUTION, this.resolutionCombo.getSelectedItem().toString());
            } else if (value.equals("ASSIGNED")) {
                this.issue.accept();
                this.issue.setFieldValue(IssueField.RESOLUTION, "");
            } else {
                this.issue.setFieldValue(IssueField.RESOLUTION, "");
                changed = false;
            }
        } else if (field == IssueField.RESOLUTION && "RESOLVED".equals(this.statusCombo.getSelectedItem())) {
            changed = true;
            if (value.equals("DUPLICATE")) {
                this.issue.duplicate(this.duplicateField.getText().trim());
                if (!this.duplicateField.getText().trim().equals(this.issue.getFieldValue(IssueField.DUPLICATE_ID))) {
                    this.addUnsavedField(IssueField.DUPLICATE_ID.getKey());
                    this.issue.setFieldValue(IssueField.DUPLICATE_ID, this.duplicateField.getText().trim());
                }
            } else {
                this.issue.resolve(value);
            }
        } else if (field == IssueField.DUPLICATE_ID && "RESOLVED".equals(this.statusCombo.getSelectedItem()) && "DUPLICATE".equals(this.resolutionCombo.getSelectedItem())) {
            this.issue.duplicate(value);
            this.addUnsavedField(field.getKey());
        } else if (field == IssueField.ASSIGNED_TO && !this.issue.isNew()) {
            this.issue.reassign(value);
            this.addUnsavedField(field.getKey());
        }
        if (changed || !this.issue.getFieldValue(field).equals(value)) {
            this.addUnsavedField(field.getKey());
            this.issue.setFieldValue(field, value);
        }
    }

    private void attachDocumentListeners() {
        this.urlField.getDocument().addDocumentListener(new CancelHighlightDocumentListener((JComponent)this.urlLabel));
        this.statusWhiteboardField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.statusWhiteboardLabel));
        this.keywordsField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.keywordsLabel));
        this.assignedField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.assignedLabel));
        this.qaContactField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.qaContactLabel));
        this.ccField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.ccLabel));
        this.blocksField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.blocksLabel));
        this.dependsField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.dependsLabel));
        CyclicDependencyDocumentListener cyclicDependencyListener = new CyclicDependencyDocumentListener();
        this.blocksField.getDocument().addDocumentListener(cyclicDependencyListener);
        this.dependsField.getDocument().addDocumentListener(cyclicDependencyListener);
        this.addCommentArea.getDocument().addDocumentListener(new RevalidatingListener());
        this.duplicateField.getDocument().addDocumentListener(new DuplicateListener());
    }

    private void attachHideStatusListener() {
        this.assignedField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!IssuePanel.this.reloading) {
                    IssuePanel.this.assignedToStatusLabel.setVisible(false);
                }
            }
        });
    }

    private void updateNoSummary() {
        if (this.summaryField.getText().trim().length() == 0) {
            if (!this.noSummary) {
                this.noSummary = true;
                this.updateMessagePanel();
            }
        } else if (this.noSummary) {
            this.noSummary = false;
            this.updateMessagePanel();
        }
    }

    private void updateInvalidKeyword() {
        boolean invalidFound = false;
        StringTokenizer st = new StringTokenizer(this.keywordsField.getText(), ", \t\n\r\f");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (this.keywords.contains(token.toUpperCase())) continue;
            invalidFound = true;
            break;
        }
        if (invalidFound != this.invalidKeyword) {
            this.invalidKeyword = invalidFound;
            this.updateMessagePanel();
        }
    }

    private void updateNoComponent() {
        boolean newNoComponent;
        boolean bl = newNoComponent = this.componentCombo.getSelectedItem() == null;
        if (this.noComponent != newNoComponent) {
            this.noComponent = newNoComponent;
            this.updateMessagePanel();
        }
    }

    private void updateNoVersion() {
        boolean newNoVersion;
        boolean bl = newNoVersion = this.versionCombo.getSelectedItem() == null;
        if (this.noVersion != newNoVersion) {
            this.noVersion = newNoVersion;
            this.updateMessagePanel();
        }
    }

    private void updateNoTargetMilestone() {
        boolean newNoTargetMilestone;
        boolean bl = newNoTargetMilestone = this.targetMilestoneCombo.getSelectedItem() == null;
        if (this.noTargetMilestione != newNoTargetMilestone) {
            this.noTargetMilestione = newNoTargetMilestone;
            this.updateMessagePanel();
        }
    }

    private void updateMessagePanel() {
        this.messagePanel.removeAll();
        if (this.noComponent) {
            this.addMessage("IssuePanel.noComponent");
        }
        if (this.noVersion) {
            this.addMessage("IssuePanel.noVersion");
        }
        if (this.noTargetMilestione) {
            this.addMessage("IssuePanel.noTargetMilestone");
        }
        if (this.noSummary) {
            JLabel noSummaryLabel = new JLabel();
            noSummaryLabel.setText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.noSummary"));
            String icon = this.issue.isNew() ? "org/netbeans/modules/bugzilla/resources/info.png" : "org/netbeans/modules/bugzilla/resources/error.gif";
            noSummaryLabel.setIcon(new ImageIcon(ImageUtilities.loadImage((String)icon)));
            this.messagePanel.add(noSummaryLabel);
        }
        if (this.cyclicDependency) {
            JLabel cyclicDependencyLabel = new JLabel();
            cyclicDependencyLabel.setText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.cyclicDependency"));
            cyclicDependencyLabel.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/bugzilla/resources/error.gif")));
            this.messagePanel.add(cyclicDependencyLabel);
        }
        if (this.invalidKeyword) {
            JLabel invalidKeywordLabel = new JLabel();
            invalidKeywordLabel.setText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.invalidKeyword"));
            invalidKeywordLabel.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/bugzilla/resources/error.gif")));
            this.messagePanel.add(invalidKeywordLabel);
        }
        if (this.noDuplicateId) {
            JLabel noDuplicateLabel = new JLabel();
            noDuplicateLabel.setText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.noDuplicateId"));
            noDuplicateLabel.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/bugzilla/resources/error.gif")));
            this.messagePanel.add(noDuplicateLabel);
        }
        if (this.noSummary || this.cyclicDependency || this.invalidKeyword || this.noComponent || this.noVersion || this.noTargetMilestione || this.noDuplicateId) {
            this.submitButton.setEnabled(false);
        } else {
            this.submitButton.setEnabled(true);
        }
        for (Pair p : new Pair[]{Pair.of(this.fieldsConflict, (Object)ICON_CONFLICT), Pair.of(this.fieldsIncoming, (Object)ICON_REMOTE), Pair.of(this.fieldsLocal, (Object)ICON_UNSUBMITTED)}) {
            for (Map.Entry e : ((Map)p.first()).entrySet()) {
                JLabel lbl = new JLabel((String)e.getValue());
                lbl.setIcon((Icon)p.second());
                this.messagePanel.add(lbl);
            }
        }
        if (this.noSummary || this.cyclicDependency || this.invalidKeyword || this.noComponent || this.noVersion || this.noTargetMilestione || this.noDuplicateId || this.fieldsConflict.size() + this.fieldsIncoming.size() + this.fieldsLocal.size() > 0) {
            this.messagePanel.setVisible(true);
            this.messagePanel.revalidate();
        } else {
            this.messagePanel.setVisible(false);
        }
    }

    void addMessage(String messageKey) {
        JLabel messageLabel = new JLabel();
        messageLabel.setText(NbBundle.getMessage(IssuePanel.class, (String)messageKey));
        String icon = this.issue.isNew() ? "org/netbeans/modules/bugzilla/resources/info.png" : "org/netbeans/modules/bugzilla/resources/error.gif";
        messageLabel.setIcon(new ImageIcon(ImageUtilities.loadImage((String)icon)));
        this.messagePanel.add(messageLabel);
    }

    private void enableComponents(boolean enable) {
        this.enableComponents(this, enable);
        if (enable) {
            this.enableMap.clear();
        }
    }

    private void enableComponents(Component comp, boolean enable) {
        if (comp instanceof Container) {
            for (Component subComp : ((Container)comp).getComponents()) {
                this.enableComponents(subComp, enable);
            }
        }
        if (comp instanceof JComboBox || comp instanceof JTextComponent && ((JTextComponent)comp).isEditable() || comp instanceof AbstractButton || comp instanceof JList) {
            if (enable) {
                Boolean b = this.enableMap.get(comp);
                if (b != null) {
                    comp.setEnabled(b);
                }
            } else {
                this.enableMap.put(comp, comp.isEnabled());
                comp.setEnabled(false);
            }
        }
    }

    private void initSpellChecker() {
        Spellchecker.register((JTextComponent)this.summaryField);
        Spellchecker.register((JTextComponent)this.addCommentArea);
        Spellchecker.register((JTextComponent)this.privateNotesField);
    }

    private void initCustomFields() {
        this.customFields.clear();
        this.customFieldsPanelLeft.removeAll();
        this.customFieldsPanelRight.removeAll();
        GroupLayout labelLayout = new GroupLayout(this.customFieldsPanelLeft);
        this.customFieldsPanelLeft.setLayout(labelLayout);
        GroupLayout fieldLayout = new GroupLayout(this.customFieldsPanelRight);
        this.customFieldsPanelRight.setLayout(fieldLayout);
        GroupLayout.ParallelGroup labelHorizontalGroup = labelLayout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.SequentialGroup labelVerticalGroup = labelLayout.createSequentialGroup();
        GroupLayout.ParallelGroup fieldHorizontalGroup = fieldLayout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.SequentialGroup fieldVerticalGroup = fieldLayout.createSequentialGroup();
        boolean nbRepository = BugzillaUtil.isNbRepository(this.issue.getRepository());
        boolean newIssue = this.issue.isNew();
        boolean anyField = false;
        block7: for (IssueField field : this.issue.getRepository().getConfiguration().getFields()) {
            Object editor;
            Object comp;
            if (!(field instanceof CustomIssueField)) continue;
            CustomIssueField cField = (CustomIssueField)field;
            if (nbRepository && cField.getKey().equals(IssueField.ISSUE_TYPE.getKey()) || newIssue && !cField.getShowOnBugCreation() || this.isNbExceptionReport(field) && (newIssue || "".equals(this.issue.getFieldValue(field).trim()))) continue;
            JLabel label = new JLabel(cField.getDisplayName() + ":");
            boolean rigid = false;
            switch (cField.getType()) {
                case LargeText: {
                    JScrollPane scrollPane = new JScrollPane();
                    JTextArea textArea = new JTextArea();
                    textArea.setRows(5);
                    scrollPane.setViewportView(textArea);
                    comp = scrollPane;
                    editor = textArea;
                    label.setVerticalAlignment(1);
                    UIUtils.fixFocusTraversalKeys((JComponent)textArea);
                    UIUtils.issue163946Hack((JScrollPane)scrollPane);
                    break;
                }
                case FreeText: {
                    if (this.isNbExceptionReport(field)) {
                        final String val = this.issue.getFieldValue(field);
                        LinkButton lb = new LinkButton(val);
                        lb.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                try {
                                    URL url = new URL("http://statistics.netbeans.org/exceptions/detail.do?id=" + val);
                                    HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                                }
                                catch (MalformedURLException muex) {
                                    Bugzilla.LOG.log(Level.INFO, "Unable to show the exception report in the browser.", muex);
                                }
                            }
                        });
                        editor = lb;
                        comp = editor;
                        break;
                    }
                    editor = new JTextField();
                    comp = editor;
                    break;
                }
                case MultipleSelection: {
                    JList<Object> list = new JList<Object>();
                    DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(cField.getOptions().toArray());
                    list.setModel(model);
                    if (model.getSize() < list.getVisibleRowCount()) {
                        list.setVisibleRowCount(model.getSize());
                    }
                    JScrollPane scrollPane = new JScrollPane();
                    scrollPane.setViewportView(list);
                    comp = scrollPane;
                    editor = list;
                    label.setVerticalAlignment(1);
                    rigid = true;
                    UIUtils.issue163946Hack((JScrollPane)scrollPane);
                    break;
                }
                case DropDown: {
                    editor = new JComboBox();
                    comp = editor;
                    DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(cField.getOptions().toArray());
                    ((JComboBox)comp).setModel(model);
                    rigid = true;
                    break;
                }
                case DateTime: {
                    editor = new JTextField();
                    comp = editor;
                    break;
                }
                default: {
                    Bugzilla.LOG.log(Level.INFO, "Custom field type {0} is not supported!", (Object)cField.getType());
                    continue block7;
                }
            }
            JLabel warning = new JLabel();
            warning.setMinimumSize(new Dimension(16, 16));
            warning.setPreferredSize(new Dimension(16, 16));
            warning.setMaximumSize(new Dimension(16, 16));
            this.customFields.add(new CustomFieldInfo(cField, label, (JComponent)editor, warning));
            label.setLabelFor((Component)editor);
            label.setPreferredSize(new Dimension(label.getPreferredSize().width, ((JComponent)comp).getPreferredSize().height));
            label.setMinimumSize(new Dimension(label.getMinimumSize().width, ((JComponent)comp).getPreferredSize().height));
            if (anyField) {
                labelVerticalGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
                fieldVerticalGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
            }
            GroupLayout.SequentialGroup sGroup = labelLayout.createSequentialGroup();
            sGroup.addComponent(warning);
            sGroup.addGap(5);
            sGroup.addComponent(label);
            labelHorizontalGroup.addGroup(sGroup);
            GroupLayout.ParallelGroup pGroup = labelLayout.createParallelGroup(GroupLayout.Alignment.LEADING);
            pGroup.addComponent(warning);
            pGroup.addComponent(label);
            labelVerticalGroup.addGroup(pGroup);
            if (rigid) {
                fieldHorizontalGroup.addComponent((Component)comp, -2, -1, -2);
            } else {
                fieldHorizontalGroup.addComponent((Component)comp);
            }
            fieldVerticalGroup.addComponent((Component)comp, -2, -1, -2);
            anyField = true;
        }
        labelLayout.setHorizontalGroup(labelHorizontalGroup);
        labelLayout.setVerticalGroup(labelVerticalGroup);
        fieldLayout.setHorizontalGroup(fieldHorizontalGroup);
        fieldLayout.setVerticalGroup(fieldVerticalGroup);
        this.customFieldsPanelLeft.setVisible(anyField);
        this.customFieldsPanelRight.setVisible(anyField);
        this.dummyLabel3.setVisible(anyField);
        this.setupCustomFieldsListeners();
    }

    private boolean isNbExceptionReport(IssueField field) {
        return field.getKey().equals("cf_autoreporter_id");
    }

    private void initComponents() {
        this.productField = new JTextField();
        this.resolutionCombo = new JComboBox();
        this.assignedCombo = new JComboBox();
        this.timetrackingPanel = new JPanel();
        this.estimatedLabel = new JLabel();
        this.estimatedField = new JTextField();
        this.estimatedWarning = new JLabel();
        this.actualLabel = new JLabel();
        this.workedLabel = new JLabel();
        this.workedField = new JTextField();
        this.workedWarning = new JLabel();
        this.remainingField = new JTextField();
        this.remainingLabel = new JLabel();
        this.remainingWarning = new JLabel();
        this.completeLabel = new JLabel();
        this.workedSumField = new JLabel();
        this.jLabel7 = new JLabel();
        this.actualField = new JTextField();
        this.completeField = new JTextField();
        this.gainLabel = new JLabel();
        this.gainField = new JTextField();
        this.deadlineLabel = new JLabel();
        this.dummyDeadlineField = new JTextField();
        this.actualWarning = new JLabel();
        this.deadlineWarning = new JLabel();
        this.completeWarning = new JLabel();
        this.gainWarning = new JLabel();
        this.attributesSectionPanel = new JPanel();
        this.duplicateWarning = new JLabel();
        this.reportedLabel = new JLabel();
        this.osCombo = new JComboBox();
        this.blocksWarning = new JLabel();
        this.dependsOnButton = new JButton();
        this.componentCombo = new JComboBox();
        this.qaContactField = new JTextField();
        this.blocksLabel = new JLabel();
        this.customFieldsPanelLeft = new JPanel();
        this.versionLabel = new JLabel();
        this.statusWhiteboardLabel = new JLabel();
        this.platformWarning = new JLabel();
        this.statusWarning = new JLabel();
        this.urlLabel = new LinkButton();
        this.priorityLabel = new JLabel();
        this.modifiedField = new JTextField();
        this.targetMilestoneLabel = new JLabel();
        this.summaryWarning = new JLabel();
        this.productLabel = new JLabel();
        this.assignedToWarning = new JLabel();
        this.issueTypeWarning = new JLabel();
        this.issueTypeLabel = new JLabel();
        this.statusLabel = new JLabel();
        this.dependsLabel = new JLabel();
        this.ccWarning = new JLabel();
        this.platformLabel = new JLabel();
        this.keywordsLabel = new JLabel();
        this.componentLabel = new JLabel();
        this.assignedLabel = new JLabel();
        this.duplicateField = new JTextField();
        this.priorityCombo = new JComboBox();
        this.resolutionWarning = new JLabel();
        this.issueTypeCombo = new JComboBox();
        this.productWarning = new JLabel();
        this.summaryField = new JTextField();
        this.assignedField = new JTextField();
        this.dummyTimetrackingPanel = new JPanel();
        this.summaryLabel = new JLabel();
        this.assignedToStatusLabel = new JLabel();
        this.blocksButton = new JButton();
        this.duplicateButton = new JButton();
        this.milestoneWarning = new JLabel();
        this.dummyLabel2 = new JLabel();
        this.assignToDefaultCheckBox = new JCheckBox();
        this.modifiedLabel = new JLabel();
        this.urlField = new JTextField();
        this.customFieldsPanelRight = new JPanel();
        this.ccLabel = new JLabel();
        this.ccField = new JTextField();
        this.blocksField = new JTextField();
        this.dependsField = new JTextField();
        this.productCombo = new JComboBox();
        this.componentWarning = new JLabel();
        this.versionCombo = new JComboBox();
        this.dummyLabel1 = new JLabel();
        this.dummyLabel3 = new JLabel();
        this.timetrackingLabel = new JLabel();
        this.dependsOnWarning = new JLabel();
        this.platformCombo = new JComboBox();
        this.severityCombo = new JComboBox();
        this.resolutionLabel = new JLabel();
        this.resolutionField = new JTextField();
        this.targetMilestoneCombo = new JComboBox();
        this.statusWhiteboardField = new JTextField();
        this.priorityWarning = new JLabel();
        this.statusWhiteboardWarning = new JLabel();
        this.reportedField = new JTextField();
        this.urlWarning = new JLabel();
        this.timetrackingWarning = new JLabel();
        this.statusCombo = new JComboBox();
        this.keywordsField = new JTextField();
        this.reportedStatusLabel = new JLabel();
        this.dummyTimetrackingLabel = new JLabel();
        this.qaContactLabel = new JLabel();
        this.versionWarning = new JLabel();
        this.duplicateLabel = new JLabel();
        this.keywordsButton = new JButton();
        this.keywordsWarning = new JLabel();
        this.qaContactWarning = new JLabel();
        this.attachmentsSectionPanel = new JPanel();
        this.attachmentsWarning = new JLabel();
        this.dummyAttachmentsPanel = new JPanel();
        this.commentsSectionPanel = new JPanel();
        this.dummyCommentsPanel = new JPanel();
        this.newCommentSectionPanel = new JPanel();
        this.scrollPane1 = new JScrollPane();
        this.addCommentArea = new JTextArea(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension dim = super.getPreferredScrollableViewportSize();
                JScrollPane scrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
                int delta = 0;
                if (scrollPane != null) {
                    JScrollBar comp = scrollPane.getHorizontalScrollBar();
                    delta = comp.isVisible() ? ((Component)comp).getHeight() : 0;
                }
                Insets insets = this.getInsets();
                int prefHeight = 5 * this.getRowHeight() + insets.top + insets.bottom;
                dim = new Dimension(0, delta + (dim.height < prefHeight ? prefHeight : dim.height));
                return dim;
            }
        };
        this.attachLogCheckBox = new JCheckBox();
        this.viewLogButton = new LinkButton();
        this.commentWarning = new JLabel();
        this.messagePanel = new JPanel();
        this.privatePanel = new JPanel();
        this.dueDateLabel = new JLabel();
        this.dummyDueDateField = new JTextField();
        this.scheduleDateLabel = new JLabel();
        this.dummyScheduleDateField = new JTextField();
        this.estimateLabel = new JLabel();
        this.estimateField = new JFormattedTextField();
        this.notesLabel = new JLabel();
        this.privateNotesScrollPane = new JScrollPane();
        this.privateNotesField = new JTextArea(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension dim = super.getPreferredScrollableViewportSize();
                JScrollPane scrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
                int delta = 0;
                if (scrollPane != null) {
                    JScrollBar comp = scrollPane.getHorizontalScrollBar();
                    delta = comp.isVisible() ? ((Component)comp).getHeight() : 0;
                }
                Insets insets = this.getInsets();
                int prefHeight = 5 * this.getRowHeight() + insets.top + insets.bottom;
                dim = new Dimension(0, delta + (dim.height < prefHeight ? prefHeight : dim.height));
                return dim;
            }
        };
        this.headerPanel = new JPanel();
        this.headerField = new JTextField();
        this.buttonsPanel = new JPanel();
        this.separatorLabel4 = new JLabel();
        this.separatorLabel6 = new JLabel();
        this.separatorLabel3 = new JLabel();
        this.separatorDismissButton = new JLabel();
        this.refreshButton = new LinkButton();
        this.cancelButton = new LinkButton();
        this.showInBrowserButton = new LinkButton();
        this.submitButton = new LinkButton();
        this.btnDeleteTask = new LinkButton();
        this.mainScrollPane = new JScrollPane();
        this.mainPanel = new JPanel();
        this.attributesSection = new CollapsibleSectionPanel();
        this.attachmentsSection = new CollapsibleSectionPanel();
        this.newCommentSection = new SectionPanel();
        this.jPanel1 = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return this.getMinimumSize();
            }
        };
        this.commentsSection = new CollapsibleSectionPanel();
        this.privateSection = new CollapsibleSectionPanel();
        FormListener formListener = new FormListener();
        this.productField.setEditable(false);
        this.productField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.productField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.productField.AccessibleContext.accessibleDescription"));
        this.resolutionCombo.addActionListener(formListener);
        this.resolutionCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.resolutionCombo.AccessibleContext.accessibleDescription"));
        this.assignedCombo.setEditable(true);
        this.assignedCombo.addActionListener(formListener);
        this.timetrackingPanel.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        Mnemonics.setLocalizedText((JLabel)this.estimatedLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.estimatedLabel.text"));
        this.estimatedField.setText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.estimatedField.text"));
        Mnemonics.setLocalizedText((JLabel)this.actualLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.actualLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.workedLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.workedLabel.text"));
        this.workedField.setText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.workedField.text"));
        this.workedField.addFocusListener(formListener);
        this.remainingField.setText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.remainingField.text"));
        Mnemonics.setLocalizedText((JLabel)this.remainingLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.remainingLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.completeLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.completeLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.workedSumField, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.workedSumField.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.jLabel7.text"));
        this.actualField.setEditable(false);
        this.actualField.setText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.actualField.text"));
        this.completeField.setEditable(false);
        this.completeField.setText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.completeField.text"));
        Mnemonics.setLocalizedText((JLabel)this.gainLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.gainLabel.text"));
        this.gainField.setEditable(false);
        this.gainField.setText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.gainField.text"));
        Mnemonics.setLocalizedText((JLabel)this.deadlineLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.deadlineLabel.text"));
        GroupLayout timetrackingPanelLayout = new GroupLayout(this.timetrackingPanel);
        this.timetrackingPanel.setLayout(timetrackingPanelLayout);
        timetrackingPanelLayout.setHorizontalGroup(timetrackingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(timetrackingPanelLayout.createSequentialGroup().addGroup(timetrackingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.estimatedLabel).addComponent(this.estimatedField, -2, 80, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.estimatedWarning, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(timetrackingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.actualLabel).addComponent(this.actualField, -2, 80, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actualWarning, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(timetrackingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(timetrackingPanelLayout.createSequentialGroup().addComponent(this.workedSumField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.workedField, -2, 80, -2)).addComponent(this.workedLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.workedWarning, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(timetrackingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.remainingLabel).addGroup(timetrackingPanelLayout.createSequentialGroup().addComponent(this.remainingField, -2, 80, -2).addGap(6, 6, 6).addComponent(this.remainingWarning, -2, 16, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(timetrackingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.completeLabel).addComponent(this.completeField, -2, 80, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.completeWarning, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(timetrackingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(timetrackingPanelLayout.createSequentialGroup().addComponent(this.gainField, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.gainWarning, -2, 16, -2).addGap(9, 9, 9).addGroup(timetrackingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dummyDeadlineField, -2, -1, -2).addComponent(this.deadlineLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deadlineWarning, -2, 16, -2)).addComponent(this.gainLabel))));
        timetrackingPanelLayout.setVerticalGroup(timetrackingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(timetrackingPanelLayout.createSequentialGroup().addGroup(timetrackingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.completeLabel).addGroup(timetrackingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.actualLabel, GroupLayout.Alignment.TRAILING).addComponent(this.estimatedLabel).addComponent(this.remainingLabel)).addComponent(this.workedLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(timetrackingPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.actualWarning, -2, 16, -2).addComponent(this.remainingField, -2, -1, -2).addComponent(this.workedField, -2, -1, -2).addComponent(this.estimatedField, -2, -1, -2).addComponent(this.deadlineWarning, -2, 16, -2).addComponent(this.completeField, -2, -1, -2).addComponent(this.jLabel7).addComponent(this.actualField, -2, -1, -2).addComponent(this.estimatedWarning, -2, 16, -2).addComponent(this.remainingWarning, -2, 16, -2).addComponent(this.workedWarning, -2, 16, -2).addComponent(this.workedSumField).addComponent(this.completeWarning, -2, 16, -2))).addGroup(timetrackingPanelLayout.createSequentialGroup().addComponent(this.gainLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(timetrackingPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.gainField, -2, -1, -2).addComponent(this.gainWarning, -2, 16, -2))).addGroup(timetrackingPanelLayout.createSequentialGroup().addComponent(this.deadlineLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dummyDeadlineField, -2, -1, -2)));
        this.attributesSectionPanel.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        this.reportedLabel.setLabelFor(this.reportedField);
        Mnemonics.setLocalizedText((JLabel)this.reportedLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.reportedLabel.text"));
        this.osCombo.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.dependsOnButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.dependsOnButton.text"));
        this.dependsOnButton.setFocusPainted(false);
        this.dependsOnButton.setMargin(new Insets(0, 0, 0, 0));
        this.dependsOnButton.addActionListener(formListener);
        this.componentCombo.addActionListener(formListener);
        this.blocksLabel.setLabelFor(this.blocksField);
        Mnemonics.setLocalizedText((JLabel)this.blocksLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.blocksLabel.text"));
        this.versionLabel.setLabelFor(this.versionCombo);
        Mnemonics.setLocalizedText((JLabel)this.versionLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.versionLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.statusWhiteboardLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.statusWhiteboardLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.urlLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.urlLabel.text"));
        this.urlLabel.addActionListener((ActionListener)formListener);
        this.priorityLabel.setLabelFor(this.priorityCombo);
        Mnemonics.setLocalizedText((JLabel)this.priorityLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.priorityLabel.text"));
        this.modifiedField.setEditable(false);
        this.modifiedField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.targetMilestoneLabel.setLabelFor(this.targetMilestoneCombo);
        Mnemonics.setLocalizedText((JLabel)this.targetMilestoneLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.targetMilestoneLabel.text"));
        this.productLabel.setLabelFor(this.productCombo);
        Mnemonics.setLocalizedText((JLabel)this.productLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.productLabel.text"));
        this.issueTypeLabel.setLabelFor(this.issueTypeCombo);
        Mnemonics.setLocalizedText((JLabel)this.issueTypeLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.issueTypeLabel.text"));
        this.statusLabel.setLabelFor(this.statusCombo);
        Mnemonics.setLocalizedText((JLabel)this.statusLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.statusLabel.text"));
        this.dependsLabel.setLabelFor(this.dependsField);
        Mnemonics.setLocalizedText((JLabel)this.dependsLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.dependsLabel.text"));
        this.platformLabel.setLabelFor(this.platformCombo);
        Mnemonics.setLocalizedText((JLabel)this.platformLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.platformLabel.text"));
        this.keywordsLabel.setLabelFor(this.keywordsField);
        Mnemonics.setLocalizedText((JLabel)this.keywordsLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.keywordsLabel.text"));
        this.componentLabel.setLabelFor(this.componentCombo);
        Mnemonics.setLocalizedText((JLabel)this.componentLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.componentLabel.text"));
        this.assignedLabel.setLabelFor(this.assignedField);
        Mnemonics.setLocalizedText((JLabel)this.assignedLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.assignedLabel.text"));
        this.duplicateField.setColumns(15);
        this.priorityCombo.addActionListener(formListener);
        this.issueTypeCombo.addActionListener(formListener);
        this.summaryLabel.setLabelFor(this.summaryField);
        Mnemonics.setLocalizedText((JLabel)this.summaryLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.summaryLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.blocksButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.blocksButton.text"));
        this.blocksButton.setFocusPainted(false);
        this.blocksButton.setMargin(new Insets(0, 0, 0, 0));
        this.blocksButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.duplicateButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.duplicateButton.text"));
        this.duplicateButton.setFocusPainted(false);
        this.duplicateButton.setMargin(new Insets(0, 0, 0, 0));
        this.duplicateButton.addActionListener(formListener);
        this.assignToDefaultCheckBox.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        Mnemonics.setLocalizedText((AbstractButton)this.assignToDefaultCheckBox, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.assignToDefaultCheckBox.text"));
        this.modifiedLabel.setLabelFor(this.modifiedField);
        Mnemonics.setLocalizedText((JLabel)this.modifiedLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.modifiedLabel.text"));
        this.urlField.setColumns(15);
        this.ccLabel.setLabelFor(this.ccField);
        Mnemonics.setLocalizedText((JLabel)this.ccLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.ccLabel.text"));
        this.blocksField.setColumns(15);
        this.dependsField.setColumns(15);
        this.productCombo.addActionListener(formListener);
        this.versionCombo.addActionListener(formListener);
        Mnemonics.setLocalizedText((JLabel)this.timetrackingLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.timetrackingLabel.text"));
        this.platformCombo.addActionListener(formListener);
        this.severityCombo.addActionListener(formListener);
        Mnemonics.setLocalizedText((JLabel)this.resolutionLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.resolutionLabel.text"));
        this.resolutionField.setEditable(false);
        this.resolutionField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.targetMilestoneCombo.addActionListener(formListener);
        this.statusWhiteboardField.setColumns(15);
        this.reportedField.setEditable(false);
        this.reportedField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.statusCombo.addActionListener(formListener);
        this.keywordsField.setColumns(15);
        this.qaContactLabel.setLabelFor(this.qaContactField);
        Mnemonics.setLocalizedText((JLabel)this.qaContactLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.qaContactLabel.text"));
        this.duplicateLabel.setLabelFor(this.duplicateField);
        Mnemonics.setLocalizedText((JLabel)this.duplicateLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.duplicateLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.keywordsButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.keywordsButton.text"));
        this.keywordsButton.setFocusPainted(false);
        this.keywordsButton.setMargin(new Insets(0, 0, 0, 0));
        this.keywordsButton.addActionListener(formListener);
        GroupLayout attributesSectionPanelLayout = new GroupLayout(this.attributesSectionPanel);
        this.attributesSectionPanel.setLayout(attributesSectionPanelLayout);
        attributesSectionPanelLayout.setHorizontalGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(attributesSectionPanelLayout.createSequentialGroup().addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(attributesSectionPanelLayout.createSequentialGroup().addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusWhiteboardWarning, -2, 16, -2).addComponent(this.keywordsWarning, -2, 16, -2).addComponent(this.urlWarning, -2, 16, -2).addComponent(this.milestoneWarning, -2, 16, -2).addComponent(this.issueTypeWarning, -2, 16, -2).addComponent(this.versionWarning, -2, 16, -2).addComponent(this.componentWarning, -2, 16, -2).addComponent(this.productWarning, -2, 16, -2).addComponent(this.summaryWarning, -2, 16, -2).addComponent(this.timetrackingWarning, -2, 16, -2)).addGap(5, 5, 5).addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.keywordsLabel).addComponent(this.statusWhiteboardLabel).addComponent(this.timetrackingLabel).addComponent(this.summaryLabel).addComponent((Component)this.urlLabel, -2, -1, -2).addComponent(this.issueTypeLabel).addComponent(this.versionLabel).addComponent(this.componentLabel).addComponent(this.productLabel).addComponent(this.targetMilestoneLabel).addComponent(this.dummyLabel2, GroupLayout.Alignment.TRAILING))).addComponent(this.customFieldsPanelLeft, -2, -1, -2).addGroup(attributesSectionPanelLayout.createSequentialGroup().addComponent(this.platformWarning, -2, 16, -2).addGap(5, 5, 5).addComponent(this.platformLabel)).addGroup(attributesSectionPanelLayout.createSequentialGroup().addComponent(this.priorityWarning, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.priorityLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dummyTimetrackingPanel, -1, -1, Short.MAX_VALUE).addComponent(this.customFieldsPanelRight, -1, -1, Short.MAX_VALUE).addGroup(attributesSectionPanelLayout.createSequentialGroup().addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, attributesSectionPanelLayout.createSequentialGroup().addComponent(this.keywordsField, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.keywordsButton)).addComponent(this.urlField, -2, -1, -2).addComponent(this.targetMilestoneCombo, -2, -1, -2).addComponent(this.issueTypeCombo, -2, -1, -2).addComponent(this.versionCombo, -2, -1, -2).addComponent(this.componentCombo, -2, -1, -2).addComponent(this.productCombo, -2, -1, -2).addGroup(attributesSectionPanelLayout.createSequentialGroup().addComponent(this.platformCombo, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.osCombo, 0, -1, Short.MAX_VALUE)).addGroup(attributesSectionPanelLayout.createSequentialGroup().addComponent(this.priorityCombo, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.severityCombo, 0, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.assignedToWarning, -2, 16, -2).addComponent(this.qaContactWarning, -2, 16, -2).addComponent(this.ccWarning, -2, 16, -2).addComponent(this.statusWarning, -2, 16, -2).addComponent(this.resolutionWarning, -2, 16, -2).addComponent(this.duplicateWarning, -2, 16, -2).addComponent(this.dependsOnWarning, -2, 16, -2).addComponent(this.blocksWarning, -2, 16, -2)).addGap(5, 5, 5).addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(attributesSectionPanelLayout.createSequentialGroup().addComponent(this.reportedLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reportedField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reportedStatusLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.modifiedLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modifiedField, -2, -1, -2)).addGroup(attributesSectionPanelLayout.createSequentialGroup().addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.blocksLabel).addComponent(this.dependsLabel).addComponent(this.duplicateLabel).addComponent(this.resolutionLabel).addComponent(this.statusLabel).addComponent(this.ccLabel).addComponent(this.qaContactLabel).addComponent(this.assignedLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.ccField, -2, -1, -2).addComponent(this.assignedField, -2, -1, -2).addComponent(this.statusCombo, -2, -1, -2).addComponent(this.assignToDefaultCheckBox).addComponent(this.qaContactField, -2, -1, -2).addComponent(this.resolutionField, -2, -1, -2).addGroup(GroupLayout.Alignment.TRAILING, attributesSectionPanelLayout.createSequentialGroup().addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.blocksField, -2, 0, Short.MAX_VALUE).addComponent(this.dependsField, -2, 0, Short.MAX_VALUE).addComponent(this.duplicateField, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.duplicateButton, GroupLayout.Alignment.TRAILING).addComponent(this.dependsOnButton, GroupLayout.Alignment.TRAILING).addComponent(this.blocksButton, GroupLayout.Alignment.TRAILING)))).addGap(18, 18, Short.MAX_VALUE).addComponent(this.assignedToStatusLabel)))).addComponent(this.summaryField).addComponent(this.statusWhiteboardField))).addGroup(attributesSectionPanelLayout.createSequentialGroup().addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.dummyLabel1).addGroup(attributesSectionPanelLayout.createSequentialGroup().addComponent(this.dummyLabel3, -2, 176, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.dummyTimetrackingLabel))).addGap(300, 300, 300)));
        attributesSectionPanelLayout.linkSize(0, this.osCombo, this.platformCombo, this.priorityCombo, this.severityCombo);
        attributesSectionPanelLayout.linkSize(0, this.assignedField, this.ccField, this.componentCombo, this.issueTypeCombo, this.productCombo, this.qaContactField, this.resolutionField, this.statusCombo, this.targetMilestoneCombo, this.urlField, this.versionCombo);
        attributesSectionPanelLayout.setVerticalGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(attributesSectionPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(attributesSectionPanelLayout.createSequentialGroup().addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.reportedField, -2, -1, -2).addComponent(this.reportedStatusLabel).addComponent(this.modifiedField, -2, -1, -2).addComponent(this.modifiedLabel).addComponent(this.productWarning, -2, 16, -2).addComponent(this.productLabel).addComponent(this.productCombo, -2, -1, -2).addComponent(this.reportedLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.componentWarning, -2, 16, -2).addComponent(this.componentLabel).addComponent(this.componentCombo, -2, -1, -2).addComponent(this.assignedToWarning, -2, 16, -2).addComponent(this.assignedLabel).addComponent(this.assignedField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.versionWarning, -2, 16, -2).addComponent(this.versionLabel).addComponent(this.versionCombo, -2, -1, -2).addComponent(this.assignToDefaultCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.platformWarning, -2, 16, -2).addComponent(this.platformLabel).addComponent(this.platformCombo, -2, -1, -2).addComponent(this.osCombo, -2, -1, -2).addComponent(this.qaContactWarning, -2, 16, -2).addComponent(this.qaContactLabel).addComponent(this.qaContactField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.issueTypeWarning, -2, 16, -2).addComponent(this.issueTypeLabel).addComponent(this.issueTypeCombo, -2, -1, -2).addComponent(this.ccWarning, -2, 16, -2).addComponent(this.ccLabel).addComponent(this.ccField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dummyLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.priorityLabel).addComponent(this.priorityWarning, -2, 16, -2).addComponent(this.priorityCombo, -2, -1, -2).addComponent(this.severityCombo, -2, -1, -2).addComponent(this.statusLabel).addComponent(this.statusWarning, -2, 16, -2).addComponent(this.statusCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.milestoneWarning, -2, 16, -2).addComponent(this.targetMilestoneLabel).addComponent(this.targetMilestoneCombo, -2, -1, -2).addComponent(this.resolutionWarning, -2, 16, -2).addComponent(this.resolutionLabel).addComponent(this.resolutionField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.duplicateWarning, -2, 16, -2).addComponent(this.duplicateLabel).addComponent(this.duplicateField, -2, -1, -2).addComponent(this.duplicateButton).addComponent(this.dummyLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.urlWarning, -2, 16, -2).addComponent((Component)this.urlLabel, -2, -1, -2).addComponent(this.urlField, -2, -1, -2).addComponent(this.dependsOnWarning, -2, 16, -2).addComponent(this.dependsLabel).addComponent(this.dependsField, -2, -1, -2).addComponent(this.dependsOnButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.keywordsWarning, -2, 16, -2).addComponent(this.keywordsLabel).addComponent(this.keywordsField, -2, -1, -2).addComponent(this.keywordsButton).addComponent(this.blocksLabel).addComponent(this.blocksWarning, -2, 16, -2).addComponent(this.blocksField, -2, -1, -2).addComponent(this.blocksButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.statusWhiteboardWarning, -2, 16, -2).addComponent(this.statusWhiteboardLabel).addComponent(this.statusWhiteboardField, -2, -1, -2))).addGroup(attributesSectionPanelLayout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.assignedToStatusLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.timetrackingWarning, -2, 16, -2).addComponent(this.timetrackingLabel)).addComponent(this.dummyTimetrackingPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dummyTimetrackingLabel).addComponent(this.dummyLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.customFieldsPanelRight, -2, -1, -2).addComponent(this.customFieldsPanelLeft, -2, -1, -2)).addGap(18, 18, 18).addGroup(attributesSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.summaryWarning, -2, 16, -2).addComponent(this.summaryLabel).addComponent(this.summaryField, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)));
        attributesSectionPanelLayout.linkSize(1, this.dummyLabel1, this.dummyLabel2, this.dummyLabel3, this.dummyTimetrackingLabel, this.priorityCombo);
        this.osCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.osCombo.AccessibleContext.accessibleDescription"));
        this.dependsOnButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.dependsOnButton.AccessibleContext.accessibleDescription"));
        this.componentCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.componentCombo.AccessibleContext.accessibleDescription"));
        this.qaContactField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.qaContactField.AccessibleContext.accessibleDescription"));
        this.modifiedField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.modifiedField.AccessibleContext.accessibleDescription"));
        this.duplicateField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.duplicateField.AccessibleContext.accessibleDescription"));
        this.priorityCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.priorityCombo.AccessibleContext.accessibleDescription"));
        this.assignedField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.assignedField.AccessibleContext.accessibleDescription"));
        this.blocksButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.blocksButton.AccessibleContext.accessibleDescription"));
        this.duplicateButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.duplicateButton.AccessibleContext.accessibleDescription"));
        this.urlField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.urlField.AccessibleContext.accessibleDescription"));
        this.ccField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.ccField.AccessibleContext.accessibleDescription"));
        this.blocksField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.blocksField.AccessibleContext.accessibleDescription"));
        this.dependsField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.dependsField.AccessibleContext.accessibleDescription"));
        this.productCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.productCombo.AccessibleContext.accessibleDescription"));
        this.versionCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.versionCombo.AccessibleContext.accessibleDescription"));
        this.platformCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.platformCombo.AccessibleContext.accessibleDescription"));
        this.severityCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.severityCombo.AccessibleContext.accessibleDescription"));
        this.resolutionField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.resolutionField.AccessibleContext.accessibleDescription"));
        this.targetMilestoneCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.targetMilestoneCombo.AccessibleContext.accessibleDescription"));
        this.reportedField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.reportedField.AccessibleContext.accessibleDescription"));
        this.statusCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.statusCombo.AccessibleContext.accessibleDescription"));
        this.keywordsField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.keywordsField.AccessibleContext.accessibleDescription"));
        this.keywordsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.keywordsButton.AccessibleContext.accessibleDescription"));
        this.attachmentsSectionPanel.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        GroupLayout attachmentsSectionPanelLayout = new GroupLayout(this.attachmentsSectionPanel);
        this.attachmentsSectionPanel.setLayout(attachmentsSectionPanelLayout);
        attachmentsSectionPanelLayout.setHorizontalGroup(attachmentsSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(attachmentsSectionPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.attachmentsWarning, -2, 16, -2).addGap(5, 5, 5).addComponent(this.dummyAttachmentsPanel, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        attachmentsSectionPanelLayout.setVerticalGroup(attachmentsSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(attachmentsSectionPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(attachmentsSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dummyAttachmentsPanel, -2, -1, -2).addComponent(this.attachmentsWarning, -2, 16, -2)).addGap(0, 0, 0)));
        this.commentsSectionPanel.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        GroupLayout commentsSectionPanelLayout = new GroupLayout(this.commentsSectionPanel);
        this.commentsSectionPanel.setLayout(commentsSectionPanelLayout);
        commentsSectionPanelLayout.setHorizontalGroup(commentsSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(commentsSectionPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.dummyCommentsPanel, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        commentsSectionPanelLayout.setVerticalGroup(commentsSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(commentsSectionPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.dummyCommentsPanel, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.newCommentSectionPanel.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        this.scrollPane1.setVerticalScrollBarPolicy(21);
        this.addCommentArea.setLineWrap(true);
        this.addCommentArea.setWrapStyleWord(true);
        this.scrollPane1.setViewportView(this.addCommentArea);
        this.addCommentArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.addCommentArea.AccessibleContext.accessibleDescription"));
        this.attachLogCheckBox.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        Mnemonics.setLocalizedText((AbstractButton)this.attachLogCheckBox, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.attachLogCheckBox.text"));
        this.attachLogCheckBox.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.viewLogButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.viewLogButton.text"));
        this.viewLogButton.addActionListener((ActionListener)formListener);
        this.messagePanel.setLayout(new BoxLayout(this.messagePanel, 3));
        GroupLayout newCommentSectionPanelLayout = new GroupLayout(this.newCommentSectionPanel);
        this.newCommentSectionPanel.setLayout(newCommentSectionPanelLayout);
        newCommentSectionPanelLayout.setHorizontalGroup(newCommentSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(newCommentSectionPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.commentWarning, -2, 16, -2).addGap(5, 5, 5).addGroup(newCommentSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.messagePanel, -1, -1, Short.MAX_VALUE).addGroup(newCommentSectionPanelLayout.createSequentialGroup().addComponent(this.attachLogCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.viewLogButton, -2, -1, -2)).addComponent(this.scrollPane1)).addGap(0, 0, 0)));
        newCommentSectionPanelLayout.setVerticalGroup(newCommentSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(newCommentSectionPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(newCommentSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.commentWarning, -2, 16, -2).addComponent(this.scrollPane1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(newCommentSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.viewLogButton, -2, -1, -2).addComponent(this.attachLogCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.messagePanel, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.privatePanel.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        this.dueDateLabel.setLabelFor(this.dummyDueDateField);
        Mnemonics.setLocalizedText((JLabel)this.dueDateLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.dueDateLabel.text"));
        this.dueDateLabel.setToolTipText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.dueDateLabel.TTtext"));
        this.scheduleDateLabel.setLabelFor(this.dummyScheduleDateField);
        Mnemonics.setLocalizedText((JLabel)this.scheduleDateLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.scheduleDateLabel.text"));
        this.scheduleDateLabel.setToolTipText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.scheduleDateLabel.TTtext"));
        this.estimateLabel.setLabelFor(this.estimatedField);
        Mnemonics.setLocalizedText((JLabel)this.estimateLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.estimateLabel.text"));
        this.estimateLabel.setToolTipText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.estimateLabel.TTtext"));
        this.estimateField.setFormatterFactory(new DefaultFormatterFactory(estimateFormatter));
        this.estimateField.setText("0");
        this.estimateField.setToolTipText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.estimateField.toolTipText"));
        this.notesLabel.setLabelFor(this.privateNotesField);
        Mnemonics.setLocalizedText((JLabel)this.notesLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.notesLabel.text"));
        this.notesLabel.setToolTipText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.notesLabel.TTtext"));
        this.privateNotesField.setColumns(20);
        this.privateNotesField.setLineWrap(true);
        this.privateNotesField.setWrapStyleWord(true);
        this.privateNotesScrollPane.setViewportView(this.privateNotesField);
        GroupLayout privatePanelLayout = new GroupLayout(this.privatePanel);
        this.privatePanel.setLayout(privatePanelLayout);
        privatePanelLayout.setHorizontalGroup(privatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(privatePanelLayout.createSequentialGroup().addGroup(privatePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.notesLabel).addComponent(this.dueDateLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(privatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(privatePanelLayout.createSequentialGroup().addComponent(this.dummyDueDateField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.scheduleDateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dummyScheduleDateField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.estimateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.estimateField, -2, 65, -2)).addComponent(this.privateNotesScrollPane))));
        privatePanelLayout.setVerticalGroup(privatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(privatePanelLayout.createSequentialGroup().addGroup(privatePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dueDateLabel).addComponent(this.dummyDueDateField, -2, -1, -2).addComponent(this.scheduleDateLabel).addComponent(this.dummyScheduleDateField, -2, -1, -2).addComponent(this.estimateLabel).addComponent(this.estimateField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(privatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.notesLabel).addComponent(this.privateNotesScrollPane, -2, -1, -2))));
        this.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        this.headerPanel.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        this.headerField.setEditable(false);
        this.headerField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonsPanel.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        this.separatorLabel4.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.separatorLabel6.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.separatorLabel3.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.separatorDismissButton.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        Mnemonics.setLocalizedText((AbstractButton)this.refreshButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.refreshButton.text"));
        this.refreshButton.setToolTipText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.refreshButton.toolTipText"));
        this.refreshButton.addActionListener((ActionListener)formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.cancelButton.text"));
        this.cancelButton.addActionListener((ActionListener)formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.showInBrowserButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.showInBrowserButton.text"));
        this.showInBrowserButton.addActionListener((ActionListener)formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.submitButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.submitButton.text"));
        this.submitButton.addActionListener((ActionListener)formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.btnDeleteTask, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.btnDeleteTask.text"));
        this.btnDeleteTask.setToolTipText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.btnDeleteTask.TTtext"));
        this.btnDeleteTask.addActionListener((ActionListener)formListener);
        GroupLayout buttonsPanelLayout = new GroupLayout(this.buttonsPanel);
        this.buttonsPanel.setLayout(buttonsPanelLayout);
        buttonsPanelLayout.setHorizontalGroup(buttonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonsPanelLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.refreshButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separatorLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.showInBrowserButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separatorLabel4, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.submitButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separatorLabel6, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.cancelButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separatorDismissButton, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.btnDeleteTask, -2, -1, -2).addGap(0, 0, 0)));
        buttonsPanelLayout.setVerticalGroup(buttonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonsPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(buttonsPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent((Component)this.refreshButton, -1, -1, Short.MAX_VALUE).addComponent(this.separatorLabel3, -1, -1, Short.MAX_VALUE).addComponent((Component)this.showInBrowserButton, -1, -1, Short.MAX_VALUE).addComponent(this.separatorLabel4, -1, -1, Short.MAX_VALUE).addComponent((Component)this.submitButton, -1, -1, Short.MAX_VALUE).addComponent((Component)this.cancelButton, -2, -1, -2).addComponent(this.separatorLabel6, -1, -1, Short.MAX_VALUE).addComponent((Component)this.btnDeleteTask, -2, -1, -2).addComponent(this.separatorDismissButton, -1, -1, Short.MAX_VALUE))));
        buttonsPanelLayout.linkSize(1, new Component[]{this.refreshButton, this.separatorLabel3, this.showInBrowserButton});
        this.refreshButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.refreshButton.AccessibleContext.accessibleDescription"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.cancelButton.AccessibleContext.accessibleDescription"));
        this.submitButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.submitButton.AccessibleContext.accessibleDescription"));
        GroupLayout headerPanelLayout = new GroupLayout(this.headerPanel);
        this.headerPanel.setLayout(headerPanelLayout);
        headerPanelLayout.setHorizontalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(headerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.headerField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonsPanel, -2, -1, -2).addContainerGap()));
        headerPanelLayout.setVerticalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(headerPanelLayout.createSequentialGroup().addContainerGap().addGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.headerField).addComponent(this.buttonsPanel, -1, -1, -2)).addContainerGap()));
        this.mainScrollPane.setBorder(null);
        this.mainPanel.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        this.attributesSection.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        this.attributesSection.setActions(this.getAttributesSectionActions());
        this.attributesSection.setContent((JComponent)this.attributesSectionPanel);
        this.attributesSection.setLabel(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.attributesSection.label"));
        this.attachmentsSection.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        this.attachmentsSection.setContent((JComponent)this.attachmentsSectionPanel);
        this.attachmentsSection.setExpanded(false);
        this.attachmentsSection.setLabel(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.attachmentsLabel.text", (Object)0));
        this.newCommentSection.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        this.newCommentSection.setContent((JComponent)this.newCommentSectionPanel);
        this.newCommentSection.setLabel(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.newCommentSection.label"));
        this.commentsSection.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        this.commentsSection.setActions(this.getCommentsSectionActions());
        this.commentsSection.setContent((JComponent)this.commentsSectionPanel);
        this.commentsSection.setLabel(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.commentsLabel.text", (Object)0));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, 0).addComponent((Component)this.commentsSection, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, 0).addComponent((Component)this.commentsSection, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.privateSection.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        this.privateSection.setActions(this.getPrivateSectionActions());
        this.privateSection.setContent((JComponent)this.privatePanel);
        this.privateSection.setLabel(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.privateAttributesSection.text"));
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.attributesSection, -1, -1, Short.MAX_VALUE).addComponent((Component)this.attachmentsSection, -1, -1, Short.MAX_VALUE).addComponent((Component)this.privateSection, -1, -1, Short.MAX_VALUE).addComponent((Component)this.newCommentSection, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.attributesSection, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.attachmentsSection, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.privateSection, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.newCommentSection, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap()));
        this.mainScrollPane.setViewportView(this.mainPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerPanel, -1, -1, Short.MAX_VALUE).addComponent(this.mainScrollPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.headerPanel, -2, -1, -2).addGap(0, 0, 0).addComponent(this.mainScrollPane)));
    }

    private void productComboActionPerformed(ActionEvent evt) {
        this.cancelHighlight(this.productLabel);
        BugzillaRepository repository = this.issue.getRepository();
        BugzillaConfiguration bc = repository.getConfiguration();
        if (bc == null || !bc.isValid()) {
            return;
        }
        String product = this.productCombo.getSelectedItem().toString();
        Object component = this.componentCombo.getSelectedItem();
        Object version = this.versionCombo.getSelectedItem();
        Object targetMilestone = this.targetMilestoneCombo.getSelectedItem();
        this.componentCombo.setModel(this.toComboModel(bc.getComponents(product)));
        this.versionCombo.setModel(this.toComboModel(bc.getVersions(product)));
        List<String> targetMilestones = bc.getTargetMilestones(product);
        this.usingTargetMilestones = !targetMilestones.isEmpty();
        this.targetMilestoneCombo.setModel(this.toComboModel(targetMilestones));
        if (!this.selectInCombo(this.componentCombo, component, false)) {
            if (this.issue.isNew() && this.componentCombo.getModel().getSize() > 0 || this.componentCombo.getModel().getSize() == 1) {
                this.componentCombo.setSelectedIndex(0);
            } else {
                this.componentCombo.setSelectedItem(null);
            }
            this.storeFieldValueForNewIssue(IssueField.COMPONENT, this.componentCombo);
        }
        if (!this.selectInCombo(this.versionCombo, version, false)) {
            if (this.issue.isNew() && this.versionCombo.getModel().getSize() > 0 || this.versionCombo.getModel().getSize() == 1) {
                this.versionCombo.setSelectedIndex(0);
            } else {
                this.versionCombo.setSelectedItem(null);
            }
            this.storeFieldValueForNewIssue(IssueField.VERSION, this.versionCombo);
        }
        if (this.usingTargetMilestones && !this.selectInCombo(this.targetMilestoneCombo, targetMilestone, false)) {
            if (this.issue.isNew() && this.targetMilestoneCombo.getModel().getSize() > 0 || this.targetMilestoneCombo.getModel().getSize() == 1) {
                this.targetMilestoneCombo.setSelectedIndex(0);
            } else {
                this.targetMilestoneCombo.setSelectedItem(null);
            }
            this.storeFieldValueForNewIssue(IssueField.MILESTONE, this.targetMilestoneCombo);
        }
        this.targetMilestoneLabel.setVisible(this.usingTargetMilestones);
        this.targetMilestoneCombo.setVisible(this.usingTargetMilestones);
        this.milestoneWarning.setVisible(this.usingTargetMilestones);
        if (this.issue.isNew()) {
            this.issue.setFieldValue(IssueField.PRODUCT, product);
            if (BugzillaUtil.isNbRepository(repository)) {
                String defaultMilestone;
                List<String> milestones = repository.getConfiguration().getTargetMilestones(product);
                if (milestones.contains(defaultMilestone = "TBD")) {
                    this.issue.setFieldValue(IssueField.MILESTONE, defaultMilestone);
                }
                List<String> versions = repository.getConfiguration().getVersions(product);
                String defaultVersion = this.getCurrentNetBeansVersion();
                for (String v : versions) {
                    if (!v.trim().toLowerCase().equals(defaultVersion.toLowerCase())) continue;
                    this.issue.setFieldValue(IssueField.VERSION, v);
                }
            }
            if (this.reloading) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IssuePanel.this.reloadForm(false);
                    }
                });
            } else {
                this.reloadForm(false);
            }
        }
    }

    private void statusComboActionPerformed(ActionEvent evt) {
        this.cancelHighlight(this.statusLabel);
        this.cancelHighlight(this.resolutionLabel);
        if ("RESOLVED".equals(this.statusCombo.getSelectedItem())) {
            if (this.resolutionCombo.getParent() == null) {
                ((GroupLayout)this.attributesSectionPanel.getLayout()).replace(this.resolutionField, this.resolutionCombo);
            }
            boolean setResolution = !this.resolutionCombo.isVisible();
            this.resolutionCombo.setVisible(true);
            this.resolutionWarning.setVisible(true);
            this.resolutionLabel.setVisible(true);
            String resolution = this.issue.getRepositoryFieldValue(IssueField.RESOLUTION);
            if (resolution.isEmpty()) {
                resolution = "FIXED";
            }
            if (setResolution) {
                this.resolutionCombo.setSelectedItem(resolution);
            }
        } else {
            this.resolutionCombo.setVisible(false);
            this.resolutionLabel.setVisible(false);
            this.resolutionWarning.setVisible(false);
            this.updateFieldDecorations(this.resolutionCombo, IssueField.RESOLUTION, this.resolutionWarning, this.resolutionLabel);
            this.duplicateLabel.setVisible(false);
            this.duplicateWarning.setVisible(false);
            this.duplicateField.setVisible(false);
            this.duplicateButton.setVisible(false);
            this.updateFieldDecorations(this.duplicateField, IssueField.DUPLICATE_ID, this.duplicateWarning, this.duplicateLabel);
            this.updateNoDuplicateId();
        }
        if (!this.resolutionField.getText().trim().equals("")) {
            if (this.statusCombo.getSelectedIndex() > this.resolvedIndex) {
                if (this.resolutionField.getParent() == null) {
                    ((GroupLayout)this.attributesSectionPanel.getLayout()).replace(this.resolutionCombo, this.resolutionField);
                }
                this.resolutionField.setVisible(true);
            } else {
                this.resolutionField.setVisible(false);
            }
            this.duplicateLabel.setVisible(false);
            this.duplicateWarning.setVisible(false);
            this.duplicateField.setVisible(false);
            this.duplicateButton.setVisible(false);
            this.updateFieldDecorations(this.duplicateField, IssueField.DUPLICATE_ID, this.duplicateWarning, this.duplicateLabel);
            this.updateNoDuplicateId();
        }
        this.resolutionLabel.setLabelFor(this.resolutionCombo.isVisible() ? this.resolutionCombo : this.resolutionField);
    }

    private void storeCCValue() {
        Set<String> oldCCs = this.ccs(this.issue.getRepositoryFieldValue(IssueField.CC));
        Set<String> newCCs = this.ccs(this.ccField.getText());
        String removedCCs = this.getMissingCCs(oldCCs, newCCs);
        String addedCCs = this.getMissingCCs(newCCs, oldCCs);
        this.addUnsavedField(IssueField.CC.getKey());
        this.issue.setFieldValues(IssueField.CC, new ArrayList<String>(this.ccs(this.ccField.getText())));
        this.storeFieldValue(IssueField.REMOVECC, removedCCs);
        this.storeFieldValue(IssueField.NEWCC, addedCCs);
    }

    private Set<String> ccs(String values) {
        LinkedHashSet<String> ccs = new LinkedHashSet<String>();
        StringTokenizer st = new StringTokenizer(values, ", \t\n\r\f");
        while (st.hasMoreTokens()) {
            ccs.add(st.nextToken());
        }
        return ccs;
    }

    private String getMissingCCs(Set<String> ccs, Set<String> missingIn) {
        StringBuilder ret = new StringBuilder();
        Iterator<String> it = ccs.iterator();
        while (it.hasNext()) {
            String cc = it.next();
            if (cc.trim().equals("") || missingIn.contains(cc)) continue;
            ret.append(cc);
            if (!it.hasNext()) continue;
            ret.append(',');
        }
        return ret.toString();
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        String refreshMessageFormat = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.refreshMessage");
        String refreshMessage = MessageFormat.format(refreshMessageFormat, this.issue.getID());
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)refreshMessage);
        handle.start();
        handle.switchToIndeterminate();
        this.skipReload = true;
        this.enableComponents(false);
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    IssuePanel.this.issue.updateModelAndRefresh();
                }
                catch (Throwable throwable) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            IssuePanel.this.enableComponents(true);
                            IssuePanel.this.skipReload = false;
                        }
                    });
                    handle.finish();
                    IssuePanel.this.reloadFormInAWT(true);
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                handle.finish();
                IssuePanel.this.reloadFormInAWT(true);
            }
        });
    }

    private void resolutionComboActionPerformed(ActionEvent evt) {
        this.cancelHighlight(this.resolutionLabel);
        if (this.resolutionCombo.getParent() == null) {
            return;
        }
        boolean shown = "DUPLICATE".equals(this.resolutionCombo.getSelectedItem());
        this.duplicateLabel.setVisible(shown);
        this.duplicateWarning.setVisible(shown);
        this.duplicateField.setVisible(shown);
        this.duplicateButton.setVisible(shown && this.duplicateField.isEditable());
        this.updateFieldDecorations(this.duplicateField, IssueField.DUPLICATE_ID, this.duplicateWarning, this.duplicateLabel);
        this.updateNoDuplicateId();
    }

    private void keywordsButtonActionPerformed(ActionEvent evt) {
        String message = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.keywordsButton.message");
        String kws = BugzillaUtil.getKeywords(message, this.keywordsField.getText(), this.issue.getRepository());
        this.keywordsField.setText(kws);
    }

    private void blocksButtonActionPerformed(ActionEvent evt) {
        Issue i = IssueQuickSearch.selectIssue((String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.blocksButton.message"), (Repository)BugzillaUtil.getRepository(this.issue.getRepository()), (JPanel)this, (HelpCtx)new HelpCtx("org.netbeans.modules.bugzilla.blocksChooser"));
        if (i != null) {
            String newIssueID = i.getID();
            StringBuilder sb = new StringBuilder();
            if (!this.blocksField.getText().trim().equals("")) {
                sb.append(this.blocksField.getText()).append(',').append(' ');
            }
            sb.append(newIssueID);
            this.blocksField.setText(sb.toString());
        }
    }

    private void dependsOnButtonActionPerformed(ActionEvent evt) {
        Issue i = IssueQuickSearch.selectIssue((String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.dependsOnButton.message"), (Repository)BugzillaUtil.getRepository(this.issue.getRepository()), (JPanel)this, (HelpCtx)new HelpCtx("org.netbeans.modules.bugzilla.dependsOnChooser"));
        if (i != null) {
            String newIssueID = i.getID();
            StringBuilder sb = new StringBuilder();
            if (!this.dependsField.getText().trim().equals("")) {
                sb.append(this.dependsField.getText()).append(',').append(' ');
            }
            sb.append(newIssueID);
            this.dependsField.setText(sb.toString());
        }
    }

    private void componentComboActionPerformed(ActionEvent evt) {
        this.cancelHighlight(this.componentLabel);
        this.updateNoComponent();
    }

    private void versionComboActionPerformed(ActionEvent evt) {
        this.cancelHighlight(this.versionLabel);
        this.updateNoVersion();
    }

    private void platformComboActionPerformed(ActionEvent evt) {
        this.cancelHighlight(this.platformLabel);
    }

    private void priorityComboActionPerformed(ActionEvent evt) {
        this.cancelHighlight(this.priorityLabel);
    }

    private void severityComboActionPerformed(ActionEvent evt) {
        this.cancelHighlight(this.priorityLabel);
    }

    private void targetMilestoneComboActionPerformed(ActionEvent evt) {
        this.cancelHighlight(this.targetMilestoneLabel);
        this.updateNoTargetMilestone();
    }

    private void osComboActionPerformed(ActionEvent evt) {
        this.cancelHighlight(this.platformLabel);
    }

    private void reloadButtonActionPerformed(ActionEvent evt) {
        String reloadMessage = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.reloadMessage");
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)reloadMessage);
        handle.start();
        handle.switchToIndeterminate();
        this.skipReload = true;
        this.enableComponents(false);
        RP.post(new Runnable(){

            @Override
            public void run() {
                IssuePanel.this.issue.getRepository().refreshConfiguration();
                EventQueue.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            IssuePanel.this.reloading = true;
                            Object product = IssuePanel.this.productCombo.getSelectedItem();
                            Object platform = IssuePanel.this.platformCombo.getSelectedItem();
                            Object os = IssuePanel.this.osCombo.getSelectedItem();
                            Object priority = IssuePanel.this.priorityCombo.getSelectedItem();
                            Object severity = IssuePanel.this.severityCombo.getSelectedItem();
                            Object resolution = IssuePanel.this.resolutionCombo.getSelectedItem();
                            Object issueType = IssuePanel.this.issueTypeCombo.getSelectedItem();
                            IssuePanel.this.initCombos();
                            IssuePanel.this.initCustomFields();
                            IssuePanel.this.selectInCombo(IssuePanel.this.productCombo, product, false);
                            IssuePanel.this.selectInCombo(IssuePanel.this.platformCombo, platform, false);
                            IssuePanel.this.selectInCombo(IssuePanel.this.osCombo, os, false);
                            IssuePanel.this.selectInCombo(IssuePanel.this.priorityCombo, priority, false);
                            IssuePanel.this.selectInCombo(IssuePanel.this.severityCombo, severity, false);
                            IssuePanel.this.initStatusCombo(IssuePanel.this.statusCombo.getSelectedItem().toString());
                            IssuePanel.this.selectInCombo(IssuePanel.this.resolutionCombo, resolution, false);
                            if (BugzillaUtil.isNbRepository(IssuePanel.this.issue.getRepository())) {
                                IssuePanel.this.issueTypeCombo.setSelectedItem(issueType);
                            }
                            IssuePanel.this.reloadCustomFields(true);
                            IssuePanel.this.updateCustomFieldStatuses();
                        }
                        finally {
                            IssuePanel.this.reloading = false;
                            IssuePanel.this.enableComponents(true);
                            IssuePanel.this.skipReload = false;
                        }
                    }
                });
                handle.finish();
            }
        });
    }

    private void duplicateButtonActionPerformed(ActionEvent evt) {
        Issue i = IssueQuickSearch.selectIssue((String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.duplicateButton.message"), (Repository)BugzillaUtil.getRepository(this.issue.getRepository()), (JPanel)this, (HelpCtx)new HelpCtx("org.netbeans.modules.bugzilla.duplicateChooser"));
        if (i != null) {
            String newIssueID = i.getID();
            this.duplicateField.setText(newIssueID);
        }
    }

    private void assignedComboActionPerformed(ActionEvent evt) {
        Object value;
        this.cancelHighlight(this.assignedLabel);
        if (!this.reloading) {
            this.assignedToStatusLabel.setVisible(false);
        }
        if ((value = this.assignedCombo.getSelectedItem()) instanceof RepositoryUser) {
            String assignee = ((RepositoryUser)value).getUserName();
            BugzillaRepository repository = this.issue.getRepository();
            if (repository instanceof KenaiRepository) {
                assignee = assignee + '@' + ((KenaiRepository)repository).getHost();
            }
            this.assignedCombo.setSelectedItem(assignee);
        }
    }

    private void issueTypeComboActionPerformed(ActionEvent evt) {
        this.cancelHighlight(this.issueTypeLabel);
    }

    private void showInBrowserButtonActionPerformed(ActionEvent evt) {
        try {
            URL url = new URL(this.issue.getRepository().getUrl() + "/show_bug.cgi?id=" + this.issue.getID());
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException muex) {
            Bugzilla.LOG.log(Level.INFO, "Unable to show the issue in the browser.", muex);
        }
    }

    private void urlButtonActionPerformed(ActionEvent evt) {
        URL url;
        block6: {
            String urlString = this.urlField.getText();
            if (urlString.isEmpty()) {
                return;
            }
            url = null;
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException muex) {
                if (this.issue == null) break block6;
                String repoUrlString = this.issue.getRepository().getUrl();
                urlString = repoUrlString + (repoUrlString.endsWith("/") ? "" : "/") + urlString;
                try {
                    url = new URL(urlString);
                }
                catch (MalformedURLException ex) {
                    Bugzilla.LOG.log(Level.INFO, "Unable to open " + urlString, muex);
                }
            }
        }
        if (url != null) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
    }

    private void workedFieldFocusLost(FocusEvent evt) {
        if (!"".equals(this.workedField.getText().trim())) {
            double workedSum;
            double worked;
            double actual;
            double remaining;
            String workedString = this.workedField.getText().trim();
            if (!workedString.trim().equals("")) {
                try {
                    Double.parseDouble(workedString);
                }
                catch (NumberFormatException e) {
                    return;
                }
            }
            if ((remaining = (actual = this.getDoubleValue(this.actualField)) - (worked = this.getDoubleValue(this.workedField)) - (workedSum = this.getDoubleValue(this.workedSumField))) > 0.0) {
                this.remainingField.setText(String.valueOf(remaining));
            } else {
                this.remainingField.setText("0");
            }
        }
    }

    private void attachLogCheckBoxActionPerformed(ActionEvent evt) {
        this.switchViewLog();
    }

    private void viewLogButtonActionPerformed(ActionEvent evt) {
        IssuePanel.showLogFile(evt);
    }

    private void submitButtonActionPerformed(ActionEvent evt) {
        String submitMessage;
        final boolean isNew = this.issue.isNew();
        if (isNew) {
            submitMessage = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.submitNewMessage");
        } else {
            String submitMessageFormat = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.submitMessage");
            submitMessage = MessageFormat.format(submitMessageFormat, this.issue.getID());
        }
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)submitMessage);
        handle.start();
        handle.switchToIndeterminate();
        this.skipReload = true;
        this.enableComponents(false);
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean submitOK = false;
                try {
                    submitOK = IssuePanel.this.issue.submitAndRefresh();
                }
                catch (Throwable throwable) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            IssuePanel.this.enableComponents(true);
                            IssuePanel.this.skipReload = false;
                        }
                    });
                    handle.finish();
                    if (submitOK) {
                        if (isNew) {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    IssuePanel.this.initCustomFields();
                                }
                            });
                        }
                        IssuePanel.this.reloadFormInAWT(true);
                    }
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                handle.finish();
                if (submitOK) {
                    if (isNew) {
                        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                    IssuePanel.this.reloadFormInAWT(true);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean saveSynchronously() {
        boolean saved = false;
        try {
            saved = this.issue.save();
        }
        catch (Throwable throwable) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IssuePanel.this.clearUnsavedFields();
                    IssuePanel.this.enableComponents(true);
                    IssuePanel.this.updateFieldStatuses();
                    IssuePanel.this.cancelButton.setEnabled(IssuePanel.this.issue.hasLocalEdits());
                    IssuePanel.this.skipReload = false;
                }
            });
            throw throwable;
        }
        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
        return saved;
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        if (0 != JOptionPane.showConfirmDialog(WindowManager.getDefault().getMainWindow(), Bundle.MSG_IssuePanel_cancelChanges_message(), Bundle.LBL_IssuePanel_cancelChanges_title(), 0, 3)) {
            return;
        }
        this.discard();
    }

    void discard() {
        this.skipReload = true;
        this.enableComponents(false);
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean fCleared;
                boolean cleared = false;
                try {
                    fCleared = cleared = IssuePanel.this.issue.discardLocalEdits();
                }
                catch (Throwable throwable) {
                    boolean fCleared2 = cleared;
                    EventQueue.invokeLater(new Runnable(fCleared2){
                        final /* synthetic */ boolean val$fCleared;
                        {
                            this.val$fCleared = bl;
                        }

                        @Override
                        public void run() {
                            IssuePanel.this.clearUnsavedFields();
                            IssuePanel.this.enableComponents(true);
                            IssuePanel.this.cancelButton.setEnabled(!this.val$fCleared);
                            IssuePanel.this.skipReload = false;
                            IssuePanel.this.reloadForm(true);
                        }
                    });
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    void clearUnsavedChanges() {
        this.issue.clearUnsavedChanges();
        this.clearUnsavedFields();
    }

    private void clearUnsavedFields() {
        boolean fire = !this.unsavedFields.isEmpty();
        this.unsavedFields.clear();
        if (fire) {
            this.issue.fireChangeEvent();
        }
    }

    private void addUnsavedField(String fieldName) {
        boolean fire = this.unsavedFields.isEmpty();
        this.unsavedFields.add(fieldName);
        if (fire) {
            this.issue.fireChangeEvent();
        }
    }

    boolean isChanged() {
        return !this.initializingNewTask() && this.getIssue().hasUnsavedChanges();
    }

    private void btnDeleteTaskActionPerformed(ActionEvent evt) {
        if (0 != JOptionPane.showConfirmDialog(WindowManager.getDefault().getMainWindow(), Bundle.MSG_IssuePanel_deleteTask_message(), Bundle.LBL_IssuePanel_deleteTask_title(), 0, 3)) {
            return;
        }
        this.clearUnsavedChanges();
        Container tc = SwingUtilities.getAncestorOfClass(TopComponent.class, this);
        if (tc instanceof TopComponent) {
            ((TopComponent)tc).close();
        }
        RP.post(new Runnable(){

            @Override
            public void run() {
                IssuePanel.this.issue.delete();
            }
        });
    }

    void makeCaretVisible(JTextArea textArea) {
        int pos = textArea.getCaretPosition();
        try {
            Rectangle rec = textArea.getUI().modelToView(textArea, pos);
            if (rec != null) {
                Point p = SwingUtilities.convertPoint(textArea, rec.x, rec.y, this);
                this.scrollRectToVisible(new Rectangle(p.x, p.y, rec.width, rec.height));
            }
        }
        catch (BadLocationException blex) {
            Bugzilla.LOG.log(Level.INFO, blex.getMessage(), blex);
        }
    }

    private String getCurrentNetBeansVersion() {
        String version = IssuePanel.parseProductVersion(IssuePanel.getProductVersionValue());
        if (version != null) {
            if (version.toLowerCase().equals("dev")) {
                return CURRENT_NB_VERSION;
            }
            return version;
        }
        return CURRENT_NB_VERSION;
    }

    static String parseProductVersion(String productVersionValue) {
        String version;
        Pattern p = Pattern.compile("NetBeans IDE\\s([a-zA-Z0-9\\.?]*)\\s?.*");
        Matcher m = p.matcher(productVersionValue);
        if (m.matches() && (version = m.group(1)) != null && !version.trim().isEmpty()) {
            return version;
        }
        return null;
    }

    private void addNetbeansInfo() {
        String format = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.newIssue.netbeansInfo");
        Object[] info = new Object[]{IssuePanel.getProductVersionValue(), System.getProperty("os.name", "unknown"), System.getProperty("os.version", "unknown"), System.getProperty("os.arch", "unknown"), System.getProperty("java.version", "unknown"), System.getProperty("java.vm.name", "unknown"), System.getProperty("java.vm.version", "")};
        String infoTxt = MessageFormat.format(format, info);
        this.addCommentArea.setText(infoTxt);
        assert (this.issue.isNew());
        this.storeFieldValueForNewIssue(IssueField.DESCRIPTION, this.addCommentArea);
    }

    public static String getProductVersionValue() {
        return MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.core.startup.Bundle").getString("currentVersion"), System.getProperty("netbeans.buildnumber"));
    }

    void opened() {
        this.restoreSections();
        this.enableComponents(false);
        this.issue.opened();
        this.opened = true;
    }

    void closed() {
        if (this.issue != null) {
            this.persistSections();
            this.commentsPanel.storeSettings();
            this.opened = false;
            this.issue.closed();
        }
    }

    private void persistSections() {
        if (!this.issue.isNew()) {
            BugzillaConfig config = BugzillaConfig.getInstance();
            String repositoryId = this.issue.getRepository().getID();
            String taskId = this.issue.getID();
            config.setEditorSectionCollapsed(repositoryId, taskId, SECTION_ATTRIBUTES, !this.attributesSection.isExpanded());
            config.setEditorSectionCollapsed(repositoryId, taskId, SECTION_ATTACHMENTS, !this.attachmentsSection.isExpanded());
            config.setEditorSectionCollapsed(repositoryId, taskId, SECTION_COMMENTS, !this.commentsSection.isExpanded());
            config.setEditorSectionCollapsed(repositoryId, taskId, SECTION_PRIVATE, !this.privateSection.isExpanded());
        }
    }

    private void restoreSections() {
        String taskId;
        String repositoryId;
        BugzillaConfig config = BugzillaConfig.getInstance();
        this.attributesSection.setExpanded(!config.isEditorSectionCollapsed(repositoryId = this.issue.getRepository().getID(), taskId = this.issue.getID(), SECTION_ATTRIBUTES, false));
        this.attachmentsSection.setExpanded(!config.isEditorSectionCollapsed(repositoryId, taskId, SECTION_ATTACHMENTS, true));
        this.commentsSection.setExpanded(!config.isEditorSectionCollapsed(repositoryId, taskId, SECTION_COMMENTS, false));
        this.privateSection.setExpanded(!config.isEditorSectionCollapsed(repositoryId, taskId, SECTION_PRIVATE, true));
    }

    private double getDoubleValue(JComponent field) {
        assert (field instanceof JTextField || field instanceof JLabel);
        String txt = field instanceof JTextField ? ((JTextField)field).getText() : ((JLabel)field).getText();
        if (txt.isEmpty()) {
            return 0.0;
        }
        try {
            return Double.parseDouble(txt);
        }
        catch (NumberFormatException e) {
            Bugzilla.LOG.log(Level.WARNING, txt, e);
            return 0.0;
        }
    }

    static void showLogFile(ActionEvent evt) {
        Action a = IssuePanel.getShowLogAction();
        if (a != null) {
            a.actionPerformed(null);
        }
    }

    static Action getShowLogAction() {
        return (Action)FileUtil.getConfigObject((String)"Actions/View/org-netbeans-core-actions-LogAction.instance", Action.class);
    }

    private void switchViewLog() {
        this.viewLogButton.setVisible(this.attachLogCheckBox.isSelected());
    }

    private String mergeValues(List<String> values) {
        StringBuilder sb = new StringBuilder();
        for (String value : values) {
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append(value);
        }
        String newValue = sb.toString();
        return newValue;
    }

    private void setupListeners() {
        if (this.issue.isNew()) {
            this.addCommentArea.getDocument().addDocumentListener(new FieldChangeListener(this.addCommentArea, IssueField.DESCRIPTION){

                @Override
                void fieldModified() {
                    if (IssuePanel.this.issue.isNew()) {
                        super.fieldModified();
                    }
                }
            });
        }
        this.addCommentArea.getDocument().addDocumentListener(new FieldChangeListener(this.addCommentArea, IssueField.COMMENT, this.commentWarning, this.newCommentSection.getLabelComponent()){

            @Override
            void fieldModified() {
                if (!IssuePanel.this.reloading && !IssuePanel.this.issue.isNew()) {
                    IssuePanel.this.issue.setFieldValue(IssueField.COMMENT, IssuePanel.this.addCommentArea.getText().trim());
                    IssuePanel.this.addUnsavedField(IssueField.COMMENT.getKey());
                    this.updateDecorations();
                }
            }
        });
        this.summaryField.getDocument().addDocumentListener(new FieldChangeListener(this.summaryField, IssueField.SUMMARY, this.summaryWarning, this.summaryLabel));
        this.productCombo.addActionListener(new FieldChangeListener(this.productCombo, IssueField.PRODUCT, this.productWarning, this.productLabel));
        this.componentCombo.addActionListener(new FieldChangeListener(this.componentCombo, IssueField.COMPONENT, this.componentWarning, this.componentLabel));
        this.versionCombo.addActionListener(new FieldChangeListener(this.versionCombo, IssueField.VERSION, this.versionWarning, this.versionLabel));
        this.platformCombo.addActionListener(new FieldChangeListener((JComponent)this.platformCombo, IssueField.PLATFORM, this.platformWarning, (JComponent)this.platformLabel, Pair.of((Object)IssueField.PLATFORM, (Object)this.platformCombo), Pair.of((Object)IssueField.OS, (Object)this.osCombo)));
        this.osCombo.addActionListener(new FieldChangeListener((JComponent)this.osCombo, IssueField.OS, this.platformWarning, (JComponent)this.platformLabel, Pair.of((Object)IssueField.PLATFORM, (Object)this.platformCombo), Pair.of((Object)IssueField.OS, (Object)this.osCombo)));
        this.statusCombo.addActionListener(new FieldChangeListener(this.statusCombo, IssueField.STATUS, this.statusWarning, this.statusLabel));
        this.resolutionCombo.addActionListener(new FieldChangeListener(this.resolutionCombo, IssueField.RESOLUTION, this.resolutionWarning, this.resolutionLabel));
        this.duplicateField.getDocument().addDocumentListener(new FieldChangeListener((JComponent)this.duplicateField, IssueField.DUPLICATE_ID, this.duplicateWarning, (JComponent)this.duplicateLabel, Bundle.LBL_Duplicate_fieldName()){

            @Override
            public void fieldModified() {
                if (!IssuePanel.this.reloading && IssuePanel.this.duplicateField.isVisible() && IssuePanel.this.duplicateField.isEditable()) {
                    IssuePanel.this.storeFieldValue(IssueField.DUPLICATE_ID, IssuePanel.this.duplicateField);
                    this.updateDecorations();
                }
            }
        });
        boolean showIssueType = BugzillaUtil.showIssueType(this.issue.getRepository());
        this.priorityCombo.addActionListener(new FieldChangeListener((JComponent)this.priorityCombo, IssueField.PRIORITY, this.priorityWarning, (JComponent)this.priorityLabel, Pair.of((Object)IssueField.PRIORITY, (Object)this.priorityCombo), showIssueType ? Pair.of((Object)IssueField.ISSUE_TYPE, (Object)this.issueTypeCombo) : Pair.of((Object)IssueField.SEVERITY, (Object)this.severityCombo)));
        this.issueTypeCombo.addActionListener(new FieldChangeListener((JComponent)this.issueTypeCombo, IssueField.ISSUE_TYPE, this.priorityWarning, (JComponent)this.priorityLabel, Pair.of((Object)IssueField.PRIORITY, (Object)this.priorityCombo), Pair.of((Object)IssueField.ISSUE_TYPE, (Object)this.issueTypeCombo)));
        this.severityCombo.addActionListener(new FieldChangeListener((JComponent)this.severityCombo, IssueField.SEVERITY, this.priorityWarning, (JComponent)this.priorityLabel, Pair.of((Object)IssueField.PRIORITY, (Object)this.priorityCombo), Pair.of((Object)IssueField.SEVERITY, (Object)this.severityCombo)));
        this.targetMilestoneCombo.addActionListener(new FieldChangeListener(this.targetMilestoneCombo, IssueField.MILESTONE, this.milestoneWarning, this.targetMilestoneLabel));
        this.assignToDefaultCheckBox.addActionListener(new FieldChangeListener(this.assignToDefaultCheckBox, IssueField.REASSIGN_TO_DEFAULT));
        this.urlField.getDocument().addDocumentListener(new FieldChangeListener(this.urlField, IssueField.URL, this.urlWarning, (JComponent)this.urlLabel));
        this.statusWhiteboardField.getDocument().addDocumentListener(new FieldChangeListener(this.statusWhiteboardField, IssueField.WHITEBOARD, this.statusWhiteboardWarning, this.statusWhiteboardLabel));
        this.keywordsField.getDocument().addDocumentListener(new FieldChangeListener(this.keywordsField, IssueField.KEYWORDS, this.keywordsWarning, this.keywordsLabel));
        this.qaContactField.getDocument().addDocumentListener(new FieldChangeListener(this.qaContactField, IssueField.QA_CONTACT, this.qaContactWarning, this.qaContactLabel));
        this.ccField.getDocument().addDocumentListener(new FieldChangeListener(this.ccField, IssueField.CC, this.ccWarning, this.ccLabel){

            @Override
            public void fieldModified() {
                if (!IssuePanel.this.reloading) {
                    IssuePanel.this.storeCCValue();
                    this.updateDecorations();
                }
            }
        });
        this.dependsField.getDocument().addDocumentListener(new FieldChangeListener(this.dependsField, IssueField.DEPENDS_ON, this.dependsOnWarning, this.dependsLabel));
        this.blocksField.getDocument().addDocumentListener(new FieldChangeListener(this.blocksField, IssueField.BLOCKS, this.blocksWarning, this.blocksLabel));
        this.assignedField.getDocument().addDocumentListener(new FieldChangeListener(this.assignedField, IssueField.ASSIGNED_TO, this.assignedToWarning, this.assignedLabel));
        this.assignedCombo.addActionListener(new FieldChangeListener(this.assignedCombo, IssueField.ASSIGNED_TO, this.assignedToWarning, this.assignedLabel));
        this.estimatedField.getDocument().addDocumentListener(new FieldChangeListener(this.estimatedField, IssueField.ESTIMATED_TIME, this.timetrackingWarning, this.estimatedLabel));
        this.workedField.getDocument().addDocumentListener(new FieldChangeListener(this.workedField, IssueField.WORK_TIME, this.timetrackingWarning, this.workedLabel));
        this.remainingField.getDocument().addDocumentListener(new FieldChangeListener(this.remainingField, IssueField.REMAINING_TIME, this.timetrackingWarning, this.remainingLabel));
        this.deadlinePicker.addChangeListener((ChangeListener)new FieldChangeListener(this.deadlinePicker.getComponent(), IssueField.DEADLINE, this.timetrackingWarning, (JComponent)this.deadlineLabel, new Pair[]{Pair.of((Object)IssueField.DEADLINE, (Object)this.deadlinePicker)}){

            @Override
            void fieldModified() {
                if (!IssuePanel.this.reloading && this.isEnabled()) {
                    String value;
                    Date date = IssuePanel.this.deadlinePicker.getDate();
                    String string = value = date == null ? "" : BugzillaIssue.DUE_DATE_FORMAT.format(date);
                    if (!IssuePanel.this.issue.getFieldValue(IssueField.DEADLINE).equals(value)) {
                        IssuePanel.this.addUnsavedField(IssueField.DEADLINE.getKey());
                        IssuePanel.this.issue.setFieldValue(IssueField.DEADLINE, value);
                        this.updateDecorations();
                    }
                }
            }
        });
        this.attachLogCheckBox.addActionListener(new FieldChangeListener(this.attachLogCheckBox, IssueField.NB_ATTACH_IDE_LOG){

            @Override
            void fieldModified() {
                if (!IssuePanel.this.reloading && this.isEnabled() && IssuePanel.this.issue.isNew()) {
                    boolean selected = IssuePanel.this.attachLogCheckBox.isSelected();
                    IssuePanel.this.storeFieldValue(IssueField.NB_ATTACH_IDE_LOG, selected ? "1" : "");
                    BugzillaConfig.getInstance().putAttachLogFile(selected);
                }
            }
        });
        this.attachmentsPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!IssuePanel.this.reloading && IssuePanel.this.attachmentsPanel.isVisible() && IssuePanel.this.issue.setUnsubmittedAttachments(IssuePanel.this.attachmentsPanel.getNewAttachments())) {
                    IssuePanel.this.addUnsavedField(IssueField.NB_NEW_ATTACHMENTS.getKey());
                    IssuePanel.this.updateAttachmentsStatus();
                }
            }
        });
        this.privateNotesField.getDocument().addDocumentListener(new TaskAttributeListener(this.privateNotesField, ATTRIBUTE_PRIVATE_NOTES, this.notesLabel){

            @Override
            protected boolean storeValue() {
                IssuePanel.this.issue.setTaskPrivateNotes(IssuePanel.this.privateNotesField.getText());
                return true;
            }
        });
        this.dueDatePicker.addChangeListener((ChangeListener)new DatePickerListener(this.dueDatePicker.getComponent(), ATTRIBUTE_DUE_DATE, this.dueDateLabel){

            @Override
            protected boolean storeValue() {
                IssuePanel.this.issue.setTaskDueDate(IssuePanel.this.dueDatePicker.getDate(), false);
                return true;
            }
        });
        this.scheduleDatePicker.addChangeListener((ChangeListener)new DatePickerListener(this.scheduleDatePicker.getComponent(), ATTRIBUTE_SCHEDULE_DATE, this.scheduleDateLabel){

            @Override
            protected boolean storeValue() {
                IssuePanel.this.issue.setTaskScheduleDate(IssuePanel.this.scheduleDatePicker.getScheduleDate(), false);
                return true;
            }
        });
        this.estimateField.getDocument().addDocumentListener(new TaskAttributeListener(this.estimateField, ATTRIBUTE_ESTIMATE, this.estimateLabel){

            @Override
            protected boolean storeValue() {
                int value = ((Number)IssuePanel.this.estimateField.getValue()).intValue();
                if (value != IssuePanel.this.issue.getEstimate()) {
                    IssuePanel.this.issue.setTaskEstimate(value, false);
                    return true;
                }
                return false;
            }
        });
    }

    private void setupCustomFieldsListeners() {
        for (CustomFieldInfo field : this.customFields) {
            if (field.comp instanceof JTextComponent) {
                ((JTextComponent)field.comp).getDocument().addDocumentListener(new FieldChangeListener(field.comp, field.field, field.warning, field.label));
                continue;
            }
            if (field.comp instanceof JComboBox) {
                ((JComboBox)field.comp).addActionListener(new FieldChangeListener(field.comp, field.field, field.warning, field.label));
                continue;
            }
            if (field.comp instanceof JList) {
                ((JList)field.comp).addListSelectionListener(new FieldChangeListener(field.comp, field.field, field.warning, field.label));
                continue;
            }
            Bugzilla.LOG.log(Level.INFO, "Custom field component {0} is not supported!", field.comp);
        }
    }

    private Action[] getAttributesSectionActions() {
        if (this.attributesSectionActions == null) {
            this.attributesSectionActions = new Action[]{new AbstractAction(Bundle.IssuePanel_reloadButton_text()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IssuePanel.this.reloadButtonActionPerformed(e);
                }
            }};
        }
        return this.attributesSectionActions;
    }

    private Action[] getCommentsSectionActions() {
        if (this.commentsSectionActions == null) {
            this.commentsSectionActions = new Action[]{new AbstractAction(Bundle.IssuePanel_commentsSectionAction_collapse_text()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IssuePanel.this.commentsPanel.collapseAll();
                    IssuePanel.this.commentsSection.setExpanded(false);
                }
            }, new AbstractAction(Bundle.IssuePanel_commentsSectionAction_expand_text()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IssuePanel.this.commentsPanel.expandAll();
                    IssuePanel.this.commentsSection.setExpanded(true);
                }
            }};
        }
        return this.commentsSectionActions;
    }

    private Action[] getAttachmentsSectionActions() {
        if (this.attachmentsSectionActions == null) {
            ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
            actions.add(new AbstractAction(Bundle.CTL_Attachment_action_create()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IssuePanel.this.attachmentsSection.setExpanded(true);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            IssuePanel.this.attachmentsPanel.createAttachment();
                        }
                    });
                }
            });
            if (NBBugzillaUtils.isNbRepository((String)this.issue.getRepository().getUrl())) {
                actions.add(new AbstractAction(Bundle.CTL_Attachment_action_attachLog()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        IssuePanel.this.attachmentsSection.setExpanded(true);
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                IssuePanel.this.attachmentsPanel.createNbLogAttachment();
                            }
                        });
                    }
                });
            }
            this.attachmentsSectionActions = actions.toArray(new Action[actions.size()]);
        }
        return this.attachmentsSectionActions;
    }

    private Action[] getPrivateSectionActions() {
        if (this.privateSectionActions == null) {
            this.privateSectionActions = new Action[]{new AbstractAction(Bundle.IssuePanel_addToCategory_text()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Bugzilla.getInstance().getBugtrackingFactory().addToCategory((Object)IssuePanel.this.issue.getRepository(), (Object)IssuePanel.this.issue);
                }
            }};
        }
        return this.privateSectionActions;
    }

    private void storeFieldValueForNewIssue(IssueField f, JComponent component) {
        if (this.reloading && this.initializingNewTask) {
            if (component instanceof JTextComponent) {
                this.issue.setFieldValue(f, ((JTextComponent)component).getText());
            } else if (component instanceof JComboBox) {
                Object value = ((JComboBox)component).getSelectedItem();
                this.issue.setFieldValue(f, value == null ? "" : value.toString());
            }
        }
    }

    private void clearHighlights() {
        this.fieldsConflict.clear();
        this.fieldsIncoming.clear();
        this.fieldsLocal.clear();
    }

    private void updateIcon(JLabel label) {
        label.setToolTipText(null);
        label.setIcon(null);
        Map conflicts = (Map)this.tooltipsConflict.get(label);
        Map local = (Map)this.tooltipsLocal.get(label);
        Map remote = (Map)this.tooltipsIncoming.get(label);
        if (conflicts != null || local != null || remote != null) {
            if (conflicts != null) {
                label.setIcon(ICON_CONFLICT);
            } else if (local != null) {
                label.setIcon(ICON_UNSUBMITTED);
            } else {
                label.setIcon(ICON_REMOTE);
            }
            StringBuilder sb = new StringBuilder("<html>");
            this.appendTooltips(sb, conflicts);
            this.appendTooltips(sb, local);
            this.appendTooltips(sb, remote);
            sb.append("</html>");
            label.setToolTipText(sb.toString());
        }
    }

    private void appendTooltips(StringBuilder sb, Map<IssueField, String> tooltips) {
        if (tooltips != null) {
            for (Map.Entry<IssueField, String> e : tooltips.entrySet()) {
                sb.append(e.getValue());
            }
        }
    }

    private void removeTooltips(JLabel label, IssueField field) {
        this.tooltipsConflict.removeTooltip(label, field);
        this.tooltipsIncoming.removeTooltip(label, field);
        this.tooltipsLocal.removeTooltip(label, field);
    }

    private void initializeNewTask() {
        this.initializingNewTask = true;
        if (BugzillaUtil.isNbRepository(this.issue.getRepository())) {
            this.addNetbeansInfo();
            this.issue.setFieldValue(IssueField.NB_ATTACH_IDE_LOG, this.attachLogCheckBox.isSelected() ? "1" : "0");
        }
        this.selectProduct();
        this.initializingNewTask = false;
    }

    private void updateNoDuplicateId() {
        boolean newNoDuplicateId;
        boolean bl = newNoDuplicateId = "DUPLICATE".equals(this.resolutionCombo.getSelectedItem()) && this.duplicateField.isVisible() && "".equals(this.duplicateField.getText().trim());
        if (newNoDuplicateId != this.noDuplicateId) {
            this.noDuplicateId = newNoDuplicateId;
            this.updateMessagePanel();
        }
    }

    static {
        incomingChangesColor = UIManager.getColor("nb.bugtracking.label.highlight");
        if (null == incomingChangesColor) {
            incomingChangesColor = new Color(217, 255, 217);
        }
        estimateFormatter = new NumberFormatter(new DecimalFormat("#0")){

            @Override
            public Object stringToValue(String text) throws ParseException {
                Number value = (Number)super.stringToValue(text);
                if (value == null) {
                    value = 0;
                }
                if (value.intValue() < 0) {
                    return 0;
                }
                return value.intValue();
            }
        };
    }

    class CancelHighlightDocumentListener
    implements DocumentListener {
        private final JComponent label;

        CancelHighlightDocumentListener(JComponent label) {
            this.label = label;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            IssuePanel.this.cancelHighlight(this.label);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            IssuePanel.this.cancelHighlight(this.label);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            IssuePanel.this.cancelHighlight(this.label);
        }
    }

    private static class CustomFieldInfo {
        CustomIssueField field;
        JLabel label;
        JComponent comp;
        JLabel warning;

        CustomFieldInfo(CustomIssueField field, JLabel label, JComponent comp, JLabel warning) {
            this.field = field;
            this.label = label;
            this.comp = comp;
            this.warning = warning;
        }
    }

    class CyclicDependencyDocumentListener
    implements DocumentListener {
        CyclicDependencyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            Set<Integer> bugs1 = this.bugs(IssuePanel.this.blocksField.getText());
            Set<Integer> bugs2 = this.bugs(IssuePanel.this.dependsField.getText());
            bugs1.retainAll(bugs2);
            if (bugs1.isEmpty()) {
                if (IssuePanel.this.cyclicDependency) {
                    IssuePanel.this.cyclicDependency = false;
                    IssuePanel.this.updateMessagePanel();
                }
            } else if (!IssuePanel.this.cyclicDependency) {
                IssuePanel.this.cyclicDependency = true;
                IssuePanel.this.updateMessagePanel();
            }
        }

        private Set<Integer> bugs(String values) {
            HashSet<Integer> bugs = new HashSet<Integer>();
            StringTokenizer st = new StringTokenizer(values, ", \t\n\r\f");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                try {
                    bugs.add(Integer.parseInt(token));
                }
                catch (NumberFormatException nfex) {}
            }
            return bugs;
        }
    }

    private abstract class DatePickerListener
    implements ChangeListener {
        private final String attributeName;
        private final JComponent component;
        private final JComponent fieldLabel;

        public DatePickerListener(JComponent component, String attributeName, JComponent fieldLabel) {
            this.component = component;
            this.attributeName = attributeName;
            this.fieldLabel = fieldLabel;
        }

        void fieldModified() {
            if (!IssuePanel.this.reloading && this.isEnabled() && this.storeValue()) {
                IssuePanel.this.addUnsavedField(this.attributeName);
                this.updateDecorations();
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.fieldModified();
        }

        public boolean isEnabled() {
            return this.component.isVisible() && this.component.isEnabled();
        }

        protected final void updateDecorations() {
            IssuePanel.this.updateFieldDecorations(this.attributeName, this.fieldLabel);
        }

        protected abstract boolean storeValue();
    }

    private class DuplicateListener
    implements DocumentListener {
        private DuplicateListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            IssuePanel.this.updateNoDuplicateId();
        }
    }

    private class FieldChangeListener
    implements DocumentListener,
    ActionListener,
    ListSelectionListener,
    ChangeListener {
        private final IssueField field;
        private final JComponent component;
        private final JLabel warningLabel;
        private final JComponent fieldLabel;
        private final String fieldName;
        private Pair<IssueField, ? extends Object>[] decoratedFields;

        public FieldChangeListener(JComponent component, IssueField field) {
            this(component, field, null, null);
        }

        public FieldChangeListener(JComponent component, IssueField field, JLabel warningLabel, JComponent fieldLabel) {
            this(component, field, warningLabel, fieldLabel, Pair.of((Object)field, (Object)component));
        }

        public FieldChangeListener(JComponent component, IssueField field, JLabel warningLabel, JComponent fieldLabel, String fieldName) {
            this(component, field, warningLabel, fieldLabel, fieldName, Pair.of((Object)field, (Object)component));
        }

        public FieldChangeListener(JComponent component, IssueField field, JLabel warningLabel, JComponent fieldLabel, Pair<IssueField, ? extends Object> ... multiField) {
            this(component, field, warningLabel, fieldLabel, fieldLabel == null ? null : issuePanel.fieldName(fieldLabel), multiField);
        }

        public FieldChangeListener(JComponent component, IssueField field, JLabel warningLabel, JComponent fieldLabel, String fieldName, Pair<IssueField, ? extends Object> ... multiField) {
            this.component = component;
            this.field = field;
            this.warningLabel = warningLabel;
            this.fieldLabel = fieldLabel;
            this.fieldName = fieldName;
            this.decoratedFields = multiField;
        }

        @Override
        public final void insertUpdate(DocumentEvent e) {
            this.fieldModified();
        }

        @Override
        public final void removeUpdate(DocumentEvent e) {
            this.fieldModified();
        }

        @Override
        public final void changedUpdate(DocumentEvent e) {
            this.fieldModified();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.component) {
                this.fieldModified();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting() && e.getSource() == this.component) {
                this.fieldModified();
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.fieldModified();
        }

        void fieldModified() {
            if (!IssuePanel.this.reloading && this.isEnabled()) {
                if (this.component instanceof JTextComponent) {
                    IssuePanel.this.storeFieldValue(this.field, (JTextComponent)this.component);
                    this.updateDecorations();
                } else if (this.component instanceof JList) {
                    IssuePanel.this.storeFieldValue(this.field, (JList)this.component);
                    this.updateDecorations();
                } else if (this.component instanceof JComboBox) {
                    Object value = ((JComboBox)this.component).getSelectedItem();
                    if (value != null && IssuePanel.this.assignToDefaultCheckBox.isVisible() && !IssuePanel.this.assignToDefaultCheckBox.isSelected()) {
                        if (this.component == IssuePanel.this.productCombo && !value.equals(IssuePanel.this.issue.getFieldValue(IssueField.PRODUCT))) {
                            IssuePanel.this.assignToDefaultCheckBox.doClick();
                        } else if (this.component == IssuePanel.this.componentCombo && !value.equals(IssuePanel.this.issue.getFieldValue(IssueField.COMPONENT))) {
                            IssuePanel.this.assignToDefaultCheckBox.doClick();
                        }
                    }
                    IssuePanel.this.storeFieldValue(this.field, (JComboBox)this.component);
                    this.updateDecorations();
                } else if (this.component instanceof JCheckBox) {
                    IssuePanel.this.storeFieldValue(this.field, ((JCheckBox)this.component).isSelected() ? "1" : "0");
                    this.updateDecorations();
                }
            }
        }

        public boolean isEnabled() {
            return this.component.isVisible() && this.component.isEnabled();
        }

        protected final void updateDecorations() {
            IssuePanel.this.updateFieldDecorations(this.warningLabel, this.fieldLabel, this.fieldName, this.decoratedFields);
        }
    }

    private class FormListener
    implements ActionListener,
    FocusListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == IssuePanel.this.refreshButton) {
                IssuePanel.this.refreshButtonActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.cancelButton) {
                IssuePanel.this.cancelButtonActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.showInBrowserButton) {
                IssuePanel.this.showInBrowserButtonActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.submitButton) {
                IssuePanel.this.submitButtonActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.btnDeleteTask) {
                IssuePanel.this.btnDeleteTaskActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.resolutionCombo) {
                IssuePanel.this.resolutionComboActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.assignedCombo) {
                IssuePanel.this.assignedComboActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.osCombo) {
                IssuePanel.this.osComboActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.dependsOnButton) {
                IssuePanel.this.dependsOnButtonActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.componentCombo) {
                IssuePanel.this.componentComboActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.urlLabel) {
                IssuePanel.this.urlButtonActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.priorityCombo) {
                IssuePanel.this.priorityComboActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.issueTypeCombo) {
                IssuePanel.this.issueTypeComboActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.blocksButton) {
                IssuePanel.this.blocksButtonActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.duplicateButton) {
                IssuePanel.this.duplicateButtonActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.productCombo) {
                IssuePanel.this.productComboActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.versionCombo) {
                IssuePanel.this.versionComboActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.platformCombo) {
                IssuePanel.this.platformComboActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.severityCombo) {
                IssuePanel.this.severityComboActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.targetMilestoneCombo) {
                IssuePanel.this.targetMilestoneComboActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.statusCombo) {
                IssuePanel.this.statusComboActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.keywordsButton) {
                IssuePanel.this.keywordsButtonActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.attachLogCheckBox) {
                IssuePanel.this.attachLogCheckBoxActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.viewLogButton) {
                IssuePanel.this.viewLogButtonActionPerformed(evt);
            }
        }

        @Override
        public void focusGained(FocusEvent evt) {
        }

        @Override
        public void focusLost(FocusEvent evt) {
            if (evt.getSource() == IssuePanel.this.workedField) {
                IssuePanel.this.workedFieldFocusLost(evt);
            }
        }
    }

    private static class PriorityRenderer
    extends DefaultListCellRenderer {
        private PriorityRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            renderer.setIcon(BugzillaConfig.getInstance().getPriorityIcon((String)value));
            return renderer;
        }
    }

    class RevalidatingListener
    implements DocumentListener,
    Runnable {
        private boolean ignoreUpdate;

        RevalidatingListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (this.ignoreUpdate) {
                return;
            }
            this.ignoreUpdate = true;
            EventQueue.invokeLater(this);
        }

        @Override
        public void run() {
            IssuePanel.this.revalidate();
            IssuePanel.this.repaint();
            this.ignoreUpdate = false;
        }
    }

    private abstract class TaskAttributeListener
    implements DocumentListener {
        private final String attributeName;
        private final JComponent component;
        private final JComponent fieldLabel;

        public TaskAttributeListener(JComponent component, String attributeName, JComponent fieldLabel) {
            this.component = component;
            this.attributeName = attributeName;
            this.fieldLabel = fieldLabel;
        }

        @Override
        public final void insertUpdate(DocumentEvent e) {
            this.fieldModified();
        }

        @Override
        public final void removeUpdate(DocumentEvent e) {
            this.fieldModified();
        }

        @Override
        public final void changedUpdate(DocumentEvent e) {
            this.fieldModified();
        }

        void fieldModified() {
            if (!IssuePanel.this.reloading && this.isEnabled() && this.storeValue()) {
                IssuePanel.this.addUnsavedField(this.attributeName);
                this.updateDecorations();
            }
        }

        public boolean isEnabled() {
            return this.component.isVisible() && this.component.isEnabled();
        }

        protected final void updateDecorations() {
            IssuePanel.this.updateFieldDecorations(this.attributeName, this.fieldLabel);
        }

        protected abstract boolean storeValue();
    }

    private static class TooltipsMap
    extends HashMap<JLabel, Map<IssueField, String>> {
        private TooltipsMap() {
        }

        private void removeTooltip(JLabel label, IssueField field) {
            Map fields = (Map)this.get(label);
            if (fields != null) {
                fields.remove(field);
                if (fields.isEmpty()) {
                    this.remove(label);
                }
            }
        }

        private void addTooltip(JLabel label, IssueField field, String tooltip) {
            LinkedHashMap<IssueField, String> fields = (LinkedHashMap<IssueField, String>)this.get(label);
            if (fields == null) {
                fields = new LinkedHashMap<IssueField, String>(2);
                this.put(label, fields);
            }
            fields.put(field, tooltip);
        }
    }
}

