/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.query.BugzillaQuery;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.netbeans.modules.mylyn.util.MylynSupport;
import org.openide.modules.Places;
import org.openide.util.ImageUtilities;
import org.openide.util.NbPreferences;

public class BugzillaConfig {
    private static BugzillaConfig instance = null;
    private static final String LAST_CHANGE_FROM = "bugzilla.last_change_from";
    private static final String QUERY_NAME = "bugzilla.query_";
    private static final String QUERY_LAST_REFRESH = "bugzilla.query_last_refresh";
    private static final String DELIMITER = "<=>";
    private static final String ATTACH_LOG = "bugzilla.attach_log";
    private static final String PREF_SECTION_COLLAPSED = "collapsedSection";
    private static final String PREF_TASK = "task.";
    private static final Level LOG_LEVEL = BugzillaUtil.isAssertEnabled() ? Level.SEVERE : Level.INFO;
    public static final int DEFAULT_QUERY_REFRESH = 30;
    public static final int DEFAULT_ISSUE_REFRESH = 15;
    private Map<String, Icon> priorityIcons;
    private Map<String, URL> priorityIconsURL;

    private BugzillaConfig() {
    }

    public static BugzillaConfig getInstance() {
        if (instance == null) {
            instance = new BugzillaConfig();
        }
        return instance;
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(BugzillaConfig.class);
    }

    public boolean getAttachLogFile() {
        return this.getPreferences().getBoolean(ATTACH_LOG, true);
    }

    public void putAttachLogFile(boolean attach) {
        this.getPreferences().putBoolean(ATTACH_LOG, attach);
    }

    public void putQuery(BugzillaRepository repository, BugzillaQuery query) {
        this.getPreferences().put(this.getQueryKey(repository.getID(), query.getDisplayName()), query.getUrlParameters() + DELIMITER + DELIMITER + query.isUrlDefined());
    }

    public void removeQuery(BugzillaRepository repository, BugzillaQuery query) {
        this.getPreferences().remove(this.getQueryKey(repository.getID(), query.getDisplayName()));
        try {
            IRepositoryQuery iquery;
            String storedName = query.getStoredQueryName();
            IRepositoryQuery iRepositoryQuery = iquery = storedName == null ? null : MylynSupport.getInstance().getRepositoryQuery(repository.getTaskRepository(), storedName);
            if (iquery != null) {
                MylynSupport.getInstance().deleteQuery(iquery);
            }
        }
        catch (CoreException ex) {
            Bugzilla.LOG.log(Level.WARNING, null, ex);
        }
    }

    public BugzillaQuery getQuery(BugzillaRepository repository, String queryName) {
        String value = this.getStoredQuery(repository, queryName);
        if (value == null) {
            return null;
        }
        String[] values = value.split(DELIMITER);
        assert (values.length >= 2) : "worng amount of stored query data " + values.length + " in query " + queryName;
        String urlParams = values[0];
        boolean urlDef = values.length > 2 ? Boolean.parseBoolean(values[2]) : false;
        return repository.createPersistentQuery(queryName, urlParams, urlDef);
    }

    public String getUrlParams(BugzillaRepository repository, String queryName) {
        String value = this.getStoredQuery(repository, queryName);
        if (value == null) {
            return null;
        }
        String[] values = value.split(DELIMITER);
        assert (values.length >= 2);
        return values[0];
    }

    public String[] getQueries(String repoID) {
        return this.getKeysWithPrefix(QUERY_NAME + repoID + DELIMITER);
    }

    public long getLastQueryRefresh(BugzillaRepository repository, String queryName) {
        return this.getPreferences().getLong("bugzilla.query_last_refresh_" + this.getQueryKey(repository.getID(), queryName), -1L);
    }

    public void putLastQueryRefresh(BugzillaRepository repository, String queryName, long lastRefresh) {
        this.getPreferences().putLong("bugzilla.query_last_refresh_" + this.getQueryKey(repository.getID(), queryName), lastRefresh);
    }

    private String[] getKeysWithPrefix(String prefix) {
        String[] keys = null;
        try {
            keys = this.getPreferences().keys();
        }
        catch (BackingStoreException ex) {
            Bugzilla.LOG.log(Level.SEVERE, null, ex);
        }
        if (keys == null || keys.length == 0) {
            return new String[0];
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (String key : keys) {
            if (!key.startsWith(prefix)) continue;
            ret.add(key.substring(prefix.length()));
        }
        return ret.toArray(new String[ret.size()]);
    }

    private String getQueryKey(String repositoryID, String queryName) {
        return QUERY_NAME + repositoryID + DELIMITER + queryName;
    }

    private String getStoredQuery(BugzillaRepository repository, String queryName) {
        String value = this.getPreferences().get(this.getQueryKey(repository.getID(), queryName), null);
        return value;
    }

    public void setLastChangeFrom(String value) {
        this.getPreferences().put(LAST_CHANGE_FROM, value);
    }

    public String getLastChangeFrom() {
        return this.getPreferences().get(LAST_CHANGE_FROM, "");
    }

    public Icon getPriorityIcon(String priority) {
        if (this.priorityIcons == null) {
            this.priorityIcons = new HashMap<String, Icon>();
            this.priorityIcons.put("P1", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/p1.png", (boolean)true));
            this.priorityIcons.put("P2", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/p2.png", (boolean)true));
            this.priorityIcons.put("P3", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/p3.png", (boolean)true));
            this.priorityIcons.put("P4", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/p4.png", (boolean)true));
            this.priorityIcons.put("P5", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/p5.png", (boolean)true));
        }
        return this.priorityIcons.get(priority);
    }

    public URL getPriorityIconURL(String priority) {
        if (this.priorityIconsURL == null) {
            this.priorityIconsURL = new HashMap<String, URL>();
            this.priorityIconsURL.put("P1", BugzillaConfig.class.getClassLoader().getResource("org/netbeans/modules/bugzilla/resources/p1.png"));
            this.priorityIconsURL.put("P2", BugzillaConfig.class.getClassLoader().getResource("org/netbeans/modules/bugzilla/resources/p2.png"));
            this.priorityIconsURL.put("P3", BugzillaConfig.class.getClassLoader().getResource("org/netbeans/modules/bugzilla/resources/p3.png"));
            this.priorityIconsURL.put("P4", BugzillaConfig.class.getClassLoader().getResource("org/netbeans/modules/bugzilla/resources/p4.png"));
            this.priorityIconsURL.put("P5", BugzillaConfig.class.getClassLoader().getResource("org/netbeans/modules/bugzilla/resources/p5.png"));
        }
        return this.priorityIconsURL.get(priority);
    }

    public void setEditorSectionCollapsed(String repositoryId, String taskId, String sectionName, boolean collapsed) {
        String key = this.getTaskKey(repositoryId, taskId) + PREF_SECTION_COLLAPSED + sectionName;
        this.getPreferences().putBoolean(key, collapsed);
    }

    public boolean isEditorSectionCollapsed(String repositoryId, String taskId, String sectionName, boolean defaultValue) {
        String key = this.getTaskKey(repositoryId, taskId) + PREF_SECTION_COLLAPSED + sectionName;
        return this.getPreferences().getBoolean(key, defaultValue);
    }

    private String getTaskKey(String repositoryId, String taskId) {
        return PREF_TASK + repositoryId + "." + taskId + ".";
    }

    private static String getNBConfigPath() {
        String t9yNbConfigPath = System.getProperty("netbeans.t9y.bugzilla.nb.config.path");
        if (t9yNbConfigPath != null && t9yNbConfigPath.length() > 0) {
            return t9yNbConfigPath;
        }
        String nbHome = Places.getUserDirectory().getAbsolutePath();
        return nbHome + "/config/issue-tracking/org-netbeans-modules-bugzilla";
    }
}

