/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class VerifyClassLinkage
extends Task {
    private File jar;
    private boolean failOnError = true;
    private boolean warnOnDefaultPackage = true;
    private Path classpath = new Path(this.getProject());
    private String ignores;
    private int maxWarnings = Integer.MAX_VALUE;

    public Path createClasspath() {
        return this.classpath.createPath();
    }

    public void setJar(File jar) {
        this.jar = jar;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setIgnores(String ignores) {
        this.ignores = ignores;
    }

    public void setWarnOnDefaultPackage(boolean warnOnDefaultPackage) {
        this.warnOnDefaultPackage = warnOnDefaultPackage;
    }

    public void setMaxWarnings(int maxWarnings) {
        if (maxWarnings <= 0) {
            throw new IllegalArgumentException();
        }
        this.maxWarnings = maxWarnings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.jar == null) {
            throw new BuildException("Must specify a JAR file", this.getLocation());
        }
        try {
            HashMap<String, Boolean> loadable = new HashMap<String, Boolean>();
            TreeMap<String, byte[]> classfiles = new TreeMap<String, byte[]>();
            try (JarFile jf = new JarFile(this.jar);){
                VerifyClassLinkage.read(jf, classfiles, new HashSet<File>(Collections.singleton(this.jar)), this, this.ignores);
            }
            for (String clazz : classfiles.keySet()) {
                loadable.put(clazz, Boolean.TRUE);
                if (!this.warnOnDefaultPackage || clazz.indexOf(46) != -1) continue;
                this.log("Warning: class '" + clazz + "' found in default package", 1);
            }
            AntClassLoader loader = new AntClassLoader(ClassLoader.getSystemClassLoader().getParent(), this.getProject(), this.classpath, true);
            AtomicInteger max = new AtomicInteger(this.maxWarnings);
            for (Map.Entry entry : classfiles.entrySet()) {
                String clazz = (String)entry.getKey();
                byte[] data = (byte[])entry.getValue();
                this.verify(clazz, data, loadable, (ClassLoader)loader, max);
                if (max.get() >= 0) continue;
                break;
            }
        }
        catch (IOException e) {
            throw new BuildException("While verifying " + this.jar + " or its Class-Path extensions: " + e, (Throwable)e, this.getLocation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void read(JarFile jf, Map<String, byte[]> classfiles, Set<File> alreadyRead, Task task, String ignores) throws IOException {
        String cp;
        File jar = new File(jf.getName());
        task.log("Reading " + jar, 3);
        Pattern p = ignores != null ? Pattern.compile(ignores) : null;
        Enumeration<JarEntry> e = jf.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            String name = entry.getName();
            if (!name.endsWith(".class")) continue;
            String clazz = name.substring(0, name.length() - 6).replace('/', '.');
            if (p != null && p.matcher(clazz).matches()) continue;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(Math.max((int)entry.getSize(), 0));
            try (InputStream is = jf.getInputStream(entry);){
                int read;
                byte[] buf = new byte[4096];
                while ((read = is.read(buf)) != -1) {
                    baos.write(buf, 0, read);
                }
            }
            classfiles.put(clazz, baos.toByteArray());
        }
        Manifest mf = jf.getManifest();
        if (mf != null && (cp = mf.getMainAttributes().getValue(Attributes.Name.CLASS_PATH)) != null) {
            String[] uris = cp.trim().split("[, ]+");
            for (int i = 0; i < uris.length; ++i) {
                File otherJar;
                String path = uris[i];
                if (path.equals("${java.home}/lib/ext/jfxrt.jar")) {
                    File jdk7;
                    String jhm = System.getProperty("java.home");
                    File classpathFile = new File(new File(new File(new File(jhm), "lib"), "ext"), "jfxrt.jar");
                    if (!classpathFile.exists() && (jdk7 = new File(new File(new File(jhm), "lib"), "jfxrt.jar")).exists()) {
                        classpathFile = jdk7;
                    }
                    if (!classpathFile.isFile()) {
                        task.log("Could not resolve Class-Path item in manifest, path is:" + path + ", skipping", 1);
                        continue;
                    }
                    path = classpathFile.getAbsolutePath();
                }
                if (alreadyRead.add(otherJar = new File(jar.toURI().resolve(path)))) {
                    if (!otherJar.isFile()) continue;
                    try (JarFile otherJF = new JarFile(otherJar);){
                        VerifyClassLinkage.read(otherJF, classfiles, alreadyRead, task, ignores);
                        continue;
                    }
                }
                task.log("Already read " + jar, 3);
            }
        }
    }

    private void verify(String clazz, byte[] data, Map<String, Boolean> loadable, ClassLoader loader, AtomicInteger maxWarn) throws IOException, BuildException {
        Set<String> dependencies = VerifyClassLinkage.dependencies(data);
        for (String clazz2 : dependencies) {
            Boolean exists = loadable.get(clazz2);
            if (exists == null) {
                exists = loader.getResource(clazz2.replace('.', '/') + ".class") != null;
                loadable.put(clazz2, exists);
            }
            if (exists.booleanValue()) continue;
            String message = clazz + " cannot access " + clazz2;
            if (this.failOnError) {
                throw new BuildException(message, this.getLocation());
            }
            if (maxWarn.getAndDecrement() > 0) {
                this.log("Warning: " + message, 1);
                continue;
            }
            this.log("(additional warnings not reported)", 1);
            return;
        }
    }

    private static void skip(DataInput input, int bytes) throws IOException {
        int skipped = input.skipBytes(bytes);
        if (skipped != bytes) {
            throw new IOException("Truncated class file");
        }
    }

    static Set<String> dependencies(byte[] data) throws IOException {
        int i;
        TreeSet<String> result = new TreeSet<String>();
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(data));
        VerifyClassLinkage.skip(input, 8);
        int size = input.readUnsignedShort() - 1;
        String[] utf8Strings = new String[size];
        boolean[] isClassName = new boolean[size];
        boolean[] isDescriptor = new boolean[size];
        block8: for (i = 0; i < size; ++i) {
            byte tag = input.readByte();
            switch (tag) {
                case 1: {
                    utf8Strings[i] = input.readUTF();
                    continue block8;
                }
                case 7: {
                    int index = input.readUnsignedShort() - 1;
                    if (index >= size) {
                        throw new IOException("@" + i + ": CONSTANT_Class_info.name_index " + index + " too big for size of pool " + size);
                    }
                    isClassName[index] = true;
                    continue block8;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: {
                    VerifyClassLinkage.skip(input, 4);
                    continue block8;
                }
                case 12: {
                    VerifyClassLinkage.skip(input, 2);
                    int index = input.readUnsignedShort() - 1;
                    if (index >= size || index < 0) {
                        throw new IOException("@" + i + ": CONSTANT_NameAndType_info.descriptor_index " + index + " too big for size of pool " + size);
                    }
                    isDescriptor[index] = true;
                    continue block8;
                }
                case 8: {
                    VerifyClassLinkage.skip(input, 2);
                    continue block8;
                }
                case 5: 
                case 6: {
                    VerifyClassLinkage.skip(input, 8);
                    ++i;
                    continue block8;
                }
                default: {
                    throw new IOException("Unrecognized constant pool tag " + tag + " at index " + i + "; running UTF-8 strings: " + Arrays.asList(utf8Strings));
                }
            }
        }
        for (i = 0; i < size; ++i) {
            String s = utf8Strings[i];
            if (isClassName[i]) {
                while (s.charAt(0) == '[') {
                    s = s.substring(1);
                }
                if (s.length() == 1) continue;
                String c = s.charAt(s.length() - 1) == ';' && s.charAt(0) == 'L' ? s.substring(1, s.length() - 1) : s;
                result.add(c.replace('/', '.'));
                continue;
            }
            if (!isDescriptor[i]) continue;
            int idx = 0;
            while ((idx = s.indexOf(76, idx)) != -1) {
                int semi = s.indexOf(59, idx);
                if (semi == -1) {
                    throw new IOException("Invalid type or descriptor: " + s);
                }
                result.add(s.substring(idx + 1, semi).replace('/', '.'));
                idx = semi;
            }
        }
        return result;
    }
}

