/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.taskdefs.SignJar;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;
import org.netbeans.nbbuild.MakeJNLP;

public class JNLPUpdateManifestBranding
extends Task {
    private static final String MANIFEST = "META-INF/MANIFEST.MF";
    private static final String UTF_8 = "UTF-8";
    private static final String ATTR_CODEBASE = "Codebase";
    private static final String ATTR_PERMISSIONS = "Permissions";
    private static final String ATTR_APPLICATION_NAME = "Application-Name";
    private final Vector<FileSet> filesets = new Vector();
    private String appName;
    private final String permissions = "all-permissions";
    private final String codebase = "*";
    private SignJar signTask;
    private static final Pattern SF = Pattern.compile("META-INF/(.+)\\.SF");

    public void addFileset(FileSet fileset) {
        this.filesets.add(fileset);
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    private SignJar getSignTask() {
        if (this.signTask == null) {
            this.signTask = (SignJar)this.getProject().createTask("signjar");
        }
        return this.signTask;
    }

    public void setAlias(String a) {
        this.getSignTask().setAlias(a);
    }

    public void setStorePass(String p) {
        this.getSignTask().setStorepass(p);
    }

    public void setKeystore(String k) {
        this.getSignTask().setKeystore(k);
    }

    public void setStoreType(String t) {
        this.getSignTask().setStoretype(t);
    }

    public void execute() throws BuildException {
        HashSet<String> filePaths = new HashSet<String>();
        File tmpFile = null;
        for (FileSet fs : this.filesets) {
            if (fs == null) continue;
            DirectoryScanner scan = fs.getDirectoryScanner(this.getProject());
            for (String f : scan.getIncludedFiles()) {
                filePaths.add(fs.getDir().getAbsolutePath() + File.separatorChar + f.replace(File.separatorChar, '/'));
            }
        }
        try {
            for (String filePathIter : filePaths) {
                File jarFile = new File(filePathIter);
                if (JNLPUpdateManifestBranding.isSigned(jarFile) == null) {
                    tmpFile = this.extendLibraryManifest(this.getProject(), jarFile, jarFile, "*", "all-permissions", this.appName);
                }
                if (tmpFile != null) {
                    this.sign(tmpFile, jarFile);
                    JNLPUpdateManifestBranding.deleteTmpFile(tmpFile);
                    continue;
                }
                this.sign(jarFile, jarFile);
            }
        }
        catch (IOException ex) {
            this.getProject().log("Failed to extend libraries manifests: " + ex.getMessage(), 1);
        }
        catch (ManifestException ex) {
            this.getProject().log("Failed to extend libraries manifests: " + ex.getMessage(), 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File extendLibraryManifest(Project prj, File sourceJar, File signedJar, String codebase, String permissions, String appName) throws IOException, ManifestException {
        File tmpFile;
        block24: {
            Manifest manifest = null;
            Copy cp = new Copy();
            tmpFile = new File(String.format("%s.tmp", signedJar.getAbsolutePath()));
            cp.setFile(sourceJar);
            cp.setTofile(tmpFile);
            cp.execute();
            boolean success = false;
            try {
                HashMap<String, String> extendedAttrs = new HashMap<String, String>();
                try (ZipFile zf = new ZipFile(sourceJar);){
                    Manifest.Section mainSection;
                    String attr;
                    ZipEntry manifestEntry = zf.getEntry(MANIFEST);
                    if (manifestEntry != null) {
                        try (InputStreamReader in = new InputStreamReader(zf.getInputStream(manifestEntry), Charset.forName(UTF_8));){
                            manifest = new Manifest((Reader)in);
                        }
                    } else {
                        manifest = new Manifest();
                    }
                    if ((attr = (mainSection = manifest.getMainSection()).getAttributeValue(ATTR_CODEBASE)) == null) {
                        mainSection.addAttributeAndCheck(new Manifest.Attribute(ATTR_CODEBASE, codebase));
                        extendedAttrs.put(ATTR_CODEBASE, codebase);
                    }
                    if ((attr = mainSection.getAttributeValue(ATTR_PERMISSIONS)) == null) {
                        mainSection.addAttributeAndCheck(new Manifest.Attribute(ATTR_PERMISSIONS, permissions));
                        extendedAttrs.put(ATTR_PERMISSIONS, permissions);
                    }
                    if ((attr = mainSection.getAttributeValue(ATTR_APPLICATION_NAME)) == null) {
                        mainSection.addAttributeAndCheck(new Manifest.Attribute(ATTR_APPLICATION_NAME, appName));
                        extendedAttrs.put(ATTR_APPLICATION_NAME, appName);
                    }
                    if (extendedAttrs.isEmpty()) break block24;
                    Enumeration zent = zf.getEntries();
                    try (ZipOutputStream out = new ZipOutputStream(tmpFile);){
                        while (zent.hasMoreElements()) {
                            ZipEntry entry = (ZipEntry)zent.nextElement();
                            try (InputStream in = zf.getInputStream(entry);){
                                out.putNextEntry(entry);
                                if (MANIFEST.equals(entry.getName())) {
                                    PrintWriter manifestOut = new PrintWriter(new OutputStreamWriter((OutputStream)out, Charset.forName(UTF_8)));
                                    manifest.write(manifestOut);
                                    manifestOut.flush();
                                    continue;
                                }
                                JNLPUpdateManifestBranding.copy(in, (OutputStream)out);
                            }
                        }
                    }
                    success = true;
                    StringBuilder message = new StringBuilder("Updating library ").append(JNLPUpdateManifestBranding.safeRelativePath(prj.getBaseDir(), tmpFile)).append(" manifest");
                    for (Map.Entry e : extendedAttrs.entrySet()) {
                        message.append(String.format(" %s: %s,", e.getKey(), e.getValue()));
                    }
                    message.deleteCharAt(message.length() - 1);
                    prj.log(message.toString(), 3);
                }
            }
            finally {
                if (!success) {
                    Delete rm = new Delete();
                    rm.setFile(tmpFile);
                    rm.setQuiet(true);
                    rm.execute();
                    tmpFile = null;
                }
            }
        }
        return tmpFile;
    }

    private static void deleteTmpFile(File tmpFile) {
        Delete del = new Delete();
        del.setFile(tmpFile);
        del.execute();
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] BUFFER = new byte[4096];
        int len;
        while ((len = in.read(BUFFER)) != -1) {
            out.write(BUFFER, 0, len);
        }
        return;
    }

    private static String safeRelativePath(File from, File to) {
        try {
            return FileUtils.getRelativePath((File)from, (File)to);
        }
        catch (Exception ex) {
            return to.getAbsolutePath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String isSigned(File f) throws IOException {
        try (JarFile jar = new JarFile(f);){
            Enumeration<JarEntry> en = jar.entries();
            while (en.hasMoreElements()) {
                Matcher m = SF.matcher(en.nextElement().getName());
                if (!m.matches()) continue;
                String string = m.group(1);
                return string;
            }
            String string = null;
            return string;
        }
    }

    private void sign(File from, File to) {
        if (!from.exists() && from.getParentFile().getName().equals("locale")) {
            this.log("Localization file " + from + " is referenced, but cannot be found. Skipping.", 1);
            return;
        }
        this.getSignTask().setJar(from);
        if (to != null) {
            to.getParentFile().mkdirs();
        }
        this.getSignTask().setSignedjar(to);
        try {
            Class<?> sjClass = Class.forName("org.apache.tools.ant.taskdefs.SignJar");
            Method sdaMethod = sjClass.getDeclaredMethod("setDigestAlg", String.class);
            sdaMethod.invoke((Object)this.getSignTask(), "SHA1");
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MakeJNLP.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(MakeJNLP.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(MakeJNLP.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MakeJNLP.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(MakeJNLP.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(MakeJNLP.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.getSignTask().execute();
    }
}

