/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.Task;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class AutoUpdateCatalogParser
extends DefaultHandler {
    private final Map<String, ModuleItem> items;
    private final URL provider;
    private final EntityResolver entityResolver;
    private final URI baseUri;
    private static final Logger ERR = Logger.getLogger(AutoUpdateCatalogParser.class.getName());
    private static final String MODULE_UPDATES_ATTR_TIMESTAMP = "timestamp";
    private static final String MODULE_GROUP_ATTR_NAME = "name";
    private static final String NOTIFICATION_ATTR_URL = "url";
    private static final String LICENSE_ATTR_NAME = "name";
    private static final String MODULE_ATTR_CODE_NAME_BASE = "codenamebase";
    private static final String MODULE_ATTR_HOMEPAGE = "homepage";
    private static final String MODULE_ATTR_DISTRIBUTION = "distribution";
    private static final String MODULE_ATTR_DOWNLOAD_SIZE = "downloadsize";
    private static final String MODULE_ATTR_NEEDS_RESTART = "needsrestart";
    private static final String MODULE_ATTR_MODULE_AUTHOR = "moduleauthor";
    private static final String MODULE_ATTR_RELEASE_DATE = "releasedate";
    private static final String MODULE_ATTR_IS_GLOBAL = "global";
    private static final String MODULE_ATTR_TARGET_CLUSTER = "targetcluster";
    private static final String MODULE_ATTR_EAGER = "eager";
    private static final String MODULE_ATTR_AUTOLOAD = "autoload";
    private static final String MODULE_ATTR_LICENSE = "license";
    private static final String LICENSE_ATTR_URL = "url";
    private static final String MANIFEST_ATTR_SPECIFICATION_VERSION = "OpenIDE-Module-Specification-Version";
    private static final String TIME_STAMP_FORMAT = "ss/mm/hh/dd/MM/yyyy";
    private static final String L10N_ATTR_LOCALE = "langcode";
    private static final String L10N_ATTR_BRANDING = "brandingcode";
    private static final String L10N_ATTR_MODULE_SPECIFICATION = "module_spec_version";
    private static final String L10N_ATTR_MODULE_MAJOR_VERSION = "module_major_version";
    private static final String L10N_ATTR_LOCALIZED_MODULE_NAME = "OpenIDE-Module-Name";
    private static final String L10N_ATTR_LOCALIZED_MODULE_DESCRIPTION = "OpenIDE-Module-Long-Description";
    private static String GZIP_EXTENSION = ".gz";
    private static Map<String, ModuleItem> cache;
    private static URI cacheURI;
    private Stack<String> currentGroup = new Stack();
    private String catalogDate;
    private Stack<ModuleDescriptor> currentModule = new Stack();
    private Stack<Map<String, String>> currentLicense = new Stack();
    private Stack<String> currentNotificationUrl = new Stack();
    private List<String> lines = new ArrayList<String>();
    private int bufferInitSize = 0;

    private AutoUpdateCatalogParser(Map<String, ModuleItem> items, URL provider, URI base) {
        this.items = items;
        this.provider = provider;
        this.entityResolver = this.newEntityResolver();
        this.baseUri = base;
    }

    private EntityResolver newEntityResolver() {
        return new EntityResolver(){

            @Override
            public InputSource resolveEntity(String string, String string1) throws SAXException, IOException {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
        };
    }

    static synchronized Map<String, ModuleItem> getUpdateItems(URL url, URL provider, Task task) throws IOException {
        HashMap<String, ModuleItem> items = new HashMap<String, ModuleItem>();
        try {
            URI base = provider != null ? provider.toURI() : url.toURI();
            if (cache != null && cacheURI.equals(base)) {
                task.log("Using existing module item cache " + base, 2);
                return cache;
            }
            task.log("Downloading " + base, 2);
            InputSource is = null;
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(false);
                SAXParser saxParser = factory.newSAXParser();
                is = AutoUpdateCatalogParser.getInputSource(url, provider, base);
                saxParser.parse(is, (DefaultHandler)new AutoUpdateCatalogParser(items, provider, base));
                cacheURI = base;
                cache = items;
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw (IOException)new IOException(ex.getMessage()).initCause(ex);
            }
            finally {
                if (is != null && is.getByteStream() != null) {
                    try {
                        is.getByteStream().close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        catch (URISyntaxException ex) {
            ERR.log(Level.INFO, null, ex);
        }
        return items;
    }

    private static boolean isGzip(URL url) {
        boolean res = false;
        if (url != null) {
            res = url.getPath().toLowerCase().endsWith(GZIP_EXTENSION);
            ERR.log(Level.FINER, "Is GZIP " + url + " ? " + res);
        } else {
            ERR.log(Level.WARNING, "AutoupdateCatalogProvider has not URL.");
        }
        return res;
    }

    private static InputSource getInputSource(URL toParse, URL p, URI base) throws IOException {
        InputStream is = toParse.openStream();
        if (AutoUpdateCatalogParser.isGzip(p)) {
            try {
                is = new GZIPInputStream(is);
            }
            catch (IOException e) {
                ERR.log(Level.INFO, "The file at " + toParse + ", corresponding to the catalog at " + p + ", does not look like the gzip file, trying to parse it as the pure xml", e);
                is.close();
                is = null;
                is = toParse.openStream();
            }
        }
        InputSource src = new InputSource(new BufferedInputStream(is));
        src.setSystemId(base.toString());
        return src;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.lines.add(new String(ch, start, length));
        this.bufferInitSize += length;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        switch (ELEMENTS.valueOfOrUnknown(qName)) {
            case module_updates: {
                break;
            }
            case module_group: {
                assert (!this.currentGroup.empty()) : "Premature end of module_group " + qName;
                this.currentGroup.pop();
                break;
            }
            case module: {
                assert (!this.currentModule.empty()) : "Premature end of module " + qName;
                this.currentModule.pop();
                break;
            }
            case l10n: {
                break;
            }
            case manifest: {
                break;
            }
            case description: {
                ERR.info("Not supported yet.");
                break;
            }
            case notification: {
                if (this.provider != null && !this.lines.isEmpty()) {
                    StringBuffer sb = new StringBuffer(this.bufferInitSize);
                    for (String line : this.lines) {
                        sb.append(line);
                    }
                    String notification = sb.toString();
                    String notificationUrl = this.currentNotificationUrl.peek();
                    notification = notificationUrl != null && notificationUrl.length() > 0 ? notification + (notification.length() > 0 ? "<br>" : "") + "<a name=\"autoupdate_catalog_parser\" href=\"" + notificationUrl + "\">" + notificationUrl + "</a>" : notification + (notification.length() > 0 ? "<br>" : "") + "<a name=\"autoupdate_catalog_parser\"/>";
                }
                this.currentNotificationUrl.pop();
                break;
            }
            case module_notification: {
                if (this.lines.isEmpty()) break;
                ModuleDescriptor md = this.currentModule.peek();
                assert (md != null) : "ModuleDescriptor found for " + this.provider;
                StringBuffer buf = new StringBuffer(this.bufferInitSize);
                for (String line : this.lines) {
                    buf.append(line);
                }
                md.appendNotification(buf.toString());
                break;
            }
            case external_package: {
                ERR.info("Not supported yet.");
                break;
            }
            case license: {
                assert (!this.currentLicense.empty()) : "Premature end of license " + qName;
                Map<String, String> curLic = this.currentLicense.peek();
                String licenseName = curLic.keySet().iterator().next();
                Collection<String> values = curLic.values();
                String licenseUrl = values.size() > 0 ? values.iterator().next() : null;
                this.currentLicense.pop();
                break;
            }
            default: {
                ERR.warning("Unknown element " + qName);
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        ERR.fine("End parsing " + (this.provider == null ? "" : this.provider) + " at " + System.currentTimeMillis());
    }

    @Override
    public void startDocument() throws SAXException {
        ERR.fine("Start parsing " + (this.provider == null ? "" : this.provider) + " at " + System.currentTimeMillis());
    }

    @Override
    public void startElement(String uri, String localName, String qName, org.xml.sax.Attributes attributes) throws SAXException {
        this.lines.clear();
        this.bufferInitSize = 0;
        switch (ELEMENTS.valueOfOrUnknown(qName)) {
            case module_updates: {
                try {
                    this.catalogDate = "";
                    SimpleDateFormat format = new SimpleDateFormat(TIME_STAMP_FORMAT);
                    String timeStamp = attributes.getValue(MODULE_UPDATES_ATTR_TIMESTAMP);
                    if (timeStamp == null) {
                        ERR.info("No timestamp is presented in " + (this.provider == null ? "" : this.provider));
                        break;
                    }
                    this.catalogDate = format.parse(timeStamp).toString();
                    ERR.finer("Successfully read time " + timeStamp);
                }
                catch (ParseException pe) {
                    ERR.log(Level.INFO, null, pe);
                }
                break;
            }
            case module_group: {
                this.currentGroup.push(attributes.getValue("name"));
                break;
            }
            case module: {
                ModuleDescriptor md = ModuleDescriptor.getModuleDescriptor(this.currentGroup.size() > 0 ? this.currentGroup.peek() : null, this.baseUri, this.catalogDate);
                md.appendModuleAttributes(attributes);
                this.currentModule.push(md);
                break;
            }
            case l10n: {
                break;
            }
            case manifest: {
                ModuleDescriptor desc = this.currentModule.peek();
                desc.appendManifest(attributes);
                ModuleItem m = desc.createUpdateItem();
                this.items.put(desc.getId(), m);
                break;
            }
            case description: {
                ERR.info("Not supported yet.");
                break;
            }
            case module_notification: {
                break;
            }
            case notification: {
                this.currentNotificationUrl.push(attributes.getValue("url"));
                break;
            }
            case external_package: {
                ERR.info("Not supported yet.");
                break;
            }
            case license: {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(attributes.getValue("name"), attributes.getValue("url"));
                this.currentLicense.push(map);
                break;
            }
            default: {
                ERR.warning("Unknown element " + qName);
            }
        }
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.parseError(e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.parseError(e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.parseError(e);
    }

    private void parseError(SAXParseException e) {
        ERR.warning(e.getSystemId() + ":" + e.getLineNumber() + ":" + e.getColumnNumber() + ": " + e.getLocalizedMessage());
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        return this.entityResolver.resolveEntity(publicId, systemId);
    }

    private static URL getDistribution(String distribution, URI base) {
        URL retval = null;
        if (distribution != null && distribution.length() > 0) {
            try {
                URI distributionURI = new URI(distribution);
                if (!distributionURI.isAbsolute() && base != null) {
                    distributionURI = base.resolve(distributionURI);
                }
                retval = distributionURI.toURL();
            }
            catch (MalformedURLException ex) {
                ERR.log(Level.INFO, null, ex);
            }
            catch (URISyntaxException ex) {
                ERR.log(Level.INFO, null, ex);
            }
        }
        return retval;
    }

    private static Manifest getManifest(org.xml.sax.Attributes attrList) {
        Manifest mf = new Manifest();
        Attributes mfAttrs = mf.getMainAttributes();
        for (int i = 0; i < attrList.getLength(); ++i) {
            mfAttrs.put(new Attributes.Name(attrList.getQName(i)), attrList.getValue(i));
        }
        return mf;
    }

    private static enum ELEMENTS {
        module_updates,
        module_group,
        notification,
        module,
        description,
        module_notification,
        external_package,
        manifest,
        l10n,
        license,
        UNKNOWN;


        private static ELEMENTS valueOfOrUnknown(String qName) {
            try {
                return ELEMENTS.valueOf(qName);
            }
            catch (IllegalArgumentException ex) {
                return UNKNOWN;
            }
        }
    }

    private static class ModuleDescriptor {
        private String moduleCodeName;
        private URL distributionURL;
        private String targetcluster;
        private String homepage;
        private String downloadSize;
        private String author;
        private String publishDate;
        private String notification;
        private Boolean needsRestart;
        private Boolean isGlobal;
        private Boolean isEager;
        private Boolean isAutoload;
        private String specVersion;
        private Manifest mf;
        private String id;
        private String group;
        private URI base;
        private String catalogDate;
        private static ModuleDescriptor md = null;

        private ModuleDescriptor() {
        }

        public static ModuleDescriptor getModuleDescriptor(String group, URI base, String catalogDate) {
            if (md == null) {
                md = new ModuleDescriptor();
            }
            ModuleDescriptor.md.group = group;
            ModuleDescriptor.md.base = base;
            ModuleDescriptor.md.catalogDate = catalogDate;
            return md;
        }

        public void appendModuleAttributes(org.xml.sax.Attributes module) {
            this.moduleCodeName = module.getValue(AutoUpdateCatalogParser.MODULE_ATTR_CODE_NAME_BASE);
            this.distributionURL = AutoUpdateCatalogParser.getDistribution(module.getValue(AutoUpdateCatalogParser.MODULE_ATTR_DISTRIBUTION), this.base);
            this.targetcluster = module.getValue(AutoUpdateCatalogParser.MODULE_ATTR_TARGET_CLUSTER);
            this.homepage = module.getValue(AutoUpdateCatalogParser.MODULE_ATTR_HOMEPAGE);
            this.downloadSize = module.getValue(AutoUpdateCatalogParser.MODULE_ATTR_DOWNLOAD_SIZE);
            this.author = module.getValue(AutoUpdateCatalogParser.MODULE_ATTR_MODULE_AUTHOR);
            this.publishDate = module.getValue(AutoUpdateCatalogParser.MODULE_ATTR_RELEASE_DATE);
            if (this.publishDate == null || this.publishDate.length() == 0) {
                this.publishDate = this.catalogDate;
            }
            String needsrestart = module.getValue(AutoUpdateCatalogParser.MODULE_ATTR_NEEDS_RESTART);
            String global = module.getValue(AutoUpdateCatalogParser.MODULE_ATTR_IS_GLOBAL);
            String eager = module.getValue(AutoUpdateCatalogParser.MODULE_ATTR_EAGER);
            String autoload = module.getValue(AutoUpdateCatalogParser.MODULE_ATTR_AUTOLOAD);
            this.needsRestart = needsrestart == null || needsrestart.trim().length() == 0 ? null : Boolean.valueOf(needsrestart);
            this.isGlobal = global == null || global.trim().length() == 0 ? null : Boolean.valueOf(global);
            this.isEager = Boolean.parseBoolean(eager);
            this.isAutoload = Boolean.parseBoolean(autoload);
            String licName = module.getValue(AutoUpdateCatalogParser.MODULE_ATTR_LICENSE);
        }

        public void appendManifest(org.xml.sax.Attributes manifest) {
            this.specVersion = manifest.getValue(AutoUpdateCatalogParser.MANIFEST_ATTR_SPECIFICATION_VERSION);
            this.mf = AutoUpdateCatalogParser.getManifest(manifest);
            this.id = this.moduleCodeName + '_' + this.specVersion;
        }

        public void appendNotification(String notification) {
            this.notification = notification;
        }

        public String getId() {
            return this.id;
        }

        public ModuleItem createUpdateItem() {
            ModuleItem res = ModuleItem.createModule(this.moduleCodeName, this.specVersion, this.distributionURL, this.author, this.downloadSize, this.homepage, this.publishDate, this.group, this.mf, this.isEager, this.isAutoload, this.needsRestart, this.isGlobal, this.targetcluster, null);
            this.cleanUp();
            return res;
        }

        private void cleanUp() {
            this.specVersion = null;
            this.mf = null;
            this.notification = null;
        }
    }

    public static final class ModuleItem {
        private final String moduleCodeName;
        private final String specVersion;
        private final URL distributionURL;
        public final String targetcluster;

        private ModuleItem(String moduleCodeName, String specVersion, URL distributionURL, String targetcluster) {
            this.moduleCodeName = moduleCodeName;
            this.specVersion = specVersion;
            this.distributionURL = distributionURL;
            this.targetcluster = targetcluster;
        }

        ModuleItem changeDistribution(URL u) {
            return new ModuleItem(this.moduleCodeName, this.specVersion, u, this.targetcluster);
        }

        static ModuleItem createModule(String moduleCodeName, String specVersion, URL distributionURL, String author, String downloadSize, String homepage, String publishDate, String group, Manifest mf, Boolean eager, Boolean autoload, Boolean needsRestart, Boolean global, String targetcluster, Object object) {
            return new ModuleItem(moduleCodeName, specVersion, distributionURL, targetcluster);
        }

        public String getCodeName() {
            return this.moduleCodeName;
        }

        String getSpecVersion() {
            return this.specVersion;
        }

        URL getURL() {
            return this.distributionURL;
        }

        public String toString() {
            return "[" + this.moduleCodeName + "@" + this.specVersion + "(" + this.targetcluster + ") <- " + this.distributionURL + "]";
        }

        boolean isNewerThan(String version) {
            String[] mine = this.specVersion.split("\\.");
            String[] its = version.split("\\.");
            int min = Math.min(mine.length, its.length);
            for (int i = 0; i < min; ++i) {
                int it;
                int m = Integer.parseInt(mine[i]);
                if (m > (it = Integer.parseInt(its[i]))) {
                    return true;
                }
                if (m >= it) continue;
                return false;
            }
            return mine.length > its.length;
        }
    }
}

