/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.palette;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.html.palette.HtmlPaletteFactory;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteController;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class HtmlPaletteActions
extends PaletteActions {
    public Action[] getImportActions() {
        return new Action[0];
    }

    public Action[] getCustomCategoryActions(Lookup category) {
        return new Action[0];
    }

    public Action[] getCustomItemActions(Lookup item) {
        return new Action[0];
    }

    public Action[] getCustomPaletteActions() {
        return new Action[0];
    }

    public Action getPreferredAction(Lookup item) {
        return new HtmlPaletteInsertAction(item);
    }

    private static class HtmlPaletteInsertAction
    extends AbstractAction {
        private Lookup item;

        HtmlPaletteInsertAction(Lookup item) {
            this.item = item;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            ActiveEditorDrop drop = (ActiveEditorDrop)this.item.lookup(ActiveEditorDrop.class);
            JTextComponent target = Utilities.getFocusedComponent();
            if (target == null) {
                String msg = NbBundle.getMessage(HtmlPaletteActions.class, (String)"MSG_ErrorNoFocusedDocument");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
                return;
            }
            try {
                drop.handleTransfer(target);
            }
            finally {
                Utilities.requestFocus((JTextComponent)target);
            }
            try {
                FileObject fo = DataLoadersBridge.getDefault().getFileObject(target);
                if (fo != null) {
                    PaletteController pc = HtmlPaletteFactory.getPalette(fo.getMIMEType());
                    pc.clearSelection();
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
    }
}

