/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.util.telit;

import de.proveo.idm.remote.server.util.telit.ByteOrderInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class TelitFile {
    private static final int MIN_HEADER_SIZE = 74;
    protected ByteOrderInputStream in;
    private String displaySwVersion;
    private String pName;
    private String swVer;
    private byte[] reserved;
    private int blockCount;
    private int byteCount;
    private int headerSize;
    private int memoryType;
    private int streamVersion;
    private long speedOffset;

    protected TelitFile(ByteOrderInputStream in) {
        this.in = in;
    }

    public static TelitFile create(File file) throws IOException {
        TelitFile telitFile = new TelitFile(new ByteOrderInputStream(new FileInputStream(file)));
        TelitFile.parseHeader(telitFile, new ByteOrderInputStream(new FileInputStream(file)));
        return telitFile;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public int getByteCount() {
        return this.byteCount;
    }

    public String getDisplaySwVersion() {
        return this.displaySwVersion;
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public int getMemoryType() {
        return this.memoryType;
    }

    public byte[] getReserved() {
        return (byte[])this.reserved.clone();
    }

    public long getSpeedOffset() {
        return this.speedOffset;
    }

    public int getStreamVersion() {
        return this.streamVersion;
    }

    public String getSwVer() {
        return this.swVer;
    }

    public String getpName() {
        return this.pName;
    }

    public int readBlock(byte[] buffer) throws IOException {
        return TelitFile.readBlock(this.in, buffer);
    }

    protected static String parseDisplaySoftwareVersion(String swVer) {
        String[] versionElements = StringUtils.split((String)swVer, (char)'.');
        if (versionElements.length > 3) {
            StringBuffer buffer = new StringBuffer();
            for (int index = 0; index < versionElements.length - 1; ++index) {
                buffer.append(versionElements[index]);
                buffer.append('.');
            }
            return buffer.substring(0, buffer.length() - 1).toString();
        }
        return swVer;
    }

    protected static void parseHeader(TelitFile telitFile, ByteOrderInputStream headerIn) throws IOException {
        int blockSize;
        telitFile.headerSize = headerIn.readUnsignedWord(0);
        if (telitFile.headerSize < 74 || telitFile.headerSize > 65535) {
            throw new IllegalArgumentException("illegal header size: " + telitFile.headerSize);
        }
        telitFile.swVer = headerIn.readZeroTerminatedStringFixedLength(32);
        telitFile.displaySwVersion = TelitFile.parseDisplaySoftwareVersion(telitFile.swVer);
        telitFile.pName = headerIn.readZeroTerminatedStringFixedLength(32);
        telitFile.memoryType = headerIn.readUnsignedWord(0);
        telitFile.streamVersion = headerIn.readUnsignedWord(0);
        telitFile.speedOffset = headerIn.readUnsignedInt(0);
        telitFile.reserved = new byte[telitFile.headerSize - 74];
        if (headerIn.read(telitFile.reserved) != telitFile.reserved.length) {
            throw new IllegalArgumentException("corrupted reserved header");
        }
        do {
            if ((blockSize = TelitFile.readBlock(headerIn, null)) < 0) continue;
            ++telitFile.blockCount;
            telitFile.byteCount += blockSize;
        } while (blockSize >= 0);
        headerIn.close();
        telitFile.in.skip(telitFile.headerSize);
    }

    protected static int readBlock(ByteOrderInputStream boIn, byte[] buffer) throws IOException {
        int size = boIn.readUnsignedWord(0) + 1;
        if (size <= 0) {
            return -1;
        }
        if (buffer == null) {
            boIn.skip(size);
            return size;
        }
        if (buffer.length < size) {
            throw new IllegalArgumentException("buffer too small, buffer size should be 655351");
        }
        int bytesRead = boIn.read(buffer, 0, size);
        if (bytesRead != size) {
            throw new IOException("block not completley read");
        }
        return bytesRead;
    }
}

