/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.util.telit;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteOrderInputStream
extends FilterInputStream {
    public static final int LITTLE_ENDIAN = 0;
    public static final int BIG_ENDIAN = 1;

    public ByteOrderInputStream(InputStream input) {
        super(input);
    }

    public long readUnsignedInt(int byteOrder) throws IOException {
        int[] readBytes = this.readBytes(4, byteOrder);
        if (readBytes == null) {
            return -1L;
        }
        long value = (long)readBytes[3] << 24;
        value |= (long)readBytes[2] << 16;
        value |= (long)(readBytes[1] << 8);
        return value |= (long)readBytes[0];
    }

    public int readUnsignedWord(int byteOrder) throws IOException {
        int[] readBytes = this.readBytes(2, byteOrder);
        if (readBytes == null) {
            return -1;
        }
        int value = readBytes[1] << 8;
        return value |= readBytes[0];
    }

    public String readZeroTerminatedStringFixedLength(int length) throws IOException {
        int endOfStringIndex;
        byte[] buffer = new byte[length];
        int count = this.read(buffer);
        if (count != length) {
            throw new IOException("EOF");
        }
        for (endOfStringIndex = 0; endOfStringIndex < length && buffer[endOfStringIndex] != 0; ++endOfStringIndex) {
        }
        return new String(buffer, 0, endOfStringIndex);
    }

    protected int[] readBytes(int length, int byteOrder) throws IOException {
        int[] readBytes = new int[length];
        for (int index = 0; index < length; ++index) {
            readBytes[index] = this.read();
            if (readBytes[index] != -1) continue;
            return null;
        }
        if (byteOrder == 1) {
            int[] swapped = new int[length];
            for (int index = 0; index < length; ++index) {
                swapped[length - 1 - index] = readBytes[index];
            }
            readBytes = swapped;
        }
        return readBytes;
    }
}

