/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.util;

import de.proveo.domain.values.datasync.DatasyncMetainfoValue;
import de.proveo.domain.values.datasync.DatasyncResourceValue;
import de.proveo.domain.values.datasync.DatasyncTaskValue;
import de.proveo.idm.core.gui.navigation.NavigationTopComponent;
import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.navigation.api.RemoteNavigationItem;
import de.proveo.idm.core.gui.navigation.api.impl.AbstractNavigationItem;
import de.proveo.idm.core.gui.util.DialogUtil;
import de.proveo.idm.core.util.ThreadPool;
import de.proveo.idm.remote.server.actions.server.RefreshTreeAction;
import de.proveo.idm.remote.server.api.AbstractRemoteInfoman;
import de.proveo.idm.remote.server.api.EFMServer;
import de.proveo.idm.remote.server.api.RemoteDeviceId;
import de.proveo.idm.remote.server.api.ServerFeatureProvider;
import de.proveo.idm.remote.server.api.UnitTreeElement;
import de.proveo.idm.remote.server.api.ZeroConfUnit;
import de.proveo.idm.remote.server.navigation.DatasyncResourceNavigationItem;
import de.proveo.idm.remote.server.navigation.DatasyncTaskNavigationItem;
import de.proveo.idm.remote.server.navigation.EFMServerNavigationItem;
import de.proveo.idm.remote.server.navigation.OperatorGroupNavigationItem;
import de.proveo.idm.remote.server.navigation.OperatorNavigationItem;
import de.proveo.util.useuser.UseUserTreeNodeBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class TreeUtil {
    private static final String UNIT_ID_STRING = NbBundle.getMessage(TreeUtil.class, (String)"TreeUtil.unitIdStr");
    private static final String UNIT_SERIAL_STRING = NbBundle.getMessage(TreeUtil.class, (String)"TreeUtil.serialStr");

    public static NavigationItem createUnitsNavigation(List<UnitTreeElement> children) {
        String description = NbBundle.getMessage(TreeUtil.class, (String)"TreeUtil.installedUnitsRoot.name");
        RemoteNavigationItem item = new RemoteNavigationItem(description, null, RemoteNavigationItem.Type.INSTALLED_DEVICES);
        if (children != null && !children.isEmpty()) {
            for (UnitTreeElement child : children) {
                NavigationItem sub = TreeUtil.createNavigationTree(child);
                if (sub == null) continue;
                sub.setParent((NavigationItem)item);
            }
        }
        return item;
    }

    public static NavigationItem createNavigationTree(UnitTreeElement tree) {
        Object contained = tree.getContainedObject();
        List<UnitTreeElement> children = tree.getChildren();
        Object item = null;
        if (children != null && !children.isEmpty()) {
            item = new RemoteNavigationItem((String)contained, null, RemoteNavigationItem.Type.INSTALLED_DEVICES);
            for (UnitTreeElement child : children) {
                NavigationItem sub = TreeUtil.createNavigationTree(child);
                if (sub == null) continue;
                sub.setParent((NavigationItem)item);
            }
        } else if (contained instanceof AbstractRemoteInfoman) {
            String iconBase = TreeUtil.createIconBase(tree.getIconBase());
            AbstractRemoteInfoman infoman = (AbstractRemoteInfoman)contained;
            infoman.setIconBase(iconBase);
            item = infoman;
        }
        return item;
    }

    public static NavigationItem createOperatorNavigation(UseUserTreeNodeBean operators) {
        String description = NbBundle.getMessage(TreeUtil.class, (String)"TreeUtil.operators.name");
        RemoteNavigationItem item = new RemoteNavigationItem(description, null, RemoteNavigationItem.Type.OPERATORS);
        item.setActionPath("Actions/Remote/Operators/Root");
        List children = operators.getChildren();
        TreeSet<UseUserTreeNodeBean> childSet = new TreeSet<UseUserTreeNodeBean>(new UseUserComparator());
        if (children != null) {
            childSet.addAll(children);
        }
        if (!childSet.isEmpty()) {
            for (UseUserTreeNodeBean child : childSet) {
                NavigationItem sub = TreeUtil.createNavigationTreeOp(child);
                if (sub == null) continue;
                sub.setParent((NavigationItem)item);
            }
        }
        return item;
    }

    public static NavigationItem createNavigationTreeOp(UseUserTreeNodeBean tree) {
        AbstractNavigationItem item = tree.isBasic() ? new OperatorNavigationItem(tree) : new OperatorGroupNavigationItem(tree);
        List children = tree.getChildren();
        TreeSet<UseUserTreeNodeBean> childSet = new TreeSet<UseUserTreeNodeBean>(new UseUserComparator());
        if (children != null) {
            childSet.addAll(children);
        }
        if (!childSet.isEmpty()) {
            for (UseUserTreeNodeBean child : childSet) {
                NavigationItem sub = TreeUtil.createNavigationTreeOp(child);
                if (sub == null) continue;
                sub.setParent((NavigationItem)item);
            }
        }
        return item;
    }

    public static NavigationItem createNavigationTree(UnitTreeElement tree, Device.DeviceType deviceType) {
        Object contained = tree.getContainedObject();
        List<UnitTreeElement> children = tree.getChildren();
        Object item = null;
        if (children != null && !children.isEmpty()) {
            item = new RemoteNavigationItem((String)contained, null, RemoteNavigationItem.Type.INSTALLED_DEVICES);
            for (UnitTreeElement child : children) {
                NavigationItem sub = TreeUtil.createNavigationTree(child, deviceType);
                if (sub == null) continue;
                sub.setParent((NavigationItem)item);
            }
            if (item.getChildren() == null || item.getChildren().isEmpty()) {
                if (item.getParent() != null) {
                    item.getParent().removeChild((NavigationItem)item);
                }
                item = null;
            }
        } else if (contained instanceof AbstractRemoteInfoman) {
            String iconBase = TreeUtil.createIconBase(tree.getIconBase());
            AbstractRemoteInfoman infoman = (AbstractRemoteInfoman)contained;
            if (deviceType.equals((Object)Device.DeviceType.ANY) || deviceType.equals((Object)Device.DeviceType.UNKNOWN) || deviceType.equals((Object)infoman.getDeviceType())) {
                try {
                    infoman = infoman.clone();
                    infoman.setIconBase(iconBase);
                    item = infoman;
                }
                catch (CloneNotSupportedException ex) {
                    item = null;
                }
            }
        }
        return item;
    }

    public static NavigationItem createTaskNavigation(Map<RemoteDeviceId, Collection<DatasyncTaskValue>> tasks) {
        RemoteNavigationItem tasksItem = null;
        if (tasks != null && !tasks.isEmpty()) {
            tasksItem = new RemoteNavigationItem(NbBundle.getMessage(TreeUtil.class, (String)"TreeUtil.openTasks.name"), null, RemoteNavigationItem.Type.TASKS);
            for (RemoteDeviceId id : tasks.keySet()) {
                long unitId = id.getUnitId();
                String serial = id.getSerialNumber();
                String name = TreeUtil.buildFolderName(unitId, serial);
                RemoteNavigationItem unitFolder = new RemoteNavigationItem(name, (NavigationItem)tasksItem, RemoteNavigationItem.Type.TASKS);
                tasksItem.addChild((NavigationItem)unitFolder);
                for (DatasyncTaskValue task : tasks.get(id)) {
                    DatasyncTaskNavigationItem taskItem = new DatasyncTaskNavigationItem(task, (NavigationItem)unitFolder);
                    unitFolder.addChild((NavigationItem)taskItem);
                }
            }
        }
        return tasksItem;
    }

    public static NavigationItem createResourceNavigation(Map<String, Map<String, Collection<DatasyncResourceValue>>> resourcesTree) {
        RemoteNavigationItem resourcesItem = null;
        if (resourcesTree != null && !resourcesTree.isEmpty()) {
            resourcesItem = new RemoteNavigationItem(NbBundle.getMessage(TreeUtil.class, (String)"TreeUtil.resources.name"), null, RemoteNavigationItem.Type.RESOURCES);
            for (String deviceType : resourcesTree.keySet()) {
                RemoteNavigationItem deviceTypeFolder = new RemoteNavigationItem(deviceType, (NavigationItem)resourcesItem, RemoteNavigationItem.Type.RESOURCES);
                resourcesItem.addChild((NavigationItem)deviceTypeFolder);
                Map<String, Collection<DatasyncResourceValue>> deviceTypeResources = resourcesTree.get(deviceType);
                Iterator<String> iterator = deviceTypeResources.keySet().iterator();
                while (iterator.hasNext()) {
                    String res;
                    String name = res = iterator.next();
                    String actionPath = "Actions/Remote/Server/Resources/Types";
                    if (res.equals(StringUtils.remove((String)"Telit Modem Firmware", (String)" "))) {
                        name = "Telit Modem Firmware";
                    } else if (res.equals(StringUtils.remove((String)"Software", (String)" "))) {
                        name = "Software";
                    } else if (res.equals(StringUtils.remove((String)"NoMo Firmware", (String)" "))) {
                        name = "NoMo Firmware";
                    } else {
                        actionPath = "Actions/Remote/Server/Resources/" + deviceType;
                    }
                    RemoteNavigationItem resTypeFolder = new RemoteNavigationItem(name, (NavigationItem)deviceTypeFolder, RemoteNavigationItem.Type.RESOURCES);
                    resTypeFolder.setActionPath(actionPath);
                    deviceTypeFolder.addChild((NavigationItem)resTypeFolder);
                    Collection<DatasyncResourceValue> resources = deviceTypeResources.get(res);
                    for (DatasyncResourceValue resource : resources) {
                        DatasyncResourceNavigationItem resItem = new DatasyncResourceNavigationItem(resource);
                        if ("NoMo Firmware".equals(name)) {
                            resItem.setActionPath("Actions/Remote/Server/Resources/NoMoFirmware");
                        } else if (TreeUtil.isConfigurationResourceItem(resItem)) {
                            resItem.setActionPath("Actions/Remote/Server/Resources/Config");
                        }
                        resTypeFolder.addChild((NavigationItem)resItem);
                    }
                }
            }
        }
        return resourcesItem;
    }

    public static NavigationItem createSoftwareNavigation(Collection<DatasyncResourceValue> software) {
        RemoteNavigationItem softwareItem = null;
        if (software != null && !software.isEmpty()) {
            String description = NbBundle.getMessage(TreeUtil.class, (String)"TreeUtil.availableSoftware.name");
            softwareItem = new RemoteNavigationItem(description, null, RemoteNavigationItem.Type.SOFTWARE);
            softwareItem.setActionPath("Actions/Remote/Software/Root");
            for (DatasyncResourceValue resource : software) {
                DatasyncResourceNavigationItem resItem = new DatasyncResourceNavigationItem(resource);
                resItem.setActionPath("Actions/Remote/Software/Child");
                softwareItem.addChild((NavigationItem)resItem);
            }
        }
        return softwareItem;
    }

    public static NavigationItem createZeroConfNavigation(List<ZeroConfUnit> units) {
        RemoteNavigationItem parent = new RemoteNavigationItem(NbBundle.getMessage(TreeUtil.class, (String)"TreeUtil.notInstalledUnits.name"), null, RemoteNavigationItem.Type.NOT_INSTALLED_DEVICES);
        HashMap<String, NavigationItem> deviceTypes = new HashMap<String, NavigationItem>();
        for (ZeroConfUnit unit : units) {
            String localizedType;
            String type;
            block7: {
                try {
                    type = (String)unit.getEnv().get("deviceType");
                    if (type == null || type.trim().length() == 0) {
                        type = unit.getDeviceType().toString();
                    }
                }
                catch (Exception ex) {
                    type = unit.getDeviceType().toString();
                }
                try {
                    localizedType = NbBundle.getMessage(TreeUtil.class, (String)("notInstalledDevice.type." + type));
                }
                catch (MissingResourceException ex) {
                    localizedType = type;
                    if (unit.getDeviceType().toString().equals(type)) break block7;
                    localizedType = unit.getDeviceType().toString() + " (" + type + ")";
                }
            }
            NavigationItem group = (NavigationItem)deviceTypes.get(type);
            if (group == null) {
                RemoteNavigationItem newGroup = new RemoteNavigationItem(localizedType, (NavigationItem)parent, RemoteNavigationItem.Type.NOT_INSTALLED_DEVICES);
                parent.addChild((NavigationItem)newGroup);
                group = newGroup;
                deviceTypes.put(type, group);
            }
            group.addChild((NavigationItem)unit);
        }
        return parent;
    }

    public static int countUnitsInTree(NavigationItem item) {
        return TreeUtil.count(item, true);
    }

    public static int countGroupsInTree(NavigationItem item) {
        return TreeUtil.count(item, false);
    }

    public static List<NavigationItem> getLeaves(NavigationItem item) {
        ArrayList<NavigationItem> leaves = new ArrayList<NavigationItem>();
        List children = item.getChildren();
        if (children != null && !children.isEmpty()) {
            for (NavigationItem child : children) {
                leaves.addAll(TreeUtil.getLeaves(child));
            }
        } else {
            leaves.add(item);
        }
        return leaves;
    }

    private static int count(NavigationItem item, boolean countLeaves) {
        int count = 0;
        for (NavigationItem parent : item.getChildren()) {
            List children = parent.getChildren();
            if (children.isEmpty() && countLeaves) {
                ++count;
                continue;
            }
            if (children.isEmpty() || countLeaves) continue;
            ++count;
        }
        return count;
    }

    private static String createIconBase(String unit) {
        return String.format("de/proveo/idm/remote/server/resources/units/%s", unit);
    }

    private static String buildFolderName(long unitId, String serial) {
        StringBuilder builder = new StringBuilder();
        builder.append(unitId != 0L ? UNIT_ID_STRING : UNIT_SERIAL_STRING);
        builder.append(" ");
        builder.append(unitId != 0L ? Long.valueOf(unitId) : serial);
        return builder.toString();
    }

    public static void refreshTreeForServerItem(EFMServerNavigationItem item) {
        if (item != null) {
            RefreshServerTreeTask task = new RefreshServerTreeTask(item);
            ThreadPool.getInstance().execute((Runnable)task);
        }
    }

    public static boolean isConfigurationResourceItem(DatasyncResourceNavigationItem item) {
        List metaInfos;
        DatasyncResourceValue value;
        if (item != null && (value = item.getResourceInstance()) != null && (metaInfos = value.getMetainfos()) != null) {
            for (DatasyncMetainfoValue metaInfo : metaInfos) {
                if (!ObjectUtils.equals((Object)"type", (Object)metaInfo.getKey()) || !ObjectUtils.equals((Object)"INFOMAN_CONFIG", (Object)metaInfo.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private static class UseUserComparator
    implements Comparator<UseUserTreeNodeBean> {
        private UseUserComparator() {
        }

        @Override
        public int compare(UseUserTreeNodeBean o1, UseUserTreeNodeBean o2) {
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1.isBasic() != o2.isBasic()) {
                if (o1.isBasic()) {
                    return 1;
                }
                return -1;
            }
            int c = o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
            if (c == 0) {
                String persNo1 = o1.getPersonnelNo();
                String persNo2 = o2.getPersonnelNo();
                if (persNo1 == null) {
                    return 1;
                }
                if (persNo2 == null) {
                    return -1;
                }
                c = persNo1.toLowerCase().compareTo(persNo2.toLowerCase());
                if (c == 0) {
                    c = Long.valueOf(o1.getId()).compareTo(o2.getId());
                }
            }
            return c;
        }
    }

    private static class RefreshServerTreeTask
    extends SwingWorker<Void, Void> {
        private static final Logger log = Logger.getLogger(RefreshServerTreeTask.class.getName());
        private final Map<RemoteNavigationItem.Type, NavigationItem> insertMap = new EnumMap<RemoteNavigationItem.Type, NavigationItem>(RemoteNavigationItem.Type.class);
        private Exception pendingException = null;
        private final EFMServerNavigationItem item;

        public RefreshServerTreeTask(EFMServerNavigationItem item) {
            this.item = item;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Void doInBackground() {
            String title = NbBundle.getMessage(RefreshTreeAction.class, (String)"RefreshTreeAction.progress.title");
            ProgressHandle handle = ProgressHandleFactory.createHandle((String)title);
            handle.start();
            handle.switchToIndeterminate();
            try {
                EFMServer server = this.item.getServerInstance();
                Collection capabilities = server.getCapabilities();
                int progressCount = 0;
                Collection featureProviders = Lookup.getDefault().lookupAll(ServerFeatureProvider.class);
                handle.switchToDeterminate(featureProviders.size());
                for (ServerFeatureProvider fp : featureProviders) {
                    if (!fp.isCapabilityFullfilled(capabilities)) continue;
                    try {
                        NavigationItem navItem = fp.createItemForServerTree(handle, this.item);
                        if (navItem != null) {
                            this.insertMap.put(fp.getRemoteNavigationItemType(), navItem);
                        }
                    }
                    catch (Exception ex) {
                        log.log(Level.WARNING, "Could not create items for " + fp.getRemoteNavigationItemType(), ex);
                    }
                    handle.progress(progressCount++);
                }
            }
            catch (Exception ex) {
                this.pendingException = ex;
            }
            finally {
                handle.finish();
            }
            return null;
        }

        @Override
        protected void done() {
            if (this.pendingException != null) {
                log.log(Level.SEVERE, "runs into", this.pendingException);
                String msg = NbBundle.getMessage(RefreshTreeAction.class, (String)"RefreshTreeAction.error.timeout");
                DialogUtil.showErrorDialog((Object)msg);
            } else {
                for (final RemoteNavigationItem.Type navType : this.insertMap.keySet()) {
                    final NavigationItem navItem = this.insertMap.get(navType);
                    NavigationItem root = null;
                    Iterator children = this.item.getChildren().iterator();
                    while (root == null && children.hasNext()) {
                        RemoteNavigationItem.Type type;
                        NavigationItem child = (NavigationItem)children.next();
                        if (!(child instanceof RemoteNavigationItem) || (type = ((RemoteNavigationItem)child).getType()) == null || !type.equals((Object)navType)) continue;
                        root = child;
                    }
                    final NavigationItem navRoot = root;
                    Runnable run = new Runnable(){

                        @Override
                        public void run() {
                            Node node;
                            NavigationTopComponent nav;
                            try {
                                nav = NavigationTopComponent.findInstance();
                                node = nav.findNodeByNavigationItem((NavigationItem)RefreshServerTreeTask.this.item);
                                nav.findExpandedNodes(node);
                            }
                            catch (Exception ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            if (navItem != null && !navItem.getChildren().isEmpty()) {
                                if (navRoot != null) {
                                    navRoot.merge(navItem);
                                } else {
                                    RefreshServerTreeTask.this.item.addChild(navItem);
                                }
                            } else if (navRoot != null) {
                                RefreshServerTreeTask.this.item.removeChild(navRoot);
                            }
                            nav = NavigationTopComponent.findInstance();
                            node = nav.findNodeByNavigationItem((NavigationItem)RefreshServerTreeTask.this.item);
                            nav.expandOriginalNodes(node);
                            if (RemoteNavigationItem.Type.INSTALLED_DEVICES.equals((Object)navType)) {
                                RefreshServerTreeTask.this.item.fireTreeUpdated();
                            }
                        }
                    };
                    if (SwingUtilities.isEventDispatchThread()) {
                        run.run();
                        continue;
                    }
                    SwingUtilities.invokeLater(run);
                }
            }
        }
    }
}

