/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.util;

import de.proveo.domain.values.datasync.DatasyncMetainfoValue;
import de.proveo.domain.values.datasync.DatasyncResourceValue;
import de.proveo.domain.values.datasync.DatasyncTaskValue;
import de.proveo.domain.values.infoman.MetaInfoKey;
import de.proveo.idm.core.gui.navigation.api.Capability;
import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.gui.navigation.api.RemoteDevice;
import de.proveo.idm.core.gui.util.DialogUtil;
import de.proveo.idm.core.util.Configuration;
import de.proveo.idm.core.util.RemoteUpdateHelper;
import de.proveo.idm.core.util.ThreadPool;
import de.proveo.idm.remote.server.api.EFMServer;
import de.proveo.idm.remote.server.api.RemoteInfoman;
import de.proveo.idm.remote.server.util.RemoteUpdateHandler;
import de.proveo.idm.software.archive.api.AbstractInfomanEFMSoftwareBundle;
import de.proveo.idm.software.archive.api.InfomanSoftwareArchiveManager;
import de.proveo.idm.software.archive.util.ChecksumUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class RemoteUpdateHelperImpl
implements RemoteUpdateHelper {
    private static final Logger log = Logger.getLogger(RemoteUpdateHelperImpl.class.getName());

    public void updateRemoteDevices(boolean datasyncAllowed, String groupName, Device.DeviceType deviceType, Map<RemoteDevice, Configuration> devicesConfigurationsMap) throws Exception {
        Map<Long, DatasyncTaskValue> tasks;
        boolean canCreateBatchTasks;
        DatasyncResourceValue updateResource;
        RemoteDevice device;
        EFMServer server = null;
        String timeZoneId = TimeZone.getDefault().getID();
        ArrayList<RemoteDevice> devices = new ArrayList<RemoteDevice>(devicesConfigurationsMap.keySet());
        Iterator iterator = devices.iterator();
        while (iterator.hasNext() && (!((device = (RemoteDevice)iterator.next()) instanceof RemoteInfoman) || (server = ((RemoteInfoman)device).getServer()) == null || (timeZoneId = server.getTimeZoneID()) == null)) {
        }
        if (server == null) {
            throw new IllegalArgumentException("No server found in given devices");
        }
        if (deviceType.equals((Object)Device.DeviceType.INFOMAN_EFM) && !server.getCapabilities().contains(Capability.INFOMANEFM_CONFIG_UPDATE)) {
            DialogUtil.showErrorDialog((Object)NbBundle.getMessage(RemoteUpdateHelperImpl.class, (String)"RemoteUpdateHelperImpl.updateRemoteDevices.server"));
            return;
        }
        switch (RemoteUpdateHandler.getHardwarePlatformConsistancy(devicesConfigurationsMap.keySet())) {
            case CONSISTENT: {
                break;
            }
            case NOT_CONSISTENT: {
                DialogUtil.showErrorDialog((Object)NbBundle.getMessage(RemoteUpdateHelperImpl.class, (String)"RemoteUpdateHelperImpl.updateRemoteDevices.hardwarPlatformNotConsistent"));
                return;
            }
            case UNKOWN: {
                Object option = DialogUtil.showOkCancelQuestionDialog((Object)NbBundle.getMessage(RemoteUpdateHelperImpl.class, (String)"RemoteUpdateHelperImpl.updateRemoteDevices.couldNotDetermine"));
                if (DialogUtil.OK_OPTION.equals(option)) break;
                return;
            }
        }
        if (timeZoneId == null) {
            timeZoneId = TimeZone.getDefault().getID();
        }
        if ((updateResource = RemoteUpdateHandler.selectResource(datasyncAllowed, false, true, canCreateBatchTasks = datasyncAllowed && server.getCapabilities().contains(Capability.CREATE_BATCH_TASK), deviceType, "Software", server.getRemoteUpdateAdapter(), timeZoneId, null, null)) == null) {
            return;
        }
        long scheduledUpdateTime = updateResource.getValidFrom();
        String resName = updateResource.getResourceName();
        if (resName == null) {
            updateResource = null;
        }
        if ((tasks = RemoteUpdateHandler.createDatasyncTasks(false, devices, "Software", scheduledUpdateTime)) != null && !tasks.isEmpty()) {
            ScheduleConfigurationUpdatesTask updateConfigurationTask = new ScheduleConfigurationUpdatesTask(deviceType, groupName, server, scheduledUpdateTime, new ArrayList<DatasyncTaskValue>(tasks.values()), updateResource, devicesConfigurationsMap);
            ThreadPool.getInstance().execute((Runnable)updateConfigurationTask);
        }
    }

    private class ScheduleConfigurationUpdatesTask
    implements Runnable {
        private final Device.DeviceType deviceType;
        private final String groupName;
        private final EFMServer server;
        private final List<DatasyncTaskValue> tasks;
        private final DatasyncResourceValue softwareResource;
        private final Map<Long, RemoteDevice> devicesMap;
        private final Map<Long, Configuration> configurationsMap;
        private final long scheduledUpdateTime;
        private volatile boolean containsInfomanEFM = false;

        public ScheduleConfigurationUpdatesTask(Device.DeviceType deviceType, String groupName, EFMServer server, long scheduledUpdateTime, List<DatasyncTaskValue> tasks, DatasyncResourceValue softwareResource, Map<RemoteDevice, Configuration> devicesConfigurationsMap) {
            long unitId;
            this.deviceType = deviceType;
            this.groupName = groupName;
            this.server = server;
            this.tasks = tasks;
            this.softwareResource = softwareResource;
            this.scheduledUpdateTime = scheduledUpdateTime;
            this.configurationsMap = new HashMap<Long, Configuration>();
            for (RemoteDevice device : devicesConfigurationsMap.keySet()) {
                unitId = device.getUnitId();
                this.configurationsMap.put(unitId, devicesConfigurationsMap.get(device));
            }
            this.devicesMap = new HashMap<Long, RemoteDevice>();
            for (RemoteDevice device : devicesConfigurationsMap.keySet()) {
                unitId = device.getUnitId();
                this.devicesMap.put(unitId, device);
                if (this.containsInfomanEFM || !ObjectUtils.equals((Object)Device.DeviceType.INFOMAN_EFM, (Object)device.getDeviceType())) continue;
                this.containsInfomanEFM = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block40: {
                String displayName = NbBundle.getMessage(RemoteUpdateHelperImpl.class, (String)"RemoteUpdateHelperImpl.ScheduleSoftwareUpdatesTask.progressHandle.name", (Object[])new Object[]{this.deviceType, this.groupName, this.server.getName()});
                ProgressHandle handle = ProgressHandleFactory.createHandle((String)displayName);
                handle.start();
                handle.switchToIndeterminate();
                ArrayList<Long> failedTasks = new ArrayList<Long>();
                ArrayList<Long> successfulTasks = new ArrayList<Long>();
                try {
                    boolean performDiffUpdates = false;
                    if (this.containsInfomanEFM) {
                        Object n = DialogUtil.showYesNoCancelQuestionDialog((Object)NbBundle.getMessage(RemoteUpdateHelperImpl.class, (String)"RemoteUpdateHelperImpl.ScheduleSoftwareUpdatesTask.performDiffUpdate.msg"), (String)NbBundle.getMessage(RemoteUpdateHelperImpl.class, (String)"RemoteUpdateHelperImpl.ScheduleSoftwareUpdatesTask.performDiffUpdate.title"));
                        if (DialogUtil.YES_OPTION.equals(n)) {
                            log.info("Performing diff updates if possible.");
                            performDiffUpdates = true;
                        } else {
                            if (DialogUtil.CANCEL_OPTION.equals(n)) {
                                log.info("User canceled configuration update.");
                                return;
                            }
                            log.info("Performing full updates.");
                        }
                    }
                    handle.switchToDeterminate(this.tasks.size());
                    if (this.server.getCapabilities().contains(Capability.CREATE_BATCH_TASK) && this.softwareResource != null) {
                        ArrayList<DatasyncTaskValue> preparedTasks = new ArrayList<DatasyncTaskValue>();
                        for (int i = 0; i < this.tasks.size(); ++i) {
                            DatasyncTaskValue task = this.tasks.get(i);
                            handle.progress(NbBundle.getMessage(RemoteUpdateHelperImpl.class, (String)"RemoteUpdateHelperImpl.ScheduleSoftwareUpdatesTask.prepare.progress.msg", (Object)task.getClientId()));
                            long unitId = task.getClientId();
                            try {
                                ArrayList<Object> resources;
                                Device.DeviceType devType;
                                RemoteDevice device;
                                Configuration configuration = this.configurationsMap.get(unitId);
                                if (configuration == null) {
                                    throw new UnsupportedOperationException("Could not find a configuration for unit " + unitId);
                                }
                                File configurationFile = configuration.getFile();
                                String configurationFileName = configurationFile.getName();
                                if (performDiffUpdates && (device = this.devicesMap.get(unitId)) != null && ObjectUtils.equals((Object)Device.DeviceType.INFOMAN_EFM, (Object)(devType = device.getDeviceType()))) {
                                    try {
                                        String swVersion = device.getSoftwareVersion();
                                        AbstractInfomanEFMSoftwareBundle bundle = null;
                                        InfomanSoftwareArchiveManager manager = (InfomanSoftwareArchiveManager)Lookup.getDefault().lookup(InfomanSoftwareArchiveManager.class);
                                        Collection bundles = manager.findInfomanEFMBundle(swVersion);
                                        for (AbstractInfomanEFMSoftwareBundle b : bundles) {
                                            if (!b.getVersion().equals(swVersion)) continue;
                                            bundle = b;
                                            break;
                                        }
                                        Configuration currentConfig = device.openConfiguration(bundle);
                                        File currentConfigFile = currentConfig.getFile();
                                        List atCmds = FileUtils.readLines((File)configurationFile);
                                        List currentATcmds = FileUtils.readLines((File)currentConfigFile);
                                        ArrayList diffATcmds = new ArrayList();
                                        for (String cmd : atCmds) {
                                            if (!cmd.contains("=")) continue;
                                            boolean cmdEqual = false;
                                            String key = StringUtils.split((String)cmd, (String)"=")[0];
                                            for (String currentCmd : currentATcmds) {
                                                if (!currentCmd.startsWith(key) || !currentCmd.equals(cmd)) continue;
                                                cmdEqual = true;
                                                break;
                                            }
                                            if (cmdEqual) continue;
                                            diffATcmds.add(cmd);
                                        }
                                        if (diffATcmds.isEmpty()) continue;
                                        File tmpDiffConfigFile = File.createTempFile(configurationFileName + "_diff", "iefm");
                                        FileUtils.forceDeleteOnExit((File)tmpDiffConfigFile);
                                        FileUtils.writeLines((File)tmpDiffConfigFile, (Collection)diffATcmds);
                                        configurationFile = tmpDiffConfigFile;
                                    }
                                    catch (Exception ex) {
                                        log.log(Level.INFO, "Diff update not possible, because", ex);
                                    }
                                }
                                resources = (resources = task.getResources()) == null ? new ArrayList<DatasyncResourceValue>() : new ArrayList(resources);
                                byte[] config = this.fileToByteArray(configurationFile);
                                String checksum = ChecksumUtil.generateSHA1Checksum((byte[])config);
                                DatasyncResourceValue resource = new DatasyncResourceValue();
                                resource.setResource(config);
                                resource.setResourceName(configurationFileName);
                                resource.setChecksum(checksum);
                                ArrayList<DatasyncMetainfoValue> metaInfos = new ArrayList<DatasyncMetainfoValue>();
                                DatasyncMetainfoValue info = new DatasyncMetainfoValue();
                                info.setKey(MetaInfoKey.CHECKSUM_TYPE.toString());
                                info.setValue("SHA1");
                                metaInfos.add(info);
                                info = new DatasyncMetainfoValue();
                                info.setKey(MetaInfoKey.CHECKSUM.toString());
                                info.setValue(checksum);
                                metaInfos.add(info);
                                info = new DatasyncMetainfoValue();
                                info.setKey(MetaInfoKey.FILE_NAME.toString());
                                info.setValue(configurationFileName);
                                metaInfos.add(info);
                                info = new DatasyncMetainfoValue();
                                info.setKey(MetaInfoKey.CONTENT_TYPE.toString());
                                info.setValue("text/plain");
                                metaInfos.add(info);
                                info = new DatasyncMetainfoValue();
                                info.setKey(MetaInfoKey.TYPE.toString());
                                info.setValue("INFOMAN_CONFIG");
                                metaInfos.add(info);
                                resource.setMetainfos(metaInfos);
                                resources.add(0, resource);
                                task.setResources(resources);
                                preparedTasks.add(task);
                                successfulTasks.add(unitId);
                                continue;
                            }
                            catch (Exception ex) {
                                log.log(Level.WARNING, "Failed to prepare configuration update task for unit " + unitId, ex);
                                failedTasks.add(unitId);
                            }
                        }
                        handle.switchToIndeterminate();
                        handle.progress(NbBundle.getMessage(RemoteUpdateHelperImpl.class, (String)"RemoteUpdateHelperImpl.ScheduleSoftwareUpdatesTask.create.progress.msg"));
                        this.server.getRemoteUpdateAdapter().createTasks(this.deviceType, preparedTasks, this.softwareResource);
                        break block40;
                    }
                    for (int i = 0; i < this.tasks.size(); ++i) {
                        DatasyncTaskValue task = this.tasks.get(i);
                        handle.progress(NbBundle.getMessage(RemoteUpdateHelperImpl.class, (String)"RemoteUpdateHelperImpl.ScheduleSoftwareUpdatesTask.progress.msg", (Object)task.getClientId()));
                        long unitId = task.getClientId();
                        try {
                            ArrayList<Object> resources;
                            Device.DeviceType devType;
                            RemoteDevice device;
                            Configuration configuration = this.configurationsMap.get(unitId);
                            if (configuration == null) {
                                throw new UnsupportedOperationException("Could not find a configuration for unit " + unitId);
                            }
                            File configurationFile = configuration.getFile();
                            String configurationFileName = configurationFile.getName();
                            if (performDiffUpdates && (device = this.devicesMap.get(unitId)) != null && ObjectUtils.equals((Object)Device.DeviceType.INFOMAN_EFM, (Object)(devType = device.getDeviceType()))) {
                                try {
                                    String swVersion = device.getSoftwareVersion();
                                    AbstractInfomanEFMSoftwareBundle bundle = null;
                                    InfomanSoftwareArchiveManager manager = (InfomanSoftwareArchiveManager)Lookup.getDefault().lookup(InfomanSoftwareArchiveManager.class);
                                    Collection bundles = manager.findInfomanEFMBundle(swVersion);
                                    for (AbstractInfomanEFMSoftwareBundle b : bundles) {
                                        if (!b.getVersion().equals(swVersion)) continue;
                                        bundle = b;
                                        break;
                                    }
                                    Configuration currentConfig = device.openConfiguration(bundle);
                                    File currentConfigFile = currentConfig.getFile();
                                    List atCmds = FileUtils.readLines((File)configurationFile);
                                    List currentATcmds = FileUtils.readLines((File)currentConfigFile);
                                    ArrayList<String> diffATcmds = new ArrayList<String>();
                                    for (String cmd : atCmds) {
                                        if (!cmd.contains("=")) continue;
                                        boolean cmdEqual = false;
                                        String key = StringUtils.split((String)cmd, (String)"=")[0];
                                        for (String currentCmd : currentATcmds) {
                                            if (!currentCmd.startsWith(key) || !currentCmd.equals(cmd)) continue;
                                            cmdEqual = true;
                                            break;
                                        }
                                        if (cmdEqual) continue;
                                        diffATcmds.add(cmd);
                                    }
                                    if (diffATcmds.isEmpty()) continue;
                                    File tmpDiffConfigFile = File.createTempFile(configurationFileName + "_diff", "iefm");
                                    FileUtils.forceDeleteOnExit((File)tmpDiffConfigFile);
                                    FileUtils.writeLines((File)tmpDiffConfigFile, diffATcmds);
                                    configurationFile = tmpDiffConfigFile;
                                }
                                catch (Exception ex) {
                                    log.log(Level.INFO, "Diff update not possible, because", ex);
                                }
                            }
                            resources = (resources = task.getResources()) == null ? new ArrayList<DatasyncResourceValue>() : new ArrayList(resources);
                            byte[] config = this.fileToByteArray(configurationFile);
                            String checksum = ChecksumUtil.generateSHA1Checksum((byte[])config);
                            DatasyncResourceValue resource = new DatasyncResourceValue();
                            resource.setResource(config);
                            resource.setResourceName(configurationFileName);
                            resource.setChecksum(checksum);
                            ArrayList<DatasyncMetainfoValue> metaInfos = new ArrayList<DatasyncMetainfoValue>();
                            DatasyncMetainfoValue info = new DatasyncMetainfoValue();
                            info.setKey(MetaInfoKey.CHECKSUM_TYPE.toString());
                            info.setValue("SHA1");
                            metaInfos.add(info);
                            info = new DatasyncMetainfoValue();
                            info.setKey(MetaInfoKey.CHECKSUM.toString());
                            info.setValue(checksum);
                            metaInfos.add(info);
                            info = new DatasyncMetainfoValue();
                            info.setKey(MetaInfoKey.FILE_NAME.toString());
                            info.setValue(configurationFileName);
                            metaInfos.add(info);
                            info = new DatasyncMetainfoValue();
                            info.setKey(MetaInfoKey.CONTENT_TYPE.toString());
                            info.setValue("text/plain");
                            metaInfos.add(info);
                            info = new DatasyncMetainfoValue();
                            info.setKey(MetaInfoKey.TYPE.toString());
                            info.setValue("INFOMAN_CONFIG");
                            metaInfos.add(info);
                            resource.setMetainfos(metaInfos);
                            resources.add(0, resource);
                            if (this.softwareResource != null) {
                                resources.add(this.softwareResource);
                            }
                            task.setResources(resources);
                            task = this.server.getRemoteUpdateAdapter().createTask(this.deviceType, task);
                            if (task == null) {
                                failedTasks.add(unitId);
                            } else {
                                successfulTasks.add(unitId);
                            }
                        }
                        catch (Exception ex) {
                            log.log(Level.WARNING, "Failed to schedule configuration update task for unit " + unitId, ex);
                            failedTasks.add(unitId);
                        }
                        handle.progress(NbBundle.getMessage(RemoteUpdateHelperImpl.class, (String)"RemoteUpdateHelperImpl.ScheduleSoftwareUpdatesTask.progress.done.msg", (Object)unitId), i);
                    }
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "Group update runs into", ex);
                    DialogUtil.showErrorDialog((Object)NbBundle.getMessage(RemoteUpdateHelperImpl.class, (String)"Tasks.failed.msg"), (String)NbBundle.getMessage(RemoteUpdateHelperImpl.class, (String)"Tasks.failed.title"));
                }
                finally {
                    handle.finish();
                    if (!failedTasks.isEmpty()) {
                        if (failedTasks.size() == this.tasks.size()) {
                            DialogUtil.showErrorDialog((Object)NbBundle.getMessage(RemoteUpdateHelperImpl.class, (String)"Tasks.failed.msg", (Object)this.groupName), (String)NbBundle.getMessage(RemoteUpdateHelperImpl.class, (String)"Tasks.failed.title"));
                        } else {
                            StringBuilder unitIds = new StringBuilder();
                            for (int i = 0; i < failedTasks.size(); ++i) {
                                unitIds.append(failedTasks.get(i));
                                if (i + 1 >= failedTasks.size()) continue;
                                unitIds.append(", ");
                            }
                            DialogUtil.showErrorDialog((Object)NbBundle.getMessage(RemoteUpdateHelperImpl.class, (String)"Tasks.failed.some.msg", (Object)unitIds.toString()), (String)NbBundle.getMessage(RemoteUpdateHelperImpl.class, (String)"Tasks.failed.title"));
                        }
                    } else if (!successfulTasks.isEmpty()) {
                        DialogUtil.showInfoDialog((Object)NbBundle.getMessage(RemoteUpdateHelperImpl.class, (String)"Tasks.scheduledTasks", (Object)new Date(this.scheduledUpdateTime)));
                    }
                }
            }
        }

        protected byte[] fileToByteArray(File configuration) {
            try {
                return FileUtils.readFileToByteArray((File)configuration);
            }
            catch (Exception ex) {
                return null;
            }
        }
    }
}

