/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.push.impl;

import de.proveo.client.configuration.ui.util.MeasurementsHelper;
import de.proveo.client.configuration.ui.util.StatusModelSVGMapping;
import de.proveo.client.configuration.ui.util.StatusModels;
import de.proveo.idm.core.gui.navigation.NavigationTopComponent;
import de.proveo.idm.core.gui.navigation.api.Server;
import de.proveo.idm.core.gui.navigation.api.ServerNavigationItem;
import de.proveo.idm.core.util.ThreadPool;
import de.proveo.idm.remote.server.api.EFMServer;
import de.proveo.idm.remote.server.communication.api.CommunicationConstants;
import de.proveo.idm.remote.server.communication.api.ConnectionStatistics;
import de.proveo.idm.remote.server.navigation.EFMServerNavigationItem;
import de.proveo.idm.remote.server.push.api.DataConsumer;
import de.proveo.idm.remote.server.push.api.DataStorage;
import de.proveo.idm.remote.server.push.api.DataStorageProxy;
import de.proveo.idm.remote.server.push.api.PushConnection;
import de.proveo.idm.remote.server.util.TreeUtil;
import de.proveo.util.unit.MapClientStampUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.SerializationUtils;

public class DataStorageImpl
implements DataStorage {
    private static final Logger log = Logger.getLogger(DataStorageImpl.class.getName());
    private final List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private final Set<DataStorage.ConsumerInterest> consumerInterests = new HashSet<DataStorage.ConsumerInterest>();
    private final List<DataConsumer> consumers = new ArrayList<DataConsumer>();
    private CommunicationConstants.ConnectionStatus connectionStatus = CommunicationConstants.ConnectionStatus.NOT_CONNECTED;
    private final Map<DataStorage.DataType, Map<String, Map<String, Object>>> dataMaps = new EnumMap<DataStorage.DataType, Map<String, Map<String, Object>>>(DataStorage.DataType.class);
    private final Map<DataStorage.DataType, List<Map<String, Object>>> dataLists = new EnumMap<DataStorage.DataType, List<Map<String, Object>>>(DataStorage.DataType.class);
    private final Map<DataStorage.DataType, Object> dataTypeLock = new EnumMap<DataStorage.DataType, Object>(DataStorage.DataType.class);
    private final StatusModelSVGMapping statusModelSvgMapping = new StatusModelSVGMapping();
    private final MeasurementsHelper measurements = new MeasurementsHelper();
    private final StatusModels statusModels = new StatusModels();
    private final DataStorageProxy proxy = new DataStorageProxy(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireBulkDataUpdated(final DataStorage.DataType dataType, List<Map<String, Object>> data) {
            HashSet consumersCopy;
            List list = DataStorageImpl.this.consumers;
            synchronized (list) {
                consumersCopy = new HashSet(DataStorageImpl.this.consumers);
            }
            for (final DataConsumer consumer : consumersCopy) {
                List<Map<String, Object>> dataClone;
                if (!this.isInterested(consumer, dataType)) continue;
                try {
                    dataClone = (List<Map<String, Object>>)((Object)SerializationUtils.clone((Serializable)((Serializable)((Object)data))));
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "Could not clone bulk event data of " + (Object)((Object)dataType), ex);
                    dataClone = data;
                }
                final List<Map<String, Object>> finalDataClone = dataClone;
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        consumer.bulkDataReceived(dataType, finalDataClone);
                    }
                };
                ThreadPool.getInstance().execute(run);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireDataUpdated(DataStorage.DataType dataType, Map<String, Object> data) {
            HashSet consumersCopy;
            List list = DataStorageImpl.this.consumers;
            synchronized (list) {
                consumersCopy = new HashSet(DataStorageImpl.this.consumers);
            }
            for (DataConsumer consumer : consumersCopy) {
                Map<String, Object> dataClone;
                if (!this.isInterested(consumer, dataType)) continue;
                try {
                    dataClone = (Map<String, Object>)((Object)SerializationUtils.clone((Serializable)((Serializable)((Object)data))));
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "Could not clone single event data of " + (Object)((Object)dataType), ex);
                    dataClone = data;
                }
                consumer.singleEventReceived(dataType, dataClone);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireMeasurementsUpdated(String xml) {
            HashSet consumersCopy;
            List list = DataStorageImpl.this.consumers;
            synchronized (list) {
                consumersCopy = new HashSet(DataStorageImpl.this.consumers);
            }
            for (DataConsumer consumer : consumersCopy) {
                if (!consumer.getInterests().contains((Object)DataStorage.ConsumerInterest.UNITS)) continue;
                consumer.measurementsUpdated(xml);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void firePropertyChange(String propName, Object oldValue, Object newValue) {
            List list = DataStorageImpl.this.listeners;
            synchronized (list) {
                PropertyChangeEvent event = new PropertyChangeEvent(this, propName, oldValue, newValue);
                for (PropertyChangeListener l : DataStorageImpl.this.listeners) {
                    l.propertyChange(event);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireStatusModelsUpdated(String xml) {
            HashSet consumersCopy;
            List list = DataStorageImpl.this.consumers;
            synchronized (list) {
                consumersCopy = new HashSet(DataStorageImpl.this.consumers);
            }
            for (DataConsumer consumer : consumersCopy) {
                if (!consumer.getInterests().contains((Object)DataStorage.ConsumerInterest.UNITS)) continue;
                consumer.statusModelsUpdated(xml);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireStatusModelSVGMappingUpdated(String xml) {
            HashSet consumersCopy;
            List list = DataStorageImpl.this.consumers;
            synchronized (list) {
                consumersCopy = new HashSet(DataStorageImpl.this.consumers);
            }
            for (DataConsumer consumer : consumersCopy) {
                if (!consumer.getInterests().contains((Object)DataStorage.ConsumerInterest.UNITS)) continue;
                consumer.statusModelSVGMappingUpdated(xml);
            }
        }

        @Override
        public void fireTreeUpdated(Map unitTreeMap) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    NavigationTopComponent nav = NavigationTopComponent.findInstance();
                    ServerNavigationItem serverNavItem = nav.findServerNavigationItemByServer((Server)DataStorageImpl.this.server);
                    if (serverNavItem != null && serverNavItem instanceof EFMServerNavigationItem) {
                        TreeUtil.refreshTreeForServerItem((EFMServerNavigationItem)serverNavItem);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                SwingUtilities.invokeLater(run);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<DataStorage.ConsumerInterest> getConsumersInterests() {
            List list = DataStorageImpl.this.consumers;
            synchronized (list) {
                return DataStorageImpl.this.consumerInterests;
            }
        }

        @Override
        public DataStorage getDataStorage() {
            return DataStorageImpl.this;
        }

        @Override
        public EFMServer getServer() {
            return DataStorageImpl.this.server;
        }

        private boolean isInterested(DataConsumer consumer, DataStorage.DataType dataType) {
            DataStorage.ConsumerInterest[] interests;
            List<DataStorage.ConsumerInterest> cInterests = consumer.getInterests();
            for (DataStorage.ConsumerInterest ci : interests = dataType.getInterests()) {
                if (!cInterests.contains((Object)ci)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeDataByIdentifier(DataStorage.DataType dataType, String id) {
            Object lock;
            String identifier = dataType.getIdentifier();
            if (identifier == null) {
                log.log(Level.WARNING, "Could not remove data with null identifier of data type ''{0}''!", (Object)dataType);
                return;
            }
            Object object = lock = DataStorageImpl.this.getDataTypeLock(dataType);
            synchronized (object) {
                Map dataMap = (Map)DataStorageImpl.this.dataMaps.get((Object)dataType);
                if (dataMap != null && dataMap.containsKey(id)) {
                    dataMap.remove(id);
                    HashMap<String, Object> dummyData = new HashMap<String, Object>();
                    dummyData.put(identifier, id);
                    this.fireDataUpdated(dataType, dummyData);
                }
            }
        }

        @Override
        public void setConnectionStatus(CommunicationConstants.ConnectionStatus status) {
            CommunicationConstants.ConnectionStatus old = DataStorageImpl.this.connectionStatus;
            DataStorageImpl.this.connectionStatus = status;
            this.firePropertyChange("DataStorageImpl.connectionStatus", (Object)old, (Object)DataStorageImpl.this.connectionStatus);
            switch (DataStorageImpl.this.connectionStatus) {
                case RECONNECTED: {
                    DataStorageImpl.this.getConnectionStatistics().addSuccessfulServerReconnect();
                    break;
                }
                case WAITING_FOR_RECONNECT: {
                    DataStorageImpl.this.getConnectionStatistics().addServerReconnect();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setData(DataStorage.DataType dataType, List<Map<String, Object>> data) {
            Object lock;
            Object object = lock = DataStorageImpl.this.getDataTypeLock(dataType);
            synchronized (object) {
                String identifier = dataType.getIdentifier();
                if (identifier == null) {
                    DataStorageImpl.this.dataLists.put(dataType, data);
                } else {
                    HashMap<String, Map<String, Object>> dataMap = new HashMap<String, Map<String, Object>>();
                    for (Map<String, Object> map : data) {
                        Object id = map.get(identifier);
                        if (id == null || id.toString().trim().length() == 0) {
                            log.log(Level.WARNING, "Received {0} data without excpected identifier ''{1}''! Data was: {2}", new Object[]{dataType, identifier, MapClientStampUtil.toString(map)});
                            continue;
                        }
                        dataMap.put(id.toString(), map);
                    }
                    DataStorageImpl.this.dataMaps.put(dataType, dataMap);
                }
            }
            this.fireBulkDataUpdated(dataType, data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateData(DataStorage.DataType dataType, Map<String, Object> data) {
            Object lock;
            Object object = lock = DataStorageImpl.this.getDataTypeLock(dataType);
            synchronized (object) {
                String identifier = dataType.getIdentifier();
                if (identifier == null) {
                    ArrayList<Map<String, Object>> dataList = (ArrayList<Map<String, Object>>)DataStorageImpl.this.dataLists.get((Object)dataType);
                    if (dataList == null) {
                        dataList = new ArrayList<Map<String, Object>>();
                    }
                    dataList.add(data);
                    DataStorageImpl.this.dataLists.put(dataType, dataList);
                } else {
                    Object id;
                    HashMap<String, Map<String, Object>> dataMap = (HashMap<String, Map<String, Object>>)DataStorageImpl.this.dataMaps.get((Object)dataType);
                    if (dataMap == null) {
                        dataMap = new HashMap<String, Map<String, Object>>();
                    }
                    if ((id = data.get(identifier)) == null || id.toString().trim().length() == 0) {
                        log.log(Level.WARNING, "Received {0} data without excpected identifier ''{1}''! Event was: {2}", new Object[]{dataType, identifier, MapClientStampUtil.toString(data)});
                        return;
                    }
                    Map<String, Object> currentData = (Map<String, Object>)dataMap.get(id.toString());
                    if (currentData != null) {
                        currentData.putAll(data);
                    } else {
                        currentData = data;
                    }
                    dataMap.put(id.toString(), currentData);
                    DataStorageImpl.this.dataMaps.put(dataType, dataMap);
                }
            }
            this.fireDataUpdated(dataType, data);
        }

        @Override
        public void updateMeasurements(String xml) {
            DataStorageImpl.this.measurements.setMeasurements(xml);
            this.fireMeasurementsUpdated(xml);
        }

        @Override
        public void updateStatusModelSVGMapping(String xml) {
            DataStorageImpl.this.statusModelSvgMapping.setStatusModelSVGMapping(xml);
            this.fireStatusModelSVGMappingUpdated(xml);
        }

        @Override
        public void updateStatusModels(String xml) {
            DataStorageImpl.this.statusModels.setStatusModels(xml);
            this.fireStatusModelsUpdated(xml);
        }
    };
    private final PushConnection connection;
    private final EFMServer server;

    public DataStorageImpl(EFMServer server) {
        this.server = server;
        for (DataStorage.DataType dataType : DataStorage.DataType.values()) {
            this.dataTypeLock.put(dataType, new Object());
        }
        this.connection = this.server.getRemoteMapAdapter().getPushConnection(this.proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<DataStorage.ConsumerInterest> _getConsumersInterests() {
        HashSet<DataConsumer> consumersCopy;
        List<DataConsumer> list = this.consumers;
        synchronized (list) {
            consumersCopy = new HashSet<DataConsumer>(this.consumers);
        }
        HashSet<DataStorage.ConsumerInterest> ret = new HashSet<DataStorage.ConsumerInterest>();
        for (DataConsumer consumer : consumersCopy) {
            List<DataStorage.ConsumerInterest> interests = consumer.getInterests();
            for (DataStorage.ConsumerInterest interest : interests) {
                if (ret.contains((Object)interest)) continue;
                ret.add(interest);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterConsumer(DataConsumer consumer) {
        boolean consumersEmpty;
        if (consumer == null) {
            return;
        }
        List<DataConsumer> list = this.consumers;
        synchronized (list) {
            if (!this.consumers.contains(consumer)) {
                return;
            }
            this.consumers.remove(consumer);
            consumersEmpty = this.consumers.isEmpty();
        }
        if (consumersEmpty) {
            this.connection.stopPushConnection();
            this.consumerInterests.clear();
        } else {
            Set<DataStorage.ConsumerInterest> interests = this._getConsumersInterests();
            if (this.consumerInterests.size() < interests.size()) {
                this.consumerInterests.clear();
                this.consumerInterests.addAll(interests);
                this.connection.reconnectPushConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, Object>> getBulkData(DataStorage.DataType dataType) {
        Object lock;
        Object object = lock = this.getDataTypeLock(dataType);
        synchronized (object) {
            String identifier = dataType.getIdentifier();
            if (identifier == null) {
                List ret = this.dataLists.get((Object)dataType);
                if (ret != null) {
                    try {
                        ret = (List)((Object)SerializationUtils.clone((Serializable)((Serializable)((Object)ret))));
                    }
                    catch (Exception ex) {
                        log.log(Level.WARNING, "Could not clone bulk data of " + (Object)((Object)dataType), ex);
                    }
                    return ret;
                }
            } else {
                Map ret = this.dataMaps.get((Object)dataType);
                if (ret != null) {
                    try {
                        ret = (Map)((Object)SerializationUtils.clone((Serializable)((Serializable)((Object)ret))));
                    }
                    catch (Exception ex) {
                        log.log(Level.WARNING, "Could not clone bulk data of " + (Object)((Object)dataType), ex);
                    }
                    return new ArrayList<Map<String, Object>>(ret.values());
                }
            }
            return null;
        }
    }

    @Override
    public CommunicationConstants.ConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    @Override
    public ConnectionStatistics getConnectionStatistics() {
        return this.connection.getConnectionStatistics();
    }

    private Object getDataTypeLock(DataStorage.DataType dataType) {
        return this.dataTypeLock.get((Object)dataType);
    }

    @Override
    public MeasurementsHelper getMeasurements() {
        return this.measurements;
    }

    @Override
    public StatusModelSVGMapping getStatusModelSvgMapping() {
        return this.statusModelSvgMapping;
    }

    @Override
    public StatusModels getStatusModels() {
        return this.statusModels;
    }

    @Override
    public void reconnect() {
        this.connection.reconnectPushConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConsumer(DataConsumer consumer) throws Exception {
        boolean wasEmpty;
        if (consumer == null) {
            return;
        }
        List<DataConsumer> list = this.consumers;
        synchronized (list) {
            wasEmpty = this.consumers.isEmpty();
            this.consumers.add(consumer);
        }
        if (wasEmpty) {
            this.consumerInterests.addAll(this._getConsumersInterests());
            this.connection.startPushConnection();
        } else {
            Set<DataStorage.ConsumerInterest> interests = this._getConsumersInterests();
            if (this.consumerInterests.size() < interests.size()) {
                this.consumerInterests.addAll(interests);
                this.connection.reconnectPushConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }
}

