/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.push.api;

import de.proveo.util.events.NotifyEvent;
import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataPreparationUtil {
    private static final Logger log = Logger.getLogger(DataPreparationUtil.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map createUnitTreeMapFromXml(String treeXml) {
        String method = "createUnitTreeMapFromXml(): ";
        Map unitTreeMap = null;
        if (treeXml == null) {
            log.log(Level.WARNING, "{0}xml string of unit tree was null. Returning null ...", method);
            return null;
        }
        if (treeXml.trim().length() == 0) {
            log.log(Level.WARNING, "{0}xml string of unit tree was empty. Returning null ...", method);
            return null;
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(treeXml.getBytes("utf-8"));
            try {
                XMLDecoder decoder = new XMLDecoder(in);
                unitTreeMap = (Map)decoder.readObject();
                if (unitTreeMap == null) {
                    log.log(Level.WARNING, "{0}XMLDecoder could not get UnitTree-Map! (unitTree == null)", method);
                } else {
                    log.log(Level.INFO, "{0}received a new unit tree.", method);
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    log.log(Level.WARNING, method + "could not close ByteArrayInputStream of XMLDecoder for unit tree", ex);
                }
            }
        }
        catch (UnsupportedEncodingException ex) {
            log.log(Level.WARNING, method + "runs into", ex);
        }
        return unitTreeMap;
    }

    public static Map<String, Object> prepareNotifyEvent(Map eventMap) {
        String eventType = (String)eventMap.get("EventType");
        if (eventType == null) {
            log.warning("Got an event map without event type, cannot be a notify event!");
            return null;
        }
        boolean notifyEvent = eventType.equals("data_type_notification_event");
        if (!notifyEvent) {
            log.log(Level.WARNING, "Got a non notify event! Event type was: {0}", eventType);
            return null;
        }
        Long unitId = (Long)eventMap.get("UnitId");
        if (unitId == null) {
            log.warning("Received single notify event does not contain an unit ID!");
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Received single notify event for unit ID ''{0}''", unitId);
        }
        Long msgId = (Long)eventMap.get("NotifyMessageID");
        String msg = (String)eventMap.get("NotifyMessage");
        Boolean entry = (Boolean)eventMap.get("NotifyEntry");
        Long timestamp = (Long)eventMap.get("NotifyTimestamp");
        Long receiveTime = (Long)eventMap.get("NotifyReceiveTime");
        TreeMap<String, NotifyEvent> notifies = new TreeMap<String, NotifyEvent>();
        notifies.put(timestamp + "_" + msgId, new NotifyEvent(unitId.longValue(), msgId.longValue(), msg, entry == null ? false : entry, timestamp.longValue(), receiveTime.longValue()));
        HashMap<String, Object> event = new HashMap<String, Object>();
        event.put("EventType", "data_type_notification_event");
        event.put("UnitId", unitId);
        event.put("NotifyEvents", notifies);
        return event;
    }

    public static TreeMap<Long, NotifyEvent> prepareNotifyEvents(long unitId, Map<String, Object> stamp) {
        TreeMap<Long, NotifyEvent> notifyEvents = new TreeMap<Long, NotifyEvent>();
        if (stamp == null) {
            return notifyEvents;
        }
        Map unitNotifysMap = (Map)stamp.get("NotifyEvents");
        if (unitNotifysMap != null && !unitNotifysMap.isEmpty()) {
            Iterator ite = unitNotifysMap.keySet().iterator();
            while (ite.hasNext()) {
                String key = ((String)ite.next()).toString();
                Object value = unitNotifysMap.get(key);
                if (!(value instanceof Map)) continue;
                Map notifyEvent = (Map)value;
                Long msgId = (Long)notifyEvent.get("NotifyMessageID");
                String msg = (String)notifyEvent.get("NotifyMessage");
                Boolean entry = (Boolean)notifyEvent.get("NotifyEntry");
                Long timestamp = (Long)notifyEvent.get("NotifyTimestamp");
                Long receiveTime = (Long)notifyEvent.get("NotifyReceiveTime");
                while (notifyEvents.containsKey(timestamp)) {
                    Long l = timestamp;
                    Long l2 = timestamp = Long.valueOf(timestamp + 1L);
                }
                NotifyEvent ne = new NotifyEvent(unitId, msgId.longValue(), msg, entry.booleanValue(), timestamp.longValue(), receiveTime.longValue());
                notifyEvents.put(timestamp, ne);
            }
        }
        return notifyEvents;
    }
}

