/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.navigation.nodes.selectable;

import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.gui.navigation.filter.AcceptAllFilter;
import de.proveo.idm.core.gui.navigation.filter.NavigationFilter;
import de.proveo.idm.core.gui.navigation.filter.TextFilter;
import de.proveo.idm.core.gui.util.NotificationMessage;
import de.proveo.idm.core.gui.util.Validatable;
import de.proveo.idm.core.gui.util.ValidationListener;
import de.proveo.idm.remote.server.navigation.nodes.AggregateFilterNode;
import de.proveo.idm.remote.server.navigation.nodes.selectable.SelectableNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class TreeSelectionPanel
extends JPanel
implements ExplorerManager.Provider,
Lookup.Provider,
Validatable {
    private static final Logger log = Logger.getLogger(TreeSelectionPanel.class.getName());
    private final NodeValidationListener nvl = new NodeValidationListener();
    protected final List<ValidationListener> listeners = new ArrayList<ValidationListener>();
    protected final ExplorerManager em = new ExplorerManager();
    protected final Lookup lookup;
    protected final String message;
    protected final String columnTitle;
    private JLabel descLbl;
    private JLabel filterLbl;
    private JPanel filterPanel;
    private JTextField filterTxtFld;
    private JScrollPane treeView;

    public TreeSelectionPanel(String message, String columnTitle, Node rootNode) {
        this.message = message;
        this.columnTitle = columnTitle;
        this.initComponents();
        ((OutlineView)this.treeView).setDragSource(false);
        ((OutlineView)this.treeView).setDropTarget(false);
        ((OutlineView)this.treeView).setPopupAllowed(false);
        ((OutlineView)this.treeView).setTreeSortable(true);
        ((OutlineView)this.treeView).setQuickSearchAllowed(false);
        ((OutlineView)this.treeView).setDefaultActionAllowed(false);
        ((OutlineView)this.treeView).getOutline().setColumnHidingAllowed(false);
        ((OutlineView)this.treeView).getOutline().setSelectionMode(0);
        this.lookup = ExplorerUtils.createLookup((ExplorerManager)this.em, (ActionMap)this.getActionMap());
        this.applyFilter("", rootNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValidationListener(ValidationListener vl) {
        List<ValidationListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(vl);
        }
    }

    private void applyFilter(String filterString, Node root) {
        Node previousRoot = this.em.getRootContext();
        if (previousRoot != null) {
            previousRoot.removeNodeListener((NodeListener)this.nvl);
        }
        TextFilter filter = new TextFilter(filterString, false);
        if (filterString == null || filterString.length() == 0) {
            filter = new AcceptAllFilter();
        }
        if (root instanceof AggregateFilterNode) {
            root = ((AggregateFilterNode)root).getOriginal();
        }
        AggregateFilterNode newRoot = new AggregateFilterNode(root, Device.DeviceType.ANY, (NavigationFilter)filter);
        if (root.isLeaf()) {
            newRoot = new AggregateFilterNode(root);
        }
        this.em.setRootContext((Node)newRoot);
        newRoot.addNodeListener((NodeListener)this.nvl);
        this.expandNodeRecursive(root);
        this.treeView.repaint();
    }

    public boolean checkValidation() {
        return this.isAnyNodeSelected();
    }

    protected void expandNodeRecursive(Node node) {
        ((OutlineView)this.treeView).expandNode(node);
        Children children = node.getChildren();
        for (int i = 0; i < children.getNodesCount(true); ++i) {
            Node child = children.getNodeAt(i);
            this.expandNodeRecursive(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNotificationChanged() {
        List<ValidationListener> list = this.listeners;
        synchronized (list) {
            for (ValidationListener vl : this.listeners) {
                vl.notificationChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireValidationChanged() {
        List<ValidationListener> list = this.listeners;
        synchronized (list) {
            for (ValidationListener vl : this.listeners) {
                vl.validationChanged();
            }
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.em;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public NotificationMessage getNotificationMessage() {
        if (!this.isAnyNodeSelected()) {
            return new NotificationMessage(0, NbBundle.getMessage(TreeSelectionPanel.class, (String)"TreeSelectionPanel.nothingSelected.msg"));
        }
        return null;
    }

    public <T> List<T> getSelectedObjects(Class<? extends T> domainObjectType) {
        Node root = this.em.getRootContext();
        if (root instanceof AggregateFilterNode) {
            root = ((AggregateFilterNode)root).getOriginal();
        }
        return this.getSelectedObjects(domainObjectType, root);
    }

    protected <T> List<T> getSelectedObjects(Class<? extends T> domainObjectType, Node node) {
        ArrayList<Object> selectedDomainObjects = new ArrayList<Object>();
        if (node instanceof AggregateFilterNode) {
            node = ((AggregateFilterNode)node).getOriginal();
        }
        Children children = node.getChildren();
        for (int i = 0; i < children.getNodesCount(true); ++i) {
            Object domainObject;
            Boolean selected;
            Node child = children.getNodeAt(i);
            while (child instanceof AggregateFilterNode) {
                child = ((AggregateFilterNode)child).getOriginal();
            }
            SelectableNode checkNode = (SelectableNode)child.getLookup().lookup(SelectableNode.class);
            if (checkNode != null && ((selected = checkNode.isSelected()) == null || Boolean.TRUE.equals(selected)) && (domainObject = child.getLookup().lookup(domainObjectType)) != null) {
                selectedDomainObjects.add(domainObject);
            }
            selectedDomainObjects.addAll(this.getSelectedObjects(domainObjectType, child));
        }
        return selectedDomainObjects;
    }

    private void initComponents() {
        this.descLbl = new JLabel();
        this.treeView = new OutlineView(this.columnTitle);
        this.filterPanel = new JPanel();
        this.filterLbl = new JLabel();
        this.filterTxtFld = new JTextField();
        this.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.descLbl, (String)this.message);
        this.descLbl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.descLbl, "North");
        this.treeView.setBorder(null);
        this.add((Component)this.treeView, "Center");
        this.filterPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.filterPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.filterLbl, (String)NbBundle.getMessage(TreeSelectionPanel.class, (String)"TreeSelectionPanel.filterLbl.text"));
        this.filterLbl.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3));
        this.filterPanel.add((Component)this.filterLbl, "West");
        this.filterTxtFld.setText(NbBundle.getMessage(TreeSelectionPanel.class, (String)"TreeSelectionPanel.filterTxtFld.text"));
        this.filterTxtFld.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TreeSelectionPanel.this.filterTxtFldKeyReleased(evt);
            }
        });
        this.filterPanel.add((Component)this.filterTxtFld, "Center");
        this.add((Component)this.filterPanel, "South");
    }

    private void filterTxtFldKeyReleased(KeyEvent evt) {
        final Node root = this.em.getRootContext();
        final String filterString = this.filterTxtFld.getText();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                TreeSelectionPanel.this.applyFilter(filterString, root);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    protected boolean isAnyNodeSelected() {
        Node root = this.em.getRootContext();
        if (root instanceof AggregateFilterNode) {
            root = ((AggregateFilterNode)root).getOriginal();
        }
        return this.isAnyNodeSelected(root);
    }

    protected boolean isAnyNodeSelected(Node node) {
        boolean ret = false;
        if (node instanceof AggregateFilterNode) {
            node = ((AggregateFilterNode)node).getOriginal();
        }
        Children children = node.getChildren();
        for (int i = 0; i < children.getNodesCount(true); ++i) {
            Boolean selected;
            Node child = children.getNodeAt(i);
            while (child instanceof AggregateFilterNode) {
                child = ((AggregateFilterNode)child).getOriginal();
            }
            SelectableNode checkNode = (SelectableNode)child.getLookup().lookup(SelectableNode.class);
            if (checkNode != null && Boolean.TRUE.equals(selected = checkNode.isSelected())) {
                return true;
            }
            if (!this.isAnyNodeSelected(child)) continue;
            return true;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValidationListener(ValidationListener vl) {
        List<ValidationListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(vl);
        }
    }

    public <T> void setSelectedObjects(Class<? extends T> domainObjectType, List<T> selectedObjects) {
        Node root = this.em.getRootContext();
        this.setSelectedObjects(domainObjectType, selectedObjects, root);
        this.fireValidationChanged();
        this.treeView.repaint();
        this.treeView.revalidate();
    }

    protected <T> void setSelectedObjects(Class<? extends T> domainObjectType, List<T> selectedObjects, Node node) {
        Children children = node.getChildren();
        for (int i = 0; i < children.getNodesCount(true); ++i) {
            Object domainObject;
            Node child = children.getNodeAt(i);
            SelectableNode checkNode = (SelectableNode)child.getLookup().lookup(SelectableNode.class);
            if (checkNode != null && (domainObject = child.getLookup().lookup(domainObjectType)) != null) {
                checkNode.setSelected(selectedObjects.contains(domainObject));
            }
            this.setSelectedObjects(domainObjectType, selectedObjects, child);
        }
    }

    private class NodeValidationListener
    extends NodeAdapter {
        private NodeValidationListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            TreeSelectionPanel.this.fireValidationChanged();
            TreeSelectionPanel.this.treeView.repaint();
            TreeSelectionPanel.this.treeView.revalidate();
        }
    }
}

