/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.navigation.nodes.selectable;

import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.remote.server.api.RemoteInfoman;
import de.proveo.idm.remote.server.navigation.nodes.ChangeableNode;
import de.proveo.idm.remote.server.navigation.nodes.selectable.CheckableRemoteGroupNode;
import de.proveo.idm.remote.server.navigation.nodes.selectable.CheckableRemoteInfomanNode;
import de.proveo.idm.remote.server.navigation.nodes.selectable.RemoteInfomanFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class CheckableRemoteGroupItemChildren
extends Children.Keys<NavigationItem> {
    private NavigationItem navigationItem;
    private final RemoteInfomanFilter filter;
    private final Boolean initialSelection;
    private Device.DeviceType[] deviceTypeFilters;

    public CheckableRemoteGroupItemChildren(NavigationItem navigationItem, RemoteInfomanFilter filter, Boolean initialSelection, Device.DeviceType ... deviceTypeFilters) {
        this.navigationItem = navigationItem;
        this.filter = filter;
        this.initialSelection = initialSelection;
        this.deviceTypeFilters = deviceTypeFilters;
        if (this.deviceTypeFilters == null || this.deviceTypeFilters.length == 0) {
            this.deviceTypeFilters = new Device.DeviceType[]{Device.DeviceType.ANY};
        }
    }

    protected void addNotify() {
        super.addNotify();
        this.setKeys(this.navigationItem.getChildren());
    }

    protected boolean containsNavigationItemRemoteInfomansForDeviceTypes(NavigationItem item, RemoteInfomanFilter filter, Device.DeviceType ... deviceTypes) {
        List childItems = item.getChildren();
        for (NavigationItem childItem : childItems) {
            RemoteInfoman infoman;
            if (!(childItem instanceof RemoteInfoman ? this.isAllowedRemoteInfoman(infoman = (RemoteInfoman)childItem, filter, deviceTypes) : this.containsNavigationItemRemoteInfomansForDeviceTypes(childItem, filter, deviceTypes))) continue;
            return true;
        }
        return false;
    }

    protected Node[] createNodes(NavigationItem key) {
        ChangeableNode node = null;
        if (key instanceof RemoteInfoman) {
            RemoteInfoman infoman = (RemoteInfoman)key;
            if (this.isAllowedRemoteInfoman(infoman, this.filter, this.deviceTypeFilters)) {
                node = new CheckableRemoteInfomanNode((RemoteInfoman)key, this.initialSelection);
            }
        } else if (this.containsNavigationItemRemoteInfomansForDeviceTypes(key, this.filter, this.deviceTypeFilters)) {
            node = new CheckableRemoteGroupNode(key, this.filter, this.initialSelection, this.deviceTypeFilters);
        }
        if (node != null) {
            return new Node[]{node};
        }
        return null;
    }

    protected boolean isAllowedRemoteInfoman(RemoteInfoman infoman, RemoteInfomanFilter filter, Device.DeviceType ... deviceTypes) {
        Device.DeviceType devType = infoman.getDeviceType();
        if (devType == null) {
            devType = Device.DeviceType.INFOMAN;
        }
        return !(filter != null && !filter.matches(infoman) || !ArrayUtils.contains((Object[])deviceTypes, (Object)Device.DeviceType.ANY) && !ArrayUtils.contains((Object[])deviceTypes, (Object)devType));
    }

    public void update() {
        Node[] childNodes;
        for (Node child : childNodes = (Node[])ArrayUtils.clone((Object[])this.getNodes())) {
            if (!child.canDestroy()) continue;
            try {
                child.destroy();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.setKeys(new ArrayList());
        this.setKeys(this.navigationItem.getChildren());
    }
}

