/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.navigation.nodes;

import de.proveo.domain.values.datasync.DatasyncTaskValue;
import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.gui.navigation.sheet.ReadOnlyProperty;
import de.proveo.idm.core.gui.util.MenuUtil;
import de.proveo.idm.remote.server.api.RemoteDeviceId;
import de.proveo.idm.remote.server.api.RemoteUpdateAdapter;
import de.proveo.idm.remote.server.api.ZeroConfUnit;
import de.proveo.idm.remote.server.navigation.nodes.TaskChildFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.SortedMap;
import javax.swing.Action;
import org.apache.commons.lang3.ArrayUtils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.xml.sax.SAXException;

public class ZeroConfUnitNode
extends AbstractNode {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");
    private PropertyChangeListener listener;

    public ZeroConfUnitNode(ZeroConfUnit item) {
        super(Children.LEAF, Lookups.singleton((Object)item));
        this.setChildren(this.createChildren(item));
        this.setIconBaseWithExtension(item.getIconBaseWithExtension());
        this.setDisplayName(item.getName());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("de.proveo.idm.remote.server.easyInstall");
    }

    private Children createChildren(ZeroConfUnit zeroConf) {
        Children children;
        block7: {
            children = Children.LEAF;
            if (zeroConf != null) {
                RemoteUpdateAdapter adapter = zeroConf.getEFMServer().getRemoteUpdateAdapter();
                if (this.listener == null) {
                    this.listener = new PropertyChangeListenerImpl();
                    adapter.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)adapter));
                }
                if (adapter.hasTasks()) {
                    try {
                        RemoteDeviceId id = zeroConf.getId();
                        Collection<DatasyncTaskValue> tasks = adapter.getTasks(id);
                        if (tasks.isEmpty()) {
                            children = Children.LEAF;
                            break block7;
                        }
                        children = Children.create((ChildFactory)new TaskChildFactory(zeroConf, adapter, id), (boolean)true);
                    }
                    catch (Exception ex) {
                        children = Children.LEAF;
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else {
                    children = Children.LEAF;
                }
            }
        }
        return children;
    }

    protected Sheet createSheet() {
        ZeroConfUnit unit = (ZeroConfUnit)this.getLookup().lookup(ZeroConfUnit.class);
        Sheet sheet = super.createSheet();
        Sheet.Set zeroConf = Sheet.createPropertiesSet();
        zeroConf.setName("zeroConf");
        zeroConf.setDisplayName(NbBundle.getMessage(ZeroConfUnitNode.class, (String)"ZeroConfUnitNode.set.data"));
        try {
            SortedMap attributes = unit.getEnv();
            String displayName = NbBundle.getMessage(ZeroConfUnitNode.class, (String)"unitId");
            Object value = unit.getUnitId();
            if (unit.getUnitId() == -1L) {
                value = NbBundle.getMessage(ZeroConfUnitNode.class, (String)"unitId.unknown");
            }
            ReadOnlyProperty attribute = new ReadOnlyProperty("unitId", displayName, value);
            zeroConf.put((Node.Property)attribute);
            displayName = NbBundle.getMessage(ZeroConfUnitNode.class, (String)"hardwareSerialNumber");
            value = attributes.get("hardwareSerialNumber");
            attribute = new ReadOnlyProperty("hardwareSerialNumber", displayName, value);
            zeroConf.put((Node.Property)attribute);
            displayName = NbBundle.getMessage(ZeroConfUnitNode.class, (String)"deviceType");
            value = unit.getDeviceType();
            if (Device.DeviceType.UNKNOWN.equals(value)) {
                value = value + " (" + attributes.get("deviceType") + ")";
            }
            attribute = new ReadOnlyProperty("deviceType", displayName, value);
            zeroConf.put((Node.Property)attribute);
            displayName = NbBundle.getMessage(ZeroConfUnitNode.class, (String)"description");
            value = attributes.get("description");
            attribute = new ReadOnlyProperty("description", displayName, value);
            zeroConf.put((Node.Property)attribute);
            displayName = NbBundle.getMessage(ZeroConfUnitNode.class, (String)"firstMessageReceiveTimestamp");
            value = attributes.get("firstMessageReceiveTimestamp");
            long timestamp = 0L;
            if (value != null) {
                try {
                    timestamp = Long.parseLong(value.toString());
                }
                catch (NumberFormatException ex) {
                    timestamp = 0L;
                }
            }
            value = NbBundle.getMessage(ZeroConfUnitNode.class, (String)"timestamp.never");
            if (timestamp > 0L) {
                value = DATE_FORMAT.format(new Date(timestamp));
            }
            ReadOnlyProperty attribute2 = new ReadOnlyProperty("firstMessageReceiveTimestamp", displayName, value);
            zeroConf.put((Node.Property)attribute2);
            displayName = NbBundle.getMessage(ZeroConfUnitNode.class, (String)"firstMessageTimestamp");
            value = attributes.get("firstMessageTimestamp");
            timestamp = 0L;
            if (value != null) {
                try {
                    timestamp = Long.parseLong(value.toString());
                }
                catch (NumberFormatException ex) {
                    timestamp = 0L;
                }
            }
            value = NbBundle.getMessage(ZeroConfUnitNode.class, (String)"timestamp.never");
            if (timestamp > 0L) {
                value = DATE_FORMAT.format(new Date(timestamp));
            }
            attribute2 = new ReadOnlyProperty("firstMessageTimestamp", displayName, value);
            zeroConf.put((Node.Property)attribute2);
            displayName = NbBundle.getMessage(ZeroConfUnitNode.class, (String)"lastMessageReceiveTimestamp");
            value = attributes.get("lastMessageReceiveTimestamp");
            timestamp = 0L;
            if (value != null) {
                try {
                    timestamp = Long.parseLong(value.toString());
                }
                catch (NumberFormatException ex) {
                    timestamp = 0L;
                }
            }
            value = NbBundle.getMessage(ZeroConfUnitNode.class, (String)"timestamp.never");
            if (timestamp > 0L) {
                value = DATE_FORMAT.format(new Date(timestamp));
            }
            attribute2 = new ReadOnlyProperty("lastMessageReceiveTimestamp", displayName, value);
            zeroConf.put((Node.Property)attribute2);
            displayName = NbBundle.getMessage(ZeroConfUnitNode.class, (String)"lastMessageTimestamp");
            value = attributes.get("lastMessageTimestamp");
            timestamp = 0L;
            if (value != null) {
                try {
                    timestamp = Long.parseLong(value.toString());
                }
                catch (NumberFormatException ex) {
                    timestamp = 0L;
                }
            }
            value = NbBundle.getMessage(ZeroConfUnitNode.class, (String)"timestamp.never");
            if (timestamp > 0L) {
                value = DATE_FORMAT.format(new Date(timestamp));
            }
            attribute2 = new ReadOnlyProperty("lastMessageTimestamp", displayName, value);
            zeroConf.put((Node.Property)attribute2);
            displayName = NbBundle.getMessage(ZeroConfUnitNode.class, (String)"name");
            value = attributes.get("name");
            attribute = new ReadOnlyProperty("name", displayName, value);
            zeroConf.put((Node.Property)attribute);
            displayName = NbBundle.getMessage(ZeroConfUnitNode.class, (String)"productSerialNumber");
            value = attributes.get("productSerialNumber");
            attribute = new ReadOnlyProperty("productSerialNumber", displayName, value);
            zeroConf.put((Node.Property)attribute);
            displayName = NbBundle.getMessage(ZeroConfUnitNode.class, (String)"zeroconfId");
            value = attributes.get("zeroconfId");
            attribute = new ReadOnlyProperty("zeroconfId", displayName, value);
            zeroConf.put((Node.Property)attribute);
            sheet.put(zeroConf);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return sheet;
    }

    public Action[] getActions(boolean context) {
        ArrayList actions = new ArrayList();
        List registeredActions = new ArrayList();
        try {
            registeredActions = MenuUtil.actionsForPaths((String[])new String[]{"Actions/Remote/ZeroConf"});
        }
        catch (SAXException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        List<Action> superActions = Arrays.asList(super.getActions(context));
        actions.addAll(registeredActions);
        actions.addAll(superActions);
        return actions.toArray(new Action[actions.size()]);
    }

    private class PropertyChangeListenerImpl
    implements PropertyChangeListener {
        private PropertyChangeListenerImpl() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            if (property.equals("RemoteUpdateAdapter.task.create") || property.equals("RemoteUpdateAdapter.task.cancel") || property.equals("RemoteUpdateAdapter.task.edit")) {
                ZeroConfUnit zeroConf = (ZeroConfUnit)ZeroConfUnitNode.this.getLookup().lookup(ZeroConfUnit.class);
                DatasyncTaskValue task = (DatasyncTaskValue)evt.getNewValue();
                if (zeroConf.getSerialNumber().equals(task.getClientSerialNumber())) {
                    Node[] childNodes;
                    for (Node child : childNodes = (Node[])ArrayUtils.clone((Object[])ZeroConfUnitNode.this.getChildren().getNodes())) {
                        if (!child.canDestroy()) continue;
                        try {
                            child.destroy();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    ZeroConfUnitNode.this.setChildren(ZeroConfUnitNode.this.createChildren(zeroConf));
                }
            }
        }
    }
}

