/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.navigation.nodes;

import de.proveo.domain.values.datasync.DatasyncTaskValue;
import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.navigation.api.RemoteDevice;
import de.proveo.idm.remote.server.api.RemoteDeviceId;
import de.proveo.idm.remote.server.api.RemoteUpdateAdapter;
import de.proveo.idm.remote.server.navigation.DatasyncTaskNavigationItem;
import de.proveo.idm.remote.server.navigation.nodes.DatasyncTaskNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

public class TaskChildFactory
extends ChildFactory<DatasyncTaskValue> {
    private static final Logger log = Logger.getLogger(TaskChildFactory.class.getName());
    private final RemoteDevice device;
    private final RemoteUpdateAdapter adapter;
    private final RemoteDeviceId id;

    public TaskChildFactory(RemoteDevice device, RemoteUpdateAdapter adapter, RemoteDeviceId id) {
        this.device = device;
        this.adapter = adapter;
        this.id = id;
        this.adapter.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)new PropertyChangeListenerImpl(), (Object)adapter));
    }

    protected boolean createKeys(List<DatasyncTaskValue> toPopulate) {
        try {
            toPopulate.addAll(this.adapter.getTasks(this.id));
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Could not get tasks for unit with ID " + this.id.getUnitId(), ex);
        }
        return true;
    }

    protected Node createNodeForKey(DatasyncTaskValue key) {
        return new DatasyncTaskNode((NavigationItem)new DatasyncTaskNavigationItem(key, (NavigationItem)this.device));
    }

    private class PropertyChangeListenerImpl
    implements PropertyChangeListener {
        private PropertyChangeListenerImpl() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            if (property.equals("RemoteUpdateAdapter.task.create") || property.equals("RemoteUpdateAdapter.task.cancel") || property.equals("RemoteUpdateAdapter.task.edit")) {
                DatasyncTaskValue task = (DatasyncTaskValue)evt.getNewValue();
                if (TaskChildFactory.this.id.getUnitId() == task.getClientId()) {
                    TaskChildFactory.this.refresh(true);
                }
            }
        }
    }
}

