/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.navigation.nodes;

import de.proveo.domain.values.datasync.DatasyncTaskValue;
import de.proveo.idm.core.gui.navigation.NavigationTopComponent;
import de.proveo.idm.core.gui.navigation.api.Connectable;
import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.gui.navigation.nodes.PropertyChangeNode;
import de.proveo.idm.core.gui.navigation.sheet.ReadOnlyProperty;
import de.proveo.idm.core.gui.util.MenuUtil;
import de.proveo.idm.core.util.ThreadPool;
import de.proveo.idm.remote.server.api.AbstractRemoteInfoman;
import de.proveo.idm.remote.server.api.RemoteActionPathProvider;
import de.proveo.idm.remote.server.api.RemoteDeviceId;
import de.proveo.idm.remote.server.api.RemoteInfoman;
import de.proveo.idm.remote.server.api.RemoteInfomanSheetProvider;
import de.proveo.idm.remote.server.api.RemoteInfomanSheetProviderListener;
import de.proveo.idm.remote.server.api.RemoteUpdateAdapter;
import de.proveo.idm.remote.server.navigation.nodes.TaskChildFactory;
import de.proveo.util.unit.MapClientStampUtil;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.ArrayUtils;
import org.openide.explorer.view.CheckableNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;
import org.xml.sax.SAXException;

public class RemoteInfomanNode
extends PropertyChangeNode {
    private static final Logger log = Logger.getLogger(RemoteInfomanNode.class.getName());
    protected static final Image VISIBLE_ON_MAP_OVERLAY = ImageUtilities.loadImage((String)"de/proveo/idm/remote/server/resources/map_overlay.png");
    protected static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");
    private final List<SheetProviderListener> sheetProviderListeners = new ArrayList<SheetProviderListener>();
    protected final Object iconImageLock = new Object();
    protected Sheet.Set envSet = null;
    protected String actionPath = "Actions/Remote/";
    protected volatile boolean positionPresent = true;
    protected volatile boolean visibleOnMap = false;
    protected Image iconImage = null;
    private PropertyChangeListener listener;

    public RemoteInfomanNode(RemoteInfoman infoman) {
        this(infoman, RemoteInfomanNode.createChildren(infoman), Lookups.singleton((Object)infoman));
        RemoteUpdateAdapter adapter = infoman.getServer().getRemoteUpdateAdapter();
        this.listener = new PropertyChangeListenerImpl();
        adapter.addPropertyChangeListener(this.listener);
    }

    protected RemoteInfomanNode(RemoteInfoman infoman, Children children, Lookup lookup) {
        super(children, lookup);
        Device.DeviceType deviceType = infoman.getDeviceType();
        if (deviceType == null) {
            this.actionPath = this.actionPath + "Infoman";
        } else if (deviceType.equals((Object)Device.DeviceType.INFOMAN)) {
            this.actionPath = this.actionPath + "Infoman";
        } else if (deviceType.equals((Object)Device.DeviceType.INFOMAN_EFM)) {
            this.actionPath = this.actionPath + "InfomanLite";
        } else if (deviceType.equals((Object)Device.DeviceType.ERCO_GENER)) {
            this.actionPath = this.actionPath + "ErcoGener";
        } else if (deviceType.equals((Object)Device.DeviceType.TK_CHEL)) {
            this.actionPath = this.actionPath + "TKChel";
        } else if (deviceType.equals((Object)Device.DeviceType.TELIC)) {
            this.actionPath = this.actionPath + "Telic";
        } else if (deviceType.equals((Object)Device.DeviceType.GPS_VISION)) {
            this.actionPath = this.actionPath + "GPSVision";
        } else if (deviceType.equals((Object)Device.DeviceType.OMNICOM)) {
            this.actionPath = this.actionPath + "Omnicom";
        } else if (deviceType.equals((Object)Device.DeviceType.NOMO)) {
            this.actionPath = this.actionPath + "NoMo";
        } else {
            log.log(Level.WARNING, "Unknown device type found for unit ''{0}'': {1}", new Object[]{infoman.getName(), deviceType});
            this.actionPath = this.actionPath + "Unknown";
        }
        this.iconImage = ImageUtilities.loadImage((String)infoman.getIconBaseWithExtension());
        this.setDisplayName(infoman.getName());
        Collection sheetProvider = Lookup.getDefault().lookupAll(RemoteInfomanSheetProvider.class);
        for (RemoteInfomanSheetProvider sp : sheetProvider) {
            if (sp.isSheetDataPresent(infoman.getServer())) {
                this.refreshNodePresentation(sp);
            }
            SheetProviderListener spl = new SheetProviderListener(sp);
            sp.addRemoteInfomanSheetProviderListener(infoman.getServer(), infoman.getUnitId(), spl);
            this.sheetProviderListeners.add(spl);
        }
    }

    protected static Children createChildren(RemoteInfoman infoman) {
        Children children;
        block5: {
            RemoteUpdateAdapter adapter = infoman.getServer().getRemoteUpdateAdapter();
            if (!(infoman instanceof CheckableNode) && adapter.hasTasks()) {
                try {
                    RemoteDeviceId id = infoman.getId();
                    Collection<DatasyncTaskValue> tasks = adapter.getTasks(id);
                    if (tasks.isEmpty()) {
                        children = Children.LEAF;
                        break block5;
                    }
                    children = Children.create((ChildFactory)new TaskChildFactory(infoman, adapter, id), (boolean)true);
                }
                catch (Exception ex) {
                    children = Children.LEAF;
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                children = Children.LEAF;
            }
        }
        return children;
    }

    protected Sheet.Set createEnvironmentSheet(RemoteInfoman infoman) throws Exception {
        Sheet.Set setProps = Sheet.createPropertiesSet();
        setProps.setName("env");
        setProps.setValue("tabName", (Object)NbBundle.getMessage(RemoteInfomanNode.class, (String)"RemoteInfomanNode.tab.env"));
        setProps.setDisplayName(NbBundle.getMessage(RemoteInfomanNode.class, (String)"RemoteInfomanNode.set.env"));
        SortedMap env = infoman.getEnv();
        if (env != null) {
            for (String key : env.keySet()) {
                String description;
                try {
                    description = NbBundle.getMessage(RemoteInfoman.class, (String)key);
                }
                catch (MissingResourceException ex) {
                    description = key;
                    log.log(Level.WARNING, "No resource for key: " + key, ex);
                }
                Object value = env.get(key);
                if (key.equals("request_config_time") || key.equals("sync_time")) {
                    long timestamp = 0L;
                    if (value != null) {
                        try {
                            timestamp = Long.parseLong(value.toString());
                        }
                        catch (NumberFormatException ex) {
                            timestamp = 0L;
                        }
                    }
                    value = NbBundle.getMessage(RemoteInfomanNode.class, (String)"timestamp.never");
                    if (timestamp > 0L) {
                        try {
                            value = DATE_FORMAT.format(new Date(timestamp));
                        }
                        catch (Exception ex) {
                            value = Long.toString(timestamp);
                        }
                    }
                }
                ReadOnlyProperty property = new ReadOnlyProperty(key, description, value);
                setProps.put((Node.Property)property);
            }
        }
        return setProps;
    }

    protected Sheet.Set createPropertiesSheet() {
        RemoteInfoman infoman = (RemoteInfoman)this.getLookup().lookup(RemoteInfoman.class);
        Sheet.Set propSet = Sheet.createPropertiesSet();
        propSet.setName("props");
        propSet.setDisplayName(NbBundle.getMessage(RemoteInfomanNode.class, (String)"RemoteInfomanNode.set.props"));
        long value = infoman.getUnitId();
        String text = Long.toString(value);
        if (value <= 0L) {
            text = NbBundle.getMessage(RemoteInfomanNode.class, (String)"RemoteInfomanNode.attribute.value.unknown");
        }
        ReadOnlyProperty property = new ReadOnlyProperty("unitId", NbBundle.getMessage(RemoteInfomanNode.class, (String)"RemoteInfomanNode.attribute.unitId"), (Object)text);
        propSet.put((Node.Property)property);
        String value2 = infoman.getName();
        if (value2 == null || value2.toString().trim().length() == 0) {
            value2 = "";
        }
        ReadOnlyProperty property2 = new ReadOnlyProperty("unitName", NbBundle.getMessage(RemoteInfomanNode.class, (String)"RemoteInfomanNode.attribute.unitName"), (Object)value2);
        propSet.put((Node.Property)property2);
        value2 = infoman.getSerialNumber();
        if (value2 == null || value2.toString().trim().length() == 0) {
            value2 = NbBundle.getMessage(RemoteInfomanNode.class, (String)"RemoteInfomanNode.attribute.value.na");
        }
        property2 = new ReadOnlyProperty("serialNo", NbBundle.getMessage(RemoteInfomanNode.class, (String)"RemoteInfomanNode.attribute.serialNo"), (Object)value2);
        propSet.put((Node.Property)property2);
        if (infoman instanceof Connectable) {
            value2 = null;
            try {
                value2 = ((Connectable)infoman).getIPAddress();
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Could not fetch IP address for unit ''{0}''", infoman.getName());
            }
            if (value2 == null || value2.toString().trim().length() == 0) {
                value2 = NbBundle.getMessage(RemoteInfomanNode.class, (String)"RemoteInfomanNode.attribute.value.na");
            }
            property2 = new ReadOnlyProperty("ipAddress", NbBundle.getMessage(RemoteInfomanNode.class, (String)"RemoteInfomanNode.attribute.ipAddress"), (Object)value2);
            propSet.put((Node.Property)property2);
        }
        if ((value2 = infoman.getDeviceType()) == null || value2.toString().trim().length() == 0) {
            value2 = NbBundle.getMessage(RemoteInfomanNode.class, (String)"RemoteInfomanNode.attribute.value.unknown") + " (" + NbBundle.getMessage(RemoteInfomanNode.class, (String)"RemoteInfomanNode.attribute.value.assuming") + " " + Device.DeviceType.INFOMAN.toString() + ")";
        }
        property2 = new ReadOnlyProperty("deviceType", NbBundle.getMessage(RemoteInfomanNode.class, (String)"RemoteInfomanNode.attribute.deviceType"), (Object)value2);
        propSet.put((Node.Property)property2);
        return propSet;
    }

    protected synchronized Sheet createSheet() {
        final RemoteInfoman infoman = (RemoteInfoman)this.getLookup().lookup(RemoteInfoman.class);
        final Sheet sheet = super.createSheet();
        Sheet.Set propSet = this.createPropertiesSheet();
        sheet.put(propSet);
        Collection sheetProvider = Lookup.getDefault().lookupAll(RemoteInfomanSheetProvider.class);
        for (RemoteInfomanSheetProvider sp : sheetProvider) {
            if (!sp.isSheetDataPresent(infoman.getServer())) continue;
            Collection<Sheet.Set> sheetSets = sp.createSheets(infoman.getServer(), infoman.getUnitId());
            for (Sheet.Set sheetSet : sheetSets) {
                Sheet.Set currentSet = sheet.get(sheetSet.getName());
                if (currentSet != null) {
                    currentSet.put(sheetSet.getProperties());
                    continue;
                }
                sheet.put(sheetSet);
            }
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    if (RemoteInfomanNode.this.envSet == null) {
                        RemoteInfomanNode.this.envSet = RemoteInfomanNode.this.createEnvironmentSheet(infoman);
                    }
                    sheet.put(RemoteInfomanNode.this.envSet);
                }
                catch (Exception ex) {
                    log.log(Level.INFO, "RemoteInfomanNode.createEnvironmentSheet() runs into", ex);
                }
            }
        };
        ThreadPool.getInstance().execute(run);
        return sheet;
    }

    public void destroy() throws IOException {
        RemoteInfoman infoman;
        if (this.listener != null && (infoman = (AbstractRemoteInfoman)this.getLookup().lookup(AbstractRemoteInfoman.class)) != null) {
            RemoteUpdateAdapter adapter = infoman.getServer().getRemoteUpdateAdapter();
            adapter.removePropertyChangeListener(this.listener);
        }
        infoman = (RemoteInfoman)this.getLookup().lookup(RemoteInfoman.class);
        for (SheetProviderListener spl : this.sheetProviderListeners) {
            spl.getSheetProvider().removeRemoteInfomanSheetProviderListener(infoman.getServer(), infoman.getUnitId(), spl);
        }
        this.sheetProviderListeners.clear();
        super.destroy();
    }

    public Action[] getActions(boolean context) {
        this.refreshEnvironmentSheet();
        ArrayList actions = new ArrayList();
        List registeredActions = new ArrayList();
        Object[] paths = new String[]{};
        boolean generalPathAllowed = true;
        RemoteInfoman infoman = (RemoteInfoman)this.getLookup().lookup(RemoteInfoman.class);
        if (infoman != null) {
            Collection actionPathProviders = Lookup.getDefault().lookupAll(RemoteActionPathProvider.class);
            for (RemoteActionPathProvider actionPathProvider : actionPathProviders) {
                paths = (String[])ArrayUtils.addAll((Object[])paths, (Object[])actionPathProvider.getUnitActionPaths(infoman, context));
                if (!context || !generalPathAllowed || actionPathProvider.isUnitActionPathAllowed(infoman, this.actionPath)) continue;
                generalPathAllowed = false;
            }
        }
        if (generalPathAllowed) {
            paths = (String[])ArrayUtils.addAll((Object[])paths, (Object[])new String[]{this.actionPath});
        }
        try {
            registeredActions = MenuUtil.actionsForPaths((String[])paths);
        }
        catch (SAXException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        actions.addAll(registeredActions);
        return actions.toArray(new Action[actions.size()]);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("de.proveo.idm.remote.server");
    }

    public String getHtmlDisplayName() {
        return "<font color=\"#" + (this.positionPresent ? "000000" : "bbbbbb") + "\">" + this.getDisplayName() + "</font>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Image getIcon(int type) {
        Image image = this.iconImage;
        if (image == null) {
            this.iconImage = image = super.getIcon(type);
        }
        Object object = this.iconImageLock;
        synchronized (object) {
            if (image != null && !this.positionPresent) {
                image = ImageUtilities.createDisabledImage((Image)image);
                Icon tmpIcon = ImageUtilities.image2Icon((Image)image);
                image = ImageUtilities.icon2Image((Icon)tmpIcon);
            }
            if (image != null && this.visibleOnMap) {
                image = ImageUtilities.mergeImages((Image)image, (Image)VISIBLE_ON_MAP_OVERLAY, (int)0, (int)0);
            }
        }
        return image;
    }

    public Object getMarkerId() {
        return Long.toString(((RemoteInfoman)this.getLookup().lookup(RemoteInfoman.class)).getUnitId());
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public Action getPreferredAction() {
        Action action = super.getPreferredAction();
        Action[] actions = this.getActions(false);
        if (actions != null && actions.length > 0) {
            for (Action a : actions) {
                if (a == null) continue;
                if (a instanceof ContextAwareAction) {
                    a = ((ContextAwareAction)a).createContextAwareInstance(super.getLookup());
                }
                if (!a.isEnabled() || a instanceof Presenter) continue;
                action = a;
                break;
            }
        }
        return action;
    }

    protected synchronized void refreshEnvironmentSheet() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                RemoteInfoman infoman = (RemoteInfoman)RemoteInfomanNode.this.getLookup().lookup(RemoteInfoman.class);
                try {
                    Sheet.Set current = RemoteInfomanNode.this.getSheet().get("env");
                    if (current != null) {
                        RemoteInfomanNode.this.envSet = RemoteInfomanNode.this.createEnvironmentSheet(infoman);
                        Node.Property[] props = RemoteInfomanNode.this.envSet.getProperties();
                        current.put(props);
                        RemoteInfomanNode.this.firePropertySetsChange(null, new Node.PropertySet[]{RemoteInfomanNode.this.envSet});
                    }
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "RemoteInfomanNode.refreshEnvironmentSheet() runs into", ex);
                }
            }
        };
        ThreadPool.getInstance().execute(run);
    }

    private void refreshExtraSheets(RemoteInfomanSheetProvider sp) {
        if (!this.sheetCreated) {
            return;
        }
        RemoteInfoman infoman = (RemoteInfoman)this.getLookup().lookup(RemoteInfoman.class);
        long unitId = infoman.getUnitId();
        Collection<Sheet.Set> newSets = sp.createSheets(infoman.getServer(), unitId);
        if (newSets != null) {
            Sheet sheet = this.getSheet();
            for (Sheet.Set newSet : newSets) {
                Sheet.Set current = sheet.get(newSet.getName());
                if (current != null) {
                    Object obj = current.getValue("rebuild");
                    if (obj != null && Boolean.TRUE.equals(Boolean.valueOf(obj.toString()))) {
                        sheet.remove(newSet.getName());
                        sheet.put(newSet);
                    } else {
                        Node.Property[] props = newSet.getProperties();
                        current.put(props);
                    }
                } else {
                    sheet.put(newSet);
                }
                this.firePropertySetsChange(null, new Node.PropertySet[]{newSet});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshNodePresentation(RemoteInfomanSheetProvider sp) {
        RemoteInfoman infoman = (RemoteInfoman)this.getLookup().lookup(RemoteInfoman.class);
        String currentName = this.getHtmlDisplayName();
        long unitId = infoman.getUnitId();
        Map<String, Object> data = sp.getSheetDataForUnitById(infoman.getServer(), unitId);
        if (data != null) {
            Object object = this.iconImageLock;
            synchronized (object) {
                this.visibleOnMap = true;
                this.positionPresent = MapClientStampUtil.containsGPSPosition(data);
                this.fireDisplayNameChange(currentName, this.getHtmlDisplayName());
                this.fireIconChange();
            }
        }
        Object object = this.iconImageLock;
        synchronized (object) {
            this.positionPresent = true;
            this.visibleOnMap = false;
            this.fireDisplayNameChange(currentName, this.getHtmlDisplayName());
            this.fireIconChange();
        }
    }

    private class SheetProviderListener
    implements RemoteInfomanSheetProviderListener {
        private RemoteInfomanSheetProvider sheetProvider;

        public SheetProviderListener(RemoteInfomanSheetProvider sheetProvider) {
            this.sheetProvider = sheetProvider;
        }

        public RemoteInfomanSheetProvider getSheetProvider() {
            return this.sheetProvider;
        }

        @Override
        public void sheetDataPresent() {
            RemoteInfomanNode.this.refreshNodePresentation(this.sheetProvider);
            RemoteInfomanNode.this.refreshExtraSheets(this.sheetProvider);
        }

        @Override
        public void sheetDataUnloaded() {
            RemoteInfomanNode.this.refreshNodePresentation(this.sheetProvider);
            RemoteInfomanNode.this.fireSheetChanged();
        }

        @Override
        public void sheetPropertyChanged(String propertyName, Object oldValue, Object newValue) {
            Node.PropertySet[] propSets;
            boolean exists = false;
            block0: for (Node.PropertySet propSet : propSets = RemoteInfomanNode.this.getPropertySets()) {
                Node.Property[] ps;
                for (Node.Property prop : ps = propSet.getProperties()) {
                    if (!prop.getName().equals(propertyName)) continue;
                    exists = true;
                    continue block0;
                }
            }
            if (exists) {
                RemoteInfomanNode.this.firePropertyChange(propertyName, oldValue, newValue);
            }
        }
    }

    private class PropertyChangeListenerImpl
    implements PropertyChangeListener {
        private PropertyChangeListenerImpl() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            if (property.equals("RemoteUpdateAdapter.task.create") || property.equals("RemoteUpdateAdapter.task.cancel") || property.equals("RemoteUpdateAdapter.task.edit")) {
                DatasyncTaskValue task = (DatasyncTaskValue)evt.getNewValue();
                final AbstractRemoteInfoman infoman = (AbstractRemoteInfoman)RemoteInfomanNode.this.getLookup().lookup(AbstractRemoteInfoman.class);
                if (infoman.getUnitId() == task.getClientId()) {
                    Runnable run = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Node[] childNodes;
                                NavigationTopComponent nav = NavigationTopComponent.findInstance();
                                boolean expanded = nav.isNodeExpanded((Node)RemoteInfomanNode.this);
                                for (Node child : childNodes = (Node[])ArrayUtils.clone((Object[])RemoteInfomanNode.this.getChildren().getNodes())) {
                                    if (!child.canDestroy()) continue;
                                    try {
                                        child.destroy();
                                    }
                                    catch (Exception ex) {
                                        // empty catch block
                                    }
                                }
                                RemoteInfomanNode.this.setChildren(RemoteInfomanNode.createChildren(infoman));
                                if (expanded) {
                                    nav.expandNode((Node)RemoteInfomanNode.this);
                                }
                            }
                            catch (Exception ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    };
                    if (SwingUtilities.isEventDispatchThread()) {
                        run.run();
                    } else {
                        SwingUtilities.invokeLater(run);
                    }
                }
            }
        }
    }
}

