/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.navigation.nodes;

import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.navigation.api.RemoteNavigationItem;
import de.proveo.idm.core.gui.navigation.api.impl.NavigationItemNode;
import de.proveo.idm.core.gui.util.MenuUtil;
import de.proveo.idm.remote.server.api.EFMServer;
import de.proveo.idm.remote.server.api.RemoteActionPathProvider;
import de.proveo.idm.remote.server.navigation.EFMServerNavigationItem;
import de.proveo.idm.remote.server.util.TreeUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import org.apache.commons.lang3.ArrayUtils;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

public class RemoteGroupNode
extends NavigationItemNode {
    public RemoteGroupNode(RemoteNavigationItem item) {
        this(item, null);
    }

    public RemoteGroupNode(RemoteNavigationItem item, String actionPath) {
        super((NavigationItem)item);
        if (actionPath != null) {
            this.setActionPath(actionPath);
        }
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set groupSet = Sheet.createPropertiesSet();
        groupSet.setName("group");
        groupSet.setDisplayName(NbBundle.getMessage(RemoteGroupNode.class, (String)"RemoteGroupNode.set.group"));
        NavigationItem item = (NavigationItem)this.getLookup().lookup(NavigationItem.class);
        int unitCount = TreeUtil.countUnitsInTree(item);
        String displayName = NbBundle.getMessage(RemoteGroupNode.class, (String)"RemoteGroupNode.attribute.units");
        ReadOnlyImpl property = new ReadOnlyImpl("units", displayName, unitCount);
        groupSet.put((Node.Property)property);
        int groupCount = TreeUtil.countGroupsInTree(item);
        displayName = NbBundle.getMessage(RemoteGroupNode.class, (String)"RemoteGroupNode.attribute.groups");
        property = new ReadOnlyImpl("groups", displayName, groupCount);
        groupSet.put((Node.Property)property);
        sheet.put(groupSet);
        return sheet;
    }

    public Action[] getActions(boolean context) {
        ArrayList actions = new ArrayList();
        List registeredActions = new ArrayList();
        Object[] paths = new String[]{this.actionPath};
        if (this.navigationItem != null) {
            EFMServer server;
            NavigationItem parent = this.navigationItem;
            while ((parent = parent.getParent()) != null && !(parent instanceof EFMServerNavigationItem)) {
            }
            if (parent != null && parent instanceof EFMServerNavigationItem && (server = ((EFMServerNavigationItem)parent).getServerInstance()) != null) {
                Collection actionPathProviders = Lookup.getDefault().lookupAll(RemoteActionPathProvider.class);
                for (RemoteActionPathProvider actionPathProvider : actionPathProviders) {
                    paths = (String[])ArrayUtils.addAll((Object[])paths, (Object[])actionPathProvider.getGroupActionPaths(server, context));
                }
            }
        }
        try {
            registeredActions = MenuUtil.actionsForPaths((String[])paths);
        }
        catch (SAXException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        List<Action> superActions = Arrays.asList(super.getActions(context));
        actions.addAll(registeredActions);
        actions.addAll(superActions);
        return actions.toArray(new Action[actions.size()]);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("de.proveo.idm.remote.server");
    }

    private class ReadOnlyImpl
    extends PropertySupport.ReadOnly<Integer> {
        private int value;

        public ReadOnlyImpl(String name, String displayName, int value) {
            super(name, Integer.class, displayName, "");
            this.value = value;
        }

        public Integer getValue() throws IllegalAccessException, InvocationTargetException {
            return this.value;
        }
    }
}

