/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.navigation.nodes;

import de.proveo.domain.values.datasync.DatasyncMetainfoValue;
import de.proveo.domain.values.datasync.DatasyncTaskValue;
import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.navigation.api.impl.NavigationItemNode;
import de.proveo.idm.core.gui.navigation.sheet.ReadOnlyProperty;
import de.proveo.idm.remote.server.navigation.DatasyncTaskNavigationItem;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class DatasyncTaskNode
extends NavigationItemNode {
    private static final SimpleDateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");

    public DatasyncTaskNode(NavigationItem item) {
        super(item);
        this.setActionPath("/Actions/Remote/Server/Tasks");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("de.proveo.idm.remote.server");
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        DatasyncTaskNavigationItem datasyncTaskItem = (DatasyncTaskNavigationItem)((Object)this.getLookup().lookup(DatasyncTaskNavigationItem.class));
        DatasyncTaskValue datasyncTask = datasyncTaskItem.getDatasyncTask();
        Sheet.Set dataSheet = Sheet.createPropertiesSet();
        dataSheet.setName("task_data");
        dataSheet.setDisplayName(NbBundle.getMessage(DatasyncTaskNode.class, (String)"DatasyncTaskNode.set.taskdata"));
        sheet.put(dataSheet);
        Object value = datasyncTask.getTaskId();
        if (value == null) {
            value = "";
        }
        ReadOnlyProperty taskProp = new ReadOnlyProperty("taskId", NbBundle.getMessage(DatasyncTaskNode.class, (String)"DatasyncTaskValue.attribute.taskid"), value);
        dataSheet.put((Node.Property)taskProp);
        value = datasyncTask.getTaskInfo();
        if (value == null) {
            value = "";
        }
        taskProp = new ReadOnlyProperty("taskInfo", NbBundle.getMessage(DatasyncTaskNode.class, (String)"DatasyncTaskValue.attribute.taskinfo"), value);
        dataSheet.put((Node.Property)taskProp);
        value = datasyncTask.getIdentifier();
        if (value == null) {
            value = "";
        }
        taskProp = new ReadOnlyProperty("identifier", NbBundle.getMessage(DatasyncTaskNode.class, (String)"DatasyncTaskValue.attribute.identifier"), value);
        dataSheet.put((Node.Property)taskProp);
        value = datasyncTask.getClientId();
        if (value == null) {
            value = "";
        }
        taskProp = new ReadOnlyProperty("clientId", NbBundle.getMessage(DatasyncTaskNode.class, (String)"DatasyncTaskValue.attribute.clientId"), value);
        dataSheet.put((Node.Property)taskProp);
        value = datasyncTask.getClientSerialNumber();
        if (value == null) {
            value = "";
        }
        taskProp = new ReadOnlyProperty("clientSerialNumber", NbBundle.getMessage(DatasyncTaskNode.class, (String)"DatasyncTaskValue.attribute.clientSerialNumber"), value);
        dataSheet.put((Node.Property)taskProp);
        long timestamp = datasyncTask.getValidFrom();
        String value2 = NbBundle.getMessage(DatasyncTaskNode.class, (String)"valid.ever");
        if (timestamp > 0L) {
            value2 = DEFAULT_DATE_FORMAT.format(new Date(timestamp));
        }
        ReadOnlyProperty taskProp2 = new ReadOnlyProperty("validFrom", NbBundle.getMessage(DatasyncTaskNode.class, (String)"DatasyncTaskValue.attribute.validFrom"), (Object)value2);
        dataSheet.put((Node.Property)taskProp2);
        timestamp = datasyncTask.getValidTill();
        value2 = NbBundle.getMessage(DatasyncTaskNode.class, (String)"valid.endless");
        if (timestamp > 0L) {
            value2 = DEFAULT_DATE_FORMAT.format(new Date(timestamp));
        }
        taskProp2 = new ReadOnlyProperty("validTill", NbBundle.getMessage(DatasyncTaskNode.class, (String)"DatasyncTaskValue.attribute.validTill"), (Object)value2);
        dataSheet.put((Node.Property)taskProp2);
        value = datasyncTask.getMaxRetry();
        if (value == null) {
            value = "";
        }
        taskProp = new ReadOnlyProperty("maxRetry", NbBundle.getMessage(DatasyncTaskNode.class, (String)"DatasyncTaskValue.attribute.maxRetry"), value);
        dataSheet.put((Node.Property)taskProp);
        List metaValues = datasyncTask.getMetainfos();
        if (metaValues != null && !metaValues.isEmpty()) {
            Sheet.Set metaDataSheet = Sheet.createPropertiesSet();
            metaDataSheet.setValue("tabName", (Object)NbBundle.getMessage(DatasyncTaskNode.class, (String)"DatasyncTaskNode.set.metadata"));
            metaDataSheet.setDisplayName(NbBundle.getMessage(DatasyncTaskNode.class, (String)"DatasyncTaskNode.set.metadata"));
            metaDataSheet.setName("meta_data");
            sheet.put(metaDataSheet);
            for (DatasyncMetainfoValue value3 : metaValues) {
                String v = value3.getValue();
                if (v == null) {
                    v = "";
                }
                ReadOnlyProperty metaProp = new ReadOnlyProperty(value3.getKey(), value3.getKey(), (Object)v);
                metaDataSheet.put((Node.Property)metaProp);
            }
        }
        return sheet;
    }
}

