/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.navigation.nodes;

import de.proveo.domain.values.datasync.DatasyncMetainfoValue;
import de.proveo.domain.values.datasync.DatasyncResourceValue;
import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.navigation.sheet.ReadOnlyProperty;
import de.proveo.idm.remote.server.navigation.DatasyncResourceNavigationItem;
import de.proveo.idm.remote.server.navigation.nodes.AbstractRemoteNode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class DatasyncResourceNode
extends AbstractRemoteNode {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");

    public DatasyncResourceNode(DatasyncResourceNavigationItem item) {
        super((NavigationItem)item);
        this.setActionPath(item.getActionPath());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("de.proveo.idm.remote.server");
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        DatasyncResourceValue datasyncResource = ((DatasyncResourceNavigationItem)this.navigationItem).getResourceInstance();
        Sheet.Set dataSheet = Sheet.createPropertiesSet();
        dataSheet.setName("res_data");
        dataSheet.setDisplayName(NbBundle.getMessage(DatasyncResourceNode.class, (String)"DatasyncResourceNode.set.resourceData"));
        sheet.put(dataSheet);
        String value = datasyncResource.getResourceName();
        if (value == null) {
            value = "";
        }
        ReadOnlyProperty nameProp = new ReadOnlyProperty("resName", NbBundle.getMessage(DatasyncResourceNode.class, (String)"DatasyncResourceNode.attribute.resName"), (Object)value);
        dataSheet.put((Node.Property)nameProp);
        value = datasyncResource.getChecksum();
        if (value == null) {
            value = "";
        }
        nameProp = new ReadOnlyProperty("resChecksum", NbBundle.getMessage(DatasyncResourceNode.class, (String)"DatasyncResourceNode.attribute.resChecksum"), (Object)value);
        dataSheet.put((Node.Property)nameProp);
        long timestamp = datasyncResource.getValidFrom();
        String value2 = NbBundle.getMessage(DatasyncResourceNode.class, (String)"valid.ever");
        if (timestamp > 0L) {
            value2 = DATE_FORMAT.format(new Date(timestamp));
        }
        ReadOnlyProperty nameProp2 = new ReadOnlyProperty("resValidFrom", NbBundle.getMessage(DatasyncResourceNode.class, (String)"DatasyncResourceNode.attribute.resValidFrom"), (Object)value2);
        dataSheet.put((Node.Property)nameProp2);
        timestamp = datasyncResource.getValidTill();
        value2 = NbBundle.getMessage(DatasyncResourceNode.class, (String)"valid.endless");
        if (timestamp > 0L) {
            value2 = DATE_FORMAT.format(new Date(timestamp));
        }
        nameProp2 = new ReadOnlyProperty("resValidTill", NbBundle.getMessage(DatasyncResourceNode.class, (String)"DatasyncResourceNode.attribute.resValidTill"), (Object)value2);
        dataSheet.put((Node.Property)nameProp2);
        if (datasyncResource.isHasMetaInfo()) {
            Sheet.Set metaDataSheet = Sheet.createPropertiesSet();
            metaDataSheet.setValue("tabName", (Object)NbBundle.getMessage(DatasyncResourceNode.class, (String)"DatasyncResourceNode.set.metadata"));
            metaDataSheet.setDisplayName(NbBundle.getMessage(DatasyncResourceNode.class, (String)"DatasyncResourceNode.set.resourceData"));
            metaDataSheet.setName("meta_data");
            sheet.put(metaDataSheet);
            List metaValues = datasyncResource.getMetainfos();
            if (metaValues != null) {
                for (DatasyncMetainfoValue value3 : metaValues) {
                    String displayName;
                    String v = value3.getValue();
                    if (v == null) {
                        v = "";
                    }
                    String name = value3.getKey();
                    try {
                        displayName = NbBundle.getMessage(DatasyncResourceNode.class, (String)("DatasyncResourceNode.attribute." + name));
                    }
                    catch (Exception ex) {
                        displayName = name;
                    }
                    ReadOnlyProperty nameProp3 = new ReadOnlyProperty(name, displayName, (Object)v);
                    metaDataSheet.put((Node.Property)nameProp3);
                }
            }
        }
        return sheet;
    }
}

