/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.navigation.nodes;

import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.gui.navigation.api.NavigationManager;
import de.proveo.idm.core.gui.navigation.filter.AcceptAllFilter;
import de.proveo.idm.core.gui.navigation.filter.NavigationFilter;
import de.proveo.idm.remote.server.navigation.nodes.AggregateFilterNode;
import java.util.Collection;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class AggregateFilterChildren
extends FilterNode.Children {
    private final Collection<? extends NavigationManager> navManagers = Lookup.getDefault().lookupAll(NavigationManager.class);
    private Device.DeviceType deviceType = Device.DeviceType.INFOMAN;
    private NavigationFilter filter;

    public AggregateFilterChildren(Node node, Device.DeviceType deviceType, NavigationFilter filter) {
        super(node);
        this.filter = filter;
        this.deviceType = deviceType;
        if (this.deviceType == null) {
            this.deviceType = Device.DeviceType.INFOMAN;
        }
    }

    protected Node copyNode(Node node) {
        while (node instanceof AggregateFilterNode) {
            node = ((AggregateFilterNode)node).getOriginal();
        }
        if (node.isLeaf()) {
            return new AggregateFilterNode(node);
        }
        return new AggregateFilterNode(node, this.deviceType, this.filter);
    }

    protected Node[] createNodes(Node key) {
        if (key instanceof AggregateFilterNode) {
            key = ((AggregateFilterNode)key).getOriginal();
        }
        for (NavigationManager navigationManager : this.navManagers) {
            if (navigationManager.isAllowedInfomanNode(key, this.deviceType)) continue;
            return new Node[0];
        }
        if (key.isLeaf()) {
            if (this.filter.filter((Object)key.getDisplayName())) {
                return new Node[]{this.copyNode(key)};
            }
            return new Node[0];
        }
        if (this.filter.isViable(key)) {
            if (this.filter.filter((Object)key.getDisplayName())) {
                return new Node[]{new AggregateFilterNode(key, this.deviceType, (NavigationFilter)new AcceptAllFilter())};
            }
            return new Node[]{this.copyNode(key)};
        }
        return new Node[0];
    }
}

