/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.navigation;

import de.proveo.idm.core.gui.navigation.api.EFMServerData;
import de.proveo.idm.core.gui.navigation.api.InfomanDBEFMServerDecoratorFactory;
import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.navigation.api.RemoteNavigationManager;
import de.proveo.idm.core.gui.navigation.api.ServerNavigationItem;
import de.proveo.idm.core.gui.navigation.api.impl.AbstractNavigationItem;
import de.proveo.idm.remote.server.api.EFMServer;
import de.proveo.idm.remote.server.api.EFMServerFactory;
import de.proveo.idm.remote.server.api.EFMServerManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Map;
import org.openide.util.Lookup;

public class EFMServerNavigationItem
extends AbstractNavigationItem
implements ServerNavigationItem<EFMServer>,
PropertyChangeListener {
    public static final String PROP_TREE_UPDATED = "EFMServerNavigationItem.treeUpdated";
    private EFMServerData data;
    private transient EFMServer server;
    private boolean connecting = false;

    public EFMServerNavigationItem(EFMServerData data) {
        this(data, null);
    }

    public EFMServerNavigationItem(EFMServerData data, NavigationItem parent) {
        super(data.getServername(), parent);
        this.data = data;
        this.data.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void fireTreeUpdated() {
        this.pss.firePropertyChange(PROP_TREE_UPDATED, null, null);
    }

    public EFMServerData getServerData() {
        return this.data;
    }

    public synchronized EFMServer getServerInstance() {
        EFMServerManager manager;
        Map<String, EFMServerFactory> adapters;
        EFMServerFactory factory;
        if (this.server == null && (factory = (adapters = (manager = (EFMServerManager)Lookup.getDefault().lookup(EFMServerManager.class)).getAvailableServerAdapters()).get(this.data.getVersion())) != null) {
            EFMServer serverInstance = factory.createInstance(this.data);
            InfomanDBEFMServerDecoratorFactory infomanDBDecoratorFactory = (InfomanDBEFMServerDecoratorFactory)Lookup.getDefault().lookup(InfomanDBEFMServerDecoratorFactory.class);
            if (infomanDBDecoratorFactory != null) {
                try {
                    this.server = (EFMServer)infomanDBDecoratorFactory.decorate((Object)serverInstance);
                    if (this.server == null) {
                        this.server = serverInstance;
                    }
                }
                catch (Exception ex) {
                    this.server = serverInstance;
                }
            } else {
                this.server = serverInstance;
            }
        }
        return this.server;
    }

    public void setConnecting(boolean connecting) {
        this.connecting = connecting;
    }

    public boolean isConnecting() {
        return this.connecting;
    }

    public String getIconBaseWithExtension() {
        return "de/proveo/idm/remote/server/resources/server.png";
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof EFMServerData) {
            if (this.server != null) {
                boolean clearNavigation = false;
                String evtName = evt.getPropertyName();
                if (evtName.equals("EFMServerData.name")) {
                    this.server.setName(this.data.getServername());
                } else if (evtName.equals("EFMServerData.tunnel")) {
                    this.server.logoff();
                    this.server.setTunnel(this.data.getTunnel());
                    clearNavigation = true;
                } else if (evtName.equals("EFMServerData.tunnel.infoman")) {
                    this.server.setInfomanTunnel(this.data.getInfomanTunnel());
                } else if (evtName.equals("EFMServerData.url")) {
                    this.server.logoff();
                    this.server.setURL(this.data.getUrl());
                    clearNavigation = true;
                } else if (evtName.equals("EFMServerData.version")) {
                    Object old = evt.getOldValue();
                    if (old == null || !old.toString().equalsIgnoreCase("Auto")) {
                        this.server.logoff();
                        clearNavigation = true;
                    }
                } else if (evtName.equals("RemoteMapAdapter.mapType")) {
                    this.server.logoff();
                    clearNavigation = true;
                }
                if (clearNavigation) {
                    for (NavigationItem child : new ArrayList(this.getChildren())) {
                        this.removeChild(child);
                    }
                    this.server = null;
                }
            }
            RemoteNavigationManager mgr = (RemoteNavigationManager)Lookup.getDefault().lookup(RemoteNavigationManager.class);
            mgr.store();
        }
    }
}

