/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.gui;

import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.navigation.api.impl.NavigationNodeFactoryManager;
import de.proveo.idm.core.gui.navigation.filter.AcceptAllFilter;
import de.proveo.idm.core.gui.navigation.filter.NavigationFilter;
import de.proveo.idm.core.gui.navigation.filter.TextFilter;
import de.proveo.idm.remote.server.navigation.AggregateNavigationItem;
import de.proveo.idm.remote.server.navigation.nodes.AggregateFilterNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class UnitSelectionPanel
extends JPanel
implements ExplorerManager.Provider,
HelpCtx.Provider {
    private ExplorerManager em;
    private NavigationNodeFactoryManager nodeFactory = null;
    private Device.DeviceType deviceType = Device.DeviceType.INFOMAN;
    private JLabel jFilterLbl;
    private JTextField jFilterValue;
    private JPanel jPanel1;
    private JScrollPane unitPane;

    public UnitSelectionPanel(Device.DeviceType deviceType) {
        this.deviceType = deviceType;
        this.em = new ExplorerManager();
        this.nodeFactory = (NavigationNodeFactoryManager)Lookup.getDefault().lookup(NavigationNodeFactoryManager.class);
        this.initComponents();
        ((BeanTreeView)this.unitPane).setRootVisible(false);
        ((BeanTreeView)this.unitPane).setPopupAllowed(false);
        ((BeanTreeView)this.unitPane).setDragSource(false);
        ((BeanTreeView)this.unitPane).setDropTarget(false);
        ((BeanTreeView)this.unitPane).setQuickSearchAllowed(false);
        ((BeanTreeView)this.unitPane).setSelectionMode(1);
    }

    public void setUnits(NavigationItem units) {
        AggregateNavigationItem aggregateItem;
        Node rootNode;
        if (units != null && (rootNode = this.nodeFactory.createNode((NavigationItem)(aggregateItem = AggregateNavigationItem.aggregateNavigationItems(units.getChildren())))) != null) {
            AggregateFilterNode filteredRootNode = new AggregateFilterNode(rootNode, this.deviceType, (NavigationFilter)new AcceptAllFilter());
            this.em.setRootContext((Node)filteredRootNode);
        }
    }

    public NavigationItem getSelectedUnit() {
        Node[] nodes = this.em.getSelectedNodes();
        if (nodes.length > 0) {
            Node node = nodes[0];
            while (node instanceof AggregateFilterNode) {
                node = ((AggregateFilterNode)node).getOriginal();
            }
            return (NavigationItem)node.getLookup().lookup(NavigationItem.class);
        }
        return null;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("de.proveo.idm.remote.server.assignToUnit");
    }

    private void initComponents() {
        this.unitPane = new BeanTreeView();
        this.jPanel1 = new JPanel();
        this.jFilterLbl = new JLabel();
        this.jFilterValue = new JTextField();
        this.setLayout(new BorderLayout());
        this.add((Component)this.unitPane, "Center");
        this.jFilterLbl.setText(NbBundle.getMessage(UnitSelectionPanel.class, (String)"UnitSelectionPanel.jFilterLbl.text"));
        this.jFilterValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                UnitSelectionPanel.this.jFilterValueKeyReleased(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jFilterLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jFilterValue, -1, 329, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFilterLbl).addComponent(this.jFilterValue, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.add((Component)this.jPanel1, "South");
    }

    private void jFilterValueKeyReleased(KeyEvent evt) {
        AggregateFilterNode newRoot;
        Node root;
        ((BeanTreeView)this.unitPane).expandAll();
        boolean expandAll = true;
        String filterString = this.jFilterValue.getText();
        TextFilter filter = new TextFilter(filterString, false);
        if (filterString == null || filterString.length() == 0) {
            expandAll = false;
            filter = new AcceptAllFilter();
        }
        if ((root = this.em.getRootContext()) instanceof AggregateFilterNode) {
            Node original = ((AggregateFilterNode)root).getOriginal();
            newRoot = new AggregateFilterNode(original, this.deviceType, (NavigationFilter)filter);
            if (original.isLeaf()) {
                newRoot = new AggregateFilterNode(original);
            }
        } else {
            newRoot = new AggregateFilterNode(root, this.deviceType, (NavigationFilter)filter);
            if (root.isLeaf()) {
                newRoot = new AggregateFilterNode(root);
            }
        }
        this.em.setRootContext((Node)newRoot);
        if (expandAll) {
            ((BeanTreeView)this.unitPane).expandAll();
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.em;
    }
}

