/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.communication.api;

import de.proveo.idm.remote.server.api.impl.HttpClientFactory;
import de.proveo.idm.remote.server.communication.api.exceptions.ServletConnectionException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.auth.NTLMScheme;
import org.apache.commons.httpclient.auth.RFC2617Scheme;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.io.IOUtils;

public class ServletConnection {
    private static final Logger log = Logger.getLogger(ServletConnection.class.getName());
    private final int SOCKET_TIMEOUT = 60000;
    private final int CONNECTION_MANAGER_TIMEOUT = 30000;
    private final String PARAMETER_PASSWORD = "password";
    private HttpClient client;
    private HttpConnection httpConnection;
    private PostMethod httpMethod;
    private URL url;
    private String lastStatusText = "";
    private int lastState = 0;
    private boolean authNeeded = false;

    public ServletConnection(URL url) {
        this.url = url;
        int port = this.url.getPort();
        if (port == -1) {
            try {
                String protocol = this.url.getProtocol();
                this.url = "http".equals(protocol) ? new URL(protocol, this.url.getHost(), 80, this.url.getFile()) : new URL(protocol, this.url.getHost(), 443, this.url.getFile());
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Could not create URL within default port", ex);
            }
        }
    }

    public void close() {
        try {
            if (this.httpMethod != null) {
                log.info("try to abort http method...");
                this.httpMethod.abort();
                this.releaseMethod((HttpMethod)this.httpMethod);
                this.httpMethod = null;
                log.info("http method aborted.");
            } else {
                log.info("http method already null");
            }
            if (this.httpConnection != null) {
                log.info("try to close connection...");
                this.httpConnection.close();
                this.httpConnection.releaseConnection();
                this.httpConnection = null;
                log.info("Servlet connection closed.");
            } else {
                log.info("httpConnection already null");
            }
        }
        catch (Throwable ex) {
            log.log(Level.INFO, "Could not close servlet connection regulary", ex);
        }
        this.client = null;
    }

    private void releaseMethod(HttpMethod method) {
        try {
            if (method != null) {
                log.info("try to release http method...");
                method.releaseConnection();
                log.info("http method released.");
            }
        }
        catch (Throwable ex) {
            log.log(Level.INFO, "Could not release servlet connection regulary.", ex);
        }
    }

    public void connect() {
        String method = "connect(): ";
        this.client = new HttpClient();
        try {
            HttpClientFactory.configureHttpClient(this.client, this.url.getProtocol(), this.url.getHost(), this.url.getPort(), this.url.getPort(), this.url.getFile(), 30000, 60000);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Could not configure HTTPClient", ex);
        }
        HostConfiguration hostConfiguration = this.client.getHostConfiguration();
        this.httpConnection = this.client.getHttpConnectionManager().getConnection(hostConfiguration);
    }

    public int executeMethod(String url) throws HttpException, IOException, ServletConnectionException {
        String passwd = this.getParaFromUrl(url, "password");
        url = this.removePwFromtUrl(url);
        return this.executeMethod(url, passwd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeMethod(String url, String passwd) throws HttpException, IOException, ServletConnectionException {
        String method = "executeMethod(): ";
        PostMethod postMethod = new PostMethod(url);
        postMethod.addRequestHeader("ContentType", "application/x-www-form-urlencoded;charset=UTF-8");
        if (passwd != null && passwd.length() > 0) {
            postMethod.addParameter("password", passwd);
        }
        postMethod.setDoAuthentication(this.authNeeded);
        try {
            this.lastState = this.client.executeMethod((HttpMethod)postMethod);
            this.lastStatusText = postMethod.getStatusText();
        }
        finally {
            this.releaseMethod((HttpMethod)postMethod);
        }
        if (this.lastState >= 400) {
            log.log(Level.WARNING, "{0}status not ok ({1}, {2}), break", new Object[]{method, this.lastState, this.lastStatusText});
            throw new ServletConnectionException("BadStatusCode", this.lastState, this.lastStatusText);
        }
        return this.lastState;
    }

    public int getLastState() {
        return this.lastState;
    }

    public String getLastStatusText() {
        return this.lastStatusText;
    }

    public ObjectInputStream getObjectInputStream(Map<String, String> servletParams) throws ServletConnectionException {
        String method = "getObjectInputStream(servletPath, params): ";
        ObjectInputStream ois = null;
        try {
            this.httpMethod = new PostMethod(this.addParametersToUrl(this.url, servletParams));
        }
        catch (Throwable ex) {
            log.log(Level.WARNING, method + "runs into exception '" + ex.getClass().getName() + "' : " + ex.toString(), ex);
            throw new ServletConnectionException("UnknownException", ex);
        }
        this.httpMethod.addRequestHeader("ContentType", "application/x-www-form-urlencoded;charset=UTF-8");
        this.httpMethod.setDoAuthentication(this.authNeeded);
        for (String key : servletParams.keySet()) {
            String val = servletParams.get(key);
            this.httpMethod.addParameter(key, val);
        }
        try {
            HttpClientParams httpClientParams = this.client.getParams();
            httpClientParams.setSoTimeout(60000);
            httpClientParams.setConnectionManagerTimeout(30000L);
            httpClientParams.setContentCharset("UTF-8");
            httpClientParams.setCredentialCharset("UTF-8");
            httpClientParams.setHttpElementCharset("UTF-8");
            this.lastState = this.client.executeMethod((HttpMethod)this.httpMethod);
            this.lastStatusText = this.httpMethod.getStatusText();
            if (this.lastState >= 400) {
                log.log(Level.WARNING, "{0}status not ok ({1}, {2}), break", new Object[]{method, this.lastState, this.lastStatusText});
                if (this.lastState == 505) {
                    log.log(Level.WARNING, "{0}(check URL for spaces and special characters)", method);
                }
                throw new ServletConnectionException("BadStatusCode", this.lastState, this.lastStatusText);
            }
            InputStream is = this.httpMethod.getResponseBodyAsStream();
            ois = new ObjectInputStream(new BufferedInputStream(is));
        }
        catch (SocketTimeoutException ste) {
            log.log(Level.WARNING, "{0}{1}, Servlet time out", new Object[]{method, ste.toString()});
            throw new ServletConnectionException("TimeOut", ste);
        }
        catch (ConnectException ce) {
            log.log(Level.WARNING, "{0}{1}, Servlet can not connect", new Object[]{method, ce.toString()});
            throw new ServletConnectionException("ConnectError", ce);
        }
        catch (HttpException e) {
            log.log(Level.WARNING, "{0}{1}", new Object[]{method, e.toString()});
            throw new ServletConnectionException("HttpError", e);
        }
        catch (SSLHandshakeException ssle) {
            log.log(Level.WARNING, "{0}{1}", new Object[]{method, ssle.toString()});
            throw new ServletConnectionException("SslHandshakeError", ssle);
        }
        catch (IOException ioe) {
            log.log(Level.WARNING, "{0}{1}, Network not available ? Servlet not accessible ? Server not running ?", new Object[]{method, ioe.toString()});
            throw new ServletConnectionException("NoServerFound");
        }
        catch (ServletConnectionException sce) {
            log.log(Level.WARNING, "{0}{1}, Bad status code? Check stacktrace...", new Object[]{method, sce.toString()});
            throw sce;
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "{0}uncatched exception ''{1}'' : {2}", new Object[]{method, ex.getClass().getName(), ex.toString()});
            throw new ServletConnectionException("UnknownException", ex);
        }
        return ois;
    }

    private String addParametersToUrl(URL url, String parameters) {
        String ret = url.toString();
        if (parameters != null && parameters.length() > 1) {
            parameters = parameters.replaceAll("\\\\", "/");
            ret = ret + "?" + parameters;
        }
        try {
            return URIUtil.encodeQuery((String)ret, (String)"UTF-8");
        }
        catch (Exception ex) {
            return ret;
        }
    }

    public String addParametersToUrl(URL url, Map<String, String> parameters) {
        StringBuilder urlParameters = new StringBuilder();
        for (String key : parameters.keySet()) {
            String val = parameters.get(key);
            urlParameters.append(key);
            urlParameters.append('=');
            urlParameters.append(val);
            urlParameters.append('&');
        }
        String parameterString = urlParameters.toString();
        if (parameterString.endsWith("&")) {
            parameterString = parameterString.substring(0, parameterString.lastIndexOf("&"));
        }
        return this.addParametersToUrl(url, parameterString);
    }

    private String removePwFromtUrl(String url) {
        int ind = url.indexOf("password=");
        if (ind < 0) {
            return url;
        }
        String part1 = url.substring(0, ind);
        String rest = url.substring(ind, url.length());
        ind = rest.indexOf("&");
        String part2 = "";
        if (ind >= 0) {
            part2 = rest.substring(ind + 1, rest.length());
        }
        return part1 + part2;
    }

    private String getParaFromUrl(String url, String para) {
        String method = "getParaFromUrl(): ";
        String ret = "";
        int ind = url.indexOf(para + "=");
        if (ind < 0) {
            log.log(Level.INFO, "{0}parameter ''{1}'' not found in URL ''{2}''", new Object[]{method, para, url});
            return ret;
        }
        String rest = url.substring(ind + para.length() + 1, url.length());
        ret = (ind = rest.indexOf("&")) >= 0 ? rest.substring(0, ind) : rest;
        return ret;
    }

    public Object readObject(String url) throws ServletConnectionException {
        String passwd = this.getParaFromUrl(url, "password");
        url = this.removePwFromtUrl(url);
        return this.readObject(url, passwd);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object readObject(String url, String passwd) throws ServletConnectionException {
        String method = "readObject(): ";
        PostMethod postMethod = new PostMethod(url);
        postMethod.addRequestHeader("ContentType", "application/x-www-form-urlencoded;charset=UTF-8");
        if (passwd != null && passwd.length() > 0) {
            postMethod.addParameter("password", passwd);
        }
        postMethod.setDoAuthentication(this.authNeeded);
        Object obj = null;
        ObjectInputStream ois = null;
        BufferedInputStream bis = null;
        InputStream is = null;
        try {
            this.lastState = this.client.executeMethod((HttpMethod)postMethod);
            this.lastStatusText = postMethod.getStatusText();
            if (this.lastState >= 400) {
                log.log(Level.WARNING, "{0}status not ok ({1}, {2}), break", new Object[]{method, this.lastState, this.lastStatusText});
                throw new ServletConnectionException("BadStatusCode", this.lastState, this.lastStatusText);
            }
            is = postMethod.getResponseBodyAsStream();
            bis = new BufferedInputStream(is);
            ois = new ObjectInputStream(bis);
            obj = ois.readObject();
        }
        catch (SocketTimeoutException ste) {
            try {
                log.log(Level.WARNING, "{0}{1}, Servlet time out", new Object[]{method, ste.toString()});
                throw new ServletConnectionException("TimeOut", ste);
                catch (ConnectException ce) {
                    log.log(Level.WARNING, "{0}{1}, Servlet can not connect", new Object[]{method, ce.toString()});
                    throw new ServletConnectionException("ConnectError", ce);
                }
                catch (HttpException e) {
                    log.log(Level.WARNING, "{0}{1}", new Object[]{method, e.toString()});
                    throw new ServletConnectionException("HttpError", e);
                }
                catch (SSLHandshakeException ssle) {
                    log.log(Level.WARNING, "{0}{1}", new Object[]{method, ssle.toString()});
                    throw new ServletConnectionException("SslHandshakeError", ssle);
                }
                catch (IOException ioe) {
                    log.log(Level.WARNING, "{0}{1}, Network not available ? Servlet not accessible ? Server not running ?", new Object[]{method, ioe.toString()});
                    throw new ServletConnectionException("NoServerFound", ioe);
                }
                catch (ServletConnectionException sce) {
                    log.log(Level.WARNING, "{0}{1}, Bad status code? Check stacktrace...", new Object[]{method, sce.toString()});
                    throw sce;
                }
                catch (ClassNotFoundException ce) {
                    log.log(Level.WARNING, "{0}Error : {1}", new Object[]{method, ce.toString()});
                    throw new ServletConnectionException("ObjectClassError", ce);
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "{0}uncatched exception ''{1}'' : {2}", new Object[]{method, ex.getClass().getName(), ex.toString()});
                    throw new ServletConnectionException("UnknownException", ex);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ois);
                IOUtils.closeQuietly(bis);
                IOUtils.closeQuietly(is);
                this.releaseMethod((HttpMethod)postMethod);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)ois);
        IOUtils.closeQuietly((InputStream)bis);
        IOUtils.closeQuietly((InputStream)is);
        this.releaseMethod((HttpMethod)postMethod);
        return obj;
    }

    public String readString(String url) throws ServletConnectionException {
        String passwd = this.getParaFromUrl(url, "password");
        url = this.removePwFromtUrl(url);
        return this.readString(url, passwd);
    }

    public String readString(String url, String passwd) throws ServletConnectionException {
        String response;
        String method = "readString(): ";
        PostMethod postMethod = new PostMethod(url);
        postMethod.addRequestHeader("ContentType", "application/x-www-form-urlencoded;charset=UTF-8");
        if (passwd != null && passwd.length() > 0) {
            postMethod.addParameter("password", passwd);
        }
        postMethod.setDoAuthentication(this.authNeeded);
        try {
            this.lastState = this.client.executeMethod((HttpMethod)postMethod);
            this.lastStatusText = postMethod.getStatusText();
            if (this.lastState >= 400) {
                log.log(Level.WARNING, "{0}status not ok ({1}, {2}), break", new Object[]{method, this.lastState, this.lastStatusText});
                throw new ServletConnectionException("BadStatusCode", this.lastState, this.lastStatusText);
            }
            response = postMethod.getResponseBodyAsString();
        }
        catch (SocketTimeoutException ste) {
            log.log(Level.WARNING, "{0}{1}, Servlet time out", new Object[]{method, ste.toString()});
            throw new ServletConnectionException("TimeOut", ste);
        }
        catch (HttpException e) {
            log.log(Level.WARNING, "{0}{1}", new Object[]{method, e.toString()});
            throw new ServletConnectionException("HttpError", e);
        }
        catch (SSLHandshakeException ssle) {
            log.log(Level.WARNING, "{0}{1}", new Object[]{method, ssle.toString()});
            throw new ServletConnectionException("SslHandshakeError", ssle);
        }
        catch (IOException ioe) {
            log.log(Level.WARNING, "{0}{1}, Network not available ? Servlet not accessible ? Server not running ?", new Object[]{method, ioe.toString()});
            throw new ServletConnectionException("NoServerFound");
        }
        catch (ServletConnectionException sce) {
            log.log(Level.WARNING, "{0}{1}, Bad status code? Check stacktrace...", new Object[]{method, sce.toString()});
            throw sce;
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "{0}uncatched exception ''{1}'' : {2}", new Object[]{method, ex.getClass().getName(), ex.toString()});
            throw new ServletConnectionException("UnknownException", ex);
        }
        finally {
            this.releaseMethod((HttpMethod)postMethod);
        }
        return response;
    }

    public void setAuthenticate(String username, String password) {
        if (this.client == null) {
            this.connect();
        }
        this.client.getState().setCredentials(new AuthScope(this.url.getHost(), this.url.getPort(), AuthScope.ANY_REALM), (Credentials)new UsernamePasswordCredentials(username, password));
        this.authNeeded = true;
    }

    public static class AuthenticationProvider
    implements CredentialsProvider {
        String domain;
        String password;
        String user;

        public AuthenticationProvider(String user, String password, String domain) {
            this.user = user;
            this.password = password;
            this.domain = domain;
        }

        public Credentials getCredentials(AuthScheme authscheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
            String method = "getCredentials(): ";
            if (authscheme == null) {
                return null;
            }
            try {
                if (authscheme instanceof NTLMScheme) {
                    log.log(Level.INFO, "{0}:{1} requires Windows authentication, return NTLM credentials", new Object[]{host, port});
                    return new NTCredentials(this.user, this.password, host, this.domain);
                }
                if (authscheme instanceof RFC2617Scheme) {
                    log.log(Level.INFO, "{0}:{1} requires authentication with the realm ''{2}'', return USER/PASS credentials", new Object[]{host, port, authscheme.getRealm()});
                    return new UsernamePasswordCredentials(this.user, this.password);
                }
                log.log(Level.WARNING, "{0}Unsupported authentication scheme: {1}", new Object[]{method, authscheme.getSchemeName()});
                throw new CredentialsNotAvailableException("Unsupported authentication scheme: " + authscheme.getSchemeName());
            }
            catch (IOException e) {
                throw new CredentialsNotAvailableException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

