/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.communication.api;

import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerTime {
    private static final Logger log = Logger.getLogger(ServerTime.class.getName());
    public static final long SERVERTIME_SMALLER_INFOMANTIME_DEVIATION_BIG = -60000L;
    public static final long SERVERTIME_SMALLER_INFOMANTIME_DEVIATION_SMALL = -10000L;
    public static final long SERVERTIME_GREATER_INFOMANTIME_DEVIATION_BIG = 60000L;
    public static final long SERVERTIME_GREATER_INFOMANTIME_DEVIATION_SMALL = 10000L;
    private TimeZone timeZone = null;
    private long sumDiffs = 0L;
    private long noDiffs = 0L;
    private long fromPing = 0L;
    final long maxDiffAlowed = 60000L;

    public ServerTime() {
    }

    public ServerTime(long st) {
        this.sumDiffs = st - System.currentTimeMillis();
        this.noDiffs = 1L;
    }

    public void setTimeZone(TimeZone tz) {
        this.timeZone = tz;
    }

    public void updateServerTime(long serverTime) {
        this.updateServerTime(serverTime, false);
    }

    public void updateServerTime(long serverTime, boolean debug) {
        this.sumDiffs += serverTime - System.currentTimeMillis();
        ++this.noDiffs;
        ++this.fromPing;
        if (debug) {
            this.analyze(serverTime);
        }
    }

    public long getDifference() {
        if (this.noDiffs > 0L) {
            return Math.round((double)this.sumDiffs / (double)this.noDiffs);
        }
        return 0L;
    }

    public long getDifferenceAbs() {
        return Math.abs(this.getDifference());
    }

    public long getServerTime() {
        return System.currentTimeMillis() + this.getDifference();
    }

    public boolean isServerTimeAhead() {
        return this.getDifference() > 0L;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    private void analyze(long serverTime) {
        long currentDiff;
        String method = "analyze(): ";
        long clientTime = System.currentTimeMillis();
        long diff = currentDiff = serverTime - clientTime;
        long absDiff = Math.abs(currentDiff);
        if (absDiff > this.maxDiffAlowed) {
            log.log(Level.WARNING, "{0}*** last server timestamp:", method);
            log.log(Level.WARNING, "{0}found unsynchronized time (differs more than {1}s):", new Object[]{method, this.maxDiffAlowed / 1000L});
            log.log(Level.WARNING, "{0}server time: {1}", new Object[]{method, serverTime});
            log.log(Level.WARNING, "{0}client time: {1}", new Object[]{method, clientTime});
            if (diff > 0L) {
                log.log(Level.WARNING, "{0}Server is {1}s ahead the client!", new Object[]{method, absDiff / 1000L});
            } else {
                log.log(Level.WARNING, "{0}Server is {1}s behind the client!", new Object[]{method, absDiff / 1000L});
            }
        } else {
            log.log(Level.INFO, "{0}current server time OK, is only {1}s diff to client", new Object[]{method, diff / 1000L});
        }
        diff = this.getDifference();
        absDiff = this.getDifferenceAbs();
        if (absDiff > this.maxDiffAlowed) {
            log.log(Level.WARNING, "{0}*** average values:", method);
            log.log(Level.WARNING, "{0}found unsynchronized time (differs more than {1}s):", new Object[]{method, this.maxDiffAlowed / 1000L});
            log.log(Level.WARNING, "{0}server time: {1}", new Object[]{method, this.getServerTime()});
            log.log(Level.WARNING, "{0}client time: {1}", new Object[]{method, clientTime});
            if (diff > 0L) {
                log.log(Level.WARNING, "{0}Server is {1}s ahead the client!", new Object[]{method, absDiff / 1000L});
            } else {
                log.log(Level.WARNING, "{0}Server is {1}s behind the client!", new Object[]{method, absDiff / 1000L});
            }
        } else {
            log.log(Level.INFO, "{0}avarage server time OK, is only {1}s diff to client", new Object[]{method, diff / 1000L});
        }
    }

    public void reset() {
        this.timeZone = null;
        this.sumDiffs = 0L;
        this.noDiffs = 0L;
        this.fromPing = 0L;
    }
}

