/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.communication.api;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Logger;

public class ConnectionStatistics {
    public static final String PROP_SERVER_VERSION = "serverVersion";
    public static final String PROP_SERVER_JAVA_VERSION = "serverJavaVersion";
    public static final String PROP_PING_EVENTS = "statPingEvents";
    public static final String PROP_SERVER_MESSAGE_EVENTS = "statServerMessageEvents";
    public static final String PROP_ALL_UNITS_EVENTS = "statAllUnitsEvents";
    public static final String PROP_SINGLE_UNIT_EVENTS = "statSingleUnitEvents";
    public static final String PROP_ALL_STANDS_EVENTS = "statAllStandsEvents";
    public static final String PROP_SINGLE_STAND_EVENTS = "statSingleStandEvents";
    public static final String PROP_GENERAL_ERROR_EVENTS = "statGeneralErrorEvents";
    public static final String PROP_INFOMAN_MESSAGE_EVENTS = "statInfomanMessageEvents";
    public static final String PROP_INFOMAN_ALERT_EVENTS = "statInfomanAlertEvents";
    public static final String PROP_SERVER_RECONNECTS = "serverReconnects";
    public static final String PROP_SUCCESSFUL_SERVER_RECONNECTS = "successfulServerReconnects";
    public static final String PROP_WATCHDOG_EVENTS = "watchdogEvents";
    private static final Logger log = Logger.getLogger(ConnectionStatistics.class.getName());
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private volatile String serverVersion = null;
    private volatile String serverJavaVersion = null;
    private volatile long statAllUnitsEvents = 0L;
    private volatile long statSingleUnitEvents = 0L;
    private volatile long statAllStandsEvents = 0L;
    private volatile long statSingleStandEvents = 0L;
    private volatile long statPingEvents = 0L;
    private volatile long statServerMessageEvents = 0L;
    private volatile long statGeneralErrorEvents = 0L;
    private volatile long statInfomanMessageEvents = 0L;
    private volatile long statInfomanAlertEvents = 0L;
    private volatile long serverReconnects = 0L;
    private volatile long successfulServerReconnects = 0L;
    private volatile long watchdogEvents = 0L;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void addPingEvent() {
        long oldValue = this.statPingEvents++;
        this.pcs.firePropertyChange(PROP_PING_EVENTS, oldValue, this.statPingEvents);
    }

    public void addServerMessageEvent() {
        long oldValue = this.statServerMessageEvents++;
        this.pcs.firePropertyChange(PROP_SERVER_MESSAGE_EVENTS, oldValue, this.statServerMessageEvents);
    }

    public void addAllUnitsEvent() {
        long oldValue = this.statAllUnitsEvents++;
        this.pcs.firePropertyChange(PROP_ALL_UNITS_EVENTS, oldValue, this.statAllUnitsEvents);
    }

    public void addSingleUnitEvent() {
        long oldValue = this.statSingleUnitEvents++;
        this.pcs.firePropertyChange(PROP_SINGLE_UNIT_EVENTS, oldValue, this.statSingleUnitEvents);
    }

    public void addAllStandsEvent() {
        long oldValue = this.statAllStandsEvents++;
        this.pcs.firePropertyChange(PROP_ALL_STANDS_EVENTS, oldValue, this.statAllStandsEvents);
    }

    public void addSingleStandEvent() {
        long oldValue = this.statSingleStandEvents++;
        this.pcs.firePropertyChange(PROP_SINGLE_STAND_EVENTS, oldValue, this.statSingleStandEvents);
    }

    public void addGeneralErrorEvent() {
        long oldValue = this.statGeneralErrorEvents++;
        this.pcs.firePropertyChange(PROP_GENERAL_ERROR_EVENTS, oldValue, this.statGeneralErrorEvents);
    }

    public void addInfomanMessageEvent() {
        long oldValue = this.statInfomanMessageEvents++;
        this.pcs.firePropertyChange(PROP_INFOMAN_MESSAGE_EVENTS, oldValue, this.statInfomanMessageEvents);
    }

    public void addInfomanAlertEvent() {
        long oldValue = this.statInfomanAlertEvents++;
        this.pcs.firePropertyChange(PROP_INFOMAN_ALERT_EVENTS, oldValue, this.statInfomanAlertEvents);
    }

    public void addServerReconnect() {
        long oldValue = this.serverReconnects++;
        this.pcs.firePropertyChange(PROP_SERVER_RECONNECTS, oldValue, this.serverReconnects);
    }

    public void addSuccessfulServerReconnect() {
        long oldValue = this.successfulServerReconnects++;
        this.pcs.firePropertyChange(PROP_SUCCESSFUL_SERVER_RECONNECTS, oldValue, this.successfulServerReconnects);
    }

    public void addWatchdogEvent() {
        long oldValue = this.watchdogEvents++;
        this.pcs.firePropertyChange(PROP_WATCHDOG_EVENTS, oldValue, this.watchdogEvents);
    }

    public long getPingEvents() {
        return this.statPingEvents;
    }

    public long getServerMessageEvents() {
        return this.statServerMessageEvents;
    }

    public long getAllUnitsEvents() {
        return this.statAllUnitsEvents;
    }

    public long getSingleUnitEvents() {
        return this.statSingleUnitEvents;
    }

    public long getAllStandsEvents() {
        return this.statAllStandsEvents;
    }

    public String getServerJavaVersion() {
        return this.serverJavaVersion;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public long getSingleStandEvents() {
        return this.statSingleStandEvents;
    }

    public long getGeneralErrorEvents() {
        return this.statGeneralErrorEvents;
    }

    public long getInfomanMessageEvents() {
        return this.statInfomanMessageEvents;
    }

    public long getInfomanAlertEvents() {
        return this.statInfomanAlertEvents;
    }

    public long getServerReconnects() {
        return this.serverReconnects;
    }

    public long getSuccessfulServerReconnects() {
        return this.successfulServerReconnects;
    }

    public long getWatchdogEvents() {
        return this.watchdogEvents;
    }

    public void reset() {
        this.resetUser();
        String oldServerJavaVersion = this.serverJavaVersion;
        String oldServerVersion = this.serverVersion;
        this.serverJavaVersion = null;
        this.serverVersion = null;
        this.pcs.firePropertyChange(PROP_SERVER_JAVA_VERSION, oldServerJavaVersion == null ? "" : oldServerJavaVersion, this.serverJavaVersion);
        this.pcs.firePropertyChange(PROP_SERVER_VERSION, oldServerVersion == null ? "" : oldServerVersion, this.serverVersion);
    }

    public void resetUser() {
        long oldStatAllUnitsEvents = this.statAllUnitsEvents;
        long oldStatSingleUnitEvents = this.statSingleUnitEvents;
        long oldStatAllStandsEvents = this.statAllStandsEvents;
        long oldStatSingleStandEvents = this.statSingleStandEvents;
        long oldStatPingEvents = this.statPingEvents;
        long oldStatServerMessageEvents = this.statServerMessageEvents;
        long oldStatGeneralErrorEvents = this.statGeneralErrorEvents;
        long oldStatInfomanMessageEvents = this.statInfomanMessageEvents;
        long oldStatInfomanAlertEvents = this.statInfomanAlertEvents;
        long oldServerReconnects = this.serverReconnects;
        long oldSuccessfulServerReconnects = this.successfulServerReconnects;
        long oldWatchdogEvents = this.watchdogEvents;
        this.statAllUnitsEvents = 0L;
        this.statSingleUnitEvents = 0L;
        this.statAllStandsEvents = 0L;
        this.statSingleStandEvents = 0L;
        this.statPingEvents = 0L;
        this.statServerMessageEvents = 0L;
        this.statGeneralErrorEvents = 0L;
        this.statInfomanMessageEvents = 0L;
        this.statInfomanAlertEvents = 0L;
        this.serverReconnects = 0L;
        this.successfulServerReconnects = 0L;
        this.watchdogEvents = 0L;
        this.pcs.firePropertyChange(PROP_ALL_UNITS_EVENTS, oldStatAllUnitsEvents == 0L ? -1L : oldStatAllUnitsEvents, this.statAllUnitsEvents);
        this.pcs.firePropertyChange(PROP_SINGLE_UNIT_EVENTS, oldStatSingleUnitEvents == 0L ? -1L : oldStatSingleUnitEvents, this.statSingleUnitEvents);
        this.pcs.firePropertyChange(PROP_ALL_STANDS_EVENTS, oldStatAllStandsEvents == 0L ? -1L : oldStatAllStandsEvents, this.statAllStandsEvents);
        this.pcs.firePropertyChange(PROP_SINGLE_STAND_EVENTS, oldStatSingleStandEvents == 0L ? -1L : oldStatSingleStandEvents, this.statSingleStandEvents);
        this.pcs.firePropertyChange(PROP_PING_EVENTS, oldStatPingEvents == 0L ? -1L : oldStatPingEvents, this.statPingEvents);
        this.pcs.firePropertyChange(PROP_SERVER_MESSAGE_EVENTS, oldStatServerMessageEvents == 0L ? -1L : oldStatServerMessageEvents, this.statServerMessageEvents);
        this.pcs.firePropertyChange(PROP_GENERAL_ERROR_EVENTS, oldStatGeneralErrorEvents == 0L ? -1L : oldStatGeneralErrorEvents, this.statGeneralErrorEvents);
        this.pcs.firePropertyChange(PROP_INFOMAN_MESSAGE_EVENTS, oldStatInfomanMessageEvents == 0L ? -1L : oldStatInfomanMessageEvents, this.statInfomanMessageEvents);
        this.pcs.firePropertyChange(PROP_INFOMAN_ALERT_EVENTS, oldStatInfomanAlertEvents == 0L ? -1L : oldStatInfomanAlertEvents, this.statInfomanAlertEvents);
        this.pcs.firePropertyChange(PROP_SERVER_RECONNECTS, oldServerReconnects == 0L ? -1L : oldServerReconnects, this.serverReconnects);
        this.pcs.firePropertyChange(PROP_SUCCESSFUL_SERVER_RECONNECTS, oldSuccessfulServerReconnects == 0L ? -1L : oldSuccessfulServerReconnects, this.successfulServerReconnects);
        this.pcs.firePropertyChange(PROP_WATCHDOG_EVENTS, oldWatchdogEvents == 0L ? -1L : oldWatchdogEvents, this.watchdogEvents);
    }

    public void setServerJavaVersion(String serverJavaVersion) {
        String oldValue = this.serverJavaVersion;
        this.serverJavaVersion = serverJavaVersion;
        this.pcs.firePropertyChange(PROP_SERVER_JAVA_VERSION, oldValue, this.serverJavaVersion);
    }

    public void setServerVersion(String serverVersion) {
        String oldValue = this.serverVersion;
        this.serverVersion = serverVersion;
        this.pcs.firePropertyChange(PROP_SERVER_VERSION, oldValue, this.serverVersion);
    }
}

